# Copyright (c) 2019-2020, RTE (https://www.rte-france.com)
# See AUTHORS.txt
# This Source Code Form is subject to the terms of the Mozilla Public License, version 2.0.
# If a copy of the Mozilla Public License, version 2.0 was not distributed with this file,
# you can obtain one at http://mozilla.org/MPL/2.0/.
# SPDX-License-Identifier: MPL-2.0
# This file is part of Grid2Op, Grid2Op a testbed platform to model sequential decision making in power systems.

NUKE_COLOR = "#e5cd00"
THERMAL_COLOR = "#7e52a0"
WIND_COLOR = "#71cdb8"
SOLAR_COLOR = "#d66b0d"
HYDRO_COLOR = "#1f73b5"
NUKE_ID = 0
THERMAL_ID = 1
WIND_ID = 2
SOLAR_ID = 3
HYDRO_ID = 4
TYPE_GEN = {
    "nuclear": NUKE_ID,
    "thermal": THERMAL_ID,
    "wind": WIND_ID,
    "solar": SOLAR_ID,
    "hydro": HYDRO_ID,
}
COLOR_GEN = {
    NUKE_ID: NUKE_COLOR,
    THERMAL_ID: THERMAL_COLOR,
    WIND_ID: WIND_COLOR,
    SOLAR_ID: SOLAR_COLOR,
    HYDRO_ID: HYDRO_COLOR,
}
