# Generated by Django 5.0.1 on 2024-01-28 06:44

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("artd_customer", "0001_initial"),
        ("artd_partner", "0001_initial"),
        ("artd_product", "0011_category_partner_rootcategory_partner"),
    ]

    operations = [
        migrations.CreateModel(
            name="OrderStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "status_code",
                    models.CharField(
                        help_text="Order status code",
                        max_length=100,
                        unique=True,
                        verbose_name="Order status code",
                    ),
                ),
                (
                    "status_description",
                    models.CharField(
                        help_text="Order status description",
                        max_length=250,
                        verbose_name="Order status description",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Status",
                "verbose_name_plural": "Order Statuses",
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "increment_id",
                    models.PositiveBigIntegerField(
                        help_text="Increment ID", verbose_name="Increment ID"
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        help_text="Payment code",
                        max_length=100,
                        verbose_name="Payment code",
                    ),
                ),
                (
                    "coupon_code",
                    models.CharField(
                        blank=True,
                        help_text="Coupon code",
                        max_length=100,
                        null=True,
                        verbose_name="Coupon code",
                    ),
                ),
                (
                    "discount_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base discount amount",
                        max_digits=20,
                        verbose_name="Base discount amount",
                    ),
                ),
                (
                    "grand_total",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base grand total",
                        max_digits=20,
                        verbose_name="Base grand total",
                    ),
                ),
                (
                    "shipping_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base shipping amount",
                        max_digits=20,
                        verbose_name="Base shipping amount",
                    ),
                ),
                (
                    "subtotal",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base subtotal",
                        max_digits=20,
                        verbose_name="Base subtotal",
                    ),
                ),
                (
                    "tax_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base tax amount",
                        max_digits=20,
                        verbose_name="Base tax amount",
                    ),
                ),
                (
                    "total_paid",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base total paid",
                        max_digits=20,
                        verbose_name="Base total paid",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Weight",
                        max_digits=20,
                        verbose_name="Weight",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        help_text="Comment",
                        null=True,
                        verbose_name="Comment",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        help_text="JSON data",
                        null=True,
                        verbose_name="JSON data",
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        help_text="Customer",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_customer.customer",
                        verbose_name="Customer",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order",
                "verbose_name_plural": "Orders",
            },
        ),
        migrations.CreateModel(
            name="OrderAdress",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "address_type",
                    models.CharField(
                        choices=[("billing", "Billing"), ("shipping", "Shipping")],
                        help_text="Address type",
                        max_length=100,
                        verbose_name="Address type",
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        help_text="City", max_length=100, verbose_name="City"
                    ),
                ),
                (
                    "address",
                    models.CharField(
                        help_text="Address", max_length=250, verbose_name="Address"
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        help_text="Phone", max_length=100, verbose_name="Phone"
                    ),
                ),
                (
                    "firstname",
                    models.CharField(
                        blank=True,
                        help_text="Firstname",
                        max_length=250,
                        null=True,
                        verbose_name="Firstname",
                    ),
                ),
                (
                    "lastname",
                    models.CharField(
                        blank=True,
                        help_text="Lastname",
                        max_length=250,
                        null=True,
                        verbose_name="Lastname",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True,
                        help_text="Email",
                        max_length=250,
                        null=True,
                        verbose_name="Email",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        help_text="Order",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_order.order",
                        verbose_name="Order",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Adress",
                "verbose_name_plural": "Order Adresses",
            },
        ),
        migrations.CreateModel(
            name="OrderDeliveryMethod",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "delivery_method_code",
                    models.CharField(
                        help_text="Delivery method code",
                        max_length=100,
                        unique=True,
                        verbose_name="Delivery method code",
                    ),
                ),
                (
                    "delivery_method_description",
                    models.CharField(
                        help_text="Delivery method description",
                        max_length=250,
                        verbose_name="Delivery method description",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        help_text="JSON data",
                        null=True,
                        verbose_name="JSON data",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Delivery Method",
                "verbose_name_plural": "Order Delivery Methods",
            },
        ),
        migrations.AddField(
            model_name="order",
            name="delivery_method",
            field=models.ForeignKey(
                help_text="Delivery method",
                on_delete=django.db.models.deletion.CASCADE,
                to="artd_order.orderdeliverymethod",
                verbose_name="Delivery method",
            ),
        ),
        migrations.CreateModel(
            name="OrderPaymentHistory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        help_text="Payment code",
                        max_length=100,
                        verbose_name="Payment code",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        help_text="JSON data",
                        null=True,
                        verbose_name="JSON data",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        help_text="Order",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_order.order",
                        verbose_name="Order",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Payment History",
                "verbose_name_plural": "Order Payment Histories",
            },
        ),
        migrations.CreateModel(
            name="OrderProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "quantity",
                    models.IntegerField(
                        default=1, help_text="Quantity", verbose_name="Quantity"
                    ),
                ),
                (
                    "base_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base amount",
                        max_digits=20,
                        verbose_name="Base amount",
                    ),
                ),
                (
                    "base_discount_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base discount amount",
                        max_digits=20,
                        verbose_name="Base discount amount",
                    ),
                ),
                (
                    "base_tax_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base tax amount",
                        max_digits=20,
                        verbose_name="Base tax amount",
                    ),
                ),
                (
                    "base_total",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Base total",
                        max_digits=20,
                        verbose_name="Base total",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Amount",
                        max_digits=20,
                        verbose_name="Amount",
                    ),
                ),
                (
                    "discount_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Discount amount",
                        max_digits=20,
                        verbose_name="Discount amount",
                    ),
                ),
                (
                    "tax_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Tax amount",
                        max_digits=20,
                        verbose_name="Tax amount",
                    ),
                ),
                (
                    "total",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        help_text="Total",
                        max_digits=20,
                        verbose_name="Total",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        help_text="JSON data",
                        null=True,
                        verbose_name="JSON data",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        help_text="Order",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_order.order",
                        verbose_name="Order",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        help_text="Product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_product.product",
                        verbose_name="Product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Product",
                "verbose_name_plural": "Order Products",
            },
        ),
        migrations.AddField(
            model_name="order",
            name="order_status",
            field=models.ForeignKey(
                default=1,
                help_text="Order status",
                on_delete=django.db.models.deletion.CASCADE,
                to="artd_order.orderstatus",
                verbose_name="Order status",
            ),
        ),
        migrations.CreateModel(
            name="OrderStatusHistory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date time on which the object was created.",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date time on which the object was last updated.",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the object.",
                        verbose_name="Status",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        help_text="Comment",
                        null=True,
                        verbose_name="Comment",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        help_text="Order",
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="artd_order.order",
                        verbose_name="Order",
                    ),
                ),
                (
                    "order_status",
                    models.ForeignKey(
                        help_text="Order status",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_order.orderstatus",
                        verbose_name="Order status",
                    ),
                ),
            ],
            options={
                "verbose_name": "Order Status History",
                "verbose_name_plural": "Order Status Histories",
            },
        ),
    ]
