# Cookbook


## Give each query a separate label

If you are using multiple queries in a single `Request` your code might look something like this:

```python
widget = Timeseries(
    title="resource utilization",
    requests=[
        Request(
            queries=[
                Query("aws.ec2.cpuutilization").agg("avg"),
                Query("aws.ec2.disk_read_ops").agg("avg"),
            ],
        )
    ],
)
```

The widget will have a title, but each line in the graph will have a label auto-generated by Datadog.

If you want to give each line a title yourself you need to explicitly define a
formula for each query and set the `alias`:

```python
query_cpu = Query("aws.ec2.cpuutilization").agg("avg")
query_disk = Query("aws.ec2.disk_read_ops").agg("avg")

widget = Timeseries(
    title="resource utilization",
    requests=[
        Request(
            formulas=[
                Formula(formula=query_cpu.identifier(), alias='cpu'),
                Formula(formula=query_disk.identifier(), alias='disk'),
            ],
            queries=[query_cpu, query_disk],
        )
    ],
)
```
