# coding: utf-8

"""
    Napoleon S&L API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.2.130
    Contact: ag@napoleonit.ru
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sl_api_client.api_client import ApiClient


class RouterApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_router_company_by_cid(self, cid, **kwargs):  # noqa: E501
        """Удалить компанию  # noqa: E501

        Удаляет компанию и данные о ней из системы. Удаление не затрагивает данных пользователей  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_company_by_cid(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_company_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_company_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def delete_router_company_by_cid_with_http_info(self, cid, **kwargs):  # noqa: E501
        """Удалить компанию  # noqa: E501

        Удаляет компанию и данные о ней из системы. Удаление не затрагивает данных пользователей  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_company_by_cid_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_company_by_cid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `delete_router_company_by_cid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_companywizard_by_cid(self, cid, **kwargs):  # noqa: E501
        """Удалить компанию с группами  # noqa: E501

        Полностью удалить ранее созданную компанию с группами по-умолчанию и всеми привязками. Порождается событие router_api.company.deleting. Внимание: компания и все пользователи будут удалены. Данные невозможно будет восстановить  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_companywizard_by_cid(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_companywizard_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_companywizard_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def delete_router_companywizard_by_cid_with_http_info(self, cid, **kwargs):  # noqa: E501
        """Удалить компанию с группами  # noqa: E501

        Полностью удалить ранее созданную компанию с группами по-умолчанию и всеми привязками. Порождается событие router_api.company.deleting. Внимание: компания и все пользователи будут удалены. Данные невозможно будет восстановить  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_companywizard_by_cid_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_companywizard_by_cid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `delete_router_companywizard_by_cid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/companywizard/{Cid}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_group_by_gid(self, gid, **kwargs):  # noqa: E501
        """Удалить группу  # noqa: E501

        Удаляет группу по Gid со всеми привязками   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_group_by_gid(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gid: Идентификатор группы (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_group_by_gid_with_http_info(gid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_group_by_gid_with_http_info(gid, **kwargs)  # noqa: E501
            return data

    def delete_router_group_by_gid_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Удалить группу  # noqa: E501

        Удаляет группу по Gid со всеми привязками   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_group_by_gid_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gid: Идентификатор группы (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_group_by_gid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `delete_router_group_by_gid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['Gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/group/{Gid}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_resource_by_resourceid(self, resource_id, **kwargs):  # noqa: E501
        """Удалить права на ресурс  # noqa: E501

        Удаляет права пользователя на ресурс    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_resource_by_resourceid(resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_id: ID ресурса, над которым производится действие. Алгоритм получения описан в пункте \"Получение валидного ID ресурса\" описания API (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_resource_by_resourceid_with_http_info(resource_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_resource_by_resourceid_with_http_info(resource_id, **kwargs)  # noqa: E501
            return data

    def delete_router_resource_by_resourceid_with_http_info(self, resource_id, **kwargs):  # noqa: E501
        """Удалить права на ресурс  # noqa: E501

        Удаляет права пользователя на ресурс    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_resource_by_resourceid_with_http_info(resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_id: ID ресурса, над которым производится действие. Алгоритм получения описан в пункте \"Получение валидного ID ресурса\" описания API (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_resource_by_resourceid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `delete_router_resource_by_resourceid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_id' in params:
            path_params['ResourceId'] = params['resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/resource/{ResourceId}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_service_by_prefix(self, prefix, **kwargs):  # noqa: E501
        """Удалить сервис  # noqa: E501

        Удалить сервис из системы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_service_by_prefix(prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefix: Префикс сервиса (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_service_by_prefix_with_http_info(prefix, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_service_by_prefix_with_http_info(prefix, **kwargs)  # noqa: E501
            return data

    def delete_router_service_by_prefix_with_http_info(self, prefix, **kwargs):  # noqa: E501
        """Удалить сервис  # noqa: E501

        Удалить сервис из системы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_service_by_prefix_with_http_info(prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefix: Префикс сервиса (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_service_by_prefix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'prefix' is set
        if ('prefix' not in params or
                params['prefix'] is None):
            raise ValueError("Missing the required parameter `prefix` when calling `delete_router_service_by_prefix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'prefix' in params:
            path_params['prefix'] = params['prefix']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/service/{prefix}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_user_by_uid(self, uid, **kwargs):  # noqa: E501
        """Удалить пользователя  # noqa: E501

        Удалить пользователя по ID из системы   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_user_by_uid(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_user_by_uid_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_user_by_uid_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def delete_router_user_by_uid_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Удалить пользователя  # noqa: E501

        Удалить пользователя по ID из системы   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_user_by_uid_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_user_by_uid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `delete_router_user_by_uid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_user_by_uid_group_by_gid(self, uid, gid, **kwargs):  # noqa: E501
        """Удалить группу пользователя  # noqa: E501

        Удаляет группу, к которой относится пользователь  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_user_by_uid_group_by_gid(uid, gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param str gid: Идентификатор группы (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_user_by_uid_group_by_gid_with_http_info(uid, gid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_user_by_uid_group_by_gid_with_http_info(uid, gid, **kwargs)  # noqa: E501
            return data

    def delete_router_user_by_uid_group_by_gid_with_http_info(self, uid, gid, **kwargs):  # noqa: E501
        """Удалить группу пользователя  # noqa: E501

        Удаляет группу, к которой относится пользователь  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_user_by_uid_group_by_gid_with_http_info(uid, gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param str gid: Идентификатор группы (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_user_by_uid_group_by_gid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `delete_router_user_by_uid_group_by_gid`")  # noqa: E501
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `delete_router_user_by_uid_group_by_gid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501
        if 'gid' in params:
            path_params['Gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/group/{Gid}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_router_user_by_uid_groupbyname_by_groupname(self, uid, group_name, **kwargs):  # noqa: E501
        """Удалить группу  # noqa: E501

        Удаляет группу, к которой относится пользователь  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_user_by_uid_groupbyname_by_groupname(uid, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param str group_name: Имя группы (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_router_user_by_uid_groupbyname_by_groupname_with_http_info(uid, group_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_router_user_by_uid_groupbyname_by_groupname_with_http_info(uid, group_name, **kwargs)  # noqa: E501
            return data

    def delete_router_user_by_uid_groupbyname_by_groupname_with_http_info(self, uid, group_name, **kwargs):  # noqa: E501
        """Удалить группу  # noqa: E501

        Удаляет группу, к которой относится пользователь  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_router_user_by_uid_groupbyname_by_groupname_with_http_info(uid, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param str group_name: Имя группы (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_router_user_by_uid_groupbyname_by_groupname" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `delete_router_user_by_uid_groupbyname_by_groupname`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if ('group_name' not in params or
                params['group_name'] is None):
            raise ValueError("Missing the required parameter `group_name` when calling `delete_router_user_by_uid_groupbyname_by_groupname`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501
        if 'group_name' in params:
            path_params['GroupName'] = params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/groupByName/{GroupName}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_company(self, **kwargs):  # noqa: E501
        """Запросить список компании  # noqa: E501

        Выводит список компаний уже имеющихся в системе. Отображает идентификатор, название компании и домен компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit:
        :param str after:
        :return: list[RouterCompany]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_company_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_router_company_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_router_company_with_http_info(self, **kwargs):  # noqa: E501
        """Запросить список компании  # noqa: E501

        Выводит список компаний уже имеющихся в системе. Отображает идентификатор, название компании и домен компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit:
        :param str after:
        :return: list[RouterCompany]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'after']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_company" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'after' in params:
            query_params.append(('after', params['after']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterCompany]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_company_by_cid(self, cid, **kwargs):  # noqa: E501
        """Запросить компанию  # noqa: E501

        Отображает данные об имеющейся компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_by_cid(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_company_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_router_company_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def get_router_company_by_cid_with_http_info(self, cid, **kwargs):  # noqa: E501
        """Запросить компанию  # noqa: E501

        Отображает данные об имеющейся компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_by_cid_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_company_by_cid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_router_company_by_cid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterCompany',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_company_by_cid_group(self, cid, **kwargs):  # noqa: E501
        """Запросить список групп компании  # noqa: E501

        Выводит все созданные группы компании  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_by_cid_group(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param int limit:
        :param str after:
        :return: list[RouterGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_company_by_cid_group_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_router_company_by_cid_group_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def get_router_company_by_cid_group_with_http_info(self, cid, **kwargs):  # noqa: E501
        """Запросить список групп компании  # noqa: E501

        Выводит все созданные группы компании  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_by_cid_group_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param int limit:
        :param str after:
        :return: list[RouterGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'limit', 'after']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_company_by_cid_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_router_company_by_cid_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'after' in params:
            query_params.append(('after', params['after']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/group/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterGroup]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_company_by_cid_user(self, cid, **kwargs):  # noqa: E501
        """Запросить список пользователей компании  # noqa: E501

        Выводит список всех пользователей компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_by_cid_user(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param int limit:
        :param str after:
        :return: list[RouterUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_company_by_cid_user_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_router_company_by_cid_user_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def get_router_company_by_cid_user_with_http_info(self, cid, **kwargs):  # noqa: E501
        """Запросить список пользователей компании  # noqa: E501

        Выводит список всех пользователей компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_company_by_cid_user_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param int limit:
        :param str after:
        :return: list[RouterUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'limit', 'after']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_company_by_cid_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_router_company_by_cid_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'after' in params:
            query_params.append(('after', params['after']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/user/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterUser]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_group_by_gid(self, gid, **kwargs):  # noqa: E501
        """Запросить данные группы по Gid  # noqa: E501

        Выводит данные группы по Gid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_group_by_gid(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gid: Идентификатор группы (required)
        :return: RouterGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_group_by_gid_with_http_info(gid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_router_group_by_gid_with_http_info(gid, **kwargs)  # noqa: E501
            return data

    def get_router_group_by_gid_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Запросить данные группы по Gid  # noqa: E501

        Выводит данные группы по Gid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_group_by_gid_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gid: Идентификатор группы (required)
        :return: RouterGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_group_by_gid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `get_router_group_by_gid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['Gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/group/{Gid}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_service(self, **kwargs):  # noqa: E501
        """Отобразить все сервисы  # noqa: E501

        Выводит список имеющихся сервисов в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_service(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[RouterService]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_service_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_router_service_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_router_service_with_http_info(self, **kwargs):  # noqa: E501
        """Отобразить все сервисы  # noqa: E501

        Выводит список имеющихся сервисов в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_service_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[RouterService]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_service" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/service/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterService]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_service_by_prefix(self, prefix, **kwargs):  # noqa: E501
        """Отобразить сервис по префиксу  # noqa: E501

        Сервисы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_service_by_prefix(prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefix: Префикс сервиса (required)
        :return: RouterService
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_service_by_prefix_with_http_info(prefix, **kwargs)  # noqa: E501
        else:
            (data) = self.get_router_service_by_prefix_with_http_info(prefix, **kwargs)  # noqa: E501
            return data

    def get_router_service_by_prefix_with_http_info(self, prefix, **kwargs):  # noqa: E501
        """Отобразить сервис по префиксу  # noqa: E501

        Сервисы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_service_by_prefix_with_http_info(prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefix: Префикс сервиса (required)
        :return: RouterService
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_service_by_prefix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'prefix' is set
        if ('prefix' not in params or
                params['prefix'] is None):
            raise ValueError("Missing the required parameter `prefix` when calling `get_router_service_by_prefix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'prefix' in params:
            path_params['prefix'] = params['prefix']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/service/{prefix}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterService',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_subscribe(self, **kwargs):  # noqa: E501
        """Отобразить все подписки пользователя  # noqa: E501

        Отображает все действующие подписки пользователя на сервисные события  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_subscribe(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Фильтр по ключу подписки
        :param str destination: Фильтр хосту назначения подписки
        :return: list[RouterSubscribe]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_subscribe_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_router_subscribe_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_router_subscribe_with_http_info(self, **kwargs):  # noqa: E501
        """Отобразить все подписки пользователя  # noqa: E501

        Отображает все действующие подписки пользователя на сервисные события  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_subscribe_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Фильтр по ключу подписки
        :param str destination: Фильтр хосту назначения подписки
        :return: list[RouterSubscribe]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'destination']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_subscribe" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'destination' in params:
            query_params.append(('destination', params['destination']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/subscribe/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterSubscribe]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_template(self, **kwargs):  # noqa: E501
        """Отобразить шаблоны  # noqa: E501

        Выводит все ранее созданные шаблоны в системе.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_template(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[RouterTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_template_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_router_template_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_router_template_with_http_info(self, **kwargs):  # noqa: E501
        """Отобразить шаблоны  # noqa: E501

        Выводит все ранее созданные шаблоны в системе.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_template_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[RouterTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_template" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/template/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterTemplate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_router_user_by_uid(self, uid, **kwargs):  # noqa: E501
        """Запросить информацию о пользователе  # noqa: E501

        Выводит на экран информацию о пользователя в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_user_by_uid(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_router_user_by_uid_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_router_user_by_uid_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def get_router_user_by_uid_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Запросить информацию о пользователе  # noqa: E501

        Выводит на экран информацию о пользователя в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_router_user_by_uid_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_router_user_by_uid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `get_router_user_by_uid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_company(self, body, **kwargs):  # noqa: E501
        """Добавить компанию  # noqa: E501

        Добавить новую компанию в систему. При добавлении компании задается произвольный домен третьего уровня  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterCompany body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_company_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_company_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_company_with_http_info(self, body, **kwargs):  # noqa: E501
        """Добавить компанию  # noqa: E501

        Добавить новую компанию в систему. При добавлении компании задается произвольный домен третьего уровня  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterCompany body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_company" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_company`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterCompany',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_company_by_cid(self, cid, body, **kwargs):  # noqa: E501
        """Изменить компанию  # noqa: E501

        Изменить домен и/или название компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_by_cid(cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param RouterCompany body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_company_by_cid_with_http_info(cid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_company_by_cid_with_http_info(cid, body, **kwargs)  # noqa: E501
            return data

    def post_router_company_by_cid_with_http_info(self, cid, body, **kwargs):  # noqa: E501
        """Изменить компанию  # noqa: E501

        Изменить домен и/или название компании в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_by_cid_with_http_info(cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param RouterCompany body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_company_by_cid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `post_router_company_by_cid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_company_by_cid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterCompany',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_company_by_cid_group(self, cid, body, **kwargs):  # noqa: E501
        """Добавить группу в компанию  # noqa: E501

        Добавляет в компанию группу с произвольным названием  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_by_cid_group(cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param RouterGroupAddRequest body: (required)
        :return: RouterGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_company_by_cid_group_with_http_info(cid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_company_by_cid_group_with_http_info(cid, body, **kwargs)  # noqa: E501
            return data

    def post_router_company_by_cid_group_with_http_info(self, cid, body, **kwargs):  # noqa: E501
        """Добавить группу в компанию  # noqa: E501

        Добавляет в компанию группу с произвольным названием  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_by_cid_group_with_http_info(cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param RouterGroupAddRequest body: (required)
        :return: RouterGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_company_by_cid_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `post_router_company_by_cid_group`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_company_by_cid_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/group/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_company_by_cid_user(self, cid, body, **kwargs):  # noqa: E501
        """Добавить пользователя  # noqa: E501

        Добавляет нового пользователя в систему   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_by_cid_user(cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param RouterUserAddQuery body: (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_company_by_cid_user_with_http_info(cid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_company_by_cid_user_with_http_info(cid, body, **kwargs)  # noqa: E501
            return data

    def post_router_company_by_cid_user_with_http_info(self, cid, body, **kwargs):  # noqa: E501
        """Добавить пользователя  # noqa: E501

        Добавляет нового пользователя в систему   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_by_cid_user_with_http_info(cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :param RouterUserAddQuery body: (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_company_by_cid_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `post_router_company_by_cid_user`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_company_by_cid_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/{Cid}/user/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_company_find(self, body, **kwargs):  # noqa: E501
        """Поиск компании по домену  # noqa: E501

        Поиск компании по домену третьего уровня. Домен задается в стандартной форме (dev-platform.shop-loyalty.ru)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_find(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterCommpanySearchQuery body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_company_find_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_company_find_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_company_find_with_http_info(self, body, **kwargs):  # noqa: E501
        """Поиск компании по домену  # noqa: E501

        Поиск компании по домену третьего уровня. Домен задается в стандартной форме (dev-platform.shop-loyalty.ru)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_company_find_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterCommpanySearchQuery body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_company_find" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_company_find`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/company/find/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterCompany',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_companywizard(self, body, **kwargs):  # noqa: E501
        """Добавить компанию с группами пользователей  # noqa: E501

        Добавляет в систему компанию с группами и привязками к микросервисам по-умолчанию (admins, moderators, users, ftp, auth, shops, catalog, infosystems, collections, documents, files, message, dc, userservice, orders, services, support, options, statistics, analytics), в дальнейшем группы могут быть изменены. Порождается событие router_api.company.create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_companywizard(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterCompany body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_companywizard_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_companywizard_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_companywizard_with_http_info(self, body, **kwargs):  # noqa: E501
        """Добавить компанию с группами пользователей  # noqa: E501

        Добавляет в систему компанию с группами и привязками к микросервисам по-умолчанию (admins, moderators, users, ftp, auth, shops, catalog, infosystems, collections, documents, files, message, dc, userservice, orders, services, support, options, statistics, analytics), в дальнейшем группы могут быть изменены. Порождается событие router_api.company.create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_companywizard_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterCompany body: (required)
        :return: RouterCompany
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_companywizard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_companywizard`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/companywizard/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterCompany',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_group_by_gid(self, gid, body, **kwargs):  # noqa: E501
        """Изменить название группы  # noqa: E501

        Изменяет название группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_group_by_gid(gid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gid: Идентификатор группы (required)
        :param RouterGroupChangeRequest body: (required)
        :return: RouterGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_group_by_gid_with_http_info(gid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_group_by_gid_with_http_info(gid, body, **kwargs)  # noqa: E501
            return data

    def post_router_group_by_gid_with_http_info(self, gid, body, **kwargs):  # noqa: E501
        """Изменить название группы  # noqa: E501

        Изменяет название группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_group_by_gid_with_http_info(gid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gid: Идентификатор группы (required)
        :param RouterGroupChangeRequest body: (required)
        :return: RouterGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_group_by_gid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `post_router_group_by_gid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_group_by_gid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['Gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/group/{Gid}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_resource(self, body, **kwargs):  # noqa: E501
        """Установить права на ресурс  # noqa: E501

        Установить права на ресурс  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_resource(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterResource body: (required)
        :return: RouterResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_resource_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_resource_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_resource_with_http_info(self, body, **kwargs):  # noqa: E501
        """Установить права на ресурс  # noqa: E501

        Установить права на ресурс  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_resource_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterResource body: (required)
        :return: RouterResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/resource/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_resource_by_resourceid(self, resource_id, body, **kwargs):  # noqa: E501
        """Редактировать ресурс  # noqa: E501

        Команда позволяет внести необходимые изменения в ресурс  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_resource_by_resourceid(resource_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_id: ID ресурса, над которым производится действие. Алгоритм получения описан в пункте \"Получение валидного ID ресурса\" описания API (required)
        :param RouterResource body: (required)
        :return: RouterResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_resource_by_resourceid_with_http_info(resource_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_resource_by_resourceid_with_http_info(resource_id, body, **kwargs)  # noqa: E501
            return data

    def post_router_resource_by_resourceid_with_http_info(self, resource_id, body, **kwargs):  # noqa: E501
        """Редактировать ресурс  # noqa: E501

        Команда позволяет внести необходимые изменения в ресурс  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_resource_by_resourceid_with_http_info(resource_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_id: ID ресурса, над которым производится действие. Алгоритм получения описан в пункте \"Получение валидного ID ресурса\" описания API (required)
        :param RouterResource body: (required)
        :return: RouterResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_resource_by_resourceid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `post_router_resource_by_resourceid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_resource_by_resourceid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_id' in params:
            path_params['ResourceId'] = params['resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/resource/{ResourceId}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_resource_ls(self, body, **kwargs):  # noqa: E501
        """Запросить список ресурсов  # noqa: E501

        Выводит список всех ресурсов, привязанных к компании  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_resource_ls(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterResourceGet body: (required)
        :return: list[RouterResource]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_resource_ls_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_resource_ls_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_resource_ls_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запросить список ресурсов  # noqa: E501

        Выводит список всех ресурсов, привязанных к компании  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_resource_ls_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterResourceGet body: (required)
        :return: list[RouterResource]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_resource_ls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_resource_ls`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/resource/ls/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterResource]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_service(self, body, **kwargs):  # noqa: E501
        """Создать сервис  # noqa: E501

        Создает новый сервис в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_service(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterService body: (required)
        :return: RouterService
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_service_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_service_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_service_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создать сервис  # noqa: E501

        Создает новый сервис в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_service_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterService body: (required)
        :return: RouterService
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/service/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterService',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_service_by_prefix(self, prefix, body, **kwargs):  # noqa: E501
        """Обновить или создать новый сервис  # noqa: E501

        Обновить или создать сервис  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_service_by_prefix(prefix, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefix: Префикс сервиса (required)
        :param RouterServiceUpdateRequest body: (required)
        :return: RouterService
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_service_by_prefix_with_http_info(prefix, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_service_by_prefix_with_http_info(prefix, body, **kwargs)  # noqa: E501
            return data

    def post_router_service_by_prefix_with_http_info(self, prefix, body, **kwargs):  # noqa: E501
        """Обновить или создать новый сервис  # noqa: E501

        Обновить или создать сервис  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_service_by_prefix_with_http_info(prefix, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefix: Префикс сервиса (required)
        :param RouterServiceUpdateRequest body: (required)
        :return: RouterService
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prefix', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_service_by_prefix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'prefix' is set
        if ('prefix' not in params or
                params['prefix'] is None):
            raise ValueError("Missing the required parameter `prefix` when calling `post_router_service_by_prefix`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_service_by_prefix`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'prefix' in params:
            path_params['prefix'] = params['prefix']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/service/{prefix}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterService',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_subscribe(self, body, **kwargs):  # noqa: E501
        """Создать подписку  # noqa: E501

        Позволяет включить подписки любому пользователю на определенные сервисные события. Указанному пользователю на выбранный url присылаются уведомления о происходящих операциях в сервисе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_subscribe(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterSubscribe body: (required)
        :return: RouterSubscribe
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_subscribe_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_subscribe_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_subscribe_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создать подписку  # noqa: E501

        Позволяет включить подписки любому пользователю на определенные сервисные события. Указанному пользователю на выбранный url присылаются уведомления о происходящих операциях в сервисе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_subscribe_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterSubscribe body: (required)
        :return: RouterSubscribe
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_subscribe" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_subscribe`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/subscribe/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterSubscribe',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_subscribe_delete(self, body, **kwargs):  # noqa: E501
        """Отключить подписки пользователя  # noqa: E501

        Позволяет отключить все подписки пользователя на сервисные события. Пользователю не будут приходить сообщения о сервисных событиях  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_subscribe_delete(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterSubscribeDelete body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_subscribe_delete_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_subscribe_delete_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_router_subscribe_delete_with_http_info(self, body, **kwargs):  # noqa: E501
        """Отключить подписки пользователя  # noqa: E501

        Позволяет отключить все подписки пользователя на сервисные события. Пользователю не будут приходить сообщения о сервисных событиях  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_subscribe_delete_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterSubscribeDelete body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_subscribe_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_subscribe_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/subscribe/delete/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_template(self, template, **kwargs):  # noqa: E501
        """Создать или обновить шаблон  # noqa: E501

        Позволяет создать новый шаблон или обновить старый. Шаблон содержит в себе готовую модель механизма создания ресурса. Используется при необходимости создания нескольких однотипных ресурсов.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplate template: (required)
        :return: RouterTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_template_with_http_info(template, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_template_with_http_info(template, **kwargs)  # noqa: E501
            return data

    def post_router_template_with_http_info(self, template, **kwargs):  # noqa: E501
        """Создать или обновить шаблон  # noqa: E501

        Позволяет создать новый шаблон или обновить старый. Шаблон содержит в себе готовую модель механизма создания ресурса. Используется при необходимости создания нескольких однотипных ресурсов.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_with_http_info(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplate template: (required)
        :return: RouterTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template' is set
        if ('template' not in params or
                params['template'] is None):
            raise ValueError("Missing the required parameter `template` when calling `post_router_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template' in params:
            body_params = params['template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/template/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_template_delete(self, template, **kwargs):  # noqa: E501
        """Удалить шаблон  # noqa: E501

        Удаляет ранее созданный шаблон  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_delete(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplateDeleteQuery template: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_template_delete_with_http_info(template, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_template_delete_with_http_info(template, **kwargs)  # noqa: E501
            return data

    def post_router_template_delete_with_http_info(self, template, **kwargs):  # noqa: E501
        """Удалить шаблон  # noqa: E501

        Удаляет ранее созданный шаблон  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_delete_with_http_info(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplateDeleteQuery template: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_template_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template' is set
        if ('template' not in params or
                params['template'] is None):
            raise ValueError("Missing the required parameter `template` when calling `post_router_template_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template' in params:
            body_params = params['template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/template/delete/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_template_rollback(self, template, **kwargs):  # noqa: E501
        """Удалить ресурс по шаблону  # noqa: E501

        По шаблону удаляет созданный ресурс  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_rollback(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplateUseQuery template: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_template_rollback_with_http_info(template, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_template_rollback_with_http_info(template, **kwargs)  # noqa: E501
            return data

    def post_router_template_rollback_with_http_info(self, template, **kwargs):  # noqa: E501
        """Удалить ресурс по шаблону  # noqa: E501

        По шаблону удаляет созданный ресурс  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_rollback_with_http_info(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplateUseQuery template: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_template_rollback" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template' is set
        if ('template' not in params or
                params['template'] is None):
            raise ValueError("Missing the required parameter `template` when calling `post_router_template_rollback`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template' in params:
            body_params = params['template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/template/rollback/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_template_use(self, template, **kwargs):  # noqa: E501
        """Использовать шаблон  # noqa: E501

        Позволяет использовать шаблон для создания нового ресурса  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_use(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplateUseQuery template: (required)
        :return: list[RouterResource]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_template_use_with_http_info(template, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_template_use_with_http_info(template, **kwargs)  # noqa: E501
            return data

    def post_router_template_use_with_http_info(self, template, **kwargs):  # noqa: E501
        """Использовать шаблон  # noqa: E501

        Позволяет использовать шаблон для создания нового ресурса  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_template_use_with_http_info(template, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouterTemplateUseQuery template: (required)
        :return: list[RouterResource]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_template_use" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template' is set
        if ('template' not in params or
                params['template'] is None):
            raise ValueError("Missing the required parameter `template` when calling `post_router_template_use`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template' in params:
            body_params = params['template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/template/use/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouterResource]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_user_by_uid(self, uid, body, **kwargs):  # noqa: E501
        """Обновить пользователя  # noqa: E501

        Позволяет обновить описание пользователя  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterUser body: (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_user_by_uid_with_http_info(uid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_user_by_uid_with_http_info(uid, body, **kwargs)  # noqa: E501
            return data

    def post_router_user_by_uid_with_http_info(self, uid, body, **kwargs):  # noqa: E501
        """Обновить пользователя  # noqa: E501

        Позволяет обновить описание пользователя  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_with_http_info(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterUser body: (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_user_by_uid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_router_user_by_uid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_user_by_uid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_user_by_uid_group(self, uid, body, **kwargs):  # noqa: E501
        """Добавить пользователя в группу  # noqa: E501

        Добавить созданного пользователя в определенную группу по ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_group(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterGroupAddToUserRequest body: (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_user_by_uid_group_with_http_info(uid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_user_by_uid_group_with_http_info(uid, body, **kwargs)  # noqa: E501
            return data

    def post_router_user_by_uid_group_with_http_info(self, uid, body, **kwargs):  # noqa: E501
        """Добавить пользователя в группу  # noqa: E501

        Добавить созданного пользователя в определенную группу по ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_group_with_http_info(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterGroupAddToUserRequest body: (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_user_by_uid_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_router_user_by_uid_group`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_user_by_uid_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/group/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_user_by_uid_passwd(self, uid, body, **kwargs):  # noqa: E501
        """Сменить пароль пользователя  # noqa: E501

        Меняет пароль пользователя на новый  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_passwd(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterChangePassword body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_user_by_uid_passwd_with_http_info(uid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_user_by_uid_passwd_with_http_info(uid, body, **kwargs)  # noqa: E501
            return data

    def post_router_user_by_uid_passwd_with_http_info(self, uid, body, **kwargs):  # noqa: E501
        """Сменить пароль пользователя  # noqa: E501

        Меняет пароль пользователя на новый  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_passwd_with_http_info(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterChangePassword body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_user_by_uid_passwd" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_router_user_by_uid_passwd`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_user_by_uid_passwd`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/passwd/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_user_by_uid_token(self, uid, body, **kwargs):  # noqa: E501
        """Получить ключ доступа по паролю  # noqa: E501

        По паролю отобразить токен-ключ доступа заданного пользователя  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_token(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterAuthUserRequest body: (required)
        :return: RouterAuthUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_user_by_uid_token_with_http_info(uid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_user_by_uid_token_with_http_info(uid, body, **kwargs)  # noqa: E501
            return data

    def post_router_user_by_uid_token_with_http_info(self, uid, body, **kwargs):  # noqa: E501
        """Получить ключ доступа по паролю  # noqa: E501

        По паролю отобразить токен-ключ доступа заданного пользователя  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_token_with_http_info(uid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param RouterAuthUserRequest body: (required)
        :return: RouterAuthUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_user_by_uid_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_router_user_by_uid_token`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_router_user_by_uid_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/token/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterAuthUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_router_user_by_uid_unsafetoken(self, uid, **kwargs):  # noqa: E501
        """Получить ключ доступа без пароля  # noqa: E501

        Отобразить токен-ключ доступа определенного пользователя в системе без ведения пароля. Функция доступна только привилегированным пользователям (модераторам)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_unsafetoken(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :return: RouterAuthUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_router_user_by_uid_unsafetoken_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_router_user_by_uid_unsafetoken_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def post_router_user_by_uid_unsafetoken_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Получить ключ доступа без пароля  # noqa: E501

        Отобразить токен-ключ доступа определенного пользователя в системе без ведения пароля. Функция доступна только привилегированным пользователям (модераторам)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_router_user_by_uid_unsafetoken_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :return: RouterAuthUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_router_user_by_uid_unsafetoken" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_router_user_by_uid_unsafetoken`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/unsafeToken/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterAuthUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_router_user_by_uid_groupbyname_by_groupname(self, uid, group_name, **kwargs):  # noqa: E501
        """Добавить группу пользователя по имени  # noqa: E501

        Создает новую группу по имени и добавляет в неё выбранного пользователя  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_router_user_by_uid_groupbyname_by_groupname(uid, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param str group_name: Имя группы (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_router_user_by_uid_groupbyname_by_groupname_with_http_info(uid, group_name, **kwargs)  # noqa: E501
        else:
            (data) = self.put_router_user_by_uid_groupbyname_by_groupname_with_http_info(uid, group_name, **kwargs)  # noqa: E501
            return data

    def put_router_user_by_uid_groupbyname_by_groupname_with_http_info(self, uid, group_name, **kwargs):  # noqa: E501
        """Добавить группу пользователя по имени  # noqa: E501

        Создает новую группу по имени и добавляет в неё выбранного пользователя  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_router_user_by_uid_groupbyname_by_groupname_with_http_info(uid, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: Идентификатор пользователя (required)
        :param str group_name: Имя группы (required)
        :return: RouterUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_router_user_by_uid_groupbyname_by_groupname" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `put_router_user_by_uid_groupbyname_by_groupname`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if ('group_name' not in params or
                params['group_name'] is None):
            raise ValueError("Missing the required parameter `group_name` when calling `put_router_user_by_uid_groupbyname_by_groupname`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['Uid'] = params['uid']  # noqa: E501
        if 'group_name' in params:
            path_params['GroupName'] = params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/router/user/{Uid}/groupByName/{GroupName}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouterUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
