# coding: utf-8

"""
    Napoleon S&L API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.2.130
    Contact: ag@napoleonit.ru
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sl_api_client.api_client import ApiClient


class CatalogsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_static_catalog_groups_by_groupid(self, group_id, **kwargs):  # noqa: E501
        """Удалить группу  # noqa: E501

        Удаление группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_groups_by_groupid(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_static_catalog_groups_by_groupid_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_static_catalog_groups_by_groupid_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def delete_static_catalog_groups_by_groupid_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Удалить группу  # noqa: E501

        Удаление группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_groups_by_groupid_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_static_catalog_groups_by_groupid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `delete_static_catalog_groups_by_groupid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/{groupId}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_static_catalog_groups_properties_by_propertykey(self, property_key, **kwargs):  # noqa: E501
        """Удалить свойство  # noqa: E501

        Удаление свойство  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_groups_properties_by_propertykey(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
            return data

    def delete_static_catalog_groups_properties_by_propertykey_with_http_info(self, property_key, **kwargs):  # noqa: E501
        """Удалить свойство  # noqa: E501

        Удаление свойство  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['property_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_static_catalog_groups_properties_by_propertykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'property_key' is set
        if ('property_key' not in params or
                params['property_key'] is None):
            raise ValueError("Missing the required parameter `property_key` when calling `delete_static_catalog_groups_properties_by_propertykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'property_key' in params:
            path_params['propertyKey'] = params['property_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/properties/{propertyKey}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_static_catalog_items_by_itemid(self, item_id, **kwargs):  # noqa: E501
        """Удалить товар  # noqa: E501

        Удаление товара из системы по его идентификатору  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_items_by_itemid(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_static_catalog_items_by_itemid_with_http_info(item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_static_catalog_items_by_itemid_with_http_info(item_id, **kwargs)  # noqa: E501
            return data

    def delete_static_catalog_items_by_itemid_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Удалить товар  # noqa: E501

        Удаление товара из системы по его идентификатору  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_items_by_itemid_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_static_catalog_items_by_itemid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `delete_static_catalog_items_by_itemid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_static_catalog_items_by_itemid_contiguous_by_contiguousid(self, item_id, contiguous_id, **kwargs):  # noqa: E501
        """Удаление смежного товара  # noqa: E501

        Удаление смежного товара contiguousId к itemId. При этом товар itemId становится также смежным товару contiguousId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_items_by_itemid_contiguous_by_contiguousid(item_id, contiguous_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param str contiguous_id: Идентификатор товара с которым устанавливается/удаляется связь (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(item_id, contiguous_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(item_id, contiguous_id, **kwargs)  # noqa: E501
            return data

    def delete_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(self, item_id, contiguous_id, **kwargs):  # noqa: E501
        """Удаление смежного товара  # noqa: E501

        Удаление смежного товара contiguousId к itemId. При этом товар itemId становится также смежным товару contiguousId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(item_id, contiguous_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param str contiguous_id: Идентификатор товара с которым устанавливается/удаляется связь (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'contiguous_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_static_catalog_items_by_itemid_contiguous_by_contiguousid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `delete_static_catalog_items_by_itemid_contiguous_by_contiguousid`")  # noqa: E501
        # verify the required parameter 'contiguous_id' is set
        if ('contiguous_id' not in params or
                params['contiguous_id'] is None):
            raise ValueError("Missing the required parameter `contiguous_id` when calling `delete_static_catalog_items_by_itemid_contiguous_by_contiguousid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501
        if 'contiguous_id' in params:
            path_params['contiguousId'] = params['contiguous_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/contiguous/{contiguousId}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_static_catalog_properties_by_propertykey(self, property_key, **kwargs):  # noqa: E501
        """Удалить свойство  # noqa: E501

        Удаление свойства  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_properties_by_propertykey(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_static_catalog_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_static_catalog_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
            return data

    def delete_static_catalog_properties_by_propertykey_with_http_info(self, property_key, **kwargs):  # noqa: E501
        """Удалить свойство  # noqa: E501

        Удаление свойства  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_properties_by_propertykey_with_http_info(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['property_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_static_catalog_properties_by_propertykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'property_key' is set
        if ('property_key' not in params or
                params['property_key'] is None):
            raise ValueError("Missing the required parameter `property_key` when calling `delete_static_catalog_properties_by_propertykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'property_key' in params:
            path_params['propertyKey'] = params['property_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/properties/{propertyKey}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_static_catalog_templates_by_templateid(self, template_id, **kwargs):  # noqa: E501
        """Удалить шаблон  # noqa: E501

        Удаление шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_templates_by_templateid(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_id: Идентификатор шаблона свойств (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_static_catalog_templates_by_templateid_with_http_info(template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_static_catalog_templates_by_templateid_with_http_info(template_id, **kwargs)  # noqa: E501
            return data

    def delete_static_catalog_templates_by_templateid_with_http_info(self, template_id, **kwargs):  # noqa: E501
        """Удалить шаблон  # noqa: E501

        Удаление шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_static_catalog_templates_by_templateid_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_id: Идентификатор шаблона свойств (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_static_catalog_templates_by_templateid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `delete_static_catalog_templates_by_templateid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/templates/{templateId}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_groups(self, **kwargs):  # noqa: E501
        """Запрос списка корневых групп  # noqa: E501

        Список корневых групп  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GroupWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_static_catalog_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Запрос списка корневых групп  # noqa: E501

        Список корневых групп  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GroupWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupWithRelations]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_groups_by_groupid(self, group_id, **kwargs):  # noqa: E501
        """Получить список объектов указанной группы  # noqa: E501

        Получить список объектов указанной группы по идентификатору группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_by_groupid(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :return: list[GroupWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_groups_by_groupid_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_groups_by_groupid_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_groups_by_groupid_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Получить список объектов указанной группы  # noqa: E501

        Получить список объектов указанной группы по идентификатору группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_by_groupid_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :return: list[GroupWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_groups_by_groupid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_static_catalog_groups_by_groupid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/{groupId}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupWithRelations]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_groups_by_groupid_properties(self, group_id, **kwargs):  # noqa: E501
        """Получить список свойств объектов группы  # noqa: E501

        Получить список свойств объектов группы (отражение свойства товаров указанных в шаблоне)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_by_groupid_properties(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :return: list[IProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_groups_by_groupid_properties_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_groups_by_groupid_properties_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_groups_by_groupid_properties_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Получить список свойств объектов группы  # noqa: E501

        Получить список свойств объектов группы (отражение свойства товаров указанных в шаблоне)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_by_groupid_properties_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :return: list[IProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_groups_by_groupid_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_static_catalog_groups_by_groupid_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/{groupId}/properties/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_groups_properties(self, **kwargs):  # noqa: E501
        """Запросить список свойств группы  # noqa: E501

        Запрос списка свойств группы каталога  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_properties(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[IProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_groups_properties_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_groups_properties_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_static_catalog_groups_properties_with_http_info(self, **kwargs):  # noqa: E501
        """Запросить список свойств группы  # noqa: E501

        Запрос списка свойств группы каталога  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_properties_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[IProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_groups_properties" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/properties/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_groups_properties_by_propertykey(self, property_key, **kwargs):  # noqa: E501
        """Запрос свойства группы  # noqa: E501

        Запрос свойства группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_properties_by_propertykey(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_groups_properties_by_propertykey_with_http_info(self, property_key, **kwargs):  # noqa: E501
        """Запрос свойства группы  # noqa: E501

        Запрос свойства группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['property_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_groups_properties_by_propertykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'property_key' is set
        if ('property_key' not in params or
                params['property_key'] is None):
            raise ValueError("Missing the required parameter `property_key` when calling `get_static_catalog_groups_properties_by_propertykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'property_key' in params:
            path_params['propertyKey'] = params['property_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/properties/{propertyKey}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_items_by_itemid(self, item_id, **kwargs):  # noqa: E501
        """Запрос информации о товаре по ID  # noqa: E501

        Запрос информации о товаре и его свойствах по идентификатору товара  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_items_by_itemid(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :return: CatalogItemWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_items_by_itemid_with_http_info(item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_items_by_itemid_with_http_info(item_id, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_items_by_itemid_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Запрос информации о товаре по ID  # noqa: E501

        Запрос информации о товаре и его свойствах по идентификатору товара  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_items_by_itemid_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :return: CatalogItemWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_items_by_itemid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `get_static_catalog_items_by_itemid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogItemWithRelations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_items_by_itemid_contiguous(self, item_id, **kwargs):  # noqa: E501
        """Запрос смежных товаров  # noqa: E501

        Запрос выведет список смежных товаров. Ссылки на смежные товары отображаются в таблице и заполняются вручную  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_items_by_itemid_contiguous(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :return: list[CatalogItemWithRemains]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_items_by_itemid_contiguous_with_http_info(item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_items_by_itemid_contiguous_with_http_info(item_id, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_items_by_itemid_contiguous_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Запрос смежных товаров  # noqa: E501

        Запрос выведет список смежных товаров. Ссылки на смежные товары отображаются в таблице и заполняются вручную  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_items_by_itemid_contiguous_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :return: list[CatalogItemWithRemains]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_items_by_itemid_contiguous" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `get_static_catalog_items_by_itemid_contiguous`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/contiguous/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemWithRemains]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_properties(self, **kwargs):  # noqa: E501
        """Запросить список свойств товара  # noqa: E501

        Запрос списка свойств  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_properties(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[IProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_properties_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_properties_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_static_catalog_properties_with_http_info(self, **kwargs):  # noqa: E501
        """Запросить список свойств товара  # noqa: E501

        Запрос списка свойств  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_properties_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[IProperty]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_properties" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/properties/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IProperty]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_properties_by_propertykey(self, property_key, **kwargs):  # noqa: E501
        """Запросить свойство  # noqa: E501

        Выводит структуру запрашиваемого свойства по его идентификатору  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_properties_by_propertykey(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_properties_by_propertykey_with_http_info(property_key, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_properties_by_propertykey_with_http_info(self, property_key, **kwargs):  # noqa: E501
        """Запросить свойство  # noqa: E501

        Выводит структуру запрашиваемого свойства по его идентификатору  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_properties_by_propertykey_with_http_info(property_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['property_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_properties_by_propertykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'property_key' is set
        if ('property_key' not in params or
                params['property_key'] is None):
            raise ValueError("Missing the required parameter `property_key` when calling `get_static_catalog_properties_by_propertykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'property_key' in params:
            path_params['propertyKey'] = params['property_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/properties/{propertyKey}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_templates(self, **kwargs):  # noqa: E501
        """Запросить список шаблонов  # noqa: E501

         По запросу отображаются все существующие шаблоны для компании  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Template]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_templates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_templates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_static_catalog_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Запросить список шаблонов  # noqa: E501

         По запросу отображаются все существующие шаблоны для компании  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Template]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_templates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/templates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Template]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_static_catalog_templates_by_templateid(self, template_id, **kwargs):  # noqa: E501
        """Запросить шаблон  # noqa: E501

        Выводит структуру запрошенного шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_templates_by_templateid(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_id: Идентификатор шаблона свойств (required)
        :return: TemplateWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_static_catalog_templates_by_templateid_with_http_info(template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_static_catalog_templates_by_templateid_with_http_info(template_id, **kwargs)  # noqa: E501
            return data

    def get_static_catalog_templates_by_templateid_with_http_info(self, template_id, **kwargs):  # noqa: E501
        """Запросить шаблон  # noqa: E501

        Выводит структуру запрошенного шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_static_catalog_templates_by_templateid_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_id: Идентификатор шаблона свойств (required)
        :return: TemplateWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_static_catalog_templates_by_templateid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_static_catalog_templates_by_templateid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/templates/{templateId}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplateWithRelations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_count(self, body, **kwargs):  # noqa: E501
        """Поиск с фильтрацией  # noqa: E501

        Количество записей, соответствующих критериям поиска  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_count(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BaseQuery body: (required)
        :return: CountQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_count_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_count_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_count_with_http_info(self, body, **kwargs):  # noqa: E501
        """Поиск с фильтрацией  # noqa: E501

        Количество записей, соответствующих критериям поиска  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_count_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BaseQuery body: (required)
        :return: CountQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_count" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/count/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountQueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_groupquery(self, body, **kwargs):  # noqa: E501
        """Запрос списка групп товара  # noqa: E501

        Осуществляет запрос списка всех групп, в котором находится указанный товар  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groupquery(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogGroupQuery body: (required)
        :return: list[GroupWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_groupquery_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_groupquery_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_groupquery_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запрос списка групп товара  # noqa: E501

        Осуществляет запрос списка всех групп, в котором находится указанный товар  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groupquery_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogGroupQuery body: (required)
        :return: list[GroupWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_groupquery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_groupquery`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groupQuery/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupWithRelations]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_groups(self, body, **kwargs):  # noqa: E501
        """Создать группу  # noqa: E501

        Добавление новой группы в систему  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupWithRelations body: (required)
        :return: GroupWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_groups_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_groups_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_groups_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создать группу  # noqa: E501

        Добавление новой группы в систему  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupWithRelations body: (required)
        :return: GroupWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_groups`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupWithRelations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_groups_by_groupid(self, group_id, body, **kwargs):  # noqa: E501
        """Обновить группу  # noqa: E501

        Обновление группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_by_groupid(group_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :param GroupWithRelations body: (required)
        :return: GroupWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_groups_by_groupid_with_http_info(group_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_groups_by_groupid_with_http_info(group_id, body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_groups_by_groupid_with_http_info(self, group_id, body, **kwargs):  # noqa: E501
        """Обновить группу  # noqa: E501

        Обновление группы  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_by_groupid_with_http_info(group_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: Идентификатор группы (required)
        :param GroupWithRelations body: (required)
        :return: GroupWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_groups_by_groupid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `post_static_catalog_groups_by_groupid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_groups_by_groupid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/{groupId}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupWithRelations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_groups_properties(self, body, **kwargs):  # noqa: E501
        """Создать свойство для групп  # noqa: E501

        Создание свойства для групп каталога  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_properties(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_groups_properties_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_groups_properties_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_groups_properties_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создать свойство для групп  # noqa: E501

        Создание свойства для групп каталога  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_properties_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_groups_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_groups_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/properties/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_groups_properties_by_propertykey(self, property_key, body, **kwargs):  # noqa: E501
        """Обновить свойства  # noqa: E501

        Обновление свойства  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_properties_by_propertykey(property_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_groups_properties_by_propertykey_with_http_info(self, property_key, body, **kwargs):  # noqa: E501
        """Обновить свойства  # noqa: E501

        Обновление свойства  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_groups_properties_by_propertykey_with_http_info(property_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['property_key', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_groups_properties_by_propertykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'property_key' is set
        if ('property_key' not in params or
                params['property_key'] is None):
            raise ValueError("Missing the required parameter `property_key` when calling `post_static_catalog_groups_properties_by_propertykey`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_groups_properties_by_propertykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'property_key' in params:
            path_params['propertyKey'] = params['property_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/groups/properties/{propertyKey}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_items(self, body, **kwargs):  # noqa: E501
        """Создание нового товара  # noqa: E501

        Добавление нового товара в систему  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogItemWithRelations body: Объект создаваемого товара (required)
        :return: CatalogItemWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_items_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_items_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_items_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создание нового товара  # noqa: E501

        Добавление нового товара в систему  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogItemWithRelations body: Объект создаваемого товара (required)
        :return: CatalogItemWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogItemWithRelations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_items_bulk(self, body, **kwargs):  # noqa: E501
        """Пакетное создание или обновление товара  # noqa: E501

        Метод позволяет осуществить массовый перенос товаров из внешней системы учета (напр. 1С) и обновить текущий список всех товаров в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_bulk(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body body: (required)
        :return: list[CatalogItemWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_items_bulk_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_items_bulk_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_items_bulk_with_http_info(self, body, **kwargs):  # noqa: E501
        """Пакетное создание или обновление товара  # noqa: E501

        Метод позволяет осуществить массовый перенос товаров из внешней системы учета (напр. 1С) и обновить текущий список всех товаров в системе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_bulk_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body body: (required)
        :return: list[CatalogItemWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_items_bulk" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_items_bulk`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/bulk/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemWithRelations]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_items_by_itemid(self, item_id, body, **kwargs):  # noqa: E501
        """Обновить информацию о товаре  # noqa: E501

        Обновление информации о товаре  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_by_itemid(item_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param CatalogItemWithRelations body: (required)
        :return: CatalogItemWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_items_by_itemid_with_http_info(item_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_items_by_itemid_with_http_info(item_id, body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_items_by_itemid_with_http_info(self, item_id, body, **kwargs):  # noqa: E501
        """Обновить информацию о товаре  # noqa: E501

        Обновление информации о товаре  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_by_itemid_with_http_info(item_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param CatalogItemWithRelations body: (required)
        :return: CatalogItemWithRelations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_items_by_itemid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `post_static_catalog_items_by_itemid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_items_by_itemid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogItemWithRelations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_items_by_itemid_shops(self, item_id, body, **kwargs):  # noqa: E501
        """Запрос цены и остатка товара в магазине  # noqa: E501

        Запрос остатков и цен по магазинам для товара  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_by_itemid_shops(item_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param CatalogItemInShopQuery body: (required)
        :return: list[CatalogItemInShop]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_items_by_itemid_shops_with_http_info(item_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_items_by_itemid_shops_with_http_info(item_id, body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_items_by_itemid_shops_with_http_info(self, item_id, body, **kwargs):  # noqa: E501
        """Запрос цены и остатка товара в магазине  # noqa: E501

        Запрос остатков и цен по магазинам для товара  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_items_by_itemid_shops_with_http_info(item_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param CatalogItemInShopQuery body: (required)
        :return: list[CatalogItemInShop]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_items_by_itemid_shops" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `post_static_catalog_items_by_itemid_shops`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_items_by_itemid_shops`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/shops/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemInShop]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_itemsforindexer(self, body, **kwargs):  # noqa: E501
        """Запрос списка товаров  # noqa: E501

        Запрос осуществляет выгрузку всех товаров из базы данных с применением параметров limit и offset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_itemsforindexer(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogIndexerQuery body: (required)
        :return: list[CatalogItemWithRemains]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_itemsforindexer_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_itemsforindexer_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_itemsforindexer_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запрос списка товаров  # noqa: E501

        Запрос осуществляет выгрузку всех товаров из базы данных с применением параметров limit и offset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_itemsforindexer_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogIndexerQuery body: (required)
        :return: list[CatalogItemWithRemains]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_itemsforindexer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_itemsforindexer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/itemsForIndexer/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemWithRemains]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_itemsshops(self, body, **kwargs):  # noqa: E501
        """Запрос цены и остатка товара  # noqa: E501

        Запрос позволяет выявить количество остатков конкретного товара в магаизне и узнать его стоимость  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_itemsshops(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogItemsInShopsQuery body: (required)
        :return: list[CatalogItemInShop]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_itemsshops_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_itemsshops_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_itemsshops_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запрос цены и остатка товара  # noqa: E501

        Запрос позволяет выявить количество остатков конкретного товара в магаизне и узнать его стоимость  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_itemsshops_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogItemsInShopsQuery body: (required)
        :return: list[CatalogItemInShop]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_itemsshops" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_itemsshops`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/itemsShops/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemInShop]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_properties(self, body, **kwargs):  # noqa: E501
        """Создать новое свойство  # noqa: E501

        Создание нового свойства в системе для последующей его привязки к товару или группе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_properties(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_properties_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_properties_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_properties_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создать новое свойство  # noqa: E501

        Создание нового свойства в системе для последующей его привязки к товару или группе  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_properties_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/properties/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_properties_by_propertykey(self, property_key, body, **kwargs):  # noqa: E501
        """Обновить свойство  # noqa: E501

        Обновление существующего свойства по его идентификатору  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_properties_by_propertykey(property_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_properties_by_propertykey_with_http_info(property_key, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_properties_by_propertykey_with_http_info(property_key, body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_properties_by_propertykey_with_http_info(self, property_key, body, **kwargs):  # noqa: E501
        """Обновить свойство  # noqa: E501

        Обновление существующего свойства по его идентификатору  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_properties_by_propertykey_with_http_info(property_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str property_key: Идентификатор свойства элемента (required)
        :param IProperty body:  (required)
        :return: IProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['property_key', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_properties_by_propertykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'property_key' is set
        if ('property_key' not in params or
                params['property_key'] is None):
            raise ValueError("Missing the required parameter `property_key` when calling `post_static_catalog_properties_by_propertykey`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_properties_by_propertykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'property_key' in params:
            path_params['propertyKey'] = params['property_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/properties/{propertyKey}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IProperty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_query(self, body, **kwargs):  # noqa: E501
        """Запрос списка товаров  # noqa: E501

        Запрос осуществляет выгрузку всех товаров из базы данных с применением параметров limit и offset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_query(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogQuery body: (required)
        :return: list[CatalogItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_query_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_query_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_query_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запрос списка товаров  # noqa: E501

        Запрос осуществляет выгрузку всех товаров из базы данных с применением параметров limit и offset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_query_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogQuery body: (required)
        :return: list[CatalogItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/query/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_querywithrelations(self, body, **kwargs):  # noqa: E501
        """Запрос списка товаров  # noqa: E501

        Запрос списка товаров  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_querywithrelations(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogQuery body: (required)
        :return: list[CatalogItemWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_querywithrelations_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_querywithrelations_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_querywithrelations_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запрос списка товаров  # noqa: E501

        Запрос списка товаров  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_querywithrelations_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CatalogQuery body: (required)
        :return: list[CatalogItemWithRelations]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_querywithrelations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_querywithrelations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/queryWithRelations/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemWithRelations]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_request(self, body, **kwargs):  # noqa: E501
        """Поиск с агрегацией  # noqa: E501

        Поиск с возможностью агрегации собираемых данных  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_request(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchRequest body: (required)
        :return: CatalogResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_request_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_request_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_request_with_http_info(self, body, **kwargs):  # noqa: E501
        """Поиск с агрегацией  # noqa: E501

        Поиск с возможностью агрегации собираемых данных  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_request_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchRequest body: (required)
        :return: CatalogResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/request/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_search(self, body, **kwargs):  # noqa: E501
        """Запрос списка продуктов  # noqa: E501

        Запрос списка продуктов  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_search(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchQuery body: (required)
        :return: list[CatalogItemWithRemains]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_search_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_search_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_search_with_http_info(self, body, **kwargs):  # noqa: E501
        """Запрос списка продуктов  # noqa: E501

        Запрос списка продуктов  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_search_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchQuery body: (required)
        :return: list[CatalogItemWithRemains]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/search/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CatalogItemWithRemains]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_templates(self, body, **kwargs):  # noqa: E501
        """Создать новый шаблон  # noqa: E501

        Создание в системе нового шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_templates(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateWithRelations body: (required)
        :return: Template
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_templates_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_templates_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_templates_with_http_info(self, body, **kwargs):  # noqa: E501
        """Создать новый шаблон  # noqa: E501

        Создание в системе нового шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_templates_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateWithRelations body: (required)
        :return: Template
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/templates/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Template',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_static_catalog_templates_by_templateid(self, template_id, body, **kwargs):  # noqa: E501
        """Обновить шаблон  # noqa: E501

        Обновление шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_templates_by_templateid(template_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_id: Идентификатор шаблона свойств (required)
        :param TemplateWithRelations body: (required)
        :return: Template
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_static_catalog_templates_by_templateid_with_http_info(template_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_static_catalog_templates_by_templateid_with_http_info(template_id, body, **kwargs)  # noqa: E501
            return data

    def post_static_catalog_templates_by_templateid_with_http_info(self, template_id, body, **kwargs):  # noqa: E501
        """Обновить шаблон  # noqa: E501

        Обновление шаблона  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_static_catalog_templates_by_templateid_with_http_info(template_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str template_id: Идентификатор шаблона свойств (required)
        :param TemplateWithRelations body: (required)
        :return: Template
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_static_catalog_templates_by_templateid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `post_static_catalog_templates_by_templateid`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_static_catalog_templates_by_templateid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/templates/{templateId}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Template',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_static_catalog_index_by_cid(self, cid, **kwargs):  # noqa: E501
        """Инициализация индекса в эластике  # noqa: E501

        Инициализация индекса в эластике  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_static_catalog_index_by_cid(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_static_catalog_index_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_static_catalog_index_by_cid_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def put_static_catalog_index_by_cid_with_http_info(self, cid, **kwargs):  # noqa: E501
        """Инициализация индекса в эластике  # noqa: E501

        Инициализация индекса в эластике  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_static_catalog_index_by_cid_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Идентификатор компании (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_static_catalog_index_by_cid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `put_static_catalog_index_by_cid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['Cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/index/{Cid}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_static_catalog_items_by_itemid_contiguous_by_contiguousid(self, item_id, contiguous_id, **kwargs):  # noqa: E501
        """Добавление смежного товара  # noqa: E501

        Добавление смежного товара СontiguousId к itemId. При этом товар itemId становится также смежным товару contiguousId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_static_catalog_items_by_itemid_contiguous_by_contiguousid(item_id, contiguous_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param str contiguous_id: Идентификатор товара с которым устанавливается/удаляется связь (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(item_id, contiguous_id, **kwargs)  # noqa: E501
        else:
            (data) = self.put_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(item_id, contiguous_id, **kwargs)  # noqa: E501
            return data

    def put_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(self, item_id, contiguous_id, **kwargs):  # noqa: E501
        """Добавление смежного товара  # noqa: E501

        Добавление смежного товара СontiguousId к itemId. При этом товар itemId становится также смежным товару contiguousId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_static_catalog_items_by_itemid_contiguous_by_contiguousid_with_http_info(item_id, contiguous_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Идентификатор элемента (required)
        :param str contiguous_id: Идентификатор товара с которым устанавливается/удаляется связь (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'contiguous_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_static_catalog_items_by_itemid_contiguous_by_contiguousid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `put_static_catalog_items_by_itemid_contiguous_by_contiguousid`")  # noqa: E501
        # verify the required parameter 'contiguous_id' is set
        if ('contiguous_id' not in params or
                params['contiguous_id'] is None):
            raise ValueError("Missing the required parameter `contiguous_id` when calling `put_static_catalog_items_by_itemid_contiguous_by_contiguousid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501
        if 'contiguous_id' in params:
            path_params['contiguousId'] = params['contiguous_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['x-cid', 'x-token']  # noqa: E501

        return self.api_client.call_api(
            '/static/catalog/items/{itemId}/contiguous/{contiguousId}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
