# sl-api-client

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.2.130
- Package version: 1.2.130
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://napoleonit.ru](http://napoleonit.ru)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import sl_api_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import sl_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import sl_api_client
from sl_api_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: x-cid
configuration = sl_api_client.Configuration()
configuration.api_key['x-cid'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-cid'] = 'Bearer'
# Configure API key authorization: x-token
configuration = sl_api_client.Configuration()
configuration.api_key['x-token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-token'] = 'Bearer'

# create an instance of the API class
api_instance = sl_api_client.AnalyticsApi(sl_api_client.ApiClient(configuration))
item_id = 'item_id_example' # str | Идентификатор элемента
begin_time = 789 # int | Таймштамп начала выборки. Если 0 или не указан то ограничение отсутствует. (optional)
end_time = 789 # int | Таймштамп окончания выборки. Если 0 или не указан то ограничение отсутствует. (optional)

try:
    # Количество уникальных просмотров в заданный промежуток времени
    api_response = api_instance.get_analytics_catalog_show_item_by_itemid(item_id, begin_time=begin_time, end_time=end_time)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnalyticsApi->get_analytics_catalog_show_item_by_itemid: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://shop-loyalty.ru*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnalyticsApi* | [**get_analytics_catalog_show_item_by_itemid**](docs/AnalyticsApi.md#get_analytics_catalog_show_item_by_itemid) | **GET** /analytics/catalog/show/item/{itemId}/ | Количество уникальных просмотров в заданный промежуток времени
*AnalyticsApi* | [**get_analytics_orders_status**](docs/AnalyticsApi.md#get_analytics_orders_status) | **GET** /analytics/orders/status/ | Выборка из заказов за указанный промежуток времени по статусу.
*AnalyticsApi* | [**get_analytics_orders_status_csv**](docs/AnalyticsApi.md#get_analytics_orders_status_csv) | **GET** /analytics/orders/status/csv/ | Выгрузка CSV по заказам
*AnalyticsApi* | [**get_analytics_orders_users**](docs/AnalyticsApi.md#get_analytics_orders_users) | **GET** /analytics/orders/users/ | Выборка пользователей когда-либо совершавших заказ.
*AnalyticsApi* | [**get_analytics_push_by_itemid**](docs/AnalyticsApi.md#get_analytics_push_by_itemid) | **GET** /analytics/push/{itemId}/ | Статистика рассылки
*AnalyticsApi* | [**get_analytics_push_by_itemid_unopened_csv**](docs/AnalyticsApi.md#get_analytics_push_by_itemid_unopened_csv) | **GET** /analytics/push/{itemId}/unopened/csv/ | Выгрузка CSV по push рассылке
*AuthApi* | [**delete_auth_user_by_userid**](docs/AuthApi.md#delete_auth_user_by_userid) | **DELETE** /auth/user/{userId}/ | Удаление пользователей из Users и Router API
*AuthApi* | [**post_auth_batch_useradd**](docs/AuthApi.md#post_auth_batch_useradd) | **POST** /auth/batch/useradd/ | Пакетное добавление пользователей
*AuthApi* | [**post_auth_batch_userupdate**](docs/AuthApi.md#post_auth_batch_userupdate) | **POST** /auth/batch/userupdate/ | Пакетное обновление пользователей
*AuthApi* | [**post_auth_check_communication**](docs/AuthApi.md#post_auth_check_communication) | **POST** /auth/check/communication/ | Проверка средства связи
*AuthApi* | [**post_auth_invite**](docs/AuthApi.md#post_auth_invite) | **POST** /auth/invite/ | Создание пользователей с инвайтом
*AuthApi* | [**post_auth_recovery_password**](docs/AuthApi.md#post_auth_recovery_password) | **POST** /auth/recovery/password/ | Запрос на восстановления пароля
*AuthApi* | [**post_auth_recovery_password_confirmation**](docs/AuthApi.md#post_auth_recovery_password_confirmation) | **POST** /auth/recovery/password/confirmation/ | Подтверждение кода авторизации при восстановлении пароля
*AuthApi* | [**post_auth_signin_code**](docs/AuthApi.md#post_auth_signin_code) | **POST** /auth/signin/code/ | Запросить код авторизации
*AuthApi* | [**post_auth_signin_code_confirmation**](docs/AuthApi.md#post_auth_signin_code_confirmation) | **POST** /auth/signin/code/confirmation/ | Подтверждение кода авторизации
*AuthApi* | [**post_auth_signin_password**](docs/AuthApi.md#post_auth_signin_password) | **POST** /auth/signin/password/ | Парольная авторизация
*AuthApi* | [**post_auth_signin_social**](docs/AuthApi.md#post_auth_signin_social) | **POST** /auth/signin/social/ | Авторизация через соц сеть
*AuthApi* | [**post_auth_signup_password**](docs/AuthApi.md#post_auth_signup_password) | **POST** /auth/signup/password/ | Регистрация по паролю
*AuthApi* | [**post_auth_verify_communication**](docs/AuthApi.md#post_auth_verify_communication) | **POST** /auth/verify/communication/ | Подтверждение средства связи
*BTerritoryApi* | [**post_bterritory_inn**](docs/BTerritoryApi.md#post_bterritory_inn) | **POST** /bterritory/inn/ | 
*BTerritoryApi* | [**post_bterritory_recovery_password**](docs/BTerritoryApi.md#post_bterritory_recovery_password) | **POST** /bterritory/recovery/password/ | 
*BTerritoryApi* | [**post_bterritory_signin_password**](docs/BTerritoryApi.md#post_bterritory_signin_password) | **POST** /bterritory/signin/password/ | Авторизация по email. Email - проверка по регулярному выражению email 
*BTerritoryApi* | [**post_bterritory_signup_password**](docs/BTerritoryApi.md#post_bterritory_signup_password) | **POST** /bterritory/signup/password/ | 
*BTerritoryApi* | [**post_bterritory_time**](docs/BTerritoryApi.md#post_bterritory_time) | **POST** /bterritory/time/ | 
*BTerritoryApi* | [**post_bterritory_user_by_userid**](docs/BTerritoryApi.md#post_bterritory_user_by_userid) | **POST** /bterritory/user/{userId}/ | 
*CalendarApi* | [**delete_cal_date**](docs/CalendarApi.md#delete_cal_date) | **DELETE** /cal/date/ | 
*CalendarApi* | [**delete_cal_default**](docs/CalendarApi.md#delete_cal_default) | **DELETE** /cal/default/ | 
*CalendarApi* | [**delete_cal_week**](docs/CalendarApi.md#delete_cal_week) | **DELETE** /cal/week/ | 
*CalendarApi* | [**get_cal_date**](docs/CalendarApi.md#get_cal_date) | **GET** /cal/date/ | 
*CalendarApi* | [**get_cal_default**](docs/CalendarApi.md#get_cal_default) | **GET** /cal/default/ | 
*CalendarApi* | [**get_cal_time_shop**](docs/CalendarApi.md#get_cal_time_shop) | **GET** /cal/time/shop/ | 
*CalendarApi* | [**get_cal_week**](docs/CalendarApi.md#get_cal_week) | **GET** /cal/week/ | 
*CalendarApi* | [**post_cal_date**](docs/CalendarApi.md#post_cal_date) | **POST** /cal/date/ | 
*CalendarApi* | [**post_cal_default**](docs/CalendarApi.md#post_cal_default) | **POST** /cal/default/ | 
*CalendarApi* | [**post_cal_list_date**](docs/CalendarApi.md#post_cal_list_date) | **POST** /cal/list/date/ | 
*CalendarApi* | [**post_cal_list_default**](docs/CalendarApi.md#post_cal_list_default) | **POST** /cal/list/default/ | 
*CalendarApi* | [**post_cal_list_week**](docs/CalendarApi.md#post_cal_list_week) | **POST** /cal/list/week/ | 
*CalendarApi* | [**post_cal_time_shop_work**](docs/CalendarApi.md#post_cal_time_shop_work) | **POST** /cal/time/shop/work/ | 
*CalendarApi* | [**post_cal_week**](docs/CalendarApi.md#post_cal_week) | **POST** /cal/week/ | 
*CatalogsApi* | [**delete_static_catalog_groups_by_groupid**](docs/CatalogsApi.md#delete_static_catalog_groups_by_groupid) | **DELETE** /static/catalog/groups/{groupId}/ | Удалить группу
*CatalogsApi* | [**delete_static_catalog_groups_properties_by_propertykey**](docs/CatalogsApi.md#delete_static_catalog_groups_properties_by_propertykey) | **DELETE** /static/catalog/groups/properties/{propertyKey}/ | Удалить свойство
*CatalogsApi* | [**delete_static_catalog_items_by_itemid**](docs/CatalogsApi.md#delete_static_catalog_items_by_itemid) | **DELETE** /static/catalog/items/{itemId}/ | Удалить товар
*CatalogsApi* | [**delete_static_catalog_items_by_itemid_contiguous_by_contiguousid**](docs/CatalogsApi.md#delete_static_catalog_items_by_itemid_contiguous_by_contiguousid) | **DELETE** /static/catalog/items/{itemId}/contiguous/{contiguousId}/ | Удаление смежного товара
*CatalogsApi* | [**delete_static_catalog_properties_by_propertykey**](docs/CatalogsApi.md#delete_static_catalog_properties_by_propertykey) | **DELETE** /static/catalog/properties/{propertyKey}/ | Удалить свойство
*CatalogsApi* | [**delete_static_catalog_templates_by_templateid**](docs/CatalogsApi.md#delete_static_catalog_templates_by_templateid) | **DELETE** /static/catalog/templates/{templateId}/ | Удалить шаблон
*CatalogsApi* | [**get_static_catalog_groups**](docs/CatalogsApi.md#get_static_catalog_groups) | **GET** /static/catalog/groups/ | Запрос списка корневых групп
*CatalogsApi* | [**get_static_catalog_groups_by_groupid**](docs/CatalogsApi.md#get_static_catalog_groups_by_groupid) | **GET** /static/catalog/groups/{groupId}/ | Получить список объектов указанной группы
*CatalogsApi* | [**get_static_catalog_groups_by_groupid_properties**](docs/CatalogsApi.md#get_static_catalog_groups_by_groupid_properties) | **GET** /static/catalog/groups/{groupId}/properties/ | Получить список свойств объектов группы
*CatalogsApi* | [**get_static_catalog_groups_properties**](docs/CatalogsApi.md#get_static_catalog_groups_properties) | **GET** /static/catalog/groups/properties/ | Запросить список свойств группы
*CatalogsApi* | [**get_static_catalog_groups_properties_by_propertykey**](docs/CatalogsApi.md#get_static_catalog_groups_properties_by_propertykey) | **GET** /static/catalog/groups/properties/{propertyKey}/ | Запрос свойства группы
*CatalogsApi* | [**get_static_catalog_items_by_itemid**](docs/CatalogsApi.md#get_static_catalog_items_by_itemid) | **GET** /static/catalog/items/{itemId}/ | Запрос информации о товаре по ID
*CatalogsApi* | [**get_static_catalog_items_by_itemid_contiguous**](docs/CatalogsApi.md#get_static_catalog_items_by_itemid_contiguous) | **GET** /static/catalog/items/{itemId}/contiguous/ | Запрос смежных товаров
*CatalogsApi* | [**get_static_catalog_properties**](docs/CatalogsApi.md#get_static_catalog_properties) | **GET** /static/catalog/properties/ | Запросить список свойств товара
*CatalogsApi* | [**get_static_catalog_properties_by_propertykey**](docs/CatalogsApi.md#get_static_catalog_properties_by_propertykey) | **GET** /static/catalog/properties/{propertyKey}/ | Запросить свойство
*CatalogsApi* | [**get_static_catalog_templates**](docs/CatalogsApi.md#get_static_catalog_templates) | **GET** /static/catalog/templates/ | Запросить список шаблонов
*CatalogsApi* | [**get_static_catalog_templates_by_templateid**](docs/CatalogsApi.md#get_static_catalog_templates_by_templateid) | **GET** /static/catalog/templates/{templateId}/ | Запросить шаблон
*CatalogsApi* | [**post_static_catalog_count**](docs/CatalogsApi.md#post_static_catalog_count) | **POST** /static/catalog/count/ | Поиск с фильтрацией
*CatalogsApi* | [**post_static_catalog_groupquery**](docs/CatalogsApi.md#post_static_catalog_groupquery) | **POST** /static/catalog/groupQuery/ | Запрос списка групп товара
*CatalogsApi* | [**post_static_catalog_groups**](docs/CatalogsApi.md#post_static_catalog_groups) | **POST** /static/catalog/groups/ | Создать группу
*CatalogsApi* | [**post_static_catalog_groups_by_groupid**](docs/CatalogsApi.md#post_static_catalog_groups_by_groupid) | **POST** /static/catalog/groups/{groupId}/ | Обновить группу
*CatalogsApi* | [**post_static_catalog_groups_properties**](docs/CatalogsApi.md#post_static_catalog_groups_properties) | **POST** /static/catalog/groups/properties/ | Создать свойство для групп
*CatalogsApi* | [**post_static_catalog_groups_properties_by_propertykey**](docs/CatalogsApi.md#post_static_catalog_groups_properties_by_propertykey) | **POST** /static/catalog/groups/properties/{propertyKey}/ | Обновить свойства
*CatalogsApi* | [**post_static_catalog_items**](docs/CatalogsApi.md#post_static_catalog_items) | **POST** /static/catalog/items/ | Создание нового товара
*CatalogsApi* | [**post_static_catalog_items_bulk**](docs/CatalogsApi.md#post_static_catalog_items_bulk) | **POST** /static/catalog/items/bulk/ | Пакетное создание или обновление товара
*CatalogsApi* | [**post_static_catalog_items_by_itemid**](docs/CatalogsApi.md#post_static_catalog_items_by_itemid) | **POST** /static/catalog/items/{itemId}/ | Обновить информацию о товаре
*CatalogsApi* | [**post_static_catalog_items_by_itemid_shops**](docs/CatalogsApi.md#post_static_catalog_items_by_itemid_shops) | **POST** /static/catalog/items/{itemId}/shops/ | Запрос цены и остатка товара в магазине
*CatalogsApi* | [**post_static_catalog_itemsforindexer**](docs/CatalogsApi.md#post_static_catalog_itemsforindexer) | **POST** /static/catalog/itemsForIndexer/ | Запрос списка товаров
*CatalogsApi* | [**post_static_catalog_itemsshops**](docs/CatalogsApi.md#post_static_catalog_itemsshops) | **POST** /static/catalog/itemsShops/ | Запрос цены и остатка товара
*CatalogsApi* | [**post_static_catalog_properties**](docs/CatalogsApi.md#post_static_catalog_properties) | **POST** /static/catalog/properties/ | Создать новое свойство
*CatalogsApi* | [**post_static_catalog_properties_by_propertykey**](docs/CatalogsApi.md#post_static_catalog_properties_by_propertykey) | **POST** /static/catalog/properties/{propertyKey}/ | Обновить свойство
*CatalogsApi* | [**post_static_catalog_query**](docs/CatalogsApi.md#post_static_catalog_query) | **POST** /static/catalog/query/ | Запрос списка товаров
*CatalogsApi* | [**post_static_catalog_querywithrelations**](docs/CatalogsApi.md#post_static_catalog_querywithrelations) | **POST** /static/catalog/queryWithRelations/ | Запрос списка товаров
*CatalogsApi* | [**post_static_catalog_request**](docs/CatalogsApi.md#post_static_catalog_request) | **POST** /static/catalog/request/ | Поиск с агрегацией
*CatalogsApi* | [**post_static_catalog_search**](docs/CatalogsApi.md#post_static_catalog_search) | **POST** /static/catalog/search/ | Запрос списка продуктов
*CatalogsApi* | [**post_static_catalog_templates**](docs/CatalogsApi.md#post_static_catalog_templates) | **POST** /static/catalog/templates/ | Создать новый шаблон
*CatalogsApi* | [**post_static_catalog_templates_by_templateid**](docs/CatalogsApi.md#post_static_catalog_templates_by_templateid) | **POST** /static/catalog/templates/{templateId}/ | Обновить шаблон
*CatalogsApi* | [**put_static_catalog_index_by_cid**](docs/CatalogsApi.md#put_static_catalog_index_by_cid) | **PUT** /static/catalog/index/{Cid}/ | Инициализация индекса в эластике
*CatalogsApi* | [**put_static_catalog_items_by_itemid_contiguous_by_contiguousid**](docs/CatalogsApi.md#put_static_catalog_items_by_itemid_contiguous_by_contiguousid) | **PUT** /static/catalog/items/{itemId}/contiguous/{contiguousId}/ | Добавление смежного товара
*CollectionsApi* | [**delete_static_collection_by_collectionkey**](docs/CollectionsApi.md#delete_static_collection_by_collectionkey) | **DELETE** /static/collection/{collectionKey}/ | Удалить коллекцию
*CollectionsApi* | [**get_static_collection**](docs/CollectionsApi.md#get_static_collection) | **GET** /static/collection/ | Запросить список коллекций
*CollectionsApi* | [**get_static_collection_by_collectionkey_tuple_all**](docs/CollectionsApi.md#get_static_collection_by_collectionkey_tuple_all) | **GET** /static/collection/{collectionKey}/tuple/all/ | Запросить все кортежи
*CollectionsApi* | [**post_static_collection**](docs/CollectionsApi.md#post_static_collection) | **POST** /static/collection/ | Моздать коллекцию
*CollectionsApi* | [**post_static_collection_by_collectionkey**](docs/CollectionsApi.md#post_static_collection_by_collectionkey) | **POST** /static/collection/{collectionKey}/ | Обновить коллекцию
*CollectionsApi* | [**post_static_collection_by_collectionkey_tuple_delete**](docs/CollectionsApi.md#post_static_collection_by_collectionkey_tuple_delete) | **POST** /static/collection/{collectionKey}/tuple/delete/ | Удалить кортеж
*CollectionsApi* | [**post_static_collection_by_collectionkey_tuple_insert**](docs/CollectionsApi.md#post_static_collection_by_collectionkey_tuple_insert) | **POST** /static/collection/{collectionKey}/tuple/insert/ | Создать и добавить кортеж
*CollectionsApi* | [**post_static_collection_by_collectionkey_tuple_select**](docs/CollectionsApi.md#post_static_collection_by_collectionkey_tuple_select) | **POST** /static/collection/{collectionKey}/tuple/select/ | Запросить кортеж
*DiscountApi* | [**delete_dc_binding**](docs/DiscountApi.md#delete_dc_binding) | **DELETE** /dc/binding/ | Запрос отвязки привязанной карты
*DiscountApi* | [**delete_dc_card_by_cardnumber**](docs/DiscountApi.md#delete_dc_card_by_cardnumber) | **DELETE** /dc/card/{cardNumber}/ | Удаление информации по карте
*DiscountApi* | [**get_dc_binding**](docs/DiscountApi.md#get_dc_binding) | **GET** /dc/binding/ | Запрос привязанной карты
*DiscountApi* | [**get_dc_binding_by_cardnumber**](docs/DiscountApi.md#get_dc_binding_by_cardnumber) | **GET** /dc/binding/{cardNumber}/ | Запрос информации покарте (безопасный)
*DiscountApi* | [**get_dc_card**](docs/DiscountApi.md#get_dc_card) | **GET** /dc/card/ | Запрос списка карта
*DiscountApi* | [**get_dc_card_by_cardnumber**](docs/DiscountApi.md#get_dc_card_by_cardnumber) | **GET** /dc/card/{cardNumber}/ | Запрос информации по карте
*DiscountApi* | [**post_dc_binding_confirmation**](docs/DiscountApi.md#post_dc_binding_confirmation) | **POST** /dc/binding/confirmation/ | Подтверждение привязки по номеру карты
*DiscountApi* | [**post_dc_binding_phone_confirmation**](docs/DiscountApi.md#post_dc_binding_phone_confirmation) | **POST** /dc/binding/phone/confirmation/ | Подтверждение привязки по номеру телефона
*DiscountApi* | [**post_dc_binding_phone_request**](docs/DiscountApi.md#post_dc_binding_phone_request) | **POST** /dc/binding/phone/request/ | Запрос кода подтверждения по номеру телефона
*DiscountApi* | [**post_dc_binding_request**](docs/DiscountApi.md#post_dc_binding_request) | **POST** /dc/binding/request/ | Запрос кода подтверждения по номеру карты
*DiscountApi* | [**post_dc_card**](docs/DiscountApi.md#post_dc_card) | **POST** /dc/card/ | Создание информации по карте
*DiscountApi* | [**post_dc_card_by_cardnumber**](docs/DiscountApi.md#post_dc_card_by_cardnumber) | **POST** /dc/card/{cardNumber}/ | Обновление информации по карте
*DiscountApi* | [**post_dc_card_import**](docs/DiscountApi.md#post_dc_card_import) | **POST** /dc/card/import/ | Массовый импорт карт
*DiscountApi* | [**post_dc_card_search**](docs/DiscountApi.md#post_dc_card_search) | **POST** /dc/card/search/ | Простая агрегация
*DocumentsApi* | [**delete_static_documents_group_by_groupid**](docs/DocumentsApi.md#delete_static_documents_group_by_groupid) | **DELETE** /static/documents/group/{groupId}/ | Удалить группу
*DocumentsApi* | [**delete_static_documents_items_by_documentid**](docs/DocumentsApi.md#delete_static_documents_items_by_documentid) | **DELETE** /static/documents/items/{documentId}/ | Удалить документ
*DocumentsApi* | [**get_static_documents**](docs/DocumentsApi.md#get_static_documents) | **GET** /static/documents/ | Запрос списка объектов корневой группы
*DocumentsApi* | [**get_static_documents_group**](docs/DocumentsApi.md#get_static_documents_group) | **GET** /static/documents/group/ | Запрос объектов корневой группы
*DocumentsApi* | [**get_static_documents_group_by_groupid**](docs/DocumentsApi.md#get_static_documents_group_by_groupid) | **GET** /static/documents/group/{groupId}/ | Запрос объектов по ID группы
*DocumentsApi* | [**get_static_documents_items_by_documentid**](docs/DocumentsApi.md#get_static_documents_items_by_documentid) | **GET** /static/documents/items/{documentId}/ | Запрос информации о документе
*DocumentsApi* | [**get_static_documents_items_by_documentid_body**](docs/DocumentsApi.md#get_static_documents_items_by_documentid_body) | **GET** /static/documents/items/{documentId}/body/ | Запрос содержания документа
*DocumentsApi* | [**get_static_documents_items_by_documentid_bodyasstring**](docs/DocumentsApi.md#get_static_documents_items_by_documentid_bodyasstring) | **GET** /static/documents/items/{documentId}/bodyAsString/ | Запрос содержания документа
*DocumentsApi* | [**get_static_documents_itemsbyname_by_documentname**](docs/DocumentsApi.md#get_static_documents_itemsbyname_by_documentname) | **GET** /static/documents/itemsByName/{documentName}/ | Запрос информации о документе
*DocumentsApi* | [**get_static_documents_itemsbyname_by_documentname_body**](docs/DocumentsApi.md#get_static_documents_itemsbyname_by_documentname_body) | **GET** /static/documents/itemsByName/{documentName}/body/ | Запрос содержания документа
*DocumentsApi* | [**get_static_documents_itemsbyname_by_documentname_bodyasstring**](docs/DocumentsApi.md#get_static_documents_itemsbyname_by_documentname_bodyasstring) | **GET** /static/documents/itemsByName/{documentName}/bodyAsString/ | Запрос содержания документа
*DocumentsApi* | [**post_static_documents**](docs/DocumentsApi.md#post_static_documents) | **POST** /static/documents/ | Создание пустого документа
*DocumentsApi* | [**post_static_documents_group**](docs/DocumentsApi.md#post_static_documents_group) | **POST** /static/documents/group/ | Создание группы
*DocumentsApi* | [**post_static_documents_group_by_groupid**](docs/DocumentsApi.md#post_static_documents_group_by_groupid) | **POST** /static/documents/group/{groupId}/ | Обновление группы
*DocumentsApi* | [**post_static_documents_items**](docs/DocumentsApi.md#post_static_documents_items) | **POST** /static/documents/items/ | Создание пустого документа
*DocumentsApi* | [**post_static_documents_items_by_documentid**](docs/DocumentsApi.md#post_static_documents_items_by_documentid) | **POST** /static/documents/items/{documentId}/ | Обновить документ
*DocumentsApi* | [**post_static_documents_items_by_documentid_body**](docs/DocumentsApi.md#post_static_documents_items_by_documentid_body) | **POST** /static/documents/items/{documentId}/body/ | Запись содержания документа
*DocumentsApi* | [**post_static_documents_items_by_documentid_bodyasstring**](docs/DocumentsApi.md#post_static_documents_items_by_documentid_bodyasstring) | **POST** /static/documents/items/{documentId}/bodyAsString/ | Запись содержания документа
*EventApi* | [**post_event_push**](docs/EventApi.md#post_event_push) | **POST** /event/push/ | 
*FileApi* | [**get_files_list**](docs/FileApi.md#get_files_list) | **GET** /files/list/ | Запросить список файлов
*FileApi* | [**post_files_delete**](docs/FileApi.md#post_files_delete) | **POST** /files/delete/ | Удалить файл
*FileApi* | [**post_files_upload**](docs/FileApi.md#post_files_upload) | **POST** /files/upload/ | Загрузить файл
*FileApi* | [**post_files_upload_user_by_userid**](docs/FileApi.md#post_files_upload_user_by_userid) | **POST** /files/upload/user/{userId}/ | Загрузить файл пользователя
*InfosystemsApi* | [**delete_static_infosystems_by_infosystemid**](docs/InfosystemsApi.md#delete_static_infosystems_by_infosystemid) | **DELETE** /static/infosystems/{infosystemId}/ | Удаление инфосистемы
*InfosystemsApi* | [**delete_static_infosystems_by_infosystemid_items_by_itemid**](docs/InfosystemsApi.md#delete_static_infosystems_by_infosystemid_items_by_itemid) | **DELETE** /static/infosystems/{infosystemId}/items/{itemId}/ | Удаление элемента информационной системы
*InfosystemsApi* | [**delete_static_infosystems_by_infosystemid_properties_by_propertykey**](docs/InfosystemsApi.md#delete_static_infosystems_by_infosystemid_properties_by_propertykey) | **DELETE** /static/infosystems/{infosystemId}/properties/{propertyKey}/ | Удаление свойства
*InfosystemsApi* | [**get_static_infosystembyname_by_infosystemname**](docs/InfosystemsApi.md#get_static_infosystembyname_by_infosystemname) | **GET** /static/infosystemByName/{infosystemName}/ | Запрос информации об инфосистеме
*InfosystemsApi* | [**get_static_infosystems**](docs/InfosystemsApi.md#get_static_infosystems) | **GET** /static/infosystems/ | Запрос списка информационных систем
*InfosystemsApi* | [**get_static_infosystems_by_infosystemid**](docs/InfosystemsApi.md#get_static_infosystems_by_infosystemid) | **GET** /static/infosystems/{infosystemId}/ | Запрос информаци об информационной системе
*InfosystemsApi* | [**get_static_infosystems_by_infosystemid_items_by_itemid**](docs/InfosystemsApi.md#get_static_infosystems_by_infosystemid_items_by_itemid) | **GET** /static/infosystems/{infosystemId}/items/{itemId}/ | Запрос элемента информационной системы
*InfosystemsApi* | [**get_static_infosystems_by_infosystemid_properties**](docs/InfosystemsApi.md#get_static_infosystems_by_infosystemid_properties) | **GET** /static/infosystems/{infosystemId}/properties/ | Запрос списка свойств информационных элементов
*InfosystemsApi* | [**get_static_infosystems_by_infosystemid_properties_by_propertykey**](docs/InfosystemsApi.md#get_static_infosystems_by_infosystemid_properties_by_propertykey) | **GET** /static/infosystems/{infosystemId}/properties/{propertyKey}/ | Запрос свойства
*InfosystemsApi* | [**post_static_infosystembyname_by_infosystemname_request**](docs/InfosystemsApi.md#post_static_infosystembyname_by_infosystemname_request) | **POST** /static/infosystemByName/{infosystemName}/request/ | Поиск по элементам инфосистем
*InfosystemsApi* | [**post_static_infosystems**](docs/InfosystemsApi.md#post_static_infosystems) | **POST** /static/infosystems/ | Создание информационной системы
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid) | **POST** /static/infosystems/{infosystemId}/ | Обновление информационной системы
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_items**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_items) | **POST** /static/infosystems/{infosystemId}/items/ | Создание элемента информационной системы
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_items_by_itemid**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_items_by_itemid) | **POST** /static/infosystems/{infosystemId}/items/{itemId}/ | Обновление элемента информационной системы
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_properties**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_properties) | **POST** /static/infosystems/{infosystemId}/properties/ | Создание свойства
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_properties_by_propertykey**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_properties_by_propertykey) | **POST** /static/infosystems/{infosystemId}/properties/{propertyKey}/ | Обновление свойства
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_query**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_query) | **POST** /static/infosystems/{infosystemId}/query/ | Запрос списка элементов
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_querywithrelations**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_querywithrelations) | **POST** /static/infosystems/{infosystemId}/queryWithRelations/ | Запрос списка элементов
*InfosystemsApi* | [**post_static_infosystems_by_infosystemid_request**](docs/InfosystemsApi.md#post_static_infosystems_by_infosystemid_request) | **POST** /static/infosystems/{infosystemId}/request/ | Поиск по элементам инфосистем
*LoyaltyApi* | [**get_loyalty_card_history**](docs/LoyaltyApi.md#get_loyalty_card_history) | **GET** /loyalty/card/history/ | Запрос истории привязанной карты
*LoyaltyApi* | [**get_loyalty_card_history_by_cardnumber**](docs/LoyaltyApi.md#get_loyalty_card_history_by_cardnumber) | **GET** /loyalty/card/history/{cardNumber}/ | Запрос истории карты
*LoyaltyApi* | [**get_loyalty_cloudloyalty_card**](docs/LoyaltyApi.md#get_loyalty_cloudloyalty_card) | **GET** /loyalty/cloudloyalty/card/ | Получение информации о бонусном счете клиента
*LoyaltyApi* | [**get_loyalty_cloudloyalty_card_history**](docs/LoyaltyApi.md#get_loyalty_cloudloyalty_card_history) | **GET** /loyalty/cloudloyalty/card/history/ | История начислений и списаний
*LoyaltyApi* | [**get_loyalty_mechanics_invite_code**](docs/LoyaltyApi.md#get_loyalty_mechanics_invite_code) | **GET** /loyalty/mechanics/invite/code/ | Запрос кода приглашения пользователя
*LoyaltyApi* | [**get_loyalty_mechanics_profile_instagram_group**](docs/LoyaltyApi.md#get_loyalty_mechanics_profile_instagram_group) | **GET** /loyalty/mechanics/profile/instagram/group/ | Запрос идентификатора группы в социальной сети
*LoyaltyApi* | [**get_loyalty_mechanics_profile_vk_group**](docs/LoyaltyApi.md#get_loyalty_mechanics_profile_vk_group) | **GET** /loyalty/mechanics/profile/vk/group/ | Запрос идентификатора группы в социальной сети
*LoyaltyApi* | [**get_loyalty_oas_card_history**](docs/LoyaltyApi.md#get_loyalty_oas_card_history) | **GET** /loyalty/oas/card/history/ | Запрос истории привязанной карты
*LoyaltyApi* | [**get_loyalty_oas_promocode**](docs/LoyaltyApi.md#get_loyalty_oas_promocode) | **GET** /loyalty/oas/promocode/ | Запрос на проверку промокода для ОАС
*LoyaltyApi* | [**post_loyalty_cloudloyalty_card_new**](docs/LoyaltyApi.md#post_loyalty_cloudloyalty_card_new) | **POST** /loyalty/cloudloyalty/card/new/ | Создание нового бонусного счета клиента
*LoyaltyApi* | [**post_loyalty_mechanics_card_binding**](docs/LoyaltyApi.md#post_loyalty_mechanics_card_binding) | **POST** /loyalty/mechanics/card/binding/ | Запрос начисления бонусов за привязанную карту лояльности
*LoyaltyApi* | [**post_loyalty_mechanics_invite_apply**](docs/LoyaltyApi.md#post_loyalty_mechanics_invite_apply) | **POST** /loyalty/mechanics/invite/apply/ | Запрос начисления бонусов по приглашению
*LoyaltyApi* | [**post_loyalty_mechanics_order_first**](docs/LoyaltyApi.md#post_loyalty_mechanics_order_first) | **POST** /loyalty/mechanics/order/first/ | Запрос начисления бонусов за первый заказ в приложении
*LoyaltyApi* | [**post_loyalty_mechanics_profile_apply**](docs/LoyaltyApi.md#post_loyalty_mechanics_profile_apply) | **POST** /loyalty/mechanics/profile/apply/ | Запрос начисления бонусов за заполненный профиль
*LoyaltyApi* | [**post_loyalty_mechanics_profile_instagram_group_apply**](docs/LoyaltyApi.md#post_loyalty_mechanics_profile_instagram_group_apply) | **POST** /loyalty/mechanics/profile/instagram/group/apply/ | Запрос начисления бонусов за вступление в группу
*LoyaltyApi* | [**post_loyalty_mechanics_profile_vk_group_apply**](docs/LoyaltyApi.md#post_loyalty_mechanics_profile_vk_group_apply) | **POST** /loyalty/mechanics/profile/vk/group/apply/ | Запрос начисления бонусов за вступление в группу
*MessageApi* | [**delete_message_deferred_by_fabricid**](docs/MessageApi.md#delete_message_deferred_by_fabricid) | **DELETE** /message/deferred/{FabricId}/ | Удалить объект из запланированных рассылок
*MessageApi* | [**delete_message_history_by_historyid**](docs/MessageApi.md#delete_message_history_by_historyid) | **DELETE** /message/history/{HistoryId}/ | Удаление рассылки из истории
*MessageApi* | [**delete_message_task_by_mailingid**](docs/MessageApi.md#delete_message_task_by_mailingid) | **DELETE** /message/task/{MailingId}/ | Удаление данных рассылки по ID
*MessageApi* | [**delete_message_template_by_key**](docs/MessageApi.md#delete_message_template_by_key) | **DELETE** /message/template/{key}/ | Удаление шаблона
*MessageApi* | [**get_message_balance**](docs/MessageApi.md#get_message_balance) | **GET** /message/balance/ | Получение баланса СМС-шлюза 
*MessageApi* | [**get_message_deferred**](docs/MessageApi.md#get_message_deferred) | **GET** /message/deferred/ | Запрос списка запланированных рассылок
*MessageApi* | [**get_message_history**](docs/MessageApi.md#get_message_history) | **GET** /message/history/ | Запрос списка отправленных рассылок
*MessageApi* | [**get_message_history_count**](docs/MessageApi.md#get_message_history_count) | **GET** /message/history/count/ | Запросить количество рассылок
*MessageApi* | [**get_message_task_by_mailingid**](docs/MessageApi.md#get_message_task_by_mailingid) | **GET** /message/task/{MailingId}/ | Получение данных рассылки по ID
*MessageApi* | [**get_message_tasks**](docs/MessageApi.md#get_message_tasks) | **GET** /message/tasks/ | Получение списка заданий на рассылку
*MessageApi* | [**get_message_tasks_by_mailingtype**](docs/MessageApi.md#get_message_tasks_by_mailingtype) | **GET** /message/tasks/{MailingType}/ | Получение списка рассылок по типу отправления
*MessageApi* | [**get_message_template_by_key**](docs/MessageApi.md#get_message_template_by_key) | **GET** /message/template/{key}/ | Получение шаблона
*MessageApi* | [**get_message_templates**](docs/MessageApi.md#get_message_templates) | **GET** /message/templates/ | Список шаблонов
*MessageApi* | [**post_message**](docs/MessageApi.md#post_message) | **POST** /message/ | Синхронная отправка одного сообщения.
*MessageApi* | [**post_message_deferred_by_fabricid**](docs/MessageApi.md#post_message_deferred_by_fabricid) | **POST** /message/deferred/{FabricId}/ | Обновление объекта рассылки
*MessageApi* | [**post_message_fabric**](docs/MessageApi.md#post_message_fabric) | **POST** /message/fabric/ | Создание и отправка группы сообщений
*MessageApi* | [**post_message_task_by_mailingid**](docs/MessageApi.md#post_message_task_by_mailingid) | **POST** /message/task/{MailingId}/ | Обновление данных рассылки по ID рассылки
*MessageApi* | [**post_message_task_email**](docs/MessageApi.md#post_message_task_email) | **POST** /message/task/email/ | Создание нового задания на рассылку сообщений на указанные адреса электронной почты
*MessageApi* | [**post_message_task_mailing**](docs/MessageApi.md#post_message_task_mailing) | **POST** /message/task/mailing/ | Создание нового задания на массовую рассылку сообщений
*MessageApi* | [**post_message_task_push**](docs/MessageApi.md#post_message_task_push) | **POST** /message/task/push/ | Создание нового задания на рассылку пуш-сообщений на указанные токены устройств
*MessageApi* | [**post_message_task_sms**](docs/MessageApi.md#post_message_task_sms) | **POST** /message/task/sms/ | Создание нового задания на рассылку sms-сообщений на указанные номера телефонов
*MessageApi* | [**post_message_task_template_email**](docs/MessageApi.md#post_message_task_template_email) | **POST** /message/task/template/email/ | Создание из шаблона нового email сообщения
*MessageApi* | [**post_message_task_template_push**](docs/MessageApi.md#post_message_task_template_push) | **POST** /message/task/template/push/ | Создание из шаблона нового пуш-сообщения
*MessageApi* | [**post_message_task_template_sms**](docs/MessageApi.md#post_message_task_template_sms) | **POST** /message/task/template/sms/ | Создание из шаблона нового sms-сообщения
*MessageApi* | [**post_message_task_template_user**](docs/MessageApi.md#post_message_task_template_user) | **POST** /message/task/template/user/ | Создание из шаблона нового сообщения пользователю
*MessageApi* | [**post_message_task_users**](docs/MessageApi.md#post_message_task_users) | **POST** /message/task/users/ | Создание нового задания на рассылку сообщений конкретным пользователям
*MessageApi* | [**post_message_template**](docs/MessageApi.md#post_message_template) | **POST** /message/template/ | Создание шаблона рассылки
*MessageApi* | [**post_message_template_by_key**](docs/MessageApi.md#post_message_template_by_key) | **POST** /message/template/{key}/ | Обновление или создание шаблона
*OrdersApi* | [**delete_dynamic_order_by_orderid**](docs/OrdersApi.md#delete_dynamic_order_by_orderid) | **DELETE** /dynamic/order/{orderId}/ | Удаление заказа
*OrdersApi* | [**delete_dynamic_order_by_orderid_items_by_orderitemid**](docs/OrdersApi.md#delete_dynamic_order_by_orderid_items_by_orderitemid) | **DELETE** /dynamic/order/{orderId}/items/{orderItemId}/ | Удаление позиции из заказа
*OrdersApi* | [**delete_dynamic_order_properties_by_propertykey**](docs/OrdersApi.md#delete_dynamic_order_properties_by_propertykey) | **DELETE** /dynamic/order/properties/{propertyKey}/ | Удаление свойства
*OrdersApi* | [**get_dynamic_order_by_orderid**](docs/OrdersApi.md#get_dynamic_order_by_orderid) | **GET** /dynamic/order/{orderId}/ | Запрос информации о заказе
*OrdersApi* | [**get_dynamic_order_number_by_ordernumber**](docs/OrdersApi.md#get_dynamic_order_number_by_ordernumber) | **GET** /dynamic/order/number/{orderNumber}/ | Запрос информации о заказе по номеру заказа
*OrdersApi* | [**get_dynamic_order_properties**](docs/OrdersApi.md#get_dynamic_order_properties) | **GET** /dynamic/order/properties/ | Запрос списка свойств
*OrdersApi* | [**get_dynamic_order_properties_by_propertykey**](docs/OrdersApi.md#get_dynamic_order_properties_by_propertykey) | **GET** /dynamic/order/properties/{propertyKey}/ | Запрос свойства
*OrdersApi* | [**get_dynamic_orderuser_by_userid**](docs/OrdersApi.md#get_dynamic_orderuser_by_userid) | **GET** /dynamic/orderUser/{userId}/ | Запрос списка заказов пользователя
*OrdersApi* | [**get_dynamic_orderuser_by_userid_by_orderid**](docs/OrdersApi.md#get_dynamic_orderuser_by_userid_by_orderid) | **GET** /dynamic/orderUser/{userId}/{orderId}/ | Запрос информации о заказе
*OrdersApi* | [**post_dynamic_order_bulk**](docs/OrdersApi.md#post_dynamic_order_bulk) | **POST** /dynamic/order/bulk/ | Массовая вставка заказов
*OrdersApi* | [**post_dynamic_order_by_orderid**](docs/OrdersApi.md#post_dynamic_order_by_orderid) | **POST** /dynamic/order/{orderId}/ | Обновление информации о заказе
*OrdersApi* | [**post_dynamic_order_by_orderid_items**](docs/OrdersApi.md#post_dynamic_order_by_orderid_items) | **POST** /dynamic/order/{orderId}/items/ | Добавление товара в заказ
*OrdersApi* | [**post_dynamic_order_by_orderid_items_by_orderitemid**](docs/OrdersApi.md#post_dynamic_order_by_orderid_items_by_orderitemid) | **POST** /dynamic/order/{orderId}/items/{orderItemId}/ | Обновление позиции в заказе
*OrdersApi* | [**post_dynamic_order_export**](docs/OrdersApi.md#post_dynamic_order_export) | **POST** /dynamic/order/export/ | Запрос заказов по фильтру
*OrdersApi* | [**post_dynamic_order_properties**](docs/OrdersApi.md#post_dynamic_order_properties) | **POST** /dynamic/order/properties/ | Создание свойства
*OrdersApi* | [**post_dynamic_order_properties_by_propertykey**](docs/OrdersApi.md#post_dynamic_order_properties_by_propertykey) | **POST** /dynamic/order/properties/{propertyKey}/ | Обновление свойства
*OrdersApi* | [**post_dynamic_order_request**](docs/OrdersApi.md#post_dynamic_order_request) | **POST** /dynamic/order/request/ | Поиск (QueryDSL) с агрегацией собираемых данных
*OrdersApi* | [**post_dynamic_order_status**](docs/OrdersApi.md#post_dynamic_order_status) | **POST** /dynamic/order/status/ | Обновление статусов заказов
*OrdersApi* | [**post_dynamic_orderquery**](docs/OrdersApi.md#post_dynamic_orderquery) | **POST** /dynamic/orderQuery/ | Запрос списка заказов
*OrdersApi* | [**post_dynamic_orderuser_by_userid**](docs/OrdersApi.md#post_dynamic_orderuser_by_userid) | **POST** /dynamic/orderUser/{userId}/ | Создание нового заказа
*OrdersApi* | [**post_dynamic_orderuser_by_userid_by_orderid**](docs/OrdersApi.md#post_dynamic_orderuser_by_userid_by_orderid) | **POST** /dynamic/orderUser/{userId}/{orderId}/ | Обновление информации о заказе
*OrdersApi* | [**post_dynamic_orderuser_by_userid_request**](docs/OrdersApi.md#post_dynamic_orderuser_by_userid_request) | **POST** /dynamic/orderUser/{userId}/request/ | Поиск (QueryDSL) с агрегацией собираемых данных по пользовательским заказам
*OrdersV2AdminApi* | [**get_v2_orders_admin**](docs/OrdersV2AdminApi.md#get_v2_orders_admin) | **GET** /v2/orders/admin/ | Список заказов для админки
*OrdersV2AdminApi* | [**get_v2_orders_admin_by_orderid**](docs/OrdersV2AdminApi.md#get_v2_orders_admin_by_orderid) | **GET** /v2/orders/admin/{orderId}/ | Получение заказа по ID
*OrdersV2AdminApi* | [**get_v2_orders_admin_cart_by_userid**](docs/OrdersV2AdminApi.md#get_v2_orders_admin_cart_by_userid) | **GET** /v2/orders/admin/cart/{userId}/ | Получить корзину по инетификатору пользователя
*OrdersV2AdminApi* | [**patch_v2_orders_admin_by_orderid**](docs/OrdersV2AdminApi.md#patch_v2_orders_admin_by_orderid) | **PATCH** /v2/orders/admin/{orderId}/ | Обновление заказа
*OrdersV2AdminApi* | [**patch_v2_orders_admin_cart_by_userid**](docs/OrdersV2AdminApi.md#patch_v2_orders_admin_cart_by_userid) | **PATCH** /v2/orders/admin/cart/{userId}/ | Обновление корзины заказов пользователя
*OrdersV2AdminApi* | [**patch_v2_orders_admin_pay_refund**](docs/OrdersV2AdminApi.md#patch_v2_orders_admin_pay_refund) | **PATCH** /v2/orders/admin/pay/refund/ | Возврат средств
*OrdersV2AdminApi* | [**patch_v2_orders_admin_pay_reverse**](docs/OrdersV2AdminApi.md#patch_v2_orders_admin_pay_reverse) | **PATCH** /v2/orders/admin/pay/reverse/ | Отмена оплаты заказа
*OrdersV2AdminApi* | [**post_v2_orders_admin_by_orderid_status**](docs/OrdersV2AdminApi.md#post_v2_orders_admin_by_orderid_status) | **POST** /v2/orders/admin/{orderId}/status/ | Изменение статуса заказа
*OrdersV2AdminApi* | [**post_v2_orders_admin_request**](docs/OrdersV2AdminApi.md#post_v2_orders_admin_request) | **POST** /v2/orders/admin/request/ | Поиск заказов в админке
*OrdersV2ClientApi* | [**delete_v2_orders_my_cart_field_by_fieldname**](docs/OrdersV2ClientApi.md#delete_v2_orders_my_cart_field_by_fieldname) | **DELETE** /v2/orders/my/cart/field/{fieldName}/ | Удаление поля с данными пользователя
*OrdersV2ClientApi* | [**delete_v2_orders_my_cart_fields**](docs/OrdersV2ClientApi.md#delete_v2_orders_my_cart_fields) | **DELETE** /v2/orders/my/cart/fields/ | Удаление всех полей с данными пользователя
*OrdersV2ClientApi* | [**delete_v2_orders_my_cart_item_by_orderitemid**](docs/OrdersV2ClientApi.md#delete_v2_orders_my_cart_item_by_orderitemid) | **DELETE** /v2/orders/my/cart/item/{orderItemId}/ | Удаление товара из корзины по ID
*OrdersV2ClientApi* | [**delete_v2_orders_my_cart_item_by_orderitemid_extra_by_orderextraid**](docs/OrdersV2ClientApi.md#delete_v2_orders_my_cart_item_by_orderitemid_extra_by_orderextraid) | **DELETE** /v2/orders/my/cart/item/{orderItemId}/extra/{orderExtraId}/ | Удаление модификатора товара в корзине
*OrdersV2ClientApi* | [**delete_v2_orders_my_cart_items**](docs/OrdersV2ClientApi.md#delete_v2_orders_my_cart_items) | **DELETE** /v2/orders/my/cart/items/ | Удаление товаров из корзины
*OrdersV2ClientApi* | [**get_v2_orders_my**](docs/OrdersV2ClientApi.md#get_v2_orders_my) | **GET** /v2/orders/my/ | Получение списка заказов пользователя
*OrdersV2ClientApi* | [**get_v2_orders_my_by_orderid**](docs/OrdersV2ClientApi.md#get_v2_orders_my_by_orderid) | **GET** /v2/orders/my/{orderId}/ | Получение заказа пользователя по ID
*OrdersV2ClientApi* | [**get_v2_orders_my_cart**](docs/OrdersV2ClientApi.md#get_v2_orders_my_cart) | **GET** /v2/orders/my/cart/ | Получение корзины заказов.
*OrdersV2ClientApi* | [**post_v2_orders_my_by_orderid_status**](docs/OrdersV2ClientApi.md#post_v2_orders_my_by_orderid_status) | **POST** /v2/orders/my/{orderId}/status/ | Смена статуса заказа пользователем
*OrdersV2ClientApi* | [**post_v2_orders_my_cart_field_by_fieldname**](docs/OrdersV2ClientApi.md#post_v2_orders_my_cart_field_by_fieldname) | **POST** /v2/orders/my/cart/field/{fieldName}/ | Заполнение поля с данными пользователя
*OrdersV2ClientApi* | [**post_v2_orders_my_cart_fields**](docs/OrdersV2ClientApi.md#post_v2_orders_my_cart_fields) | **POST** /v2/orders/my/cart/fields/ | Заполнение нескольких полей с данными пользователя
*OrdersV2ClientApi* | [**post_v2_orders_my_cart_item_by_orderitemid**](docs/OrdersV2ClientApi.md#post_v2_orders_my_cart_item_by_orderitemid) | **POST** /v2/orders/my/cart/item/{orderItemId}/ | Обновление товара в корзине
*OrdersV2ClientApi* | [**post_v2_orders_my_request**](docs/OrdersV2ClientApi.md#post_v2_orders_my_request) | **POST** /v2/orders/my/request/ | Поиск заказов пользователя
*OrdersV2ClientApi* | [**put_v2_orders_my_cart_item_by_orderitemid_extras**](docs/OrdersV2ClientApi.md#put_v2_orders_my_cart_item_by_orderitemid_extras) | **PUT** /v2/orders/my/cart/item/{orderItemId}/extras/ | Добавление модификатора товара в корзине
*OrdersV2ClientApi* | [**put_v2_orders_my_cart_items**](docs/OrdersV2ClientApi.md#put_v2_orders_my_cart_items) | **PUT** /v2/orders/my/cart/items/ | Добавление товара в корзину
*PayApi* | [**delete_pay_sberbank_binding_by_bindingid**](docs/PayApi.md#delete_pay_sberbank_binding_by_bindingid) | **DELETE** /pay/sberbank/binding/{bindingId}/ | Деактивация связки
*PayApi* | [**get_pay_check**](docs/PayApi.md#get_pay_check) | **GET** /pay/check/ | Проверка доступности оплат
*PayApi* | [**get_pay_sberbank_binding**](docs/PayApi.md#get_pay_sberbank_binding) | **GET** /pay/sberbank/binding/ | Список связок
*PayApi* | [**get_pay_sberbank_payment_by_paymentid**](docs/PayApi.md#get_pay_sberbank_payment_by_paymentid) | **GET** /pay/sberbank/payment/{paymentId}/ | Cтатуса платежа
*PayApi* | [**post_pay_sberbank_register**](docs/PayApi.md#post_pay_sberbank_register) | **POST** /pay/sberbank/register/ | Регистрация заказа
*PayApi* | [**post_pay_sberbank_register_apple**](docs/PayApi.md#post_pay_sberbank_register_apple) | **POST** /pay/sberbank/register/apple/ | Регистрация платежа Apple Pay
*PayApi* | [**post_pay_sberbank_register_google**](docs/PayApi.md#post_pay_sberbank_register_google) | **POST** /pay/sberbank/register/google/ | Регистрация платежа Google Pay
*PayApi* | [**post_pay_sberbank_register_samsung**](docs/PayApi.md#post_pay_sberbank_register_samsung) | **POST** /pay/sberbank/register/samsung/ | Регистрация платежа Samsung Pay
*PaymentsV2Api* | [**delete_v2_orders_pay_bindings_by_bindingid**](docs/PaymentsV2Api.md#delete_v2_orders_pay_bindings_by_bindingid) | **DELETE** /v2/orders/pay/bindings/{bindingId}/ | Удаление привзяанной карты по ID привзяки
*PaymentsV2Api* | [**get_v2_orders_pay_bindings**](docs/PaymentsV2Api.md#get_v2_orders_pay_bindings) | **GET** /v2/orders/pay/bindings/ | Получение списка привзаных карт пользователей
*PaymentsV2Api* | [**get_v2_orders_pay_callback**](docs/PaymentsV2Api.md#get_v2_orders_pay_callback) | **GET** /v2/orders/pay/callback/ | Обратный вызов Сбребанка для обновления статусов заказа
*PaymentsV2Api* | [**post_v2_orders_order_apple_pay**](docs/PaymentsV2Api.md#post_v2_orders_order_apple_pay) | **POST** /v2/orders/order/apple-pay/ | Заказ с использованием платежной системы Apple Pay
*PaymentsV2Api* | [**post_v2_orders_order_by_paymenttype**](docs/PaymentsV2Api.md#post_v2_orders_order_by_paymenttype) | **POST** /v2/orders/order/{paymentType}/ | Заказ с использование оффлайн-оплаты
*PaymentsV2Api* | [**post_v2_orders_order_card**](docs/PaymentsV2Api.md#post_v2_orders_order_card) | **POST** /v2/orders/order/card/ | Заказ с оплатой картой онлайн
*PaymentsV2Api* | [**post_v2_orders_order_google_pay**](docs/PaymentsV2Api.md#post_v2_orders_order_google_pay) | **POST** /v2/orders/order/google-pay/ | Заказ с использованием платежной системы Google Pay
*PaymentsV2Api* | [**post_v2_orders_order_samsung_pay**](docs/PaymentsV2Api.md#post_v2_orders_order_samsung_pay) | **POST** /v2/orders/order/samsung-pay/ | Заказ с использованием платежной системы Samsung Pay
*PermissionsApi* | [**delete_options_permissions_by_userid_by_modulename**](docs/PermissionsApi.md#delete_options_permissions_by_userid_by_modulename) | **DELETE** /options/permissions/{userId}/{moduleName}/ | Сбросить настройки доступа модуля
*PermissionsApi* | [**delete_options_permissions_by_userid_by_modulename_by_settingkey**](docs/PermissionsApi.md#delete_options_permissions_by_userid_by_modulename_by_settingkey) | **DELETE** /options/permissions/{userId}/{moduleName}/{settingKey}/ | Сбросить настройку доступа модуля
*PermissionsApi* | [**delete_options_permissionscompany_by_modulename**](docs/PermissionsApi.md#delete_options_permissionscompany_by_modulename) | **DELETE** /options/permissionsCompany/{moduleName}/ | Сбросить настройки доступа модуля компании
*PermissionsApi* | [**delete_options_permissionscompany_by_modulename_by_settingkey**](docs/PermissionsApi.md#delete_options_permissionscompany_by_modulename_by_settingkey) | **DELETE** /options/permissionsCompany/{moduleName}/{settingKey}/ | Сбросить настройку доступа модуля компании
*PermissionsApi* | [**get_options_permissions_by_userid**](docs/PermissionsApi.md#get_options_permissions_by_userid) | **GET** /options/permissions/{userId}/ | Получить все настройки доступа пользователя
*PermissionsApi* | [**get_options_permissions_by_userid_by_modulename**](docs/PermissionsApi.md#get_options_permissions_by_userid_by_modulename) | **GET** /options/permissions/{userId}/{moduleName}/ | Получить настройки доступа модуля
*PermissionsApi* | [**get_options_permissions_by_userid_by_modulename_by_settingkey**](docs/PermissionsApi.md#get_options_permissions_by_userid_by_modulename_by_settingkey) | **GET** /options/permissions/{userId}/{moduleName}/{settingKey}/ | Получить настройку доступа модуля
*PermissionsApi* | [**get_options_permissionscompany**](docs/PermissionsApi.md#get_options_permissionscompany) | **GET** /options/permissionsCompany/ | Получить все настройки доступа для компании
*PermissionsApi* | [**get_options_permissionscompany_by_modulename**](docs/PermissionsApi.md#get_options_permissionscompany_by_modulename) | **GET** /options/permissionsCompany/{moduleName}/ | Получить настройки доступа модуля компании
*PermissionsApi* | [**get_options_permissionscompany_by_modulename_by_settingkey**](docs/PermissionsApi.md#get_options_permissionscompany_by_modulename_by_settingkey) | **GET** /options/permissionsCompany/{moduleName}/{settingKey}/ | Получить настройку доступа модуля компании
*PermissionsApi* | [**post_options_permissions_by_userid**](docs/PermissionsApi.md#post_options_permissions_by_userid) | **POST** /options/permissions/{userId}/ | Сохранить настройки доступа пользователя
*PermissionsApi* | [**post_options_permissions_by_userid_by_modulename**](docs/PermissionsApi.md#post_options_permissions_by_userid_by_modulename) | **POST** /options/permissions/{userId}/{moduleName}/ | Сохранить настройки доступа модуля
*PermissionsApi* | [**post_options_permissions_by_userid_by_modulename_by_settingkey**](docs/PermissionsApi.md#post_options_permissions_by_userid_by_modulename_by_settingkey) | **POST** /options/permissions/{userId}/{moduleName}/{settingKey}/ | Сохранить настройку доступа модуля
*PermissionsApi* | [**post_options_permissionscompany**](docs/PermissionsApi.md#post_options_permissionscompany) | **POST** /options/permissionsCompany/ | Сохранить настройки доступа для компании
*PermissionsApi* | [**post_options_permissionscompany_by_modulename**](docs/PermissionsApi.md#post_options_permissionscompany_by_modulename) | **POST** /options/permissionsCompany/{moduleName}/ | Сохранить настройки доступа модуля компании
*PermissionsApi* | [**post_options_permissionscompany_by_modulename_by_settingkey**](docs/PermissionsApi.md#post_options_permissionscompany_by_modulename_by_settingkey) | **POST** /options/permissionsCompany/{moduleName}/{settingKey}/ | Сохранить настройки доступа модуля компании
*PizzamanApi* | [**delete_pizzamia_pizzaman_promocode_by_promoid**](docs/PizzamanApi.md#delete_pizzamia_pizzaman_promocode_by_promoid) | **DELETE** /pizzamia/pizzaman/promocode/{promoId}/ | Удалить акцию с промокодами
*PizzamanApi* | [**get_pizzamia_pizzaman_health**](docs/PizzamanApi.md#get_pizzamia_pizzaman_health) | **GET** /pizzamia/pizzaman/health/ | Возвращает HealthCheck
*PizzamanApi* | [**get_pizzamia_pizzaman_history**](docs/PizzamanApi.md#get_pizzamia_pizzaman_history) | **GET** /pizzamia/pizzaman/history/ | Возвращает список всех историй
*PizzamanApi* | [**get_pizzamia_pizzaman_history_winners_by_histid**](docs/PizzamanApi.md#get_pizzamia_pizzaman_history_winners_by_histid) | **GET** /pizzamia/pizzaman/history/winners/{histId}/ | Возвращает список всех победителей
*PizzamanApi* | [**get_pizzamia_pizzaman_promocode**](docs/PizzamanApi.md#get_pizzamia_pizzaman_promocode) | **GET** /pizzamia/pizzaman/promocode/ | Возвращает список всех промокодов
*PizzamanApi* | [**post_pizzamia_pizzaman_promocode**](docs/PizzamanApi.md#post_pizzamia_pizzaman_promocode) | **POST** /pizzamia/pizzaman/promocode/ | Создать новые промокоды
*PizzamanApi* | [**post_pizzamia_pizzaman_promotion_activate_by_promoid**](docs/PizzamanApi.md#post_pizzamia_pizzaman_promotion_activate_by_promoid) | **POST** /pizzamia/pizzaman/promotion/activate/{promoId}/ | Привязывает свободный промокод к пользователю
*PizzamanApi* | [**post_pizzamia_pizzaman_promotion_launch_by_promoid**](docs/PizzamanApi.md#post_pizzamia_pizzaman_promotion_launch_by_promoid) | **POST** /pizzamia/pizzaman/promotion/launch/{promoId}/ | Запуск промо-акции
*RouterApi* | [**delete_router_company_by_cid**](docs/RouterApi.md#delete_router_company_by_cid) | **DELETE** /router/company/{Cid}/ | Удалить компанию
*RouterApi* | [**delete_router_companywizard_by_cid**](docs/RouterApi.md#delete_router_companywizard_by_cid) | **DELETE** /router/companywizard/{Cid}/ | Удалить компанию с группами
*RouterApi* | [**delete_router_group_by_gid**](docs/RouterApi.md#delete_router_group_by_gid) | **DELETE** /router/group/{Gid}/ | Удалить группу
*RouterApi* | [**delete_router_resource_by_resourceid**](docs/RouterApi.md#delete_router_resource_by_resourceid) | **DELETE** /router/resource/{ResourceId}/ | Удалить права на ресурс
*RouterApi* | [**delete_router_service_by_prefix**](docs/RouterApi.md#delete_router_service_by_prefix) | **DELETE** /router/service/{prefix}/ | Удалить сервис
*RouterApi* | [**delete_router_user_by_uid**](docs/RouterApi.md#delete_router_user_by_uid) | **DELETE** /router/user/{Uid}/ | Удалить пользователя
*RouterApi* | [**delete_router_user_by_uid_group_by_gid**](docs/RouterApi.md#delete_router_user_by_uid_group_by_gid) | **DELETE** /router/user/{Uid}/group/{Gid}/ | Удалить группу пользователя
*RouterApi* | [**delete_router_user_by_uid_groupbyname_by_groupname**](docs/RouterApi.md#delete_router_user_by_uid_groupbyname_by_groupname) | **DELETE** /router/user/{Uid}/groupByName/{GroupName}/ | Удалить группу
*RouterApi* | [**get_router_company**](docs/RouterApi.md#get_router_company) | **GET** /router/company/ | Запросить список компании
*RouterApi* | [**get_router_company_by_cid**](docs/RouterApi.md#get_router_company_by_cid) | **GET** /router/company/{Cid}/ | Запросить компанию
*RouterApi* | [**get_router_company_by_cid_group**](docs/RouterApi.md#get_router_company_by_cid_group) | **GET** /router/company/{Cid}/group/ | Запросить список групп компании
*RouterApi* | [**get_router_company_by_cid_user**](docs/RouterApi.md#get_router_company_by_cid_user) | **GET** /router/company/{Cid}/user/ | Запросить список пользователей компании
*RouterApi* | [**get_router_group_by_gid**](docs/RouterApi.md#get_router_group_by_gid) | **GET** /router/group/{Gid}/ | Запросить данные группы по Gid
*RouterApi* | [**get_router_service**](docs/RouterApi.md#get_router_service) | **GET** /router/service/ | Отобразить все сервисы
*RouterApi* | [**get_router_service_by_prefix**](docs/RouterApi.md#get_router_service_by_prefix) | **GET** /router/service/{prefix}/ | Отобразить сервис по префиксу
*RouterApi* | [**get_router_subscribe**](docs/RouterApi.md#get_router_subscribe) | **GET** /router/subscribe/ | Отобразить все подписки пользователя
*RouterApi* | [**get_router_template**](docs/RouterApi.md#get_router_template) | **GET** /router/template/ | Отобразить шаблоны
*RouterApi* | [**get_router_user_by_uid**](docs/RouterApi.md#get_router_user_by_uid) | **GET** /router/user/{Uid}/ | Запросить информацию о пользователе
*RouterApi* | [**post_router_company**](docs/RouterApi.md#post_router_company) | **POST** /router/company/ | Добавить компанию
*RouterApi* | [**post_router_company_by_cid**](docs/RouterApi.md#post_router_company_by_cid) | **POST** /router/company/{Cid}/ | Изменить компанию
*RouterApi* | [**post_router_company_by_cid_group**](docs/RouterApi.md#post_router_company_by_cid_group) | **POST** /router/company/{Cid}/group/ | Добавить группу в компанию
*RouterApi* | [**post_router_company_by_cid_user**](docs/RouterApi.md#post_router_company_by_cid_user) | **POST** /router/company/{Cid}/user/ | Добавить пользователя
*RouterApi* | [**post_router_company_find**](docs/RouterApi.md#post_router_company_find) | **POST** /router/company/find/ | Поиск компании по домену
*RouterApi* | [**post_router_companywizard**](docs/RouterApi.md#post_router_companywizard) | **POST** /router/companywizard/ | Добавить компанию с группами пользователей
*RouterApi* | [**post_router_group_by_gid**](docs/RouterApi.md#post_router_group_by_gid) | **POST** /router/group/{Gid}/ | Изменить название группы
*RouterApi* | [**post_router_resource**](docs/RouterApi.md#post_router_resource) | **POST** /router/resource/ | Установить права на ресурс
*RouterApi* | [**post_router_resource_by_resourceid**](docs/RouterApi.md#post_router_resource_by_resourceid) | **POST** /router/resource/{ResourceId}/ | Редактировать ресурс
*RouterApi* | [**post_router_resource_ls**](docs/RouterApi.md#post_router_resource_ls) | **POST** /router/resource/ls/ | Запросить список ресурсов
*RouterApi* | [**post_router_service**](docs/RouterApi.md#post_router_service) | **POST** /router/service/ | Создать сервис
*RouterApi* | [**post_router_service_by_prefix**](docs/RouterApi.md#post_router_service_by_prefix) | **POST** /router/service/{prefix}/ | Обновить или создать новый сервис
*RouterApi* | [**post_router_subscribe**](docs/RouterApi.md#post_router_subscribe) | **POST** /router/subscribe/ | Создать подписку
*RouterApi* | [**post_router_subscribe_delete**](docs/RouterApi.md#post_router_subscribe_delete) | **POST** /router/subscribe/delete/ | Отключить подписки пользователя
*RouterApi* | [**post_router_template**](docs/RouterApi.md#post_router_template) | **POST** /router/template/ | Создать или обновить шаблон
*RouterApi* | [**post_router_template_delete**](docs/RouterApi.md#post_router_template_delete) | **POST** /router/template/delete/ | Удалить шаблон
*RouterApi* | [**post_router_template_rollback**](docs/RouterApi.md#post_router_template_rollback) | **POST** /router/template/rollback/ | Удалить ресурс по шаблону
*RouterApi* | [**post_router_template_use**](docs/RouterApi.md#post_router_template_use) | **POST** /router/template/use/ | Использовать шаблон
*RouterApi* | [**post_router_user_by_uid**](docs/RouterApi.md#post_router_user_by_uid) | **POST** /router/user/{Uid}/ | Обновить пользователя
*RouterApi* | [**post_router_user_by_uid_group**](docs/RouterApi.md#post_router_user_by_uid_group) | **POST** /router/user/{Uid}/group/ | Добавить пользователя в группу
*RouterApi* | [**post_router_user_by_uid_passwd**](docs/RouterApi.md#post_router_user_by_uid_passwd) | **POST** /router/user/{Uid}/passwd/ | Сменить пароль пользователя
*RouterApi* | [**post_router_user_by_uid_token**](docs/RouterApi.md#post_router_user_by_uid_token) | **POST** /router/user/{Uid}/token/ | Получить ключ доступа по паролю
*RouterApi* | [**post_router_user_by_uid_unsafetoken**](docs/RouterApi.md#post_router_user_by_uid_unsafetoken) | **POST** /router/user/{Uid}/unsafeToken/ | Получить ключ доступа без пароля
*RouterApi* | [**put_router_user_by_uid_groupbyname_by_groupname**](docs/RouterApi.md#put_router_user_by_uid_groupbyname_by_groupname) | **PUT** /router/user/{Uid}/groupByName/{GroupName}/ | Добавить группу пользователя по имени
*ServiceApi* | [**delete_service_groups_by_groupid**](docs/ServiceApi.md#delete_service_groups_by_groupid) | **DELETE** /service/groups/{groupId}/ | 
*ServiceApi* | [**delete_service_items_by_itemid**](docs/ServiceApi.md#delete_service_items_by_itemid) | **DELETE** /service/items/{itemId}/ | 
*ServiceApi* | [**delete_service_price**](docs/ServiceApi.md#delete_service_price) | **DELETE** /service/price/ | 
*ServiceApi* | [**delete_service_properties_by_propertykey**](docs/ServiceApi.md#delete_service_properties_by_propertykey) | **DELETE** /service/properties/{propertyKey}/ | 
*ServiceApi* | [**delete_service_resources_by_resourceid**](docs/ServiceApi.md#delete_service_resources_by_resourceid) | **DELETE** /service/resources/{resourceId}/ | 
*ServiceApi* | [**delete_service_resources_items**](docs/ServiceApi.md#delete_service_resources_items) | **DELETE** /service/resources/items/ | 
*ServiceApi* | [**delete_service_resources_properties_by_propertykey**](docs/ServiceApi.md#delete_service_resources_properties_by_propertykey) | **DELETE** /service/resources/properties/{propertyKey}/ | 
*ServiceApi* | [**delete_service_resources_time_by_resourceid_by_shopid_date_by_date**](docs/ServiceApi.md#delete_service_resources_time_by_resourceid_by_shopid_date_by_date) | **DELETE** /service/resources/time/{resourceId}/{shopId}/date/{date}/ | 
*ServiceApi* | [**delete_service_resources_time_by_resourceid_by_shopid_week**](docs/ServiceApi.md#delete_service_resources_time_by_resourceid_by_shopid_week) | **DELETE** /service/resources/time/{resourceId}/{shopId}/week/ | 
*ServiceApi* | [**delete_service_time**](docs/ServiceApi.md#delete_service_time) | **DELETE** /service/time/ | 
*ServiceApi* | [**get_service_groups**](docs/ServiceApi.md#get_service_groups) | **GET** /service/groups/ | 
*ServiceApi* | [**get_service_groups_by_groupid**](docs/ServiceApi.md#get_service_groups_by_groupid) | **GET** /service/groups/{groupId}/ | 
*ServiceApi* | [**get_service_items_by_itemid**](docs/ServiceApi.md#get_service_items_by_itemid) | **GET** /service/items/{itemId}/ | 
*ServiceApi* | [**get_service_options**](docs/ServiceApi.md#get_service_options) | **GET** /service/options/ | 
*ServiceApi* | [**get_service_properties**](docs/ServiceApi.md#get_service_properties) | **GET** /service/properties/ | 
*ServiceApi* | [**get_service_properties_by_propertykey**](docs/ServiceApi.md#get_service_properties_by_propertykey) | **GET** /service/properties/{propertyKey}/ | 
*ServiceApi* | [**get_service_resources**](docs/ServiceApi.md#get_service_resources) | **GET** /service/resources/ | 
*ServiceApi* | [**get_service_resources_by_resourceid**](docs/ServiceApi.md#get_service_resources_by_resourceid) | **GET** /service/resources/{resourceId}/ | 
*ServiceApi* | [**get_service_resources_properties**](docs/ServiceApi.md#get_service_resources_properties) | **GET** /service/resources/properties/ | 
*ServiceApi* | [**get_service_resources_properties_by_propertykey**](docs/ServiceApi.md#get_service_resources_properties_by_propertykey) | **GET** /service/resources/properties/{propertyKey}/ | 
*ServiceApi* | [**get_service_resources_time_by_resourceid_by_shopid_date**](docs/ServiceApi.md#get_service_resources_time_by_resourceid_by_shopid_date) | **GET** /service/resources/time/{resourceId}/{shopId}/date/ | 
*ServiceApi* | [**get_service_resources_time_by_resourceid_by_shopid_date_by_date**](docs/ServiceApi.md#get_service_resources_time_by_resourceid_by_shopid_date_by_date) | **GET** /service/resources/time/{resourceId}/{shopId}/date/{date}/ | 
*ServiceApi* | [**get_service_resources_time_by_resourceid_by_shopid_week**](docs/ServiceApi.md#get_service_resources_time_by_resourceid_by_shopid_week) | **GET** /service/resources/time/{resourceId}/{shopId}/week/ | 
*ServiceApi* | [**get_service_resources_time_date**](docs/ServiceApi.md#get_service_resources_time_date) | **GET** /service/resources/time/date/ | 
*ServiceApi* | [**post_service_groups**](docs/ServiceApi.md#post_service_groups) | **POST** /service/groups/ | 
*ServiceApi* | [**post_service_groups_by_groupid**](docs/ServiceApi.md#post_service_groups_by_groupid) | **POST** /service/groups/{groupId}/ | 
*ServiceApi* | [**post_service_items**](docs/ServiceApi.md#post_service_items) | **POST** /service/items/ | 
*ServiceApi* | [**post_service_items_by_itemid**](docs/ServiceApi.md#post_service_items_by_itemid) | **POST** /service/items/{itemId}/ | 
*ServiceApi* | [**post_service_price**](docs/ServiceApi.md#post_service_price) | **POST** /service/price/ | 
*ServiceApi* | [**post_service_price_query**](docs/ServiceApi.md#post_service_price_query) | **POST** /service/price/query/ | 
*ServiceApi* | [**post_service_properties**](docs/ServiceApi.md#post_service_properties) | **POST** /service/properties/ | 
*ServiceApi* | [**post_service_properties_by_propertykey**](docs/ServiceApi.md#post_service_properties_by_propertykey) | **POST** /service/properties/{propertyKey}/ | 
*ServiceApi* | [**post_service_resources**](docs/ServiceApi.md#post_service_resources) | **POST** /service/resources/ | 
*ServiceApi* | [**post_service_resources_by_resourceid**](docs/ServiceApi.md#post_service_resources_by_resourceid) | **POST** /service/resources/{resourceId}/ | 
*ServiceApi* | [**post_service_resources_items**](docs/ServiceApi.md#post_service_resources_items) | **POST** /service/resources/items/ | 
*ServiceApi* | [**post_service_resources_items_query**](docs/ServiceApi.md#post_service_resources_items_query) | **POST** /service/resources/items/query/ | 
*ServiceApi* | [**post_service_resources_properties**](docs/ServiceApi.md#post_service_resources_properties) | **POST** /service/resources/properties/ | 
*ServiceApi* | [**post_service_resources_properties_by_propertykey**](docs/ServiceApi.md#post_service_resources_properties_by_propertykey) | **POST** /service/resources/properties/{propertyKey}/ | 
*ServiceApi* | [**post_service_resources_time_by_resourceid_by_shopid_date_by_date**](docs/ServiceApi.md#post_service_resources_time_by_resourceid_by_shopid_date_by_date) | **POST** /service/resources/time/{resourceId}/{shopId}/date/{date}/ | 
*ServiceApi* | [**post_service_resources_time_by_resourceid_by_shopid_week**](docs/ServiceApi.md#post_service_resources_time_by_resourceid_by_shopid_week) | **POST** /service/resources/time/{resourceId}/{shopId}/week/ | 
*ServiceApi* | [**post_service_time**](docs/ServiceApi.md#post_service_time) | **POST** /service/time/ | 
*ServiceApi* | [**post_service_time_query**](docs/ServiceApi.md#post_service_time_query) | **POST** /service/time/query/ | 
*SettingsApi* | [**delete_options_settings_by_userid_by_modulename**](docs/SettingsApi.md#delete_options_settings_by_userid_by_modulename) | **DELETE** /options/settings/{userId}/{moduleName}/ | Сбросить настройки модуля пользователя
*SettingsApi* | [**delete_options_settings_by_userid_by_modulename_by_settingkey**](docs/SettingsApi.md#delete_options_settings_by_userid_by_modulename_by_settingkey) | **DELETE** /options/settings/{userId}/{moduleName}/{settingKey}/ | Сбросить настройку модуля
*SettingsApi* | [**delete_options_settingscompany_by_modulename**](docs/SettingsApi.md#delete_options_settingscompany_by_modulename) | **DELETE** /options/settingsCompany/{moduleName}/ | Сбросить настройки модуля компании
*SettingsApi* | [**delete_options_settingscompany_by_modulename_by_settingkey**](docs/SettingsApi.md#delete_options_settingscompany_by_modulename_by_settingkey) | **DELETE** /options/settingsCompany/{moduleName}/{settingKey}/ | Сбросить настройку модуля компании
*SettingsApi* | [**delete_options_settingsglobal_by_modulename**](docs/SettingsApi.md#delete_options_settingsglobal_by_modulename) | **DELETE** /options/settingsGlobal/{moduleName}/ | Сбросить настройки модуля компании
*SettingsApi* | [**delete_options_settingsglobal_by_modulename_by_settingkey**](docs/SettingsApi.md#delete_options_settingsglobal_by_modulename_by_settingkey) | **DELETE** /options/settingsGlobal/{moduleName}/{settingKey}/ | Сбросить настройку модуля компании
*SettingsApi* | [**get_options_settings_by_userid**](docs/SettingsApi.md#get_options_settings_by_userid) | **GET** /options/settings/{userId}/ | Запросить настройки пользователя
*SettingsApi* | [**get_options_settings_by_userid_by_modulename**](docs/SettingsApi.md#get_options_settings_by_userid_by_modulename) | **GET** /options/settings/{userId}/{moduleName}/ | Запросить настройки модуля пользователя
*SettingsApi* | [**get_options_settings_by_userid_by_modulename_by_settingkey**](docs/SettingsApi.md#get_options_settings_by_userid_by_modulename_by_settingkey) | **GET** /options/settings/{userId}/{moduleName}/{settingKey}/ | Запросить настройку модуля по ключу
*SettingsApi* | [**get_options_settingscompany**](docs/SettingsApi.md#get_options_settingscompany) | **GET** /options/settingsCompany/ | Запросить настройки компании
*SettingsApi* | [**get_options_settingscompany_by_modulename**](docs/SettingsApi.md#get_options_settingscompany_by_modulename) | **GET** /options/settingsCompany/{moduleName}/ | Запросить настройки модуля компании
*SettingsApi* | [**get_options_settingscompany_by_modulename_by_settingkey**](docs/SettingsApi.md#get_options_settingscompany_by_modulename_by_settingkey) | **GET** /options/settingsCompany/{moduleName}/{settingKey}/ | Получить настройку модуля компании
*SettingsApi* | [**get_options_settingsglobal**](docs/SettingsApi.md#get_options_settingsglobal) | **GET** /options/settingsGlobal/ | Запросить все глобальные настройки
*SettingsApi* | [**get_options_settingsglobal_by_modulename**](docs/SettingsApi.md#get_options_settingsglobal_by_modulename) | **GET** /options/settingsGlobal/{moduleName}/ | Получить настройки модуля компании
*SettingsApi* | [**get_options_settingsglobal_by_modulename_by_settingkey**](docs/SettingsApi.md#get_options_settingsglobal_by_modulename_by_settingkey) | **GET** /options/settingsGlobal/{moduleName}/{settingKey}/ | Получить настройку модуля компании
*SettingsApi* | [**post_options_settings_by_userid**](docs/SettingsApi.md#post_options_settings_by_userid) | **POST** /options/settings/{userId}/ | Сохранить настройки пользователя
*SettingsApi* | [**post_options_settings_by_userid_by_modulename**](docs/SettingsApi.md#post_options_settings_by_userid_by_modulename) | **POST** /options/settings/{userId}/{moduleName}/ | Сохранить настройки модуля пользователя
*SettingsApi* | [**post_options_settings_by_userid_by_modulename_by_settingkey**](docs/SettingsApi.md#post_options_settings_by_userid_by_modulename_by_settingkey) | **POST** /options/settings/{userId}/{moduleName}/{settingKey}/ | Сохранить настройку модуля
*SettingsApi* | [**post_options_settingscompany**](docs/SettingsApi.md#post_options_settingscompany) | **POST** /options/settingsCompany/ | Сохранить настройки компании
*SettingsApi* | [**post_options_settingscompany_by_modulename**](docs/SettingsApi.md#post_options_settingscompany_by_modulename) | **POST** /options/settingsCompany/{moduleName}/ | Сохранить настройки модуля компании
*SettingsApi* | [**post_options_settingscompany_by_modulename_by_settingkey**](docs/SettingsApi.md#post_options_settingscompany_by_modulename_by_settingkey) | **POST** /options/settingsCompany/{moduleName}/{settingKey}/ | Сохранить настройку модуля компании
*SettingsApi* | [**post_options_settingsglobal**](docs/SettingsApi.md#post_options_settingsglobal) | **POST** /options/settingsGlobal/ | Сохранить глобальные настройки
*SettingsApi* | [**post_options_settingsglobal_by_modulename**](docs/SettingsApi.md#post_options_settingsglobal_by_modulename) | **POST** /options/settingsGlobal/{moduleName}/ | Сохранить настройки модуля компании
*SettingsApi* | [**post_options_settingsglobal_by_modulename_by_settingkey**](docs/SettingsApi.md#post_options_settingsglobal_by_modulename_by_settingkey) | **POST** /options/settingsGlobal/{moduleName}/{settingKey}/ | Сохранить настройку модуля компании
*ShininvestApi* | [**get_shininvest_delivery_cities**](docs/ShininvestApi.md#get_shininvest_delivery_cities) | **GET** /shininvest/delivery/cities/ | 
*ShininvestApi* | [**post_shininvest_card_activate**](docs/ShininvestApi.md#post_shininvest_card_activate) | **POST** /shininvest/card/activate/ | 
*ShininvestApi* | [**post_shininvest_card_info**](docs/ShininvestApi.md#post_shininvest_card_info) | **POST** /shininvest/card/info/ | 
*ShininvestApi* | [**post_shininvest_card_virtual**](docs/ShininvestApi.md#post_shininvest_card_virtual) | **POST** /shininvest/card/virtual/ | 
*ShininvestApi* | [**post_shininvest_card_virtual_transfer**](docs/ShininvestApi.md#post_shininvest_card_virtual_transfer) | **POST** /shininvest/card/virtual/transfer/ | 
*ShininvestApi* | [**post_shininvest_delivery_price**](docs/ShininvestApi.md#post_shininvest_delivery_price) | **POST** /shininvest/delivery/price/ | 
*ShininvestApi* | [**post_shininvest_promocode**](docs/ShininvestApi.md#post_shininvest_promocode) | **POST** /shininvest/promocode/ | 
*ShininvestApi* | [**post_shininvest_time**](docs/ShininvestApi.md#post_shininvest_time) | **POST** /shininvest/time/ | 
*ShopsApi* | [**delete_static_shops_groups_by_groupid**](docs/ShopsApi.md#delete_static_shops_groups_by_groupid) | **DELETE** /static/shops/groups/{groupId}/ | Удаление группы
*ShopsApi* | [**delete_static_shops_groups_properties_by_propertykey**](docs/ShopsApi.md#delete_static_shops_groups_properties_by_propertykey) | **DELETE** /static/shops/groups/properties/{propertyKey}/ | Удаление свойства
*ShopsApi* | [**delete_static_shops_items_by_itemid**](docs/ShopsApi.md#delete_static_shops_items_by_itemid) | **DELETE** /static/shops/items/{itemId}/ | Удаление магазина
*ShopsApi* | [**delete_static_shops_items_by_itemid_catalogitem_by_catalogitemid**](docs/ShopsApi.md#delete_static_shops_items_by_itemid_catalogitem_by_catalogitemid) | **DELETE** /static/shops/items/{itemId}/catalogItem/{CatalogItemId}/ | Удаление связи магазина и товара
*ShopsApi* | [**delete_static_shops_properties_by_propertykey**](docs/ShopsApi.md#delete_static_shops_properties_by_propertykey) | **DELETE** /static/shops/properties/{propertyKey}/ | Удаление свойства магазина
*ShopsApi* | [**get_static_shops_groups**](docs/ShopsApi.md#get_static_shops_groups) | **GET** /static/shops/groups/ | Запрос списка групп и объектов корневой группы
*ShopsApi* | [**get_static_shops_groups_by_groupid**](docs/ShopsApi.md#get_static_shops_groups_by_groupid) | **GET** /static/shops/groups/{groupId}/ | Получить список объектов указанной группы
*ShopsApi* | [**get_static_shops_groups_properties**](docs/ShopsApi.md#get_static_shops_groups_properties) | **GET** /static/shops/groups/properties/ | Запрос списка свойств каждого элемента в группе (у магазинов)
*ShopsApi* | [**get_static_shops_groups_properties_by_propertykey**](docs/ShopsApi.md#get_static_shops_groups_properties_by_propertykey) | **GET** /static/shops/groups/properties/{propertyKey}/ | Запрос свойства группы
*ShopsApi* | [**get_static_shops_items_by_itemid**](docs/ShopsApi.md#get_static_shops_items_by_itemid) | **GET** /static/shops/items/{itemId}/ | Запрос информации о магазине
*ShopsApi* | [**get_static_shops_properties**](docs/ShopsApi.md#get_static_shops_properties) | **GET** /static/shops/properties/ | Запрос списка свойств магазинов
*ShopsApi* | [**get_static_shops_properties_by_propertykey**](docs/ShopsApi.md#get_static_shops_properties_by_propertykey) | **GET** /static/shops/properties/{propertyKey}/ | Запрос свойства
*ShopsApi* | [**post_static_shops_groups**](docs/ShopsApi.md#post_static_shops_groups) | **POST** /static/shops/groups/ | Создание группы
*ShopsApi* | [**post_static_shops_groups_by_groupid**](docs/ShopsApi.md#post_static_shops_groups_by_groupid) | **POST** /static/shops/groups/{groupId}/ | Обновление группы
*ShopsApi* | [**post_static_shops_groups_properties**](docs/ShopsApi.md#post_static_shops_groups_properties) | **POST** /static/shops/groups/properties/ | Создание свойства для групп магазинов организации
*ShopsApi* | [**post_static_shops_groups_properties_by_propertykey**](docs/ShopsApi.md#post_static_shops_groups_properties_by_propertykey) | **POST** /static/shops/groups/properties/{propertyKey}/ | Обновление свойства
*ShopsApi* | [**post_static_shops_items**](docs/ShopsApi.md#post_static_shops_items) | **POST** /static/shops/items/ | Создание нового магазина
*ShopsApi* | [**post_static_shops_items_by_itemid**](docs/ShopsApi.md#post_static_shops_items_by_itemid) | **POST** /static/shops/items/{itemId}/ | Обновление магазина
*ShopsApi* | [**post_static_shops_items_by_itemid_catalogitem**](docs/ShopsApi.md#post_static_shops_items_by_itemid_catalogitem) | **POST** /static/shops/items/{itemId}/catalogItem/ | Создание связи магазина и товара
*ShopsApi* | [**post_static_shops_items_by_itemid_catalogitem_by_catalogitemid**](docs/ShopsApi.md#post_static_shops_items_by_itemid_catalogitem_by_catalogitemid) | **POST** /static/shops/items/{itemId}/catalogItem/{CatalogItemId}/ | Обновление связи магазина и товара
*ShopsApi* | [**post_static_shops_properties**](docs/ShopsApi.md#post_static_shops_properties) | **POST** /static/shops/properties/ | Создание свойства для магазинов организации
*ShopsApi* | [**post_static_shops_properties_by_propertykey**](docs/ShopsApi.md#post_static_shops_properties_by_propertykey) | **POST** /static/shops/properties/{propertyKey}/ | Обновление свойства
*ShopsApi* | [**post_static_shops_query**](docs/ShopsApi.md#post_static_shops_query) | **POST** /static/shops/query/ | Поиск по магазинам с товарами в наличии
*ShopsApi* | [**post_static_shops_querywithrelations**](docs/ShopsApi.md#post_static_shops_querywithrelations) | **POST** /static/shops/queryWithRelations/ | Поиск по магазинам в наличии которых есть товары с доп свойствами
*ShopsApi* | [**post_static_shops_request**](docs/ShopsApi.md#post_static_shops_request) | **POST** /static/shops/request/ | Поиск (QueryDSL) с агрегацией собираемых данных
*SpaceApi* | [**delete_dynamic_space_by_spacekey**](docs/SpaceApi.md#delete_dynamic_space_by_spacekey) | **DELETE** /dynamic/space/{spaceKey}/ | Удалить пространство
*SpaceApi* | [**delete_dynamic_space_by_spacekey_tuples_by_tupleid**](docs/SpaceApi.md#delete_dynamic_space_by_spacekey_tuples_by_tupleid) | **DELETE** /dynamic/space/{spaceKey}/tuples/{tupleId}/ | Удалить кортеж
*SpaceApi* | [**get_dynamic_space_by_spacekey**](docs/SpaceApi.md#get_dynamic_space_by_spacekey) | **GET** /dynamic/space/{spaceKey}/ | Запросить информацию о пространстве
*SpaceApi* | [**get_dynamic_space_by_spacekey_tuples_by_tupleid**](docs/SpaceApi.md#get_dynamic_space_by_spacekey_tuples_by_tupleid) | **GET** /dynamic/space/{spaceKey}/tuples/{tupleId}/ | Запросить кортеж пространства
*SpaceApi* | [**post_dynamic_space**](docs/SpaceApi.md#post_dynamic_space) | **POST** /dynamic/space/ | Создать пространство
*SpaceApi* | [**post_dynamic_space_by_spacekey_query**](docs/SpaceApi.md#post_dynamic_space_by_spacekey_query) | **POST** /dynamic/space/{spaceKey}/query/ | Запросить кортежи пространства
*SpaceApi* | [**post_dynamic_space_by_spacekey_tuples**](docs/SpaceApi.md#post_dynamic_space_by_spacekey_tuples) | **POST** /dynamic/space/{spaceKey}/tuples/ | Вставить кортеж
*SpaceApi* | [**post_dynamic_space_by_spacekey_tuples_by_tupleid**](docs/SpaceApi.md#post_dynamic_space_by_spacekey_tuples_by_tupleid) | **POST** /dynamic/space/{spaceKey}/tuples/{tupleId}/ | Обновить кортеж
*StatisticsApi* | [**put_statistics_event_catalog_item_show**](docs/StatisticsApi.md#put_statistics_event_catalog_item_show) | **PUT** /statistics/event/catalog/item/show/ | Регистрация события просмотра товара
*StatisticsApi* | [**put_statistics_event_order_items**](docs/StatisticsApi.md#put_statistics_event_order_items) | **PUT** /statistics/event/order/items/ | Регистрация события смены состава заказа
*StatisticsApi* | [**put_statistics_event_order_status**](docs/StatisticsApi.md#put_statistics_event_order_status) | **PUT** /statistics/event/order/status/ | Регистрация события смена статуса заказа
*StatisticsApi* | [**put_statistics_event_push_open**](docs/StatisticsApi.md#put_statistics_event_push_open) | **PUT** /statistics/event/push/open/ | Регистрация события открытия push уведомления
*StatisticsApi* | [**put_statistics_event_push_received**](docs/StatisticsApi.md#put_statistics_event_push_received) | **PUT** /statistics/event/push/received/ | Регистрация события приема push уведомления
*SupportApi* | [**delete_support_reason_by_reasonname**](docs/SupportApi.md#delete_support_reason_by_reasonname) | **DELETE** /support/reason/{reasonName}/ | Удаление причины обращения
*SupportApi* | [**delete_support_reason_by_reasonname_operator_by_operatorid**](docs/SupportApi.md#delete_support_reason_by_reasonname_operator_by_operatorid) | **DELETE** /support/reason/{reasonName}/operator/{operatorId}/ | Удаление оператора
*SupportApi* | [**delete_support_ticket_by_userid_by_ticketid**](docs/SupportApi.md#delete_support_ticket_by_userid_by_ticketid) | **DELETE** /support/ticket/{userId}/{ticketId}/ | Удаление обращения
*SupportApi* | [**get_support_client_reason_by_reasonname_operator**](docs/SupportApi.md#get_support_client_reason_by_reasonname_operator) | **GET** /support/client/reason/{reasonName}/operator/ | Список операторов для клиентов (без сердств коммуникации)
*SupportApi* | [**get_support_client_reason_by_reasonname_operator_by_operatorid**](docs/SupportApi.md#get_support_client_reason_by_reasonname_operator_by_operatorid) | **GET** /support/client/reason/{reasonName}/operator/{operatorId}/ | Запрос оператора для клиентов  (без сердств коммуникации)
*SupportApi* | [**get_support_reason**](docs/SupportApi.md#get_support_reason) | **GET** /support/reason/ | Список причин обращения
*SupportApi* | [**get_support_reason_by_reasonname**](docs/SupportApi.md#get_support_reason_by_reasonname) | **GET** /support/reason/{reasonName}/ | Запрос причины обращения
*SupportApi* | [**get_support_reason_by_reasonname_format**](docs/SupportApi.md#get_support_reason_by_reasonname_format) | **GET** /support/reason/{reasonName}/format/ | 
*SupportApi* | [**get_support_reason_by_reasonname_operator**](docs/SupportApi.md#get_support_reason_by_reasonname_operator) | **GET** /support/reason/{reasonName}/operator/ | Список операторов
*SupportApi* | [**get_support_reason_by_reasonname_operator_by_operatorid**](docs/SupportApi.md#get_support_reason_by_reasonname_operator_by_operatorid) | **GET** /support/reason/{reasonName}/operator/{operatorId}/ | Запрос оператор
*SupportApi* | [**get_support_ticket_by_userid_by_ticketid**](docs/SupportApi.md#get_support_ticket_by_userid_by_ticketid) | **GET** /support/ticket/{userId}/{ticketId}/ | Запрос обращения
*SupportApi* | [**post_support_feedback**](docs/SupportApi.md#post_support_feedback) | **POST** /support/feedback/ | 
*SupportApi* | [**post_support_reason_by_reasonname**](docs/SupportApi.md#post_support_reason_by_reasonname) | **POST** /support/reason/{reasonName}/ | Обновление причины обращения
*SupportApi* | [**post_support_reason_by_reasonname_format**](docs/SupportApi.md#post_support_reason_by_reasonname_format) | **POST** /support/reason/{reasonName}/format/ | 
*SupportApi* | [**post_support_reason_by_reasonname_operator_by_operatorid**](docs/SupportApi.md#post_support_reason_by_reasonname_operator_by_operatorid) | **POST** /support/reason/{reasonName}/operator/{operatorId}/ | Обновление оператора
*SupportApi* | [**post_support_ticket**](docs/SupportApi.md#post_support_ticket) | **POST** /support/ticket/ | Поиск обращений оператора
*SupportApi* | [**post_support_ticket_by_userid**](docs/SupportApi.md#post_support_ticket_by_userid) | **POST** /support/ticket/{userId}/ | Поиск обращений пользователя
*SupportApi* | [**post_support_ticket_by_userid_by_ticketid**](docs/SupportApi.md#post_support_ticket_by_userid_by_ticketid) | **POST** /support/ticket/{userId}/{ticketId}/ | Обновление обращения
*SupportApi* | [**post_support_ticket_export**](docs/SupportApi.md#post_support_ticket_export) | **POST** /support/ticket/export/ | Экспорт обращений
*SupportApi* | [**put_support_reason**](docs/SupportApi.md#put_support_reason) | **PUT** /support/reason/ | Создание причины
*SupportApi* | [**put_support_reason_by_reasonname_operator**](docs/SupportApi.md#put_support_reason_by_reasonname_operator) | **PUT** /support/reason/{reasonName}/operator/ | Добавление оператора
*SupportApi* | [**put_support_ticket_by_userid**](docs/SupportApi.md#put_support_ticket_by_userid) | **PUT** /support/ticket/{userId}/ | Создание обращения пользователя
*TalanApi* | [**delete_talan_bookmarks_by_bookmarkid**](docs/TalanApi.md#delete_talan_bookmarks_by_bookmarkid) | **DELETE** /talan/bookmarks/{BookmarkId}/ | Удаление закладки
*TalanApi* | [**get_talan_bookmarks**](docs/TalanApi.md#get_talan_bookmarks) | **GET** /talan/bookmarks/ | Список закладок пользователя
*TalanApi* | [**post_talan_bookmarks**](docs/TalanApi.md#post_talan_bookmarks) | **POST** /talan/bookmarks/ | Создание закладки
*TalanApi* | [**post_talan_bookmarks_by_bookmarkid**](docs/TalanApi.md#post_talan_bookmarks_by_bookmarkid) | **POST** /talan/bookmarks/{BookmarkId}/ | Обновить закладку
*TalanAuthApi* | [**post_talan_auth_signin_code**](docs/TalanAuthApi.md#post_talan_auth_signin_code) | **POST** /talan/auth/signin/code/ | Запросить код авторизации
*TalanAuthApi* | [**post_talan_auth_signin_code_confirmation**](docs/TalanAuthApi.md#post_talan_auth_signin_code_confirmation) | **POST** /talan/auth/signin/code/confirmation/ | Подтверждение кода авторизации
*TalanAuthApi* | [**post_talan_auth_token_refresh**](docs/TalanAuthApi.md#post_talan_auth_token_refresh) | **POST** /talan/auth/token/refresh/ | Получение нового токена
*TalanAuthApi* | [**post_talan_auth_verify_communication**](docs/TalanAuthApi.md#post_talan_auth_verify_communication) | **POST** /talan/auth/verify/communication/ | Подтверждение средства связи
*UsersApi* | [**delete_dynamic_user_by_userid**](docs/UsersApi.md#delete_dynamic_user_by_userid) | **DELETE** /dynamic/user/{userId}/ | Удаление пользователя
*UsersApi* | [**delete_dynamic_user_properties_by_propertykey**](docs/UsersApi.md#delete_dynamic_user_properties_by_propertykey) | **DELETE** /dynamic/user/properties/{propertyKey}/ | Удаление свойства
*UsersApi* | [**get_dynamic_user_by_userid**](docs/UsersApi.md#get_dynamic_user_by_userid) | **GET** /dynamic/user/{userId}/ | Запрос информации о пользователе
*UsersApi* | [**get_dynamic_user_properties**](docs/UsersApi.md#get_dynamic_user_properties) | **GET** /dynamic/user/properties/ | Запрос списка свойств
*UsersApi* | [**get_dynamic_user_properties_by_propertykey**](docs/UsersApi.md#get_dynamic_user_properties_by_propertykey) | **GET** /dynamic/user/properties/{propertyKey}/ | Запрос свойства пользователя
*UsersApi* | [**post_dynamic_finduserbycommunication**](docs/UsersApi.md#post_dynamic_finduserbycommunication) | **POST** /dynamic/findUserByCommunication/ | Запрос пользователя по средству связи или логину
*UsersApi* | [**post_dynamic_user**](docs/UsersApi.md#post_dynamic_user) | **POST** /dynamic/user/ | Создание нового пользователя
*UsersApi* | [**post_dynamic_user_by_userid**](docs/UsersApi.md#post_dynamic_user_by_userid) | **POST** /dynamic/user/{userId}/ | Обновлении информации о пользователе
*UsersApi* | [**post_dynamic_user_by_userid_communicationconfirm**](docs/UsersApi.md#post_dynamic_user_by_userid_communicationconfirm) | **POST** /dynamic/user/{userId}/communicationConfirm/ | Изменение статуса подтверждения средства связи
*UsersApi* | [**post_dynamic_user_by_userid_groups**](docs/UsersApi.md#post_dynamic_user_by_userid_groups) | **POST** /dynamic/user/{userId}/groups/ | Изменение списка групп пользователя
*UsersApi* | [**post_dynamic_user_count**](docs/UsersApi.md#post_dynamic_user_count) | **POST** /dynamic/user/count/ | Запрос записей по заданным параметрам
*UsersApi* | [**post_dynamic_user_create**](docs/UsersApi.md#post_dynamic_user_create) | **POST** /dynamic/user/create/ | Создание нового пользователя для внешних запросов
*UsersApi* | [**post_dynamic_user_properties**](docs/UsersApi.md#post_dynamic_user_properties) | **POST** /dynamic/user/properties/ | Создание свойства
*UsersApi* | [**post_dynamic_user_properties_by_propertykey**](docs/UsersApi.md#post_dynamic_user_properties_by_propertykey) | **POST** /dynamic/user/properties/{propertyKey}/ | Обновление свойства
*UsersApi* | [**post_dynamic_user_reindex_by_cid**](docs/UsersApi.md#post_dynamic_user_reindex_by_cid) | **POST** /dynamic/user/reindex/{cid}/ | Переиндексация пользователей для компаний 
*UsersApi* | [**post_dynamic_user_request**](docs/UsersApi.md#post_dynamic_user_request) | **POST** /dynamic/user/request/ | Поиск пользователей с созданием агрегаций
*UsersApi* | [**post_dynamic_user_search**](docs/UsersApi.md#post_dynamic_user_search) | **POST** /dynamic/user/search/ | Запрос списка пользователей к elastic
*UsersApi* | [**post_dynamic_user_searchafter**](docs/UsersApi.md#post_dynamic_user_searchafter) | **POST** /dynamic/user/searchAfter/ | Запрос определенного количества пользователей по заданным параметрам
*UsersApi* | [**post_dynamic_user_update_by_userid**](docs/UsersApi.md#post_dynamic_user_update_by_userid) | **POST** /dynamic/user/update/{userId}/ | Обновление информации о пользователе для внешних запросов
*UsersApi* | [**post_dynamic_userquery**](docs/UsersApi.md#post_dynamic_userquery) | **POST** /dynamic/userQuery/ | Запрос списка пользователей
*UsersApi* | [**post_dynamic_userquerywithrelations**](docs/UsersApi.md#post_dynamic_userquerywithrelations) | **POST** /dynamic/userQueryWithRelations/ | Запрос списка пользователей
*UsersApi* | [**put_dynamic_user_by_userid_communication**](docs/UsersApi.md#put_dynamic_user_by_userid_communication) | **PUT** /dynamic/user/{userId}/communication/ | Добавление средства связи


## Documentation For Models

 - [Address](docs/Address.md)
 - [AfterSearch](docs/AfterSearch.md)
 - [Aggregation](docs/Aggregation.md)
 - [AnalyticsPushResponse](docs/AnalyticsPushResponse.md)
 - [AnalyticsResponse](docs/AnalyticsResponse.md)
 - [ApplePayRegisterRequest](docs/ApplePayRegisterRequest.md)
 - [BalanceModel](docs/BalanceModel.md)
 - [BaseMailingItem](docs/BaseMailingItem.md)
 - [BaseQuery](docs/BaseQuery.md)
 - [BaseSearch](docs/BaseSearch.md)
 - [BaseTemplateMessage](docs/BaseTemplateMessage.md)
 - [BaseTemplateMessageTemplate](docs/BaseTemplateMessageTemplate.md)
 - [BatchErrorsModel](docs/BatchErrorsModel.md)
 - [BatchUpdateUsersModel](docs/BatchUpdateUsersModel.md)
 - [BatchUserQuery](docs/BatchUserQuery.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [Body2](docs/Body2.md)
 - [Body3](docs/Body3.md)
 - [Body4](docs/Body4.md)
 - [CalDay](docs/CalDay.md)
 - [CalInterval](docs/CalInterval.md)
 - [CalQueryListShopWork](docs/CalQueryListShopWork.md)
 - [CalQueryListShopWorkResponse](docs/CalQueryListShopWorkResponse.md)
 - [CalQueryListShopWorkResponseItem](docs/CalQueryListShopWorkResponseItem.md)
 - [CalQueryListWorkTimes](docs/CalQueryListWorkTimes.md)
 - [CalWeek](docs/CalWeek.md)
 - [CalWorkTime](docs/CalWorkTime.md)
 - [CardActivation](docs/CardActivation.md)
 - [CardIdentification](docs/CardIdentification.md)
 - [CardInfo](docs/CardInfo.md)
 - [CardRegisterRequestV2](docs/CardRegisterRequestV2.md)
 - [Cart](docs/Cart.md)
 - [CartItem](docs/CartItem.md)
 - [CartItemData](docs/CartItemData.md)
 - [CartItems](docs/CartItems.md)
 - [CartPatch](docs/CartPatch.md)
 - [CatalogGroupQuery](docs/CatalogGroupQuery.md)
 - [CatalogIndexerQuery](docs/CatalogIndexerQuery.md)
 - [CatalogItem](docs/CatalogItem.md)
 - [CatalogItemInShop](docs/CatalogItemInShop.md)
 - [CatalogItemInShopQuery](docs/CatalogItemInShopQuery.md)
 - [CatalogItemRemains](docs/CatalogItemRemains.md)
 - [CatalogItemsInShopsQuery](docs/CatalogItemsInShopsQuery.md)
 - [CatalogQuery](docs/CatalogQuery.md)
 - [CatalogResponse](docs/CatalogResponse.md)
 - [Channel](docs/Channel.md)
 - [CloudLoyaltyBalance](docs/CloudLoyaltyBalance.md)
 - [CloudLoyaltyBonuses](docs/CloudLoyaltyBonuses.md)
 - [CloudLoyaltyClient](docs/CloudLoyaltyClient.md)
 - [CloudLoyaltyHistory](docs/CloudLoyaltyHistory.md)
 - [CloudLoyaltyHistoryResponse](docs/CloudLoyaltyHistoryResponse.md)
 - [CloudLoyaltyOperationApplied](docs/CloudLoyaltyOperationApplied.md)
 - [CloudLoyaltyOperationCollected](docs/CloudLoyaltyOperationCollected.md)
 - [CloudLoyaltyPagination](docs/CloudLoyaltyPagination.md)
 - [CodeQuery](docs/CodeQuery.md)
 - [Collection](docs/Collection.md)
 - [CollectionRow](docs/CollectionRow.md)
 - [Communication](docs/Communication.md)
 - [CommunicationConfirm](docs/CommunicationConfirm.md)
 - [ConfirmationQuery](docs/ConfirmationQuery.md)
 - [Content](docs/Content.md)
 - [CountQuery](docs/CountQuery.md)
 - [CountQueryResponse](docs/CountQueryResponse.md)
 - [CreateVirtual](docs/CreateVirtual.md)
 - [DcAggregationReq](docs/DcAggregationReq.md)
 - [DcAggregationResp](docs/DcAggregationResp.md)
 - [DcBind](docs/DcBind.md)
 - [DcBindingByPhoneRequest](docs/DcBindingByPhoneRequest.md)
 - [DcBindingRequest](docs/DcBindingRequest.md)
 - [DcCardBase](docs/DcCardBase.md)
 - [DcCardImportResponse](docs/DcCardImportResponse.md)
 - [DcLoyaltyHistory](docs/DcLoyaltyHistory.md)
 - [Delivery](docs/Delivery.md)
 - [DeliveryPrice](docs/DeliveryPrice.md)
 - [Document](docs/Document.md)
 - [DocumentResponse](docs/DocumentResponse.md)
 - [EmailTarget](docs/EmailTarget.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [EventPayload](docs/EventPayload.md)
 - [FileDeleteRequest](docs/FileDeleteRequest.md)
 - [FileUploadResponse](docs/FileUploadResponse.md)
 - [GooglePayRegisterRequest](docs/GooglePayRegisterRequest.md)
 - [Group](docs/Group.md)
 - [Health](docs/Health.md)
 - [History](docs/History.md)
 - [HistoryCountResponse](docs/HistoryCountResponse.md)
 - [IProperty](docs/IProperty.md)
 - [InfoItem](docs/InfoItem.md)
 - [InfoItemsResponse](docs/InfoItemsResponse.md)
 - [Infosystem](docs/Infosystem.md)
 - [InfosystemQuery](docs/InfosystemQuery.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InviteQuery](docs/InviteQuery.md)
 - [ListIds](docs/ListIds.md)
 - [Loyalty](docs/Loyalty.md)
 - [LoyaltyHistory](docs/LoyaltyHistory.md)
 - [LoyaltyInstagramId](docs/LoyaltyInstagramId.md)
 - [LoyaltyInviteCode](docs/LoyaltyInviteCode.md)
 - [LoyaltyVkId](docs/LoyaltyVkId.md)
 - [MailingItemList](docs/MailingItemList.md)
 - [MailingStatistics](docs/MailingStatistics.md)
 - [MailingTarget](docs/MailingTarget.md)
 - [MessageFabric](docs/MessageFabric.md)
 - [MessageHistory](docs/MessageHistory.md)
 - [MessageHistoryStatistic](docs/MessageHistoryStatistic.md)
 - [MessageSingle](docs/MessageSingle.md)
 - [MessageTemplate](docs/MessageTemplate.md)
 - [MessageTemplateList](docs/MessageTemplateList.md)
 - [Mode](docs/Mode.md)
 - [NewMailingItem](docs/NewMailingItem.md)
 - [OasPromocode](docs/OasPromocode.md)
 - [OperatorCommunication](docs/OperatorCommunication.md)
 - [Order](docs/Order.md)
 - [OrderDelivery](docs/OrderDelivery.md)
 - [OrderExport](docs/OrderExport.md)
 - [OrderItem](docs/OrderItem.md)
 - [OrderPayment](docs/OrderPayment.md)
 - [OrderQuery](docs/OrderQuery.md)
 - [OrderResponse](docs/OrderResponse.md)
 - [OrderService](docs/OrderService.md)
 - [OrderServiceItem](docs/OrderServiceItem.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [OrderV2List](docs/OrderV2List.md)
 - [OrderV2ListPagination](docs/OrderV2ListPagination.md)
 - [OrderV2Patch](docs/OrderV2Patch.md)
 - [OrderV2Short](docs/OrderV2Short.md)
 - [OrderV2User](docs/OrderV2User.md)
 - [OrderV2UserPayment](docs/OrderV2UserPayment.md)
 - [OrdersV2PaymentType](docs/OrdersV2PaymentType.md)
 - [OrdersV2QueryDslResult](docs/OrdersV2QueryDslResult.md)
 - [OrdersV2StatusShort](docs/OrdersV2StatusShort.md)
 - [Pagination](docs/Pagination.md)
 - [PasswordQuery](docs/PasswordQuery.md)
 - [PayBinding](docs/PayBinding.md)
 - [PayRegisterSberbankRequest](docs/PayRegisterSberbankRequest.md)
 - [PayRegisterSberbankResponse](docs/PayRegisterSberbankResponse.md)
 - [Payment](docs/Payment.md)
 - [PaymentRegisterRequestV2](docs/PaymentRegisterRequestV2.md)
 - [PaymentResponse](docs/PaymentResponse.md)
 - [PaymentStatus](docs/PaymentStatus.md)
 - [Point](docs/Point.md)
 - [Price](docs/Price.md)
 - [Promocode](docs/Promocode.md)
 - [PromocodeItem](docs/PromocodeItem.md)
 - [PromocodeResponse](docs/PromocodeResponse.md)
 - [PromotionActivateResp](docs/PromotionActivateResp.md)
 - [PromotionLaunchResp](docs/PromotionLaunchResp.md)
 - [PushTarget](docs/PushTarget.md)
 - [QueryShopsSearch](docs/QueryShopsSearch.md)
 - [Rectangle](docs/Rectangle.md)
 - [RequestBatchUpdateUser](docs/RequestBatchUpdateUser.md)
 - [ResponseBatchUpdateModel](docs/ResponseBatchUpdateModel.md)
 - [RouterAuthUserRequest](docs/RouterAuthUserRequest.md)
 - [RouterAuthUserResponse](docs/RouterAuthUserResponse.md)
 - [RouterChangePassword](docs/RouterChangePassword.md)
 - [RouterCommpanySearchQuery](docs/RouterCommpanySearchQuery.md)
 - [RouterCompany](docs/RouterCompany.md)
 - [RouterGroup](docs/RouterGroup.md)
 - [RouterGroupAddRequest](docs/RouterGroupAddRequest.md)
 - [RouterGroupAddToUserRequest](docs/RouterGroupAddToUserRequest.md)
 - [RouterGroupChangeRequest](docs/RouterGroupChangeRequest.md)
 - [RouterResource](docs/RouterResource.md)
 - [RouterResourceGet](docs/RouterResourceGet.md)
 - [RouterService](docs/RouterService.md)
 - [RouterServiceUpdateRequest](docs/RouterServiceUpdateRequest.md)
 - [RouterSubscribe](docs/RouterSubscribe.md)
 - [RouterSubscribeDelete](docs/RouterSubscribeDelete.md)
 - [RouterTemplate](docs/RouterTemplate.md)
 - [RouterTemplateDeleteQuery](docs/RouterTemplateDeleteQuery.md)
 - [RouterTemplateRoute](docs/RouterTemplateRoute.md)
 - [RouterTemplateUseQuery](docs/RouterTemplateUseQuery.md)
 - [RouterTemplateUseQueryBinding](docs/RouterTemplateUseQueryBinding.md)
 - [RouterUser](docs/RouterUser.md)
 - [RouterUserAddQuery](docs/RouterUserAddQuery.md)
 - [SamsungPayRegisterRequest](docs/SamsungPayRegisterRequest.md)
 - [SearchFilter](docs/SearchFilter.md)
 - [ServiceDateLinked](docs/ServiceDateLinked.md)
 - [ServiceDay](docs/ServiceDay.md)
 - [ServiceGroup](docs/ServiceGroup.md)
 - [ServiceGroupsResponse](docs/ServiceGroupsResponse.md)
 - [ServiceInterval](docs/ServiceInterval.md)
 - [ServiceItem](docs/ServiceItem.md)
 - [ServiceOptions](docs/ServiceOptions.md)
 - [ServicePriceInShop](docs/ServicePriceInShop.md)
 - [ServicePriceInShopResponce](docs/ServicePriceInShopResponce.md)
 - [ServicePriceQuery](docs/ServicePriceQuery.md)
 - [ServiceResource](docs/ServiceResource.md)
 - [ServiceResourceQuery](docs/ServiceResourceQuery.md)
 - [ServiceServiceInResource](docs/ServiceServiceInResource.md)
 - [ServiceServiceInResourceResponce](docs/ServiceServiceInResourceResponce.md)
 - [ServiceTimeQuery](docs/ServiceTimeQuery.md)
 - [ServiceTimeblock](docs/ServiceTimeblock.md)
 - [ServiceVersion](docs/ServiceVersion.md)
 - [ServiceWeek](docs/ServiceWeek.md)
 - [ServiceWeekLinked](docs/ServiceWeekLinked.md)
 - [ShinOrderItem](docs/ShinOrderItem.md)
 - [ShininvestTimeQuery](docs/ShininvestTimeQuery.md)
 - [ShininvestTimeblock](docs/ShininvestTimeblock.md)
 - [Shop](docs/Shop.md)
 - [ShopsGroup](docs/ShopsGroup.md)
 - [ShopsResponse](docs/ShopsResponse.md)
 - [ShopsSearchResponse](docs/ShopsSearchResponse.md)
 - [Signin](docs/Signin.md)
 - [SignupQuery](docs/SignupQuery.md)
 - [SignupResponse](docs/SignupResponse.md)
 - [SingleMessageResponse](docs/SingleMessageResponse.md)
 - [SmsTarget](docs/SmsTarget.md)
 - [SocialQuery](docs/SocialQuery.md)
 - [Stage](docs/Stage.md)
 - [Statistic](docs/Statistic.md)
 - [StatisticsEventCatalogItemShow](docs/StatisticsEventCatalogItemShow.md)
 - [StatisticsEventCatalogPush](docs/StatisticsEventCatalogPush.md)
 - [StatisticsEventOrderItems](docs/StatisticsEventOrderItems.md)
 - [StatisticsEventOrderStatus](docs/StatisticsEventOrderStatus.md)
 - [StatisticsOrderItem](docs/StatisticsOrderItem.md)
 - [SupportFeedback](docs/SupportFeedback.md)
 - [SupportOperatorShort](docs/SupportOperatorShort.md)
 - [SupportReason](docs/SupportReason.md)
 - [SupportRequestTicket](docs/SupportRequestTicket.md)
 - [SupportTicketExport](docs/SupportTicketExport.md)
 - [SupportTicketQuery](docs/SupportTicketQuery.md)
 - [TalanBookmarks](docs/TalanBookmarks.md)
 - [TalanCodeQuery](docs/TalanCodeQuery.md)
 - [TalanConfirmationQuery](docs/TalanConfirmationQuery.md)
 - [TalanRefreshQuery](docs/TalanRefreshQuery.md)
 - [TalanVerifyQuery](docs/TalanVerifyQuery.md)
 - [TbInnRequest](docs/TbInnRequest.md)
 - [TbInnResponse](docs/TbInnResponse.md)
 - [TbRecoveryRequest](docs/TbRecoveryRequest.md)
 - [TbSigninRequest](docs/TbSigninRequest.md)
 - [TbSigninResponse](docs/TbSigninResponse.md)
 - [TbSignupRequest](docs/TbSignupRequest.md)
 - [TbTimeInfo](docs/TbTimeInfo.md)
 - [TbTimeInfoDate](docs/TbTimeInfoDate.md)
 - [TbTimeRequest](docs/TbTimeRequest.md)
 - [TbTimeResponse](docs/TbTimeResponse.md)
 - [TbUserUpdateRequest](docs/TbUserUpdateRequest.md)
 - [Template](docs/Template.md)
 - [TransferInput](docs/TransferInput.md)
 - [Tuple](docs/Tuple.md)
 - [TupleQuery](docs/TupleQuery.md)
 - [UpdateMailingItem](docs/UpdateMailingItem.md)
 - [User](docs/User.md)
 - [UserGroups](docs/UserGroups.md)
 - [UserQuery](docs/UserQuery.md)
 - [UserQueryByCommunication](docs/UserQueryByCommunication.md)
 - [UserSpace](docs/UserSpace.md)
 - [UserSpaceResponse](docs/UserSpaceResponse.md)
 - [UsersResponse](docs/UsersResponse.md)
 - [UsersTarget](docs/UsersTarget.md)
 - [VerifyCheckQuery](docs/VerifyCheckQuery.md)
 - [VerifyQuery](docs/VerifyQuery.md)
 - [VirtualCard](docs/VirtualCard.md)
 - [WeekWorkTime](docs/WeekWorkTime.md)
 - [Winner](docs/Winner.md)
 - [WorkTime](docs/WorkTime.md)
 - [CalDate](docs/CalDate.md)
 - [CalWorkTimeDate](docs/CalWorkTimeDate.md)
 - [CalWorkTimeDefault](docs/CalWorkTimeDefault.md)
 - [CalWorkTimeWeek](docs/CalWorkTimeWeek.md)
 - [CartItemWithExtra](docs/CartItemWithExtra.md)
 - [CatalogItemWithRelations](docs/CatalogItemWithRelations.md)
 - [DcCard](docs/DcCard.md)
 - [DcCardByPhoneConfirmation](docs/DcCardByPhoneConfirmation.md)
 - [DcCardConfirmation](docs/DcCardConfirmation.md)
 - [DcCardImport](docs/DcCardImport.md)
 - [DcCardMask](docs/DcCardMask.md)
 - [EmailTemplateMessage](docs/EmailTemplateMessage.md)
 - [ExistingUsersModel](docs/ExistingUsersModel.md)
 - [FullMailingItem](docs/FullMailingItem.md)
 - [GooglePayRegisterRequestV2](docs/GooglePayRegisterRequestV2.md)
 - [GroupWithRelations](docs/GroupWithRelations.md)
 - [IPropertyValue](docs/IPropertyValue.md)
 - [InfoItemWithRelations](docs/InfoItemWithRelations.md)
 - [MailingItem](docs/MailingItem.md)
 - [MailingItemListObject](docs/MailingItemListObject.md)
 - [NewEmailMailingItem](docs/NewEmailMailingItem.md)
 - [NewMassMailingItem](docs/NewMassMailingItem.md)
 - [NewPushMailingItem](docs/NewPushMailingItem.md)
 - [NewSmsMailingItem](docs/NewSmsMailingItem.md)
 - [NewUserMailingItem](docs/NewUserMailingItem.md)
 - [OrderV2](docs/OrderV2.md)
 - [OrderWithProperties](docs/OrderWithProperties.md)
 - [OrderWithRelations](docs/OrderWithRelations.md)
 - [OrdersV2Status](docs/OrdersV2Status.md)
 - [PushTemplateMessage](docs/PushTemplateMessage.md)
 - [SearchQuery](docs/SearchQuery.md)
 - [SearchRequest](docs/SearchRequest.md)
 - [ServiceDate](docs/ServiceDate.md)
 - [ShopGroupWithRelations](docs/ShopGroupWithRelations.md)
 - [ShopWithRelations](docs/ShopWithRelations.md)
 - [SmsTemplateMessage](docs/SmsTemplateMessage.md)
 - [SupportOperator](docs/SupportOperator.md)
 - [SupportTicket](docs/SupportTicket.md)
 - [TemplateWithRelations](docs/TemplateWithRelations.md)
 - [UserTemplateMessage](docs/UserTemplateMessage.md)
 - [UserWithRelations](docs/UserWithRelations.md)
 - [CatalogItemWithRemains](docs/CatalogItemWithRemains.md)
 - [DcAggregationCardWithBinds](docs/DcAggregationCardWithBinds.md)


## Documentation For Authorization


## x-cid

- **Type**: API key
- **API key parameter name**: x-cid
- **Location**: HTTP header

## x-token

- **Type**: API key
- **API key parameter name**: x-token
- **Location**: HTTP header


## Author

ag@napoleonit.ru

