# Quality control 

*Libinsitu* embeds several features for QC analysis :

* Computes QC flags and embeds it into NetCDF files : 
  * Via the CLI : command [ins-transform](cli/ins-transform.md)
  * Via the Python API : function [compute_qc_flags](api/compute_qc_flags.md)
 
* Filters out flagged data :
  * Via the CLI : command [ins-cat](cli/ins-cat.md) 
  * Via Python API : parameter `skip_qc` of function [netcdf_to_dataframe](api/netcdf_to_dataframe.md)

## NetCDF encoding

The QC flags are encoded into NetCDF following the CF convention. 
See the [dedicated section in our convention](conventions.md#quality-flags) 

{#qc-flags}
## List of QC Flags

The following table shows the flags we currently process and embed into NetCDF files.

We provide the matching against the flags used in IEA-PVPS Task-16 [(Anne Forstinger and Al, 2021)](http://dx.doi.org/10.23646/3491b1a6-e32d-4b34-9dbb-ee0affe49e36)

This list of flags may evolve in next releases of *libinsitu*.

```{eval-rst}
+-----------------------------------+-----------------------------------+----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
| Test Category                     | Reference                         | Libinsitu Flag | IEA-PVPS Flag | Conditions                                 | Domain                                                   | GHI | DNI | DIF |
+===================================+===================================+================+===============+============================================+==========================================================+=====+=====+=====+
| K-Tests                           | Geuder Et Al. 2015; Gueymard 2017 | T2C_seri_kn_kt | FlagKnKt      | Kn < Kt                                    | (GHI > 50 W M2 And Kn > 0 And Kt >0)                     | X   | X   |     |
|                                   |                                   |                +---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   |                | FlagKn        | Kn < (1100+0.03 ∗ ALT)/ETN)                | (GHI > 50 W M2 And Kn > 0)                               | X   | X   |     |
|                                   |                                   |                +---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   |                | FlagKt        | Kt < 1.35                                  | (GHI > 50 W M2 And Kt > 0)                               | X   |     |     |
|                                   |                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   | T2C_bsrn_kt    | FlagKlowSZA   | 𝐾 < 1.05                                   | (SZA < 75° And GHI > 50 W M2 And 𝐾 > 0 )                 | X   |     | X   |
|                                   |                                   |                +---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   |                | FlagKhighSZA  | 𝐾 < 1.1                                    | (SZA ≥ 75° And GHI > 50 W/m2 And 𝐾 > 0)                  | X   |     | X   |
|                                   |                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   | T2C_seri_k_kt  | FlagKKt       | 𝐾 < 0.96                                   | (Kt > 0.6 And GHI > 150 W/m² And SZA < 85° And 𝐾 > 0)    | X   |     | X   |
+-----------------------------------+-----------------------------------+----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
| BSRN’s Closure                    | Long And Dutton 2002              | T3C_bsrn_3cmp  | Flag3lowSZA   | abs(GHI/(DNI⋅cos(SZA)+DIF) − 1) ≤ 0.08     | (SZA ≤ 75° And GHI > 50 W/m2)                            | X   | X   | X   |
|                                   |                                   |                +---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   |                | Flag3highSZA  | abs(GHI/(DNI⋅cos(SZA)+DIF) − 1) ≤ 0.15     | (SZA > 75° And GHI > 50 W/m2)                            | X   | X   | X   |
+-----------------------------------|                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
| BSRN’s Extremely Rare Limits      |                                   | T1C_erl_GHI    | FlagERLGHI    | −2 ≤ GHI ≤ 1.2 ⋅ ETN ⋅ Cos(SZA)^1.2+50     | All Data                                                 | X   |     |     |
|                                   |                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   | T1C_erl_DIF    | FlagERLDIF    | −2 ≤ DIF ≤ 0.75 ⋅ ETN ⋅ Cos(SZA)^1.2+30    | All Data                                                 |     |     | X   |
|                                   |                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   | T1C_erl_DNI    | FlagERLDNI    | −2 ≤ DNI ≤ 0.95 ⋅ ETN ⋅ Cos(SZA)^0.2+10    | All Data                                                 |     | X   |     |
+-----------------------------------|                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
| BSRN’s Physically Possible Limits |                                   | T1C_ppl_GHI    | FlagPPLGHI    | −4 ≤ GHI ≤ 1.5 ⋅ ETN ⋅ Cos(SZA)^1.2+100    | All Data                                                 | X   |     |     |
|                                   |                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   | T1C_ppl_DIF    | FlagPPLDIF    | −4 ≤ DIF ≤ 0.95 ⋅ ETN ⋅ Cos(SZA)^1.2+50    | All Data                                                 |     |     | X   |
|                                   |                                   +----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
|                                   |                                   | T1C_ppl_DNI    | FlagPPLDNI    | −4 ≤ DNI ≤ ETN                             | All Data                                                 |     | X   |     |
+-----------------------------------+-----------------------------------+----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
| Tracker-Off Test                  | Long And Shi 2008                 | Tracker_off    | FlagTracker   | DIF < 0.85*GHI                             | (GHI > 50 W/m2 And GHI > 0.85 * (0.8*ETN*cos(SZA)))      | X   |     | X   |
+-----------------------------------+-----------------------------------+----------------+---------------+--------------------------------------------+----------------------------------------------------------+-----+-----+-----+
```