# Introduction

This repository holds python code/tools to transform in-situ irradiation data to NetCDF and load / manipulate 
the result files locally or other the OpenDAP protocol.

# Installation 

This code is available as a PIP package :

    pip install libinsitu

# Documentation

The full documentation of Python & CLI API is available here :
https://libinsitu.readthedocs.io/en/latest/

# Resources 

* [The scientific paper explaining this work](https://hal.archives-ouvertes.fr/hal-03811628)
* [A proposed convention for NetCDF encoding of in-situ data](https://libinsitu.readthedocs.io/en/latest/conventions.html)
* [Our Thredss (TDS) server holding in-situ data of hundred of stations, encoded with this library](http://tds.webservice-energy.org/thredds/in-situ.html)
* [A web interface to explore this data, with map & time series](http://viewer.webservice-energy.org/in-situ/)


# Copyright & Licence

This library is copyrighted by [O.I.E center / Mines-Paristech](https://www.oie.minesparis.psl.eu/Accueil/). 

The code is distributed under the [BSD type 2 licence](LICENSE)


# Contact

For comment & discussions around this work, please join the mailing list [solar-insitu@groupes.mines-paristech.fr](https://groupes.minesparis.psl.eu/wws/info/solar-insitu)


