# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['aga', 'aga.gradescope', 'aga.gradescope.resources']

package_data = \
{'': ['*']}

install_requires = \
['dill>=0.3.4,<0.4.0',
 'gradescope-utils>=0.4.0,<0.5.0',
 'importlib-resources>=5.2.2,<6.0.0',
 'typer>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['aga = aga.cli:app']}

setup_kwargs = {
    'name': 'aga',
    'version': '0.3.0',
    'description': 'aga grades assignments',
    'long_description': '**aga** (aga grades assignments) is a tool for automatically checking the correctness of python code against known-correct solutions.\n\n# Usage\nIn `square.py` (or any file), write:\n\n```python\nfrom aga import problem, test_case\n\n\n@test_case(-3)\n@test_case(100)\n@test_case(2, aga_output=4)\n@test_case(-2, aga_output=4)\n@problem()\ndef square(x: int) -> int:\n    """Square x."""\n    return x * x\n```\n\nThen run `aga gen square` from the directory with `square.py`. This will generate a ZIP\nfile suitable for upload to gradescope.\n\nMore user-facing documentation is WIP.\n\n# Development\n\n## Setup\n\nTo set up the development environment:\n\n1. Clone the repo: `git clone git@github.com:nihilistkitten/aga.git && cd aga`.\n2. Install [poetry](https://python-poetry.org/docs/#installation).\n3. Install dependencies: `poetry install`.\n4. Install a [python3.6](https://www.python.org/downloads/) interpreter (I assume you already have the most recent `python`). This is necessary for testing against the Gradescope environment. While you can just download it from the above-linked website, I recommend [pyenv](https://github.com/pyenv/pyenv) for managing multiple python versions.\n5. Activate the development environment: `poetry shell`.\n\nI encourage you to set up integration between our dev tools and your editor, but it\'s not strictly necessary; you can use them as you please, from their CLIs or (I suppose) not at all. Regardless, the environment includes [python-lsp-server](https://github.com/python-lsp/python-lsp-server), which I personally use for this purpose, and can be used via `lsp-mode` in emacs, `atom-languageclient` in atom, or the built-in lsp support in neovim and vscode.\n\n## Nox\n\nThe tool [nox](https://nox.thea.codes/) runs tooling in virtualized environments, which is especially useful for running tests against python3.6 for Gradescope. To both run tests and lints, run `nox -r` (`-r` prevents nox from reinstalling the environments across multiple runs, which saves significant time.)\n\n## Testing\n\nTesting depends on [pytest](https://docs.pytest.org/). To run tests, simply run `pytest` from within the poetry shell. To run tests in python 3.9 and 3.6 via nox, run `nox -rs test`.\n\nCode coverage information can be generated by `pytest --cov`. This happens by default in nox runs.\n\n## Linting\n\nA number of static analysis tools are available in the development environment:\n\n- [mypy](http://mypy-lang.org/), a static type analysis tool.\n- [pylint](https://pylint.org/), a general-purpose linter.\n- [flake8](https://flake8.pycqa.org/en/latest/), a highly modular linter.\n  - [flake8-black](https://github.com/peterjc/flake8-black), a code formatting checker.\n  - [flake8-bugbear](https://github.com/PyCQA/flake8-bugbear), which makes `flake8` stricter.\n- [pydocstyle](http://www.pydocstyle.org/en/stable/), a documentation linter.\n\nThese tend to be quite strict, but after a while you\'ll get used to them, and they help write _much_ better code.\n\nTo run all lints across python 3.6 and 3.9, run `nox -rs lint`.\n\n## Formatting\n\nWe use two tools to enforce a uniform code style:\n\n- [black](https://github.com/psf/black), a highly opinionated code formatter.\n- [isort](https://github.com/PyCQA/isort), an import sorter.\n\nTo run both formatters, run `nox -rs fmt`. This is _not_ run by default runs of nox.\n',
    'author': 'Riley Shahar',
    'author_email': 'riley.shahar@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nihilistkitten/aga',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
