**aga** (aga grades assignments) is a tool for automatically checking the correctness of python code against known-correct solutions.

# Usage
In `square.py` (or any file), write:

```python
from aga import problem, test_case


@test_case(-3)
@test_case(100)
@test_case(2, aga_output=4)
@test_case(-2, aga_output=4)
@problem()
def square(x: int) -> int:
    """Square x."""
    return x * x
```

Then run `aga gen square` from the directory with `square.py`. This will generate a ZIP
file suitable for upload to gradescope.

More user-facing documentation is WIP.

# Development

## Setup

To set up the development environment:

1. Clone the repo: `git clone git@github.com:nihilistkitten/aga.git && cd aga`.
2. Install [poetry](https://python-poetry.org/docs/#installation).
3. Install dependencies: `poetry install`.
4. Install a [python3.6](https://www.python.org/downloads/) interpreter (I assume you already have the most recent `python`). This is necessary for testing against the Gradescope environment. While you can just download it from the above-linked website, I recommend [pyenv](https://github.com/pyenv/pyenv) for managing multiple python versions.
5. Activate the development environment: `poetry shell`.

I encourage you to set up integration between our dev tools and your editor, but it's not strictly necessary; you can use them as you please, from their CLIs or (I suppose) not at all. Regardless, the environment includes [python-lsp-server](https://github.com/python-lsp/python-lsp-server), which I personally use for this purpose, and can be used via `lsp-mode` in emacs, `atom-languageclient` in atom, or the built-in lsp support in neovim and vscode.

## Nox

The tool [nox](https://nox.thea.codes/) runs tooling in virtualized environments, which is especially useful for running tests against python3.6 for Gradescope. To both run tests and lints, run `nox -r` (`-r` prevents nox from reinstalling the environments across multiple runs, which saves significant time.)

## Testing

Testing depends on [pytest](https://docs.pytest.org/). To run tests, simply run `pytest` from within the poetry shell. To run tests in python 3.9 and 3.6 via nox, run `nox -rs test`.

Code coverage information can be generated by `pytest --cov`. This happens by default in nox runs.

## Linting

A number of static analysis tools are available in the development environment:

- [mypy](http://mypy-lang.org/), a static type analysis tool.
- [pylint](https://pylint.org/), a general-purpose linter.
- [flake8](https://flake8.pycqa.org/en/latest/), a highly modular linter.
  - [flake8-black](https://github.com/peterjc/flake8-black), a code formatting checker.
  - [flake8-bugbear](https://github.com/PyCQA/flake8-bugbear), which makes `flake8` stricter.
- [pydocstyle](http://www.pydocstyle.org/en/stable/), a documentation linter.

These tend to be quite strict, but after a while you'll get used to them, and they help write _much_ better code.

To run all lints across python 3.6 and 3.9, run `nox -rs lint`.

## Formatting

We use two tools to enforce a uniform code style:

- [black](https://github.com/psf/black), a highly opinionated code formatter.
- [isort](https://github.com/PyCQA/isort), an import sorter.

To run both formatters, run `nox -rs fmt`. This is _not_ run by default runs of nox.
