# Generated by Django 4.1.5 on 2023-01-23 01:21

import django.contrib.auth.models
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import smart_media.mixins
import smart_media.modelfields
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("taggit", "0005_auto_20220424_2025"),
    ]

    operations = [
        migrations.CreateModel(
            name="Author",
            fields=[],
            options={
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("auth.user", models.Model),
            managers=[
                ("objects", django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=[
                            ("en", "English"),
                            ("fr", "Français"),
                            ("de", "Deutsche"),
                        ],
                        db_index=True,
                        default="en",
                        max_length=8,
                        verbose_name="language",
                    ),
                ),
                (
                    "title",
                    models.CharField(default="", max_length=255, verbose_name="title"),
                ),
                ("slug", models.SlugField(max_length=255, verbose_name="slug")),
                (
                    "lead",
                    models.TextField(
                        blank=True,
                        help_text="Lead paragraph, commonly used for SEO purposes in page meta tags.",
                        verbose_name="lead",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, verbose_name="description"),
                ),
                (
                    "cover",
                    smart_media.modelfields.SmartMediaField(
                        blank=True,
                        default="",
                        max_length=255,
                        upload_to="lotus/category/cover/%y/%m",
                        verbose_name="cover image",
                    ),
                ),
                (
                    "original",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Mark this category as a translation of an original category.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="lotus.category",
                    ),
                ),
            ],
            options={
                "verbose_name": "Category",
                "verbose_name_plural": "Categories",
                "ordering": ["title"],
            },
            bases=(smart_media.mixins.SmartFormatMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Article",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=[
                            ("en", "English"),
                            ("fr", "Français"),
                            ("de", "Deutsche"),
                        ],
                        db_index=True,
                        default="en",
                        max_length=8,
                        verbose_name="language",
                    ),
                ),
                (
                    "status",
                    models.SmallIntegerField(
                        choices=[(0, "draft"), (10, "available")],
                        db_index=True,
                        default=0,
                        help_text="Publication status.",
                        verbose_name="status",
                    ),
                ),
                (
                    "featured",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="Mark this article as featured.",
                        verbose_name="featured",
                    ),
                ),
                (
                    "pinned",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="A pinned article is enforced at top of order results.",
                        verbose_name="pinned",
                    ),
                ),
                (
                    "private",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="Private article is only available for authenticated users.",
                        verbose_name="private",
                    ),
                ),
                (
                    "publish_date",
                    models.DateField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        help_text="Start date of publication.",
                        verbose_name="publication date",
                    ),
                ),
                (
                    "publish_time",
                    models.TimeField(
                        default=django.utils.timezone.now,
                        help_text="Start time of publication.",
                        verbose_name="publication time",
                    ),
                ),
                (
                    "publish_end",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="End date of publication.",
                        null=True,
                        verbose_name="publication end",
                    ),
                ),
                (
                    "last_update",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="last update"
                    ),
                ),
                (
                    "title",
                    models.CharField(default="", max_length=150, verbose_name="title"),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Used to build the article URL.",
                        max_length=255,
                        verbose_name="slug",
                    ),
                ),
                (
                    "seo_title",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="This value will be used as page meta title if not blank, else the article title is used.",
                        max_length=150,
                        verbose_name="SEO title",
                    ),
                ),
                (
                    "lead",
                    models.TextField(
                        blank=True,
                        help_text="Lead paragraph, commonly used for SEO purposes in page meta tags.",
                        verbose_name="lead",
                    ),
                ),
                (
                    "introduction",
                    models.TextField(blank=True, verbose_name="introduction"),
                ),
                (
                    "content",
                    models.TextField(blank=True, default="", verbose_name="content"),
                ),
                (
                    "cover",
                    smart_media.modelfields.SmartMediaField(
                        blank=True,
                        default="",
                        help_text="Article cover image.",
                        max_length=255,
                        upload_to="lotus/article/cover/%y/%m",
                        verbose_name="cover image",
                    ),
                ),
                (
                    "image",
                    smart_media.modelfields.SmartMediaField(
                        blank=True,
                        default="",
                        help_text="Article large image.",
                        max_length=255,
                        upload_to="lotus/article/image/%y/%m",
                        verbose_name="main image",
                    ),
                ),
                (
                    "authors",
                    models.ManyToManyField(
                        blank=True,
                        related_name="articles",
                        to="lotus.author",
                        verbose_name="authors",
                    ),
                ),
                (
                    "categories",
                    models.ManyToManyField(
                        blank=True,
                        related_name="articles",
                        to="lotus.category",
                        verbose_name="categories",
                    ),
                ),
                (
                    "original",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Mark this article as a translation of an original article.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="lotus.article",
                        verbose_name="original article",
                    ),
                ),
                (
                    "related",
                    models.ManyToManyField(
                        blank=True,
                        related_name="relations",
                        to="lotus.article",
                        verbose_name="related articles",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        blank=True,
                        help_text="A comma-separated list of tags.",
                        through="taggit.TaggedItem",
                        to="taggit.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={
                "verbose_name": "Article",
                "verbose_name_plural": "Articles",
                "ordering": ["-publish_date", "-publish_time", "title"],
            },
            bases=(smart_media.mixins.SmartFormatMixin, models.Model),
        ),
        migrations.AddConstraint(
            model_name="category",
            constraint=models.UniqueConstraint(
                fields=("slug", "language"), name="lotus_unique_cat_slug_lang"
            ),
        ),
        migrations.AddConstraint(
            model_name="category",
            constraint=models.UniqueConstraint(
                fields=("original", "language"), name="lotus_unique_cat_original_lang"
            ),
        ),
        migrations.AddConstraint(
            model_name="article",
            constraint=models.UniqueConstraint(
                fields=("publish_date", "slug", "language"),
                name="lotus_unique_art_pub_slug_lang",
            ),
        ),
        migrations.AddConstraint(
            model_name="article",
            constraint=models.UniqueConstraint(
                fields=("original", "language"), name="lotus_unique_art_original_lang"
            ),
        ),
    ]
