/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.FuncEntry;
import com.sas.rio.MVASQLException;
import com.sas.rio.MessageCode;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

@SASScope
final class ParsedQuery {
    private static final String WORK_LIBREF = "WORK";
    private static final String USER_LIBREF = "USER";
    private final String defaultLibref;
    final String libref;
    final String tableNm;
    final boolean isSelect;
    final boolean useGetTable;
    private final String rawQuery;
    private final String sasifiedQuery;
    private static final int d = 1;
    private static final int t = 2;
    private static final int ts = 3;
    private static final int fn = 4;
    private static final int oj = 5;
    private static final int escape = 6;
    static final List<String> MONTHS = Collections.unmodifiableList(Arrays.asList("", "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    private static final Hashtable<String, FuncEntry> sasfns = new Hashtable();
    private final int parameterCount;
    private static final HashMap<String, String> TS_INTERVALS = new HashMap();

    ParsedQuery(List<String> librefs, String query, int sasifyVersion) throws SQLException {
        if (query == null || query.length() == 0) {
            throw new MVASQLException(MessageCode.MVAStatement_invalidQuery, new Object[0]);
        }
        this.rawQuery = query;
        String libref = this.defaultLibref = librefs.contains(USER_LIBREF) ? USER_LIBREF : WORK_LIBREF;
        String tableNm = null;
        boolean isSelect = false;
        boolean useGetTable = true;
        StringTokenizer st = new StringTokenizer(query);
        int index = 0;
        while (st.hasMoreTokens() && useGetTable) {
            String s = st.nextToken();
            switch (index) {
                case 0: {
                    if (s.equalsIgnoreCase("select")) {
                        isSelect = true;
                        break;
                    }
                    useGetTable = false;
                    break;
                }
                case 1: {
                    if (s.equals("*")) break;
                    useGetTable = false;
                    break;
                }
                case 2: {
                    if (s.equalsIgnoreCase("from")) break;
                    useGetTable = false;
                    break;
                }
                case 3: {
                    StringTokenizer poo = new StringTokenizer(s, ".");
                    while (poo.countTokens() > 2) {
                        poo.nextToken();
                    }
                    if (poo.countTokens() == 1) {
                        tableNm = poo.nextToken();
                        break;
                    }
                    libref = poo.nextToken();
                    tableNm = poo.nextToken();
                    break;
                }
                default: {
                    useGetTable = false;
                }
            }
            ++index;
        }
        if (tableNm != null && tableNm.charAt(tableNm.length() - 1) == ';') {
            tableNm = tableNm.substring(0, tableNm.length() - 1);
        }
        this.libref = libref;
        this.tableNm = tableNm;
        this.isSelect = isSelect;
        this.useGetTable = useGetTable;
        this.sasifiedQuery = ParsedQuery.sasify(query, sasifyVersion);
        int pCount = 0;
        int inquotes = -1;
        int length = this.sasifiedQuery.length();
        for (int b = 0; b < length; ++b) {
            if (this.sasifiedQuery.charAt(b) == '\'' || this.sasifiedQuery.charAt(b) == '\"') {
                if (inquotes == -1) {
                    inquotes = this.sasifiedQuery.charAt(b);
                } else if (inquotes == this.sasifiedQuery.charAt(b)) {
                    inquotes = -1;
                }
            }
            if (this.sasifiedQuery.charAt(b) != '?' || inquotes != -1) continue;
            ++pCount;
        }
        this.parameterCount = pCount;
    }

    @Nonnull
    public String getRawQuery() {
        return this.rawQuery;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    static String sasify(String stmt, int sasifyVersion) throws SQLException {
        switch (sasifyVersion) {
            case 1: {
                return ParsedQuery.sasifyV91(stmt);
            }
            case 2: {
                return ParsedQuery.sasifyNone(stmt);
            }
        }
        return ParsedQuery.sasifyDefault(stmt);
    }

    public String getSasifiedQuery() {
        return this.sasifiedQuery;
    }

    boolean queryReturnsResultSet() {
        String temp = this.sasifiedQuery.toUpperCase().trim();
        return temp.indexOf("SELECT") == 0;
    }

    static int findLastString(String stmt, String token) {
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int tlen = token.length() - 1;
        for (int curoffset = stmt.length() - 1; curoffset >= 0; --curoffset) {
            int j;
            if (stmt.charAt(curoffset) == '\'') {
                singleQuote = !singleQuote;
            }
            if (stmt.charAt(curoffset) == '\"') {
                doubleQuote = !doubleQuote;
            }
            if (singleQuote || doubleQuote || stmt.charAt(curoffset) != token.charAt(tlen)) continue;
            for (j = 1; j < tlen; ++j) {
                if (curoffset - j < 0) {
                    return -1;
                }
                if (stmt.charAt(curoffset - j) != token.charAt(tlen - j)) break;
            }
            if (j < tlen) continue;
            return curoffset - tlen;
        }
        return -1;
    }

    @SASScope
    protected static int findFirstString(String stmt, String token, int offset) {
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int len = stmt.length();
        int tlen = token.length() - 1;
        for (int curoffset = offset; curoffset < len; ++curoffset) {
            int j;
            if (stmt.charAt(curoffset) == '\'') {
                singleQuote = !singleQuote;
            }
            if (stmt.charAt(curoffset) == '\"') {
                doubleQuote = !doubleQuote;
            }
            if (singleQuote || doubleQuote || stmt.charAt(curoffset) != token.charAt(0)) continue;
            for (j = 1; j <= tlen; ++j) {
                if (curoffset + j > len - 1) {
                    return -1;
                }
                if (stmt.charAt(curoffset + j) != token.charAt(j)) break;
            }
            if (j < tlen) continue;
            return curoffset;
        }
        return -1;
    }

    static String sasifyV91(String stmt) throws SQLException {
        int i;
        int l;
        Integer temp = 0;
        int monthIndex = 0;
        String sub1 = "";
        String sub2 = "";
        String sub3 = "";
        String temps = "";
        int b = 0;
        int c = 0;
        int e = 0;
        int type = 0;
        stmt = stmt.trim();
        block21: while ((l = ParsedQuery.findLastString(stmt, "{")) > 0) {
            int nested = 0;
            i = 0;
            char c2 = '\uffffffff';
            b = l;
            int endloc = ParsedQuery.findFirstString(stmt, "}", b);
            if (endloc == -1) {
                throw new MVASQLException(MessageCode.MVAStatement_malformedStatement, new Object[0]);
            }
            e = endloc;
            sub1 = stmt.substring(0, b);
            sub1 = sub1.trim();
            sub2 = stmt.substring(b + 1, e);
            sub2 = sub2.trim();
            if (e + 1 < stmt.length()) {
                sub3 = stmt.substring(e + 1);
                sub3 = sub3.trim();
            } else {
                sub3 = "";
            }
            temps = sub2.toLowerCase();
            type = 0;
            if (temps.charAt(0) == 't' && temps.charAt(1) == 's') {
                type = 3;
            }
            if (temps.charAt(0) == 'f' && temps.charAt(1) == 'n') {
                type = 4;
            }
            if (temps.charAt(0) == 't' && temps.charAt(1) != 's') {
                type = 2;
            }
            if (temps.charAt(0) == 'd') {
                type = 1;
            }
            if (temps.charAt(0) == 'o' && temps.charAt(1) == 'j') {
                type = 5;
            }
            if (temps.startsWith("escape ", 0)) {
                type = 6;
            }
            switch (type) {
                case 2: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 10) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTime, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(9) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTime, new Object[0]);
                    }
                    stmt = sub1 + " " + sub2.substring(0) + "t " + sub3;
                    continue block21;
                }
                case 1: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(11) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    temp = new Integer(sub2.substring(6, 8));
                    monthIndex = temp;
                    if (monthIndex < 1 || monthIndex > 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + MONTHS.get(monthIndex) + sub2.substring(1, 5) + "'d " + sub3;
                    continue block21;
                }
                case 3: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    if (sub2.length() < 21) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    int k = sub2.indexOf(39, 1);
                    if (k < 20) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    temp = new Integer(sub2.substring(6, 8));
                    monthIndex = temp;
                    if (monthIndex < 1 || monthIndex > 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + MONTHS.get(monthIndex) + sub2.substring(1, 5) + ":" + sub2.substring(12) + "dt " + sub3;
                    continue block21;
                }
                case 5: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    temps = sub2.toUpperCase();
                    b = ParsedQuery.findFirstString(temps, "OUTER", 0);
                    if (b == -1) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedOuterJoin, new Object[0]);
                    }
                    stmt = sub1 + " " + sub2.substring(0, b) + sub2.substring(b + 5) + " " + sub3;
                    continue block21;
                }
                case 6: {
                    b = sub2.indexOf(39);
                    if (b == -1 || sub2.length() < b + 2 || sub2.charAt(b + 2) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedEscape, new Object[0]);
                    }
                    char escapeChar = sub2.charAt(b + 1);
                    temps = sub1 + " " + sub3;
                    String newStmt = "";
                    int length = temps.length();
                    int curEscape = -2;
                    c2 = '\uffffffff';
                    for (i = 0; i < length; ++i) {
                        if (temps.charAt(i) == '\'' || temps.charAt(i) == '\"') {
                            if (c2 == '\uffffffff') {
                                c2 = temps.charAt(i);
                            } else if (c2 == temps.charAt(i)) {
                                c2 = '\uffffffff';
                            }
                        }
                        if (c2 != '\uffffffff' && temps.charAt(i) == escapeChar && i != curEscape + 1) {
                            curEscape = i;
                            continue;
                        }
                        newStmt = newStmt + temps.charAt(i);
                    }
                    stmt = newStmt.trim();
                    continue block21;
                }
                case 4: {
                    int length;
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    b = ParsedQuery.findFirstString(sub2, "(", 0);
                    if (b == -1) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                    }
                    temps = sub2.substring(0, b);
                    FuncEntry tempfunc = sasfns.get(temps = temps.toUpperCase());
                    if (tempfunc == null || tempfunc.sasFn == null) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                    }
                    sub2 = tempfunc.sasFn + sub2.substring(b);
                    if (tempfunc.specialHandling != 0) {
                        switch (tempfunc.specialHandling) {
                            case 1: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedConcatFunction, new Object[0]);
                                }
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = b + 1; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                String temp1 = sub2.substring(b + 1, c) + " || ";
                                b = ParsedQuery.findLastString(sub2.substring(c + 1), ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedConcatFunction, new Object[0]);
                                }
                                b = ParsedQuery.findLastString(sub2, ")");
                                String temp2 = sub2.substring(c + 1, b);
                                if (temp2.equals("")) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedConcatFunction, new Object[0]);
                                }
                                sub2 = temp1 + temp2;
                                break;
                            }
                            case 2: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedLeftFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + ",1" + sub2.substring(c);
                                break;
                            }
                            case 3: {
                                sub2 = sub2 + ")";
                                break;
                            }
                            case 4: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ')' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedRepeatFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + "-1" + sub2.substring(c);
                                break;
                            }
                            case 5: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedSpaceFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b + 1) + "' ',(" + sub2.substring(b + 1) + "-1)";
                                break;
                            }
                            case 6: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -2;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedPowerFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + ")**(" + sub2.substring(c + 1) + ")";
                                break;
                            }
                            case 7: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                c = ParsedQuery.findLastString(sub2, ")");
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                if (c - b != 1) break;
                                sub2 = sub2.substring(0, b + 1) + "0" + sub2.substring(b + 1);
                                break;
                            }
                            case 8: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedRoundFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c + 1) + "10**-(" + sub2.substring(c + 1) + ")";
                                break;
                            }
                            case 9: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedDayNameFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b) + ", DowName.)" + sub2.substring(b);
                                break;
                            }
                            case 10: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedDayOfYearFunction, new Object[0]);
                                }
                                sub2 = sub2 + ", 1000)";
                                break;
                            }
                            case 11: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedChangeMonthName, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b) + ", MonName.)" + sub2.substring(b);
                                break;
                            }
                            default: {
                                throw new MVASQLException(MessageCode.MVAStatement_undefinedFunction, new Object[0]);
                            }
                        }
                    }
                    stmt = sub1 + " " + sub2 + " " + sub3;
                    stmt = stmt.trim();
                    continue block21;
                }
            }
            return stmt;
        }
        boolean scanStmt = false;
        temps = stmt.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(temps, " ");
        if (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("CREATE") && stringTokenizer.hasMoreTokens()) {
                token = stringTokenizer.nextToken();
                if (token.equals("TABLE")) {
                    scanStmt = true;
                }
            } else if (token.equals("ALTER") && stringTokenizer.hasMoreTokens() && (token = stringTokenizer.nextToken()).equals("TABLE")) {
                while (stringTokenizer.hasMoreTokens()) {
                    token = stringTokenizer.nextToken();
                    if (!token.equals("ADD") && !token.equals("MODIFY") || !stringTokenizer.hasMoreTokens()) continue;
                    scanStmt = true;
                    token = stringTokenizer.nextToken();
                    if (!token.equals("COLUMN")) continue;
                }
            }
        }
        b = 0;
        i = 0;
        c = -1;
        boolean state = false;
        int dots = 0;
        int dot1 = 0;
        int inquotes = -1;
        int edge = 0;
        if (stmt.indexOf(".") != -1) {
            String tempStmt;
            while ((i = stmt.indexOf(" .", i)) != -1) {
                int dotidx = stmt.indexOf(".", i);
                if (dotidx + 1 >= stmt.length() || stmt.charAt(dotidx + 1) == ' ') {
                    ++i;
                    continue;
                }
                tempStmt = stmt;
                stmt = tempStmt.substring(0, i) + tempStmt.substring(i + 1);
            }
            int curChar = 32;
            for (i = 0; i < stmt.length(); ++i) {
                curChar = stmt.charAt(i);
                if (curChar == 39 || curChar == 34) {
                    if (inquotes == -1) {
                        inquotes = curChar;
                    } else if (inquotes == curChar) {
                        inquotes = -1;
                    }
                }
                if ((Character.isLetterOrDigit((char)curChar) || curChar == 95 || curChar == 46) && inquotes == -1) {
                    if (!state) {
                        dots = 0;
                        edge = i;
                        state = true;
                        continue;
                    }
                    if (curChar != 46 || ++dots != 1) continue;
                    dot1 = i;
                    continue;
                }
                if (!state) continue;
                if (dots > 1) {
                    tempStmt = stmt;
                    stmt = tempStmt.substring(0, edge) + tempStmt.substring(dot1 + 1);
                    state = false;
                    i = 0;
                    continue;
                }
                state = false;
            }
            if (state && dots > 1) {
                tempStmt = stmt;
                stmt = tempStmt.substring(0, edge) + tempStmt.substring(dot1 + 1);
                state = false;
                i = 0;
            }
        }
        if (!scanStmt) {
            return stmt;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "INTEGER", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "integer", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 7 && (Character.isWhitespace(stmt.charAt(b + 7)) || stmt.charAt(b + 7) == ',' || stmt.charAt(b + 7) == ')')) {
                stmt = stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 7);
                b += 7;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 7) {
                stmt = stmt.substring(0, b) + " num format=11.0 ";
                b += 7;
                continue;
            }
            b += 7;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "LONG", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "long", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=11.0 ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "TIME", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "time", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=time8. " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=time8. ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "DATE", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "date", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=date9. " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=date9. ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "TIMESTAMP", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "timestamp", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 9 && (Character.isWhitespace(stmt.charAt(b + 9)) || stmt.charAt(b + 9) == ',' || stmt.charAt(b + 9) == ')')) {
                stmt = stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 9);
                b += 9;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 9) {
                stmt = stmt.substring(0, b) + " num format=datetime19. ";
                b += 9;
                continue;
            }
            b += 9;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "DATETIME", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "datetime", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 8 && (Character.isWhitespace(stmt.charAt(b + 8)) || stmt.charAt(b + 8) == ',' || stmt.charAt(b + 8) == ')')) {
                stmt = stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 8);
                b += 8;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 8) {
                stmt = stmt.substring(0, b) + " num format=datetime19. ";
                b += 8;
                continue;
            }
            b += 8;
        }
        return stmt;
    }

    static String sasifyNone(String stmt) throws SQLException {
        int i;
        int l;
        String sub1 = "";
        String sub2 = "";
        String sub3 = "";
        String temps = "";
        int b = 0;
        int c = 0;
        int e = 0;
        int type = 0;
        stmt = stmt.trim();
        block21: while ((l = ParsedQuery.findLastString(stmt, "{")) > 0) {
            int nested = 0;
            i = 0;
            char c2 = '\uffffffff';
            b = l;
            int endloc = ParsedQuery.findFirstString(stmt, "}", b);
            if (endloc == -1) {
                throw new MVASQLException(MessageCode.MVAStatement_malformedStatement, new Object[0]);
            }
            e = endloc;
            sub1 = stmt.substring(0, b);
            sub1 = sub1.trim();
            sub2 = stmt.substring(b + 1, e);
            sub2 = sub2.trim();
            if (e + 1 < stmt.length()) {
                sub3 = stmt.substring(e + 1);
                sub3 = sub3.trim();
            } else {
                sub3 = "";
            }
            temps = sub2.toLowerCase();
            type = 0;
            if (temps.charAt(0) == 't' && temps.charAt(1) == 's') {
                type = 3;
            }
            if (temps.charAt(0) == 'f' && temps.charAt(1) == 'n') {
                type = 4;
            }
            if (temps.charAt(0) == 't' && temps.charAt(1) != 's') {
                type = 2;
            }
            if (temps.charAt(0) == 'd') {
                type = 1;
            }
            if (temps.charAt(0) == 'o' && temps.charAt(1) == 'j') {
                type = 5;
            }
            if (temps.startsWith("escape ", 0)) {
                type = 6;
            }
            int monthIndex = 0;
            switch (type) {
                case 2: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 10) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTime, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(9) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTime, new Object[0]);
                    }
                    stmt = sub1 + " " + sub2.substring(0) + "t " + sub3;
                    continue block21;
                }
                case 1: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(11) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    monthIndex = Integer.valueOf(sub2.substring(6, 8));
                    if (monthIndex < 1 || monthIndex > 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + MONTHS.get(monthIndex) + sub2.substring(1, 5) + "'d " + sub3;
                    continue block21;
                }
                case 3: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    if (sub2.length() < 21) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    int k = sub2.indexOf(39, 1);
                    if (k < 20) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    monthIndex = Integer.valueOf(sub2.substring(6, 8));
                    if (monthIndex < 1 || monthIndex > 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + MONTHS.get(monthIndex) + sub2.substring(1, 5) + ":" + sub2.substring(12) + "dt " + sub3;
                    continue block21;
                }
                case 5: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    temps = sub2.toUpperCase();
                    b = ParsedQuery.findFirstString(temps, "OUTER", 0);
                    if (b == -1) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedOuterJoin, new Object[0]);
                    }
                    stmt = sub1 + " " + sub2.substring(0, b) + sub2.substring(b + 5) + " " + sub3;
                    continue block21;
                }
                case 6: {
                    b = sub2.indexOf(39);
                    if (b == -1 || sub2.length() < b + 2 || sub2.charAt(b + 2) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedEscape, new Object[0]);
                    }
                    char escapeChar = sub2.charAt(b + 1);
                    temps = sub1 + " " + sub3;
                    String newStmt = "";
                    int length = temps.length();
                    int curEscape = -2;
                    c2 = '\uffffffff';
                    for (i = 0; i < length; ++i) {
                        if (temps.charAt(i) == '\'' || temps.charAt(i) == '\"') {
                            if (c2 == '\uffffffff') {
                                c2 = temps.charAt(i);
                            } else if (c2 == temps.charAt(i)) {
                                c2 = '\uffffffff';
                            }
                        }
                        if (c2 != '\uffffffff' && temps.charAt(i) == escapeChar && i != curEscape + 1) {
                            curEscape = i;
                            continue;
                        }
                        newStmt = newStmt + temps.charAt(i);
                    }
                    stmt = newStmt.trim();
                    continue block21;
                }
                case 4: {
                    int length;
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    b = ParsedQuery.findFirstString(sub2, "(", 0);
                    if (b == -1) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                    }
                    temps = sub2.substring(0, b);
                    FuncEntry tempfunc = sasfns.get(temps = temps.toUpperCase());
                    if (tempfunc == null || tempfunc.sasFn == null) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                    }
                    sub2 = tempfunc.sasFn + sub2.substring(b);
                    if (tempfunc.specialHandling != 0) {
                        switch (tempfunc.specialHandling) {
                            case 1: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedConcatFunction, new Object[0]);
                                }
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = b + 1; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                String temp1 = sub2.substring(b + 1, c) + " || ";
                                b = ParsedQuery.findLastString(sub2.substring(c + 1), ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedConcatFunction, new Object[0]);
                                }
                                b = ParsedQuery.findLastString(sub2, ")");
                                String temp2 = sub2.substring(c + 1, b);
                                if (temp2.equals("")) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedConcatFunction, new Object[0]);
                                }
                                sub2 = temp1 + temp2;
                                break;
                            }
                            case 2: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedLeftFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + ",1" + sub2.substring(c);
                                break;
                            }
                            case 3: {
                                sub2 = sub2 + ")";
                                break;
                            }
                            case 4: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ')' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedRepeatFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + "-1" + sub2.substring(c);
                                break;
                            }
                            case 5: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedSpaceFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b + 1) + "' ',(" + sub2.substring(b + 1) + "-1)";
                                break;
                            }
                            case 6: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -2;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedPowerFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + ")**(" + sub2.substring(c + 1) + ")";
                                break;
                            }
                            case 7: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                c = ParsedQuery.findLastString(sub2, ")");
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                if (c - b != 1) break;
                                sub2 = sub2.substring(0, b + 1) + "0" + sub2.substring(b + 1);
                                break;
                            }
                            case 8: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedRoundFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c + 1) + "10**-(" + sub2.substring(c + 1) + ")";
                                break;
                            }
                            case 9: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedDayNameFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b) + ", DowName.)" + sub2.substring(b);
                                break;
                            }
                            case 10: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedDayOfYearFunction, new Object[0]);
                                }
                                sub2 = sub2 + ", 1000)";
                                break;
                            }
                            case 11: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedChangeMonthName, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b) + ", MonName.)" + sub2.substring(b);
                                break;
                            }
                            default: {
                                throw new MVASQLException(MessageCode.MVAStatement_undefinedFunction, new Object[0]);
                            }
                        }
                    }
                    stmt = sub1 + " " + sub2 + " " + sub3;
                    stmt = stmt.trim();
                    continue block21;
                }
            }
            return stmt;
        }
        boolean scanStmt = false;
        temps = stmt.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(temps, " ");
        if (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("CREATE") && stringTokenizer.hasMoreTokens()) {
                token = stringTokenizer.nextToken();
                if (token.equals("TABLE")) {
                    scanStmt = true;
                }
            } else if (token.equals("ALTER") && stringTokenizer.hasMoreTokens() && (token = stringTokenizer.nextToken()).equals("TABLE")) {
                while (stringTokenizer.hasMoreTokens()) {
                    token = stringTokenizer.nextToken();
                    if (!token.equals("ADD") && !token.equals("MODIFY") || !stringTokenizer.hasMoreTokens()) continue;
                    scanStmt = true;
                    token = stringTokenizer.nextToken();
                    if (!token.equals("COLUMN")) continue;
                }
            }
        }
        if (!scanStmt) {
            return stmt;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "INTEGER", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "integer", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 7 && (Character.isWhitespace(stmt.charAt(b + 7)) || stmt.charAt(b + 7) == ',' || stmt.charAt(b + 7) == ')')) {
                stmt = stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 7);
                b += 7;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 7) {
                stmt = stmt.substring(0, b) + " num format=11.0 ";
                b += 7;
                continue;
            }
            b += 7;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "LONG", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "long", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=11.0 ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "TIME", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "time", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=time8. " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=time8. ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "DATE", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "date", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=date9. " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=date9. ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "TIMESTAMP", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "timestamp", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 9 && (Character.isWhitespace(stmt.charAt(b + 9)) || stmt.charAt(b + 9) == ',' || stmt.charAt(b + 9) == ')')) {
                stmt = stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 9);
                b += 9;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 9) {
                stmt = stmt.substring(0, b) + " num format=datetime19. ";
                b += 9;
                continue;
            }
            b += 9;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "DATETIME", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "datetime", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 8 && (Character.isWhitespace(stmt.charAt(b + 8)) || stmt.charAt(b + 8) == ',' || stmt.charAt(b + 8) == ')')) {
                stmt = stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 8);
                b += 8;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 8) {
                stmt = stmt.substring(0, b) + " num format=datetime19. ";
                b += 8;
                continue;
            }
            b += 8;
        }
        return stmt;
    }

    static String sasifyDefault(String stmt) throws SQLException {
        int i;
        int l;
        Integer temp = 0;
        int monthIndex = 0;
        String sub1 = "";
        String sub2 = "";
        String sub3 = "";
        String temps = "";
        int b = 0;
        int c = 0;
        int e = 0;
        int type = 0;
        stmt = stmt.trim();
        block30: while ((l = ParsedQuery.findLastString(stmt, "{")) > 0) {
            int nested = 0;
            i = 0;
            char c2 = '\uffffffff';
            b = l;
            int endloc = ParsedQuery.findFirstString(stmt, "}", b);
            if (endloc == -1) {
                throw new MVASQLException(MessageCode.MVAStatement_malformedStatement, new Object[0]);
            }
            e = endloc;
            sub1 = stmt.substring(0, b);
            sub1 = sub1.trim();
            sub2 = stmt.substring(b + 1, e);
            sub2 = sub2.trim();
            if (e + 1 < stmt.length()) {
                sub3 = stmt.substring(e + 1);
                sub3 = sub3.trim();
            } else {
                sub3 = "";
            }
            temps = sub2.toLowerCase();
            type = 0;
            if (temps.length() >= 2) {
                if (temps.charAt(0) == 't' && temps.charAt(1) == 's') {
                    type = 3;
                }
                if (temps.charAt(0) == 'f' && temps.charAt(1) == 'n') {
                    type = 4;
                }
                if (temps.charAt(0) == 't' && temps.charAt(1) != 's') {
                    type = 2;
                }
                if (temps.charAt(0) == 'd') {
                    type = 1;
                }
                if (temps.charAt(0) == 'o' && temps.charAt(1) == 'j') {
                    type = 5;
                }
                if (temps.startsWith("escape ", 0)) {
                    type = 6;
                }
            }
            switch (type) {
                case 2: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 10) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTime, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(9) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTime, new Object[0]);
                    }
                    stmt = sub1 + " " + sub2.substring(0) + "t " + sub3;
                    continue block30;
                }
                case 1: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(11) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    temp = new Integer(sub2.substring(6, 8));
                    monthIndex = temp;
                    if (monthIndex < 1 || monthIndex > 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedDate, new Object[0]);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + MONTHS.get(monthIndex) + sub2.substring(1, 5) + "'d " + sub3;
                    continue block30;
                }
                case 3: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    if (sub2.length() < 21) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    if (sub2.charAt(0) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    int k = sub2.indexOf(39, 1);
                    if (k < 20) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    temp = new Integer(sub2.substring(6, 8));
                    monthIndex = temp;
                    if (monthIndex < 1 || monthIndex > 12) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedTimeStamp, new Object[0]);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + MONTHS.get(monthIndex) + sub2.substring(1, 5) + ":" + sub2.substring(12) + "dt " + sub3;
                    continue block30;
                }
                case 5: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    temps = sub2.toUpperCase();
                    b = ParsedQuery.findFirstString(temps, "OUTER", 0);
                    if (b == -1) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedOuterJoin, new Object[0]);
                    }
                    stmt = sub1 + " " + sub2.substring(0, b) + sub2.substring(b + 5) + " " + sub3;
                    continue block30;
                }
                case 6: {
                    b = sub2.indexOf(39);
                    if (b == -1 || sub2.length() < b + 2 || sub2.charAt(b + 2) != '\'') {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedEscape, new Object[0]);
                    }
                    char escapeChar = sub2.charAt(b + 1);
                    temps = sub1 + " " + sub3;
                    String newStmt = "";
                    int length = temps.length();
                    int curEscape = -2;
                    c2 = '\uffffffff';
                    for (i = 0; i < length; ++i) {
                        if (temps.charAt(i) == '\'' || temps.charAt(i) == '\"') {
                            if (c2 == '\uffffffff') {
                                c2 = temps.charAt(i);
                            } else if (c2 == temps.charAt(i)) {
                                c2 = '\uffffffff';
                            }
                        }
                        if (c2 != '\uffffffff' && temps.charAt(i) == escapeChar && i != curEscape + 1) {
                            curEscape = i;
                            continue;
                        }
                        newStmt = newStmt + temps.charAt(i);
                    }
                    stmt = newStmt.trim();
                    continue block30;
                }
                case 4: {
                    int length;
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    b = ParsedQuery.findFirstString(sub2, "(", 0);
                    if (b == -1) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                    }
                    temps = sub2.substring(0, b);
                    FuncEntry tempfunc = sasfns.get(temps = temps.toUpperCase());
                    if (tempfunc == null || tempfunc.sasFn == null) {
                        throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                    }
                    sub2 = tempfunc.sasFn + sub2.substring(b);
                    if (tempfunc.specialHandling != 0) {
                        switch (tempfunc.specialHandling) {
                            case 12: {
                                sub2 = "CONSTANT ('PI')";
                                break;
                            }
                            case 13: {
                                sub2 = "\"&sysuserid.\"";
                                break;
                            }
                            case 14: {
                                sub2 = sub2.substring(0, sub2.length() - 1) + ", 'v')";
                                break;
                            }
                            case 15: {
                                String parameter1 = sub2.substring(sub2.indexOf("(") + 1, sub2.indexOf(","));
                                String parameter2 = sub2.substring(sub2.indexOf(",") + 1, sub2.indexOf(")"));
                                sub2 = "SUBSTR(" + parameter1 + ", length(" + parameter1 + ") + 1 -" + parameter2 + ")";
                                break;
                            }
                            case 20: {
                                List<String> params = Arrays.asList(sub2.replaceAll("[\\(\\)]", "").split("\\s*,\\s*"));
                                sub2 = "FIND(" + params.get(1) + ", " + params.get(0);
                                if (sub2.length() == 3) {
                                    sub2 = sub2 + ", " + params.get(2);
                                }
                                sub2 = sub2 + ")";
                                break;
                            }
                            case 16: {
                                sub2 = sub2.substring(0, sub2.length() - 1) + "*180.0 / CONSTANT('PI'))";
                                break;
                            }
                            case 17: {
                                sub2 = sub2.substring(0, sub2.length() - 1) + "*CONSTANT('PI') / 180.0)";
                                break;
                            }
                            case 18: {
                                List<String> params = Arrays.asList(sub2.replaceAll("[\\(\\)]", "").split("\\s*,\\s*"));
                                String sasInterval = TS_INTERVALS.get(params.get(0));
                                if (sasInterval == null) {
                                    throw new SQLException("unknown or unsupported interval " + params.get(0));
                                }
                                sub2 = "INTNX('" + sasInterval + "', " + params.get(2) + ", " + params.get(1) + ", 'SAME') format=datetime19.2";
                                break;
                            }
                            case 19: {
                                List<String> params = Arrays.asList(sub2.replaceAll("[\\(\\)]", "").split("\\s*,\\s*"));
                                String sasInterval = TS_INTERVALS.get(params.get(0));
                                if (sasInterval == null) {
                                    throw new SQLException("unknown or unsupported interval " + params.get(0));
                                }
                                sub2 = "INTCK('" + sasInterval + "', " + params.get(1) + ", " + params.get(2) + ", 'C')";
                                break;
                            }
                            case 1: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = b + 1; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                String temp1 = sub2.substring(b + 1, c) + " || ";
                                b = ParsedQuery.findLastString(sub2.substring(c + 1), ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                b = ParsedQuery.findLastString(sub2, ")");
                                String temp2 = sub2.substring(c + 1, b);
                                if (temp2.equals("")) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                sub2 = temp1 + temp2;
                                break;
                            }
                            case 2: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedLeftFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + ",1" + sub2.substring(c);
                                break;
                            }
                            case 3: {
                                sub2 = sub2 + ")";
                                break;
                            }
                            case 4: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ')' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedRepeatFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + "-1" + sub2.substring(c);
                                break;
                            }
                            case 5: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedSpaceFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b + 1) + "' ',(" + sub2.substring(b + 1) + "-1)";
                                break;
                            }
                            case 6: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -2;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedPowerFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c) + ")**(" + sub2.substring(c + 1) + ")";
                                break;
                            }
                            case 7: {
                                b = ParsedQuery.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                c = ParsedQuery.findLastString(sub2, ")");
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedFunction, new Object[0]);
                                }
                                if (c - b != 1) break;
                                sub2 = sub2.substring(0, b + 1) + "0" + sub2.substring(b + 1);
                                break;
                            }
                            case 8: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedRoundFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, c + 1) + "10**-(" + sub2.substring(c + 1) + ")";
                                break;
                            }
                            case 9: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedDayNameFunction, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b) + ", DowName.)" + sub2.substring(b);
                                break;
                            }
                            case 10: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedDayOfYearFunction, new Object[0]);
                                }
                                sub2 = sub2 + ", 1000)";
                                break;
                            }
                            case 11: {
                                b = ParsedQuery.findLastString(sub2, ")");
                                if (b == -1) {
                                    throw new MVASQLException(MessageCode.MVAStatement_malformedChangeMonthName, new Object[0]);
                                }
                                sub2 = sub2.substring(0, b) + ", MonName.)" + sub2.substring(b);
                                break;
                            }
                            default: {
                                throw new MVASQLException(MessageCode.MVAStatement_undefinedFunction, new Object[0]);
                            }
                        }
                    }
                    stmt = sub1 + " " + sub2 + " " + sub3;
                    stmt = stmt.trim();
                    continue block30;
                }
            }
            return stmt;
        }
        boolean scanStmt = false;
        temps = stmt.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(temps, " ");
        if (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("CREATE") && stringTokenizer.hasMoreTokens()) {
                token = stringTokenizer.nextToken();
                if (token.equals("TABLE")) {
                    scanStmt = true;
                }
            } else if (token.equals("ALTER") && stringTokenizer.hasMoreTokens() && (token = stringTokenizer.nextToken()).equals("TABLE")) {
                while (stringTokenizer.hasMoreTokens()) {
                    token = stringTokenizer.nextToken();
                    if (!token.equals("ADD") && !token.equals("MODIFY") || !stringTokenizer.hasMoreTokens()) continue;
                    scanStmt = true;
                    token = stringTokenizer.nextToken();
                    if (!token.equals("COLUMN")) continue;
                }
            }
        }
        b = 0;
        i = 0;
        c = -1;
        boolean state = false;
        int dots = 0;
        int dot1 = 0;
        int inquotes = -1;
        int edge = 0;
        if (stmt.indexOf(".") != -1) {
            String tempStmt;
            StringTokenizer sqlParse = new StringTokenizer(stmt, "'\"", true);
            StringBuffer mungedStmt = new StringBuffer();
            boolean quoted = false;
            boolean isSingle = false;
            while (sqlParse.hasMoreTokens()) {
                String x = sqlParse.nextToken();
                if (x.equals("'") || x.equals("\"")) {
                    if (!quoted) {
                        if (x.equals("'")) {
                            isSingle = true;
                            quoted = true;
                        } else {
                            quoted = true;
                        }
                    } else if (isSingle) {
                        if (x.equals("'")) {
                            isSingle = false;
                            quoted = false;
                        }
                    } else if (x.equals("\"")) {
                        quoted = false;
                    }
                }
                i = 0;
                if (!quoted) {
                    while ((i = x.indexOf(" .", i)) != -1) {
                        int dotidx = x.indexOf(".", i);
                        if (dotidx + 1 >= x.length() || x.charAt(dotidx + 1) == ' ' || x.charAt(dotidx + 1) == '\n' || x.charAt(dotidx + 1) == '\t' || x.charAt(dotidx + 1) == '\f' || x.charAt(dotidx + 1) == '\r' || x.charAt(dotidx + 1) == ')' || x.charAt(dotidx + 1) == ',') {
                            ++i;
                            continue;
                        }
                        tempStmt = x;
                        x = tempStmt.substring(0, i) + tempStmt.substring(i + 1);
                    }
                }
                mungedStmt.append(x);
            }
            if (mungedStmt.length() > 0) {
                stmt = mungedStmt.toString();
            }
            int curChar = 32;
            for (i = 0; i < stmt.length(); ++i) {
                curChar = stmt.charAt(i);
                if (curChar == 39 || curChar == 34) {
                    if (inquotes == -1) {
                        inquotes = curChar;
                    } else if (inquotes == curChar) {
                        inquotes = -1;
                    }
                }
                if ((Character.isLetterOrDigit((char)curChar) || curChar == 95 || curChar == 46) && inquotes == -1) {
                    if (!state) {
                        dots = 0;
                        edge = i;
                        state = true;
                        continue;
                    }
                    if (curChar != 46 || ++dots != 1) continue;
                    dot1 = i;
                    continue;
                }
                if (!state) continue;
                if (dots > 1) {
                    tempStmt = stmt;
                    stmt = tempStmt.substring(0, edge) + tempStmt.substring(dot1 + 1);
                    state = false;
                    i = 0;
                    continue;
                }
                state = false;
            }
            if (state && dots > 1) {
                tempStmt = stmt;
                stmt = tempStmt.substring(0, edge) + tempStmt.substring(dot1 + 1);
                state = false;
                i = 0;
            }
        }
        if (!scanStmt) {
            return stmt;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "INTEGER", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "integer", b)) != -1) {
            b = i;
            if (Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(' && stmt.length() > b + 7 && (Character.isWhitespace(stmt.charAt(b + 7)) || stmt.charAt(b + 7) == ',' || stmt.charAt(b + 7) == ')')) {
                stmt = stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 7);
                b += 7;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 7) {
                stmt = stmt.substring(0, b) + " num format=11.0 ";
                b += 7;
                continue;
            }
            b += 7;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "LONG", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "long", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=11.0 ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "TIME", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "time", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=time8. " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=time8. ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "DATE", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "date", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = stmt.substring(0, b) + " num format=date9. " + stmt.substring(b + 4);
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = stmt.substring(0, b) + " num format=date9. ";
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "TIMESTAMP", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "timestamp", b)) != -1) {
            b = i;
            if (Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(' && stmt.length() > b + 9 && (Character.isWhitespace(stmt.charAt(b + 9)) || stmt.charAt(b + 9) == ',' || stmt.charAt(b + 9) == ')')) {
                stmt = stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 9);
                b += 9;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 9) {
                stmt = stmt.substring(0, b) + " num format=datetime19. ";
                b += 9;
                continue;
            }
            b += 9;
        }
        b = 0;
        while ((i = ParsedQuery.findFirstString(stmt, "DATETIME", b)) != -1 || (i = ParsedQuery.findFirstString(stmt, "datetime", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 8 && (Character.isWhitespace(stmt.charAt(b + 8)) || stmt.charAt(b + 8) == ',' || stmt.charAt(b + 8) == ')')) {
                stmt = stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 8);
                b += 8;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 8) {
                stmt = stmt.substring(0, b) + " num format=datetime19. ";
                b += 8;
                continue;
            }
            b += 8;
        }
        return stmt;
    }

    String buildQuery(String[] parameters) throws SQLException {
        if (parameters.length == 0) {
            return this.sasifiedQuery;
        }
        StringBuilder query = new StringBuilder();
        int b = 0;
        int e = 0;
        int inquotes = -1;
        int length = this.rawQuery.length();
        block0: for (int i = 0; i < parameters.length; ++i) {
            String parm = parameters[i];
            if (parm == null) {
                throw new MVASQLException(MessageCode.MVAPreparedStatement_substituteParamError, ++i);
            }
            while (e < length) {
                if (this.rawQuery.charAt(e) == '\'' || this.rawQuery.charAt(e) == '\"') {
                    if (inquotes == -1) {
                        inquotes = this.rawQuery.charAt(e);
                    } else if (inquotes == this.rawQuery.charAt(e)) {
                        inquotes = -1;
                    }
                }
                if (this.getRawQuery().charAt(e) == '?' && inquotes == -1) {
                    query.append(this.rawQuery.substring(b, e));
                    query.append(parm);
                    b = e + 1;
                    ++e;
                    continue block0;
                }
                ++e;
            }
        }
        if (b < length) {
            query.append(this.rawQuery.substring(b));
        }
        return query.toString();
    }

    static {
        TS_INTERVALS.put("SQL_TSI_DAY", "DTDAY");
        TS_INTERVALS.put("SQL_TSI_FRAC_SECOND", null);
        TS_INTERVALS.put("SQL_TSI_HOUR", "DTHOUR");
        TS_INTERVALS.put("SQL_TSI_MINUTE", "DTMINUTE");
        TS_INTERVALS.put("SQL_TSI_MONTH", "DTMONTH");
        TS_INTERVALS.put("SQL_TSI_QUARTER", "DTQTR");
        TS_INTERVALS.put("SQL_TSI_SECOND", "DTSECOND");
        TS_INTERVALS.put("SQL_TSI_WEEK", "DTWEEK");
        TS_INTERVALS.put("SQL_TSI_YEAR", "DTYEAR");
        FuncEntry entry = new FuncEntry("RANK", 0);
        sasfns.put("ASCII", entry);
        sasfns.put("ascii", entry);
        entry = new FuncEntry("BYTE", 0);
        sasfns.put("CHAR", entry);
        sasfns.put("char", entry);
        entry = new FuncEntry("", 1);
        sasfns.put("CONCAT", entry);
        sasfns.put("concat", entry);
        entry = new FuncEntry(null, 0);
        sasfns.put("DIFFERENCE", entry);
        sasfns.put("difference", entry);
        entry = new FuncEntry(null, 0);
        sasfns.put("INSERT", entry);
        sasfns.put("insert", entry);
        entry = new FuncEntry("LOWCASE", 0);
        sasfns.put("LCASE", entry);
        sasfns.put("lcase", entry);
        entry = new FuncEntry("SUBSTR", 2);
        sasfns.put("LEFT", entry);
        sasfns.put("left", entry);
        entry = new FuncEntry("LENGTH", 0);
        sasfns.put("LENGTH", entry);
        sasfns.put("length", entry);
        entry = new FuncEntry("", 20);
        sasfns.put("LOCATE", entry);
        sasfns.put("locate", entry);
        entry = new FuncEntry("TRIM(LEFT", 3);
        sasfns.put("LTRIM", entry);
        sasfns.put("ltrim", entry);
        entry = new FuncEntry("REPEAT", 4);
        sasfns.put("REPEAT", entry);
        sasfns.put("repeat", entry);
        entry = new FuncEntry("TRANWRD", 0);
        sasfns.put("REPLACE", entry);
        sasfns.put("replace", entry);
        entry = new FuncEntry("", 15);
        sasfns.put("RIGHT", entry);
        sasfns.put("right", entry);
        entry = new FuncEntry("TRIMN", 0);
        sasfns.put("RTRIM", entry);
        sasfns.put("rtrim", entry);
        entry = new FuncEntry("SOUNDEX", 0);
        sasfns.put("SOUNDEX", entry);
        sasfns.put("soundex", entry);
        entry = new FuncEntry("REPEAT", 5);
        sasfns.put("SPACE", entry);
        sasfns.put("space", entry);
        entry = new FuncEntry("SUBSTR", 0);
        sasfns.put("SUBSTRING", entry);
        sasfns.put("substring", entry);
        entry = new FuncEntry("UPCASE", 0);
        sasfns.put("UCASE", entry);
        sasfns.put("ucase", entry);
        entry = new FuncEntry("ABS", 0);
        sasfns.put("ABS", entry);
        sasfns.put("abs", entry);
        entry = new FuncEntry("ARCOS", 0);
        sasfns.put("ACOS", entry);
        sasfns.put("acos", entry);
        entry = new FuncEntry("ARSIN", 0);
        sasfns.put("ASIN", entry);
        sasfns.put("asin", entry);
        entry = new FuncEntry("ATAN", 0);
        sasfns.put("ATAN", entry);
        sasfns.put("atan", entry);
        entry = new FuncEntry("ATAN2", 0);
        sasfns.put("ATAN2", entry);
        sasfns.put("atan2", entry);
        entry = new FuncEntry("CEIL", 0);
        sasfns.put("CEILING", entry);
        sasfns.put("ceiling", entry);
        entry = new FuncEntry("COS", 0);
        sasfns.put("COS", entry);
        sasfns.put("cos", entry);
        entry = new FuncEntry("COT", 0);
        sasfns.put("COT", entry);
        sasfns.put("cot", entry);
        entry = new FuncEntry("", 16);
        sasfns.put("DEGREES", entry);
        sasfns.put("degrees", entry);
        entry = new FuncEntry("EXP", 0);
        sasfns.put("EXP", entry);
        sasfns.put("exp", entry);
        entry = new FuncEntry("FLOOR", 0);
        sasfns.put("FLOOR", entry);
        sasfns.put("floor", entry);
        entry = new FuncEntry("LOG", 0);
        sasfns.put("LOG", entry);
        sasfns.put("log", entry);
        entry = new FuncEntry("LOG10", 0);
        sasfns.put("LOG10", entry);
        sasfns.put("log10", entry);
        entry = new FuncEntry("MOD", 0);
        sasfns.put("MOD", entry);
        sasfns.put("mod", entry);
        entry = new FuncEntry("", 12);
        sasfns.put("PI", entry);
        sasfns.put("pi", entry);
        entry = new FuncEntry("  (", 6);
        sasfns.put("POWER", entry);
        sasfns.put("power", entry);
        entry = new FuncEntry("", 17);
        sasfns.put("RADIANS", entry);
        sasfns.put("radians", entry);
        entry = new FuncEntry("RANUNI", 7);
        sasfns.put("RAND", entry);
        sasfns.put("rand", entry);
        entry = new FuncEntry("ROUND", 8);
        sasfns.put("ROUND", entry);
        sasfns.put("round", entry);
        entry = new FuncEntry("SIGN", 0);
        sasfns.put("SIGN", entry);
        sasfns.put("sign", entry);
        entry = new FuncEntry("SIN", 0);
        sasfns.put("SIN", entry);
        sasfns.put("sin", entry);
        entry = new FuncEntry("SQRT", 0);
        sasfns.put("SQRT", entry);
        sasfns.put("sqrt", entry);
        entry = new FuncEntry("TAN", 0);
        sasfns.put("TAN", entry);
        sasfns.put("tan", entry);
        entry = new FuncEntry(null, 0);
        sasfns.put("TRUNCATE", entry);
        sasfns.put("truncate", entry);
        entry = new FuncEntry("DATE", 0);
        sasfns.put("CURDATE", entry);
        sasfns.put("curdate", entry);
        entry = new FuncEntry("TIME", 0);
        sasfns.put("CURTIME", entry);
        sasfns.put("curtime", entry);
        entry = new FuncEntry("LEFT(PUT", 9);
        sasfns.put("DAYNAME", entry);
        sasfns.put("dayname", entry);
        entry = new FuncEntry("DAY", 0);
        sasfns.put("DAYOFMONTH", entry);
        sasfns.put("dayofmonth", entry);
        entry = new FuncEntry("WEEKDAY", 0);
        sasfns.put("DAYOFWEEK", entry);
        sasfns.put("dayofweek", entry);
        entry = new FuncEntry("MOD(JULDATE", 10);
        sasfns.put("DAYOFYEAR", entry);
        sasfns.put("dayofyear", entry);
        entry = new FuncEntry("HOUR", 0);
        sasfns.put("HOUR", entry);
        sasfns.put("hour", entry);
        entry = new FuncEntry("MINUTE", 0);
        sasfns.put("MINUTE", entry);
        sasfns.put("minute", entry);
        entry = new FuncEntry("MONTH", 0);
        sasfns.put("MONTH", entry);
        sasfns.put("month", entry);
        entry = new FuncEntry("LEFT(PUT", 11);
        sasfns.put("MONTHNAME", entry);
        sasfns.put("monthname", entry);
        entry = new FuncEntry("DATETIME", 0);
        sasfns.put("NOW", entry);
        sasfns.put("now", entry);
        entry = new FuncEntry("QTR", 0);
        sasfns.put("QUARTER", entry);
        sasfns.put("quarter", entry);
        entry = new FuncEntry("SECOND", 0);
        sasfns.put("SECOND", entry);
        sasfns.put("second", entry);
        entry = new FuncEntry("", 18);
        sasfns.put("TIMESTAMPADD", entry);
        sasfns.put("timestampadd", entry);
        entry = new FuncEntry("", 19);
        sasfns.put("TIMESTAMPDIFF", entry);
        sasfns.put("timestampdiff", entry);
        entry = new FuncEntry("WEEK", 14);
        sasfns.put("WEEK", entry);
        sasfns.put("week", entry);
        entry = new FuncEntry("YEAR", 0);
        sasfns.put("YEAR", entry);
        sasfns.put("year", entry);
        entry = new FuncEntry(null, 0);
        sasfns.put("DATABASE", entry);
        sasfns.put("database", entry);
        entry = new FuncEntry("COALESCE", 0);
        sasfns.put("IFNULL", entry);
        sasfns.put("ifnull", entry);
        entry = new FuncEntry("", 13);
        sasfns.put(USER_LIBREF, entry);
        sasfns.put("user", entry);
        entry = new FuncEntry(null, 0);
        sasfns.put("CONVERT", entry);
        sasfns.put("convert", entry);
    }
}

