/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.CalendarType;
import com.sas.text.DateTimeValue;
import com.sas.text.DateValue;
import com.sas.text.FormatDescription;
import com.sas.text.Info;
import com.sas.text.InvalidFormatException;
import com.sas.text.LanguageCode;
import com.sas.text.NLFormats;
import com.sas.text.NumericalShape;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASFormatInfo;
import com.sas.text.SASNumericFormat;
import com.sas.text.SingleEntry;
import com.sas.text.TableEntry;
import com.sas.text.TimeValue;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope
public class ExcelFormat {
    private static final char APOS = '\'';
    private static final char COLON = ':';
    private static final String JDATE_PREFIX = "JDATE";
    private static final String JTIME_PREFIX = "JTIME";
    private static final String JNENGO_PREFIX = "JNENGO";
    private static final String JAPANESE = "ja";
    private static final String JDATEYT = "JDATEYT";
    private static final String JDATEYTW = "JDATEYTW";
    private static final String JNENGOT = "JNENGOT";
    private static final String JNENGOTW = "JNENGOTW";
    private static final String JNENGO = "JNENGO";
    private static final String JNENGOW = "JNENGOW";
    private static final Map<String, String> japanesePatterns = new HashMap<String, String>();
    private static final Pattern numberPart;
    private static final Pattern pat;
    private static final Pattern WIDTH_PATTERN;
    private static final Pattern NUMBER_PATTERN;
    private static final Pattern PERCENT_PATTERN;
    private static final Pattern decimalPart;

    public static String getFormat(String name, Locale locale) {
        String pattern = null;
        if (locale.getLanguage().startsWith(JAPANESE) && (name.startsWith(JDATE_PREFIX) || name.startsWith(JTIME_PREFIX) || name.startsWith("JNENGO"))) {
            pattern = ExcelFormat.getJapanesePattern(name);
            if (pattern == null) {
                pattern = japanesePatterns.get(name);
            }
            if (pattern != null) {
                return pattern;
            }
        } else {
            Matcher matcher = NUMBER_PATTERN.matcher(name);
            if (matcher.find() && !"2".equals(matcher.group(2))) {
                name = matcher.group(1);
            }
            if ("NLDATMMN".equals(name)) {
                pattern = "MMMM";
            } else {
                if ("NLSTRQTR".equals(name) || "NLSTRMON".equals(name) || "NLSTRWK".equals(name)) {
                    return "General; ; ;";
                }
                if ("NLDATMYQ".equals(name)) {
                    name = "NLDATEYM";
                } else if ("NLDATMYW".equals(name) || name.startsWith("NLDATEYQ")) {
                    name = "NLDATE2";
                }
                pattern = NLFormats.getPattern(name, locale);
            }
        }
        if (pattern == null) {
            pattern = ExcelFormat.getDatePattern(name, locale);
            if (pattern == null && ExcelFormat.hasWidthSpecified(name)) {
                String baseName = ExcelFormat.trimWidth(name);
                if ("NLDATMMN".equals(baseName)) {
                    pattern = "MMMM";
                } else {
                    if ("NLSTRQTR".equals(baseName) || "NLSTRMON".equals(baseName) || "NLSTRWK".equals(baseName)) {
                        return "General; ; ;";
                    }
                    if ("NLDATMYQ".equals(baseName)) {
                        baseName = "NLDATEYM";
                    } else if ("NLDATMYW".equals(baseName) || "NLDATEYQ".equals(baseName)) {
                        baseName = "NLDATE2";
                    }
                    pattern = NLFormats.getPattern(baseName, locale);
                }
                if (pattern == null) {
                    pattern = ExcelFormat.findDatePattern(name, locale);
                }
            }
            if (pattern == null) {
                return null;
            }
        }
        pattern = ExcelFormat.convertPattern(pattern);
        StringBuffer buff = new StringBuffer("[$-");
        buff.append(NumericalShape.getNumericalShape(locale));
        buff.append(CalendarType.getCalendar(locale));
        buff.append(LanguageCode.getLanguageCode(locale));
        buff.append("]");
        buff.append(pattern);
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumeric(String name, Locale locale) {
        String pattern;
        String optionalPattern = null;
        if (ExcelFormat.hasWidthSpecified(name) && (pattern = ExcelFormat.findNumberPattern(name, locale)) != null) {
            optionalPattern = pattern;
            if (name.startsWith("NLMNYI")) {
                optionalPattern = ExcelFormat.processNLMNYI(pattern, locale);
            } else if (name.startsWith("NLMNY")) {
                optionalPattern = ExcelFormat.processNLMNY(pattern, locale);
            } else if (name.startsWith("NLNUM")) {
                optionalPattern = ExcelFormat.processNLNUM(pattern, locale);
            } else if (name.startsWith("NLMNL") || name.startsWith("NLMNI")) {
                String currencySymbol = ExcelFormat.getCurrencySymbol(name, locale);
                optionalPattern = ExcelFormat.processNLMNI(pattern, currencySymbol, locale);
            } else if (name.startsWith("NLPCT")) {
                optionalPattern = ExcelFormat.processNLPCT(pattern);
            }
        }
        if (ExcelFormat.hasWidthSpecified(name)) {
            name = ExcelFormat.trimWidth(name);
        }
        if (name.equals("NLD")) {
            name = "NLBEST";
        }
        Object[] definedFormats = SASNumericFormat.getSupportedFormats(locale);
        for (int j = 0; j < definedFormats.length; ++j) {
            FormatDescription format = (FormatDescription)definedFormats[j];
            String formatName = format.getBaseFormatName();
            if (!formatName.equals(name) || !(format instanceof SingleEntry)) continue;
            SingleEntry entry = (SingleEntry)format;
            try {
                boolean repl = entry.m_isReplaced;
                entry.m_isReplaced = false;
                String pattern2 = null;
                String currencySymbol = entry.getCurrecnySymbol();
                try {
                    pattern2 = entry.getPattern(formatName);
                }
                finally {
                    entry.m_isReplaced = repl;
                }
                if (pattern2 != null) {
                    if (name.equals("NLMNY")) {
                        return ExcelFormat.processNLMNY(pattern2, locale);
                    }
                    if (name.equals("NLMNYI")) {
                        return ExcelFormat.processNLMNYI(pattern2, locale);
                    }
                    if (name.startsWith("NLNUM")) {
                        return ExcelFormat.processNLNUM(pattern2, locale);
                    }
                    if (name.startsWith("NLMNL") || name.startsWith("NLMNI")) {
                        return ExcelFormat.processNLMNI(pattern2, currencySymbol, locale);
                    }
                    if (name.startsWith("NLPCT")) {
                        return ExcelFormat.processNLPCT(pattern2);
                    }
                    return pattern2;
                }
                break;
            }
            catch (InvalidFormatException e) {
                // empty catch block
            }
        }
        return optionalPattern;
    }

    private static String processNLMNI(String pattern, String currencySymbol, Locale locale) {
        int pos;
        String symbol;
        if (currencySymbol != null && pattern.indexOf(symbol = ExcelFormat.unescapeCurrencySymbol(currencySymbol)) >= 0) {
            pattern = pattern.replaceAll(currencySymbol, ExcelFormat.escapeCurrencySymbol(currencySymbol));
        }
        if ((pos = pattern.indexOf(";")) > 0) {
            if (pattern.endsWith(")")) {
                return ExcelFormat.addUnderParen(pattern.substring(0, pos), ")") + pattern.substring(pos);
            }
            if (pattern.endsWith("-")) {
                return ExcelFormat.addUnderParen(pattern.substring(0, pos), "-") + pattern.substring(pos);
            }
        }
        return pattern;
    }

    private static String unescapeCurrencySymbol(String symbol) {
        return symbol.replaceAll("\\\\", "");
    }

    private static String escapeCurrencySymbol(String currencySymbol) {
        StringBuffer letters = new StringBuffer(currencySymbol);
        for (int i = letters.length() - 1; i >= 0; --i) {
            char ch = currencySymbol.charAt(i);
            if (ch != '.' && (ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            letters.insert(i, "\\\\");
        }
        return letters.toString();
    }

    private static String processNLPCT(String pattern) {
        Matcher matcher = PERCENT_PATTERN.matcher(pattern);
        if (matcher.find()) {
            return matcher.group(1) + matcher.group(2);
        }
        return pattern;
    }

    private static String processNLMNY(String pattern, Locale locale) {
        int pos = pattern.indexOf(";");
        if (pos > 0) {
            if (pattern.endsWith(")")) {
                pattern = ExcelFormat.addUnderParen(pattern.substring(0, pos), ")") + pattern.substring(pos);
            } else if (pattern.endsWith("-")) {
                pattern = ExcelFormat.addUnderParen(pattern.substring(0, pos), "-") + pattern.substring(pos);
            }
        }
        Matcher matcher = decimalPart.matcher(pattern);
        while (matcher.find()) {
            String sub = matcher.group(1);
            int start = matcher.start(1);
            int end = matcher.end(1);
            pattern = pattern.substring(0, start) + sub.replace("#", "0") + pattern.substring(end);
        }
        return ExcelFormat.setCurrencySymbol(pattern, ExcelFormat.localeCurrency(locale));
    }

    private static String processNLMNYI(String pattern, Locale locale) {
        int pos = pattern.indexOf(";");
        if (pos > 0) {
            if (pattern.endsWith(")")) {
                pattern = ExcelFormat.addUnderParen(pattern.substring(0, pos), ")") + pattern.substring(pos);
            } else if (pattern.endsWith("-")) {
                pattern = ExcelFormat.addUnderParen(pattern.substring(0, pos), "-") + pattern.substring(pos);
            }
        }
        Matcher matcher = decimalPart.matcher(pattern);
        while (matcher.find()) {
            String sub = matcher.group(1);
            int start = matcher.start(1);
            int end = matcher.end(1);
            pattern = pattern.substring(0, start) + sub.replace("#", "0") + pattern.substring(end);
        }
        return ExcelFormat.setCurrencyString(pattern);
    }

    private static String processNLNUM(String pattern, Locale locale) {
        String pat = pattern;
        int pos = pat.indexOf(".###");
        if (pos > 0 && pos == pat.length() - 4) {
            pat = pat.substring(0, pos);
        }
        return pat;
    }

    private static String setCurrencySymbol(String pattern, String symbol) {
        if (symbol != null && !symbol.equals("\u00a4")) {
            int pos;
            String symb = "\"" + symbol + "\"";
            while ((pos = pattern.indexOf(164)) >= 0) {
                StringBuffer buff = new StringBuffer();
                if (pos > 0) {
                    buff.append(pattern.substring(0, pos));
                }
                buff.append(symb);
                if (pos < pattern.length()) {
                    buff.append(pattern.substring(pos + 1));
                }
                pattern = buff.toString();
            }
        }
        return pattern;
    }

    private static String localeCurrency(Locale locale) {
        DecimalFormatSymbols instance = new DecimalFormatSymbols(locale);
        return instance.getCurrencySymbol();
    }

    private static String setCurrencyString(String pattern) {
        Matcher mat = pat.matcher(pattern);
        if (mat.find()) {
            String full = mat.group(2);
            String symbol = mat.group(3);
            String symb = "\"" + symbol + "\"";
            return pattern.replaceAll(full, symb);
        }
        return pattern;
    }

    private static String addUnderParen(String pattern, String ch) {
        Matcher matcher = numberPart.matcher(pattern);
        if (matcher.find()) {
            String prefix = matcher.group(1);
            String number = matcher.group(2);
            String suffix = matcher.group(3);
            StringBuffer buff = new StringBuffer(prefix);
            buff.append(number);
            buff.append("_").append(ch).append(suffix);
            return buff.toString();
        }
        return pattern + "_" + ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatePattern(String name, Locale locale) {
        Object[] definedFormats = SASDateTimeFormat.getSupportedFormats(locale);
        for (int j = 0; j < definedFormats.length; ++j) {
            FormatDescription format = (FormatDescription)definedFormats[j];
            String formatName = format.getBaseFormatName();
            if (!formatName.equals(name) || !(format instanceof SingleEntry)) continue;
            SingleEntry entry = (SingleEntry)format;
            try {
                boolean repl = entry.m_isReplaced;
                entry.m_isReplaced = false;
                String pattern = null;
                try {
                    pattern = entry.getPattern(formatName);
                }
                finally {
                    entry.m_isReplaced = repl;
                }
                return pattern;
            }
            catch (InvalidFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\\') {
                buff.append(ch);
                buff.append(pattern.charAt(++i));
                continue;
            }
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                int count = 1;
                if (i < length - 1) {
                    char nch;
                    do {
                        if (ch != (nch = pattern.charAt(i + 1))) continue;
                        ++count;
                        ++i;
                    } while (i < length - 1 && ch == nch);
                }
                ExcelFormat.appendCode(buff, ch, count);
                continue;
            }
            if (ch == '\'') {
                StringBuffer tempBuff = new StringBuffer();
                tempBuff.append(ch);
                while (++i < length) {
                    ch = pattern.charAt(i);
                    tempBuff.append(ch);
                    if (ch != '\'') continue;
                }
                if (tempBuff.length() == 3 && tempBuff.charAt(2) == '\'') {
                    char ch2 = tempBuff.charAt(1);
                    if (ch2 == ':' || ch2 == '.' || ch2 == '/' || ch2 == ',' || ch2 == '-') {
                        buff.append(ch2);
                        continue;
                    }
                    buff.append(tempBuff);
                    continue;
                }
                buff.append(tempBuff);
                continue;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    private static void appendCode(StringBuffer buff, int ch, int count) {
        switch (ch) {
            case 71: {
                break;
            }
            case 121: {
                if (count <= 2) {
                    buff.append("yy");
                    break;
                }
                buff.append("yyyy");
                break;
            }
            case 77: {
                if (count < 3) {
                    if (count == 1) {
                        buff.append("m");
                        break;
                    }
                    buff.append("mm");
                    break;
                }
                if (count < 4) {
                    buff.append("mmm");
                    break;
                }
                buff.append("mmmm");
                break;
            }
            case 119: {
                break;
            }
            case 87: {
                break;
            }
            case 68: {
                break;
            }
            case 100: {
                if (count == 1) {
                    buff.append("d");
                    break;
                }
                buff.append("dd");
                break;
            }
            case 70: {
                break;
            }
            case 69: {
                if (count < 4) {
                    buff.append("ddd");
                    break;
                }
                buff.append("dddd");
                break;
            }
            case 97: {
                buff.append("AM/PM");
                break;
            }
            case 72: 
            case 107: {
                if (count == 2) {
                    buff.append("hh");
                    break;
                }
                buff.append("h");
                break;
            }
            case 75: 
            case 104: {
                if (count == 2) {
                    buff.append("hh");
                    break;
                }
                buff.append("h");
                break;
            }
            case 109: {
                if (count == 2) {
                    buff.append("mm");
                    break;
                }
                buff.append("m");
                break;
            }
            case 115: {
                if (count == 2) {
                    buff.append("ss");
                    break;
                }
                buff.append("s");
                break;
            }
            case 83: {
                buff.append("00");
                break;
            }
            case 88: {
                break;
            }
            case 122: {
                break;
            }
            case 90: {
                break;
            }
            default: {
                for (int i = 0; i < count; ++i) {
                    buff.append((char)ch);
                }
            }
        }
    }

    private static String getJapanesePattern(String name) {
        String pattern = null;
        Object[] definedFormats = null;
        if (name.equals(JDATEYT) || name.equals(JDATEYTW) || name.equals(JNENGOT) || name.equals(JNENGOTW)) {
            definedFormats = DateTimeValue.getDefinedFormats(Locale.JAPANESE);
        } else if (name.startsWith(JTIME_PREFIX)) {
            definedFormats = TimeValue.getDefinedFormats(Locale.JAPANESE);
        } else if (name.startsWith(JDATE_PREFIX) || name.equals("JNENGO") || name.equals(JNENGOW)) {
            definedFormats = DateValue.getDefinedFormats(Locale.JAPANESE);
        }
        if (definedFormats != null) {
            for (int j = 0; j < definedFormats.length; ++j) {
                FormatDescription format = (FormatDescription)definedFormats[j];
                String formatName = format.getBaseFormatName();
                if (!formatName.equals(name)) continue;
                if (!(format instanceof SingleEntry)) break;
                SingleEntry entry = (SingleEntry)format;
                try {
                    pattern = entry.getPattern(formatName);
                }
                catch (InvalidFormatException e) {}
                break;
            }
        }
        return pattern;
    }

    private static String trimWidth(String origName) {
        Matcher matcher = WIDTH_PATTERN.matcher(origName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return origName;
    }

    private static boolean hasWidthSpecified(String origName) {
        Matcher matcher = WIDTH_PATTERN.matcher(origName);
        if (matcher.find()) {
            String name = matcher.group(1);
            return !origName.equals(name);
        }
        return false;
    }

    private static String findDatePattern(String name, Locale locale) {
        SASFormat fmt = SASFormat.getInstance(name, locale);
        if (fmt != null && (fmt.isDateFormat() || fmt.isDateTimeFormat() || fmt.isTimeFormat())) {
            return ExcelFormat.getPattern(name, fmt);
        }
        return null;
    }

    private static String findNumberPattern(String name, Locale locale) {
        SASFormat fmt = SASFormat.getInstance(name, locale);
        if (fmt != null && (fmt.isNumericFormat() || fmt.isPercent() || fmt.isDFormat())) {
            return ExcelFormat.getPattern(name, fmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPattern(String name, SASFormat fmt) {
        Info info = fmt.formatInfo;
        if (info instanceof SASFormatInfo) {
            SASFormatInfo sinfo = (SASFormatInfo)info;
            TableEntry te = sinfo.te;
            if (te instanceof SingleEntry) {
                SingleEntry se = (SingleEntry)te;
                boolean oldVal = se.m_isReplaced;
                se.m_isReplaced = false;
                try {
                    String string = se.getPattern(name);
                    return string;
                }
                catch (InvalidFormatException e) {
                }
                finally {
                    se.m_isReplaced = oldVal;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrencySymbol(String name, Locale locale) {
        SASFormat fmt = SASFormat.getInstance(name, locale);
        Info info = fmt.formatInfo;
        if (info instanceof SASFormatInfo) {
            SASFormatInfo sinfo = (SASFormatInfo)info;
            TableEntry te = sinfo.te;
            if (te instanceof SingleEntry) {
                SingleEntry se = (SingleEntry)te;
                boolean oldVal = se.m_isReplaced;
                try {
                    se.m_isReplaced = false;
                    String string = se.getCurrecnySymbol();
                    return string;
                }
                finally {
                    se.m_isReplaced = oldVal;
                }
            }
        }
        return null;
    }

    static {
        japanesePatterns.put("JDATEMDW", "[$-411]m\u6708d\u65e5");
        japanesePatterns.put("JDATEMNW", "[$-411]m\u6708");
        japanesePatterns.put("JDATEWK", "[$-411]yyyy\u5e74m\u6708d\u65e5");
        japanesePatterns.put("JDATEYDW", "[$-411]yyyy\u5e74m\u6708d\u65e5");
        japanesePatterns.put("JDATEYMD", "[$-411]yyyy\u5e74m\u6708d\u65e5");
        japanesePatterns.put("JDATEYMW", "[$-411]yyyy\u5e74m\u6708");
        japanesePatterns.put("JNENGO", "[$-411]ggge\u5e74 m\u6708d\u65e5");
        japanesePatterns.put(JNENGOW, "[$-411]ggge\u5e74 m\u6708d\u65e5");
        japanesePatterns.put("JTIMEH", "[$-411]h\u6642");
        japanesePatterns.put("JTIMEHM", "[$-411]h\u6642mm\u5206");
        japanesePatterns.put("JTIMEHMS", "[$-411]h\u6642mm\u5206ss\u79d2");
        japanesePatterns.put("JTIMEHW", "[$-411]h\u6642");
        japanesePatterns.put("JTIMEMW", "[$-411]h\u6642mm\u5206");
        japanesePatterns.put("JTIMESW", "[$-411]h\u6642mm\u5206ss\u79d2");
        japanesePatterns.put(JDATEYT, "[$-411]yyyy\u5e74m\u6708d\u65e5 h\u6642mm\u5206");
        japanesePatterns.put(JDATEYTW, "[$-411]yyyy\u5e74m\u6708d\u65e5 h\u6642mm\u5206");
        japanesePatterns.put(JNENGOT, "[$-411]ggge\u5e74 m\u6708d\u65e5 h\u6642mm\u5206");
        japanesePatterns.put(JNENGOTW, "[$-411]ggge\u5e74 m\u6708d\u65e5 h\u6642mm\u5206");
        numberPart = Pattern.compile("^([^#]*)(#[#.,0]+#0?)([^#]*)$");
        pat = Pattern.compile("(^|[^'\"])('?([A-Z]{3})'?)($|[^'\"])");
        decimalPart = Pattern.compile("(\\.#(_\\)|\u00a4|\\)$|\\-?$|_\\-;|;|\\-?\\s|'))");
        WIDTH_PATTERN = Pattern.compile("^([A-Z]+)[0-9]*\\.?[0-9]*$");
        NUMBER_PATTERN = Pattern.compile("^([A-Z]+)([0-9]+)?$");
        PERCENT_PATTERN = Pattern.compile("^(.+)\\.#(\\s*%)$");
    }
}

