/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.SASFormatEntry;
import com.sas.text.SASNumericFormat;
import com.sas.text.SingleEntry;
import java.util.Vector;

class Conversion
extends SASNumericFormat {
    StringBuffer result = new StringBuffer(32);
    private static Object[] conversionFormats;

    @Override
    public StringBuffer format(double value) {
        this.result.setLength(0);
        int width = this.info.getWidth();
        String base = this.info.getBaseFormat();
        switch (base.charAt(0)) {
            default: {
                if (width >= 16) {
                    this.fitToWidth(Long.toHexString(Double.doubleToLongBits(value)).toUpperCase(), width, this.result);
                    break;
                }
                this.fitToWidth(Long.toHexString((long)value).toUpperCase(), width, this.result);
                break;
            }
            case 'B': {
                this.fitToWidth(Long.toBinaryString((long)value), width, this.result);
                break;
            }
            case 'O': {
                this.fitToWidth(Long.toOctalString((long)value), width, this.result);
            }
        }
        return this.result;
    }

    @Override
    public double informat(String value) {
        double result = 0.0;
        int width = this.info.getWidth();
        String base = this.info.getBaseFormat();
        switch (base.charAt(0)) {
            case 'H': {
                result = this.hexToDouble(value, width);
                break;
            }
            case 'B': {
                result = this.binaryToDouble(value, width);
                break;
            }
            case 'O': {
                result = this.octalToDouble(value, width);
                break;
            }
        }
        return result;
    }

    private void fitToWidth(String value, int width, StringBuffer result) {
        if (width - value.length() < 0) {
            result.append(value.substring(value.length() - width));
        } else {
            result.append(value);
            for (int j = result.length(); j < width; ++j) {
                result.insert(0, '0');
            }
        }
    }

    protected double hexToDouble(String value, int width) {
        long v = this.stringToLong(value, width, 16);
        double result = width >= 16 ? Double.longBitsToDouble(v) : (double)v;
        return result;
    }

    protected double binaryToDouble(String value, int width) {
        int dv;
        double result = this.stringToLong(value, width, 2);
        if (this.info.isDecimalWidthSupported() && (dv = this.info.getDValue()) != 0) {
            result /= Math.pow(10.0, dv);
        }
        return result;
    }

    protected double octalToDouble(String value, int width) {
        int dv;
        double result = this.stringToLong(value, width, 8);
        if (this.info.isDecimalWidthSupported() && (dv = this.info.getDValue()) != 0) {
            result /= Math.pow(10.0, dv);
        }
        return result;
    }

    protected long stringToLong(String value, int width, int radix) {
        int valueLength = value.length();
        long v = 0L;
        int digit = 0;
        int index = (valueLength > width ? valueLength - (valueLength - width) : valueLength) - 1;
        for (int i = 0; i < width && index >= 0; ++i, --index) {
            digit = Character.digit(value.charAt(index), radix);
            if (digit == -1) continue;
            v = (long)((double)v + (double)digit * Math.pow(radix, i));
        }
        return v;
    }

    static Object[] getDefinedFormats() {
        if (conversionFormats == null) {
            Vector<SingleEntry> temp = new Vector<SingleEntry>(20, 5);
            String className = Conversion.class.getName();
            SingleEntry entry = new SingleEntry("BINARYw", className);
            ((SASFormatEntry)entry).addPattern(8, 64, null, true);
            ((SASFormatEntry)entry).addPattern(1, 7, null);
            temp.addElement(entry);
            entry = new SingleEntry("HEXw", className);
            ((SASFormatEntry)entry).addPattern(8, 16, null, true);
            ((SASFormatEntry)entry).addPattern(1, 7, null);
            temp.addElement(entry);
            entry = new SingleEntry("OCTALw", className);
            ((SASFormatEntry)entry).addPattern(3, 24, null, true);
            ((SASFormatEntry)entry).addPattern(1, 2, null);
            temp.addElement(entry);
            conversionFormats = new Object[temp.size()];
            temp.copyInto(conversionFormats);
        }
        return conversionFormats;
    }
}

