/*
 * Decompiled with CFR 0.152.
 */
package com.sas.measures;

import com.sas.PublicClonable;
import com.sas.codepolicy.SASScope;
import com.sas.measures.MeasureInterface;
import com.sas.measures.RB;
import com.sas.util.NumberUtil;
import com.sas.util.Util;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class Measure
implements MeasureInterface,
PublicClonable,
Serializable {
    static final long serialVersionUID = -6504648673403471770L;
    public static final String RB_KEY = "Measure.";
    public static final int DISPLAY_FORMAT_SPACE_BETWEEN_MAGNITUDE_AND_UNIT = 0;
    public static final int DISPLAY_FORMAT_NOSPACE_BETWEEN_MAGNITUDE_AND_UNIT = 1;
    protected double magnitude;
    protected Locale locale;
    protected int displayFormat;

    protected Measure(double magnitude, Object unit) {
        this(magnitude, unit, null);
    }

    protected Measure(double magnitude, Object unit, Locale locale) {
        this._init();
        this.setLocale(locale);
        this.initializeUnit(unit);
        this.magnitude = magnitude;
    }

    protected Measure(String text) {
        this(text, null);
    }

    protected Measure(String text, Locale locale) {
        this._init();
        this.setLocale(locale);
        this.setText(text);
    }

    protected void _init() {
        this.displayFormat = 0;
    }

    @SASScope
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @SASScope
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public double getMagnitude() {
        return this.magnitude;
    }

    @Override
    public abstract double getMagnitude(Object var1);

    @Override
    public abstract Object getUnit();

    @Override
    public abstract String getUnitName();

    protected abstract void initializeUnit(Object var1);

    @SASScope
    public void setDisplayFormat(int displayFormat) {
        this.displayFormat = displayFormat;
    }

    @SASScope
    public int getDisplayFormat() {
        return this.displayFormat;
    }

    public String toString() {
        String betweenSpace = "";
        if (this.displayFormat == 0) {
            betweenSpace = " ";
        }
        if (this.locale == null) {
            return NumberUtil.toString(this.getMagnitude()) + betweenSpace + this.getUnit();
        }
        return NumberUtil.toString(this.getMagnitude(), this.locale) + betweenSpace + this.getUnit();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(MeasureInterface measure) {
        return measure.getMagnitude() == this.getMagnitude() && Util.equal(measure.getUnit(), this.getUnit());
    }

    public final boolean equals(Object o) {
        if (o instanceof MeasureInterface) {
            return this.equals((MeasureInterface)o);
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        code = (int)((double)code + this.getMagnitude());
        if (this.getUnit() != null) {
            code += this.getUnit().hashCode();
        }
        return code;
    }

    private void setText(String text) {
        try {
            text = text.trim();
            NumberFormat formatter = this.locale == null ? NumberFormat.getInstance() : NumberFormat.getInstance(this.locale);
            ParsePosition pos = new ParsePosition(0);
            Number number = formatter.parse(text, pos);
            if (number == null || pos.getIndex() == 0) {
                throw new Exception();
            }
            double v = number.doubleValue();
            this.initializeUnit(text.substring(pos.getIndex()).trim());
            this.magnitude = v;
        }
        catch (Exception e) {
            IllegalArgumentException rte = new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidArgument.ex.txt"), text));
            rte.initCause(e);
            throw rte;
        }
    }
}

