"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const index_1 = require("./index");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack', { env });
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'defaultVpc', {
    isDefault: true,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: (_a = stack.node.tryGetContext('GITLAB_TOKEN')) !== null && _a !== void 0 ? _a : 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    dockerVolumes: [
        {
            hostPath: '/tmp/cahce',
            containerPath: '/tmp/cahce',
        },
    ],
});
//runner.expireAfter(Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2ludGVnLmFwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBNkM7QUFDN0MsOENBQXlFO0FBQ3pFLHdDQUFzRDtBQUN0RCxtQ0FBZ0Q7QUFDaEQsTUFBTSxHQUFHLEdBQUc7SUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7SUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO0NBQ3pDLENBQUM7QUFDRixNQUFNLE9BQU8sR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLE9BQU8sRUFBRSxlQUFlLEVBQUUsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBQzNELE1BQU0sSUFBSSxHQUFHLElBQUksY0FBSSxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUU7SUFDMUMsU0FBUyxFQUFFLElBQUksMEJBQWdCLENBQUMsbUJBQW1CLENBQUM7SUFDcEQsV0FBVyxFQUFFLGlDQUFpQztJQUM5QyxRQUFRLEVBQUUsVUFBVTtDQUNyQixDQUFDLENBQUM7QUFFSCxNQUFNLEdBQUcsR0FBRyxhQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxZQUFZLEVBQUU7SUFDOUMsU0FBUyxFQUFFLElBQUk7Q0FDaEIsQ0FBQyxDQUFDO0FBQ0gsTUFBTSxNQUFNLEdBQUcsSUFBSSw2QkFBcUIsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFO0lBQ3pELFdBQVcsUUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsbUNBQUksY0FBYztJQUN2RSxPQUFPLEVBQUUsVUFBVTtJQUNuQixVQUFVLEVBQUUsSUFBSTtJQUNoQixPQUFPLEVBQUUsR0FBRztJQUNaLE9BQU8sRUFBRSxHQUFHO0lBQ1osYUFBYSxFQUFFO1FBQ2I7WUFDRSxRQUFRLEVBQUUsWUFBWTtZQUN0QixhQUFhLEVBQUUsWUFBWTtTQUM1QjtLQUNGO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsd0NBQXdDO0FBQ3hDLE1BQU0sQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQ2hDLHVCQUFhLENBQUMsd0JBQXdCLENBQUMsd0JBQXdCLENBQUMsQ0FDakUsQ0FBQztBQUNGLE1BQU0sQ0FBQyxlQUFlLENBQUMsV0FBVyxDQUFDLGdCQUFnQixDQUFDLGNBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztBQUNsRSxNQUFNLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7QUFFbkUsaUZBQWlGO0FBQ2pGLElBQUksZ0JBQVMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLEVBQUUsS0FBSyxFQUFFLE1BQU0sQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztBQUNuRSw2RUFBNkUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQb3J0LCBWcGMgfSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCB7IE1hbmFnZWRQb2xpY3ksIFJvbGUsIFNlcnZpY2VQcmluY2lwYWwgfSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7IEFwcCwgU3RhY2ssIENmbk91dHB1dCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgR2l0bGFiQ29udGFpbmVyUnVubmVyIH0gZnJvbSAnLi9pbmRleCc7XG5jb25zdCBlbnYgPSB7XG4gIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OLFxuICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxufTtcbmNvbnN0IG1vY2tBcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhtb2NrQXBwLCAndGVzdGluZy1zdGFjaycsIHsgZW52IH0pO1xuY29uc3Qgcm9sZSA9IG5ldyBSb2xlKHN0YWNrLCAncnVubmVyLXJvbGUnLCB7XG4gIGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2VjMi5hbWF6b25hd3MuY29tJyksXG4gIGRlc2NyaXB0aW9uOiAnRm9yIEdpdGxhYiBFQzIgUnVubmVyIFRlc3QgUm9sZScsXG4gIHJvbGVOYW1lOiAnVGVzdFJvbGUnLFxufSk7XG5cbmNvbnN0IHZwYyA9IFZwYy5mcm9tTG9va3VwKHN0YWNrLCAnZGVmYXVsdFZwYycsIHtcbiAgaXNEZWZhdWx0OiB0cnVlLFxufSk7XG5jb25zdCBydW5uZXIgPSBuZXcgR2l0bGFiQ29udGFpbmVyUnVubmVyKHN0YWNrLCAndGVzdGluZycsIHtcbiAgZ2l0bGFidG9rZW46IHN0YWNrLm5vZGUudHJ5R2V0Q29udGV4dCgnR0lUTEFCX1RPS0VOJykgPz8gJ0dJVExBQl9UT0tFTicsXG4gIGVjMnR5cGU6ICd0My5sYXJnZScsXG4gIGVjMmlhbXJvbGU6IHJvbGUsXG4gIGVic1NpemU6IDEwMCxcbiAgc2VsZnZwYzogdnBjLFxuICBkb2NrZXJWb2x1bWVzOiBbXG4gICAge1xuICAgICAgaG9zdFBhdGg6ICcvdG1wL2NhaGNlJyxcbiAgICAgIGNvbnRhaW5lclBhdGg6ICcvdG1wL2NhaGNlJyxcbiAgICB9LFxuICBdLFxufSk7XG5cbi8vcnVubmVyLmV4cGlyZUFmdGVyKER1cmF0aW9uLmhvdXJzKDEpKTtcbnJ1bm5lci5ydW5uZXJSb2xlLmFkZE1hbmFnZWRQb2xpY3koXG4gIE1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBbWF6b25TM1JlYWRPbmx5QWNjZXNzJyksXG4pO1xucnVubmVyLmRlZmF1bHRSdW5uZXJTRy5jb25uZWN0aW9ucy5hbGxvd0Zyb21BbnlJcHY0KFBvcnQudGNwKDgwKSk7XG5ydW5uZXIuZGVmYXVsdFJ1bm5lclNHLmNvbm5lY3Rpb25zLmFsbG93RnJvbUFueUlwdjQoUG9ydC50Y3AoNDQzKSk7XG5cbi8vcnVubmVyLnJ1bm5lckVjMi5jb25uZWN0aW9ucy5hbGxvd0Zyb20oUGVlci5pcHY0KCcwLjAuMC4wLzAnKSwgUG9ydC50Y3AoODA4MCkpO1xubmV3IENmbk91dHB1dChzdGFjaywgJ3JvbGUnLCB7IHZhbHVlOiBydW5uZXIucnVubmVyUm9sZS5yb2xlQXJuIH0pO1xuLy9uZXcgQ2ZuT3V0cHV0KHN0YWNrLCAnSW5zdGFuY2VJRCcsIHsgdmFsdWU6IHJ1bm5lci5ydW5uZXJFYzIuaW5zdGFuY2VJZCB9KTtcbiJdfQ==