"""This module provides the RP To-Do config functionality."""

import configparser
from pathlib import Path

import typer

from todopyedu import (
    DB_WRITE_ERROR, DIR_ERROR, FILE_ERROR, SUCCESS,EDITOR_ERROR, __app_name__
)

from todopyedu import database

CONFIG_DIR_PATH = Path(typer.get_app_dir(__app_name__))
CONFIG_FILE_PATH = CONFIG_DIR_PATH / "config.ini"


def init_app(db_path: str, redactor: str) -> int:
    """Initialize the application"""
    config_code = _init_config_file()
    if config_code != SUCCESS:
        return config_code
    database_code = _create_databse(db_path, redactor)
    if database_code != SUCCESS:
        return database_code
    return SUCCESS


def _init_config_file() -> int:
    try:
        CONFIG_DIR_PATH.mkdir(exist_ok=True)
    except OSError:
        return DIR_ERROR
    try:
        CONFIG_FILE_PATH.touch(exist_ok=True)
    except OSError:
        return FILE_ERROR
    return SUCCESS


def _create_databse(db_path: str, redactor: str) -> int:
    if redactor not in database.DEFAULT_EDITORS:
        return EDITOR_ERROR
    config_parser = configparser.ConfigParser()
    config_parser["General"] = {"database": db_path}
    config_parser["Editor"] = {"redactor": redactor}
    try:
        with CONFIG_FILE_PATH.open("w") as file:
            config_parser.write(file)
    except OSError:
        return DB_WRITE_ERROR
    return SUCCESS
