"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * Represents the filesystem for the Lambda function.
 *
 * @stability stable
 */
class FileSystem {
    /**
     * @param config the FileSystem configurations for the Lambda function.
     * @stability stable
     */
    constructor(config) {
        this.config = config;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_FileSystemConfig(config);
    }
    /**
     * mount the filesystem from Amazon EFS.
     *
     * @param ap the Amazon EFS access point.
     * @param mountPath the target path in the lambda runtime environment.
     * @stability stable
     */
    static fromEfsAccessPoint(ap, mountPath) {
        return new FileSystem({
            localMountPath: mountPath,
            arn: ap.accessPointArn,
            dependency: [ap.fileSystem.mountTargetsAvailable],
            connections: ap.fileSystem.connections,
            policies: [
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientMount'],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'elasticfilesystem:AccessPointArn': ap.accessPointArn,
                        },
                    },
                }),
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientWrite'],
                    resources: [core_1.Stack.of(ap).formatArn({
                            service: 'elasticfilesystem',
                            resource: 'file-system',
                            resourceName: ap.fileSystem.fileSystemId,
                        })],
                }),
            ],
        });
    }
}
exports.FileSystem = FileSystem;
_a = JSII_RTTI_SYMBOL_1;
FileSystem[_a] = { fqn: "@aws-cdk/aws-lambda.FileSystem", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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