# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: stigg/sidecar/v1/sidecar.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class AccessDeniedReason(betterproto.Enum):
    ACCESS_DENIED_REASON_UNSPECIFIED = 0
    ACCESS_DENIED_REASON_UNKNOWN = 1
    ACCESS_DENIED_REASON_CUSTOMER_IS_ARCHIVED = 2
    ACCESS_DENIED_REASON_CUSTOMER_NOT_FOUND = 3
    ACCESS_DENIED_REASON_CUSTOMER_RESOURCE_NOT_FOUND = 4
    ACCESS_DENIED_REASON_FEATURE_NOT_FOUND = 5
    ACCESS_DENIED_REASON_NO_ACTIVE_SUBSCRIPTION = 6
    ACCESS_DENIED_REASON_NO_FEATURE_ENTITLEMENT_IN_SUBSCRIPTION = 7
    ACCESS_DENIED_REASON_REQUESTED_USAGE_EXCEEDING_LIMIT = 8
    ACCESS_DENIED_REASON_BUDGET_EXCEEDED = 9


class FeatureType(betterproto.Enum):
    FEATURE_TYPE_UNSPECIFIED = 0
    FEATURE_TYPE_BOOLEAN = 1
    FEATURE_TYPE_NUMBER = 2


class MeterType(betterproto.Enum):
    METER_TYPE_UNSPECIFIED = 0
    METER_TYPE_NONE = 1
    METER_TYPE_FLUCTUATING = 2
    METER_TYPE_INCREMENTAL = 3


class EntitlementResetPeriod(betterproto.Enum):
    ENTITLEMENT_RESET_PERIOD_UNSPECIFIED = 0
    ENTITLEMENT_RESET_PERIOD_DAY = 1
    ENTITLEMENT_RESET_PERIOD_HOUR = 2
    ENTITLEMENT_RESET_PERIOD_MONTH = 3
    ENTITLEMENT_RESET_PERIOD_WEEK = 4
    ENTITLEMENT_RESET_PERIOD_YEAR = 5


class UsageUpdateBehavior(betterproto.Enum):
    USAGE_UPDATE_BEHAVIOR_UNSPECIFIED = 0
    USAGE_UPDATE_BEHAVIOR_DELTA = 1
    USAGE_UPDATE_BEHAVIOR_SET = 2


@dataclass(eq=False, repr=False)
class EntitlementFeature(betterproto.Message):
    id: str = betterproto.string_field(1)
    feature_type: "FeatureType" = betterproto.enum_field(2)
    units: Optional[str] = betterproto.string_field(3, optional=True, group="_units")
    units_plural: Optional[str] = betterproto.string_field(
        4, optional=True, group="_units_plural"
    )
    meter_type: "MeterType" = betterproto.enum_field(5)
    is_metered: bool = betterproto.bool_field(6)


@dataclass(eq=False, repr=False)
class BooleanEntitlement(betterproto.Message):
    feature: Optional["EntitlementFeature"] = betterproto.message_field(
        4, optional=True, group="_feature"
    )


@dataclass(eq=False, repr=False)
class NumericEntitlement(betterproto.Message):
    feature: Optional["EntitlementFeature"] = betterproto.message_field(
        4, optional=True, group="_feature"
    )
    value: Optional[int] = betterproto.int32_field(5, optional=True, group="_value")
    is_unlimited: bool = betterproto.bool_field(6)


@dataclass(eq=False, repr=False)
class MeteredEntitlement(betterproto.Message):
    feature: Optional["EntitlementFeature"] = betterproto.message_field(
        4, optional=True, group="_feature"
    )
    usage_limit: Optional[float] = betterproto.double_field(
        5, optional=True, group="_usage_limit"
    )
    is_unlimited: bool = betterproto.bool_field(6)
    current_usage: float = betterproto.double_field(7)
    reset_period: Optional["EntitlementResetPeriod"] = betterproto.enum_field(
        9, optional=True, group="_reset_period"
    )
    next_reset_date: Optional[datetime] = betterproto.message_field(
        10, optional=True, group="_next_reset_date"
    )
    usage_period_anchor: Optional[datetime] = betterproto.message_field(
        11, optional=True, group="_usage_period_anchor"
    )
    usage_period_start: Optional[datetime] = betterproto.message_field(
        12, optional=True, group="_usage_period_start"
    )
    usage_period_end: Optional[datetime] = betterproto.message_field(
        13, optional=True, group="_usage_period_end"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("next_reset_date"):
            warnings.warn(
                "MeteredEntitlement.next_reset_date is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class Entitlement(betterproto.Message):
    boolean: "BooleanEntitlement" = betterproto.message_field(1, group="entitlement")
    numeric: "NumericEntitlement" = betterproto.message_field(2, group="entitlement")
    metered: "MeteredEntitlement" = betterproto.message_field(3, group="entitlement")


@dataclass(eq=False, repr=False)
class GetEntitlementsRequest(betterproto.Message):
    customer_id: str = betterproto.string_field(1)
    resource_id: Optional[str] = betterproto.string_field(
        2, optional=True, group="_resource_id"
    )


@dataclass(eq=False, repr=False)
class GetEntitlementsResponse(betterproto.Message):
    entitlements: List["Entitlement"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class BooleanEntitlementFallback(betterproto.Message):
    has_access: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class BooleanEntitlementOptions(betterproto.Message):
    fallback: Optional["BooleanEntitlementFallback"] = betterproto.message_field(
        1, optional=True, group="_fallback"
    )


@dataclass(eq=False, repr=False)
class GetBooleanEntitlementRequest(betterproto.Message):
    customer_id: str = betterproto.string_field(1)
    feature_id: str = betterproto.string_field(2)
    resource_id: Optional[str] = betterproto.string_field(
        3, optional=True, group="_resource_id"
    )
    options: Optional["BooleanEntitlementOptions"] = betterproto.message_field(
        4, optional=True, group="_options"
    )


@dataclass(eq=False, repr=False)
class GetBooleanEntitlementResponse(betterproto.Message):
    has_access: bool = betterproto.bool_field(1)
    is_fallback: bool = betterproto.bool_field(2)
    access_denied_reason: Optional["AccessDeniedReason"] = betterproto.enum_field(
        3, optional=True, group="_access_denied_reason"
    )
    entitlement: "BooleanEntitlement" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class NumericEntitlementFallback(betterproto.Message):
    has_access: bool = betterproto.bool_field(1)
    value: Optional[int] = betterproto.int32_field(2, optional=True, group="_value")
    is_unlimited: Optional[bool] = betterproto.bool_field(
        3, optional=True, group="_is_unlimited"
    )


@dataclass(eq=False, repr=False)
class NumericEntitlementOptions(betterproto.Message):
    fallback: Optional["NumericEntitlementFallback"] = betterproto.message_field(
        1, optional=True, group="_fallback"
    )


@dataclass(eq=False, repr=False)
class GetNumericEntitlementRequest(betterproto.Message):
    customer_id: str = betterproto.string_field(1)
    feature_id: str = betterproto.string_field(2)
    resource_id: Optional[str] = betterproto.string_field(
        3, optional=True, group="_resource_id"
    )
    options: Optional["NumericEntitlementOptions"] = betterproto.message_field(
        4, optional=True, group="_options"
    )


@dataclass(eq=False, repr=False)
class GetNumericEntitlementResponse(betterproto.Message):
    has_access: bool = betterproto.bool_field(1)
    is_fallback: bool = betterproto.bool_field(2)
    access_denied_reason: Optional["AccessDeniedReason"] = betterproto.enum_field(
        3, optional=True, group="_access_denied_reason"
    )
    entitlement: "NumericEntitlement" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class MeteredEntitlementFallback(betterproto.Message):
    has_access: bool = betterproto.bool_field(1)
    usage_limit: Optional[float] = betterproto.double_field(
        2, optional=True, group="_usage_limit"
    )
    is_unlimited: Optional[bool] = betterproto.bool_field(
        3, optional=True, group="_is_unlimited"
    )


@dataclass(eq=False, repr=False)
class MeteredEntitlementOptions(betterproto.Message):
    requested_usage: Optional[float] = betterproto.double_field(
        1, optional=True, group="_requested_usage"
    )
    fallback: Optional["MeteredEntitlementFallback"] = betterproto.message_field(
        2, optional=True, group="_fallback"
    )


@dataclass(eq=False, repr=False)
class GetMeteredEntitlementRequest(betterproto.Message):
    customer_id: str = betterproto.string_field(1)
    feature_id: str = betterproto.string_field(2)
    resource_id: Optional[str] = betterproto.string_field(
        3, optional=True, group="_resource_id"
    )
    options: Optional["MeteredEntitlementOptions"] = betterproto.message_field(
        4, optional=True, group="_options"
    )


@dataclass(eq=False, repr=False)
class GetMeteredEntitlementResponse(betterproto.Message):
    has_access: bool = betterproto.bool_field(1)
    is_fallback: bool = betterproto.bool_field(2)
    access_denied_reason: Optional["AccessDeniedReason"] = betterproto.enum_field(
        3, optional=True, group="_access_denied_reason"
    )
    requested_usage: float = betterproto.double_field(4)
    entitlement: "MeteredEntitlement" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class RedisOptions(betterproto.Message):
    environment_prefix: str = betterproto.string_field(1)
    host: Optional[str] = betterproto.string_field(2, optional=True, group="_host")
    port: Optional[int] = betterproto.int32_field(3, optional=True, group="_port")
    db: Optional[int] = betterproto.int32_field(4, optional=True, group="_db")
    username: Optional[str] = betterproto.string_field(
        5, optional=True, group="_username"
    )
    password: Optional[str] = betterproto.string_field(
        6, optional=True, group="_password"
    )
    ttl: Optional[int] = betterproto.int32_field(7, optional=True, group="_ttl")


@dataclass(eq=False, repr=False)
class EntitlementFallback(betterproto.Message):
    boolean: "BooleanEntitlementFallback" = betterproto.message_field(
        1, group="fallback"
    )
    numeric: "NumericEntitlementFallback" = betterproto.message_field(
        2, group="fallback"
    )
    metered: "MeteredEntitlementFallback" = betterproto.message_field(
        3, group="fallback"
    )


@dataclass(eq=False, repr=False)
class ApiConfig(betterproto.Message):
    api_key: str = betterproto.string_field(1)
    api_url: Optional[str] = betterproto.string_field(
        2, optional=True, group="_api_url"
    )
    edge_enabled: Optional[bool] = betterproto.bool_field(
        3, optional=True, group="_edge_enabled"
    )
    edge_api_url: Optional[str] = betterproto.string_field(
        4, optional=True, group="_edge_api_url"
    )


@dataclass(eq=False, repr=False)
class LocalSidecarConfig(betterproto.Message):
    ws_enabled: Optional[bool] = betterproto.bool_field(
        5, optional=True, group="_ws_enabled"
    )
    ws_url: Optional[str] = betterproto.string_field(6, optional=True, group="_ws_url")
    redis: Optional["RedisOptions"] = betterproto.message_field(
        7, optional=True, group="_redis"
    )
    entitlements_fallback: Dict[str, "EntitlementFallback"] = betterproto.map_field(
        8, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    cache_max_size_bytes: Optional[int] = betterproto.int64_field(
        9, optional=True, group="_cache_max_size_bytes"
    )


@dataclass(eq=False, repr=False)
class ReportUsageRequest(betterproto.Message):
    customer_id: str = betterproto.string_field(1)
    resource_id: Optional[str] = betterproto.string_field(
        2, optional=True, group="_resource_id"
    )
    feature_id: str = betterproto.string_field(3)
    value: float = betterproto.double_field(4)
    update_behavior: Optional["UsageUpdateBehavior"] = betterproto.enum_field(
        5, optional=True, group="_update_behavior"
    )


@dataclass(eq=False, repr=False)
class EventDimensionValue(betterproto.Message):
    string_value: str = betterproto.string_field(1, group="value")
    number_value: float = betterproto.double_field(2, group="value")
    boolean_value: bool = betterproto.bool_field(3, group="value")


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    event_name: str = betterproto.string_field(1)
    customer_id: str = betterproto.string_field(2)
    idempotency_key: str = betterproto.string_field(3)
    resource_id: Optional[str] = betterproto.string_field(
        4, optional=True, group="_resource_id"
    )
    dimensions: Dict[str, "EventDimensionValue"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    timestamp: Optional[datetime] = betterproto.message_field(
        6, optional=True, group="_timestamp"
    )


@dataclass(eq=False, repr=False)
class ReportUsageResponse(betterproto.Message):
    measurement_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ReportEventsRequest(betterproto.Message):
    events: List["Event"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ReloadEntitlementsRequest(betterproto.Message):
    customer_id: str = betterproto.string_field(1)
    resource_id: Optional[str] = betterproto.string_field(
        2, optional=True, group="_resource_id"
    )


@dataclass(eq=False, repr=False)
class ReloadEntitlementsResponse(betterproto.Message):
    entitled_entity_exists: bool = betterproto.bool_field(1)


class SidecarServiceStub(betterproto.ServiceStub):
    async def get_entitlements(
        self,
        get_entitlements_request: "GetEntitlementsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetEntitlementsResponse":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/GetEntitlements",
            get_entitlements_request,
            GetEntitlementsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_boolean_entitlement(
        self,
        get_boolean_entitlement_request: "GetBooleanEntitlementRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetBooleanEntitlementResponse":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/GetBooleanEntitlement",
            get_boolean_entitlement_request,
            GetBooleanEntitlementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_numeric_entitlement(
        self,
        get_numeric_entitlement_request: "GetNumericEntitlementRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetNumericEntitlementResponse":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/GetNumericEntitlement",
            get_numeric_entitlement_request,
            GetNumericEntitlementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_metered_entitlement(
        self,
        get_metered_entitlement_request: "GetMeteredEntitlementRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetMeteredEntitlementResponse":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/GetMeteredEntitlement",
            get_metered_entitlement_request,
            GetMeteredEntitlementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def report_usage(
        self,
        report_usage_request: "ReportUsageRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ReportUsageResponse":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/ReportUsage",
            report_usage_request,
            ReportUsageResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def report_events(
        self,
        report_events_request: "ReportEventsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "betterproto_lib_google_protobuf.Empty":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/ReportEvents",
            report_events_request,
            betterproto_lib_google_protobuf.Empty,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def reload_entitlements(
        self,
        reload_entitlements_request: "ReloadEntitlementsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ReloadEntitlementsResponse":
        return await self._unary_unary(
            "/stigg.sidecar.v1.SidecarService/ReloadEntitlements",
            reload_entitlements_request,
            ReloadEntitlementsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class SidecarServiceBase(ServiceBase):
    async def get_entitlements(
        self, get_entitlements_request: "GetEntitlementsRequest"
    ) -> "GetEntitlementsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_boolean_entitlement(
        self, get_boolean_entitlement_request: "GetBooleanEntitlementRequest"
    ) -> "GetBooleanEntitlementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_numeric_entitlement(
        self, get_numeric_entitlement_request: "GetNumericEntitlementRequest"
    ) -> "GetNumericEntitlementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_metered_entitlement(
        self, get_metered_entitlement_request: "GetMeteredEntitlementRequest"
    ) -> "GetMeteredEntitlementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def report_usage(
        self, report_usage_request: "ReportUsageRequest"
    ) -> "ReportUsageResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def report_events(
        self, report_events_request: "ReportEventsRequest"
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reload_entitlements(
        self, reload_entitlements_request: "ReloadEntitlementsRequest"
    ) -> "ReloadEntitlementsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_entitlements(
        self,
        stream: "grpclib.server.Stream[GetEntitlementsRequest, GetEntitlementsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_entitlements(request)
        await stream.send_message(response)

    async def __rpc_get_boolean_entitlement(
        self,
        stream: "grpclib.server.Stream[GetBooleanEntitlementRequest, GetBooleanEntitlementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_boolean_entitlement(request)
        await stream.send_message(response)

    async def __rpc_get_numeric_entitlement(
        self,
        stream: "grpclib.server.Stream[GetNumericEntitlementRequest, GetNumericEntitlementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_numeric_entitlement(request)
        await stream.send_message(response)

    async def __rpc_get_metered_entitlement(
        self,
        stream: "grpclib.server.Stream[GetMeteredEntitlementRequest, GetMeteredEntitlementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_metered_entitlement(request)
        await stream.send_message(response)

    async def __rpc_report_usage(
        self, stream: "grpclib.server.Stream[ReportUsageRequest, ReportUsageResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.report_usage(request)
        await stream.send_message(response)

    async def __rpc_report_events(
        self,
        stream: "grpclib.server.Stream[ReportEventsRequest, betterproto_lib_google_protobuf.Empty]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.report_events(request)
        await stream.send_message(response)

    async def __rpc_reload_entitlements(
        self,
        stream: "grpclib.server.Stream[ReloadEntitlementsRequest, ReloadEntitlementsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.reload_entitlements(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/stigg.sidecar.v1.SidecarService/GetEntitlements": grpclib.const.Handler(
                self.__rpc_get_entitlements,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetEntitlementsRequest,
                GetEntitlementsResponse,
            ),
            "/stigg.sidecar.v1.SidecarService/GetBooleanEntitlement": grpclib.const.Handler(
                self.__rpc_get_boolean_entitlement,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetBooleanEntitlementRequest,
                GetBooleanEntitlementResponse,
            ),
            "/stigg.sidecar.v1.SidecarService/GetNumericEntitlement": grpclib.const.Handler(
                self.__rpc_get_numeric_entitlement,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetNumericEntitlementRequest,
                GetNumericEntitlementResponse,
            ),
            "/stigg.sidecar.v1.SidecarService/GetMeteredEntitlement": grpclib.const.Handler(
                self.__rpc_get_metered_entitlement,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMeteredEntitlementRequest,
                GetMeteredEntitlementResponse,
            ),
            "/stigg.sidecar.v1.SidecarService/ReportUsage": grpclib.const.Handler(
                self.__rpc_report_usage,
                grpclib.const.Cardinality.UNARY_UNARY,
                ReportUsageRequest,
                ReportUsageResponse,
            ),
            "/stigg.sidecar.v1.SidecarService/ReportEvents": grpclib.const.Handler(
                self.__rpc_report_events,
                grpclib.const.Cardinality.UNARY_UNARY,
                ReportEventsRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/stigg.sidecar.v1.SidecarService/ReloadEntitlements": grpclib.const.Handler(
                self.__rpc_reload_entitlements,
                grpclib.const.Cardinality.UNARY_UNARY,
                ReloadEntitlementsRequest,
                ReloadEntitlementsResponse,
            ),
        }
