"""
    PocketSmith

    The public PocketSmith API  # noqa: E501

    The version of the OpenAPI document: 2.0+0.3.2
    Contact: api@pocketsmith.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pocketsmith.api_client import ApiClient, Endpoint as _Endpoint
from pocketsmith.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pocketsmith.model.inline_object7 import InlineObject7
from pocketsmith.model.inline_object8 import InlineObject8
from pocketsmith.model.inline_response403 import InlineResponse403
from pocketsmith.model.transaction import Transaction


class TransactionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_transaction_account_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/transaction_accounts/{id}/transactions',
                'operation_id': 'create_transaction_account_transaction',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'inline_object7',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'inline_object7':
                        (InlineObject7,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'inline_object7': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/transactions/{id}',
                'operation_id': 'get_transaction',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_transactions_endpoint = _Endpoint(
            settings={
                'response_type': ([Transaction],),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/accounts/{id}/transactions',
                'operation_id': 'list_account_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'start_date',
                    'end_date',
                    'only_uncategorised',
                    'type',
                    'page',
                    'per_page',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                    'page',
                    'per_page',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                    ('per_page',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 10,
                    },
                },
                'allowed_values': {
                    ('type',): {

                        "DEBIT": "debit",
                        "CREDIT": "credit"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'only_uncategorised':
                        (int,),
                    'type':
                        (str,),
                    'page':
                        (int,),
                    'per_page':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'only_uncategorised': 'only_uncategorised',
                    'type': 'type',
                    'page': 'page',
                    'per_page': 'per_page',
                },
                'location_map': {
                    'id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'only_uncategorised': 'query',
                    'type': 'query',
                    'page': 'query',
                    'per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transaction_account_transactions_endpoint = _Endpoint(
            settings={
                'response_type': ([Transaction],),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/transaction_accounts/{id}/transactions',
                'operation_id': 'list_transaction_account_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'start_date',
                    'end_date',
                    'only_uncategorised',
                    'type',
                    'search',
                    'page',
                    'per_page',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                    'page',
                    'per_page',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                    ('per_page',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 10,
                    },
                },
                'allowed_values': {
                    ('type',): {

                        "DEBIT": "debit",
                        "CREDIT": "credit"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'only_uncategorised':
                        (int,),
                    'type':
                        (str,),
                    'search':
                        (str,),
                    'page':
                        (int,),
                    'per_page':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'only_uncategorised': 'only_uncategorised',
                    'type': 'type',
                    'search': 'search',
                    'page': 'page',
                    'per_page': 'per_page',
                },
                'location_map': {
                    'id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'only_uncategorised': 'query',
                    'type': 'query',
                    'search': 'query',
                    'page': 'query',
                    'per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_endpoint = _Endpoint(
            settings={
                'response_type': ([Transaction],),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/users/{id}/transactions',
                'operation_id': 'list_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'start_date',
                    'end_date',
                    'only_uncategorised',
                    'type',
                    'page',
                    'per_page',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                    'page',
                    'per_page',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                    ('per_page',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 10,
                    },
                },
                'allowed_values': {
                    ('type',): {

                        "DEBIT": "debit",
                        "CREDIT": "credit"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'only_uncategorised':
                        (int,),
                    'type':
                        (str,),
                    'page':
                        (int,),
                    'per_page':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'only_uncategorised': 'only_uncategorised',
                    'type': 'type',
                    'page': 'page',
                    'per_page': 'per_page',
                },
                'location_map': {
                    'id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'only_uncategorised': 'query',
                    'type': 'query',
                    'page': 'query',
                    'per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/transactions/{id}',
                'operation_id': 'update_transaction',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'labels',
                    'inline_object8',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'labels':
                        (str,),
                    'inline_object8':
                        (InlineObject8,),
                },
                'attribute_map': {
                    'id': 'id',
                    'labels': 'labels',
                },
                'location_map': {
                    'id': 'path',
                    'labels': 'query',
                    'inline_object8': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_transaction_account_transaction(
        self,
        id,
        **kwargs
    ):
        """Create a transaction in transaction account  # noqa: E501

        Creates a transaction in a transaction account by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transaction_account_transaction(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the transaction account.

        Keyword Args:
            inline_object7 (InlineObject7): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Transaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.create_transaction_account_transaction_endpoint.call_with_http_info(**kwargs)

    def get_transaction(
        self,
        id,
        **kwargs
    ):
        """Get a transaction  # noqa: E501

        Gets a transaction by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the transaction.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Transaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.get_transaction_endpoint.call_with_http_info(**kwargs)

    def list_account_transactions(
        self,
        id,
        **kwargs
    ):
        """List transactions in account  # noqa: E501

        Lists transactions belonging to an account by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_transactions(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the account.

        Keyword Args:
            start_date (str): Return only transactions on or after this date. Required if end_date is provided. If not provided, defaults to the furtherest date allowed by the user's subscription.. [optional]
            end_date (str): Return transactions that fall on or before this date. Required if start_date is provided. If not provided, defaults to today's date.. [optional]
            only_uncategorised (int): If set, will return only uncategorised results.. [optional]
            type (str): Only return transactions of this type.. [optional]
            page (int): Choose a particular page of the results.. [optional] if omitted the server will use the default value of 1
            per_page (int): Number of records to return in a single response.. [optional] if omitted the server will use the default value of 30
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Transaction]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.list_account_transactions_endpoint.call_with_http_info(**kwargs)

    def list_transaction_account_transactions(
        self,
        id,
        **kwargs
    ):
        """List transactions in transaction account  # noqa: E501

        Lists transactions belonging to a transaction account by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_account_transactions(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the transaction account.

        Keyword Args:
            start_date (str): Return only transactions on or after this date. Required if `end_date` is provided. If not provided, defaults to the furtherest date allowed by the user's subscription.. [optional]
            end_date (str): Return transactions that fall on or before this date. Required if `start_date` is provided. If not provided, defaults to today's date.. [optional]
            only_uncategorised (int): If set, will return only uncategorised results.. [optional]
            type (str): Only return transactions of this type.. [optional]
            search (str): Only return transactions matching these search terms. [optional]
            page (int): Choose a particular page of the results.. [optional] if omitted the server will use the default value of 1
            per_page (int): Number of records to return in a single response.. [optional] if omitted the server will use the default value of 30
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Transaction]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.list_transaction_account_transactions_endpoint.call_with_http_info(**kwargs)

    def list_transactions(
        self,
        id,
        **kwargs
    ):
        """List transactions in user  # noqa: E501

        Lists transactions belonging to a user by their ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the account.

        Keyword Args:
            start_date (str): Return only transactions on or after this date. Required if end_date is provided. If not provided, defaults to the furtherest date allowed by the user's subscription.. [optional]
            end_date (str): Return transactions that fall on or before this date. Required if start_date is provided. If not provided, defaults to today's date.. [optional]
            only_uncategorised (int): If set, will return only uncategorised results.. [optional]
            type (str): Only return transactions of this type.. [optional]
            page (int): Choose a particular page of the results.. [optional] if omitted the server will use the default value of 1
            per_page (int): Number of records to return in a single response.. [optional] if omitted the server will use the default value of 30
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Transaction]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.list_transactions_endpoint.call_with_http_info(**kwargs)

    def update_transaction(
        self,
        id,
        **kwargs
    ):
        """Update a transaction  # noqa: E501

        Updates a transaction by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the transaction.

        Keyword Args:
            labels (str): A new set of labels for the transaction.. [optional]
            inline_object8 (InlineObject8): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Transaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.update_transaction_endpoint.call_with_http_info(**kwargs)

