from threading import Timer
import time
from jellyfin_accounts import config, data_store
from jellyfin_accounts.web_api import checkInvite


class Repeat:
    def __init__(self, interval, function, *args, **kwargs):
        self._timer = None
        self.interval = interval
        self.function = function
        self.args = args
        self.kwargs = kwargs
        self.is_running = False
        self.next_call = time.time()
        self.start()

    def _run(self):
        self.is_running = False
        self.start()
        self.function(*self.args, **self.kwargs)

    def start(self):
        if not self.is_running:
            self.next_call += self.interval
            self._timer = Timer(self.next_call - time.time(), self._run)
            self._timer.start()
            self.is_running = True

    def stop(self):
        self._timer.cancel()
        self.is_running = False


def checkInvites():
    invites = dict(data_store.invites)
    # checkInvite already loops over everything, no point running it multiple times.
    if len(invites) != 0:
        checkInvite(list(invites.keys())[0])


if config.getboolean("notifications", "enabled"):
    inviteDaemon = Repeat(60, checkInvites)
