"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AWS_SERVICES = exports.AWS_REGIONS = void 0;
/**
 * The names of all (known) AWS regions
 *
 * Not in the list ==> no built-in data for that region.
 */
exports.AWS_REGIONS = [
    'af-south-1',
    'ap-east-1',
    'ap-northeast-1',
    'ap-northeast-2',
    'ap-northeast-3',
    'ap-south-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-north-1',
    'eu-south-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'me-south-1',
    'sa-east-1',
    'us-east-1',
    'us-east-2',
    'us-gov-east-1',
    'us-gov-west-1',
    'us-iso-east-1',
    'us-isob-east-1',
    'us-west-1',
    'us-west-2',
].sort();
/**
 * Possibly non-exaustive list of all service names, used to locate service principals.
 *
 * Not in the list ==> default service principal mappings.
 */
exports.AWS_SERVICES = [
    'application-autoscaling',
    'autoscaling',
    'codedeploy',
    'ec2',
    'events',
    'lambda',
    'logs',
    's3',
    'sns',
    'sqs',
    'states',
].sort();
//# sourceMappingURL=data:application/json;base64,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