/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IntList;
import com.android.dx.util.LabeledItem;
import java.util.Arrays;

public class LabeledList
extends FixedSizeList {
    private final IntList labelToIndex;

    public LabeledList(int n) {
        super(n);
        this.labelToIndex = new IntList(n);
    }

    public LabeledList(LabeledList labeledList) {
        super(labeledList.size());
        this.labelToIndex = labeledList.labelToIndex.mutableCopy();
        int n = labeledList.size();
        for (int i = 0; i < n; ++i) {
            Object object = labeledList.get0(i);
            if (object == null) continue;
            this.set0(i, object);
        }
    }

    public final int getMaxLabel() {
        int n;
        int n2 = this.labelToIndex.size();
        for (n = n2 - 1; n >= 0 && this.labelToIndex.get(n) < 0; --n) {
        }
        int n3 = n + 1;
        this.labelToIndex.shrink(n3);
        return n3;
    }

    private void removeLabel(int n) {
        this.labelToIndex.set(n, -1);
    }

    private void addLabelIndex(int n, int n2) {
        int n3 = this.labelToIndex.size();
        for (int i = 0; i <= n - n3; ++i) {
            this.labelToIndex.add(-1);
        }
        this.labelToIndex.set(n, n2);
    }

    public final int indexOfLabel(int n) {
        if (n >= this.labelToIndex.size()) {
            return -1;
        }
        return this.labelToIndex.get(n);
    }

    public final int[] getLabelsInOrder() {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            LabeledItem labeledItem = (LabeledItem)this.get0(i);
            if (labeledItem == null) {
                throw new NullPointerException("null at index " + i);
            }
            nArray[i] = labeledItem.getLabel();
        }
        Arrays.sort(nArray);
        return nArray;
    }

    @Override
    public void shrinkToFit() {
        super.shrinkToFit();
        this.rebuildLabelToIndex();
    }

    private void rebuildLabelToIndex() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            LabeledItem labeledItem = (LabeledItem)this.get0(i);
            if (labeledItem == null) continue;
            this.labelToIndex.set(labeledItem.getLabel(), i);
        }
    }

    protected void set(int n, LabeledItem labeledItem) {
        LabeledItem labeledItem2 = (LabeledItem)this.getOrNull0(n);
        this.set0(n, labeledItem);
        if (labeledItem2 != null) {
            this.removeLabel(labeledItem2.getLabel());
        }
        if (labeledItem != null) {
            this.addLabelIndex(labeledItem.getLabel(), n);
        }
    }
}

