/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.util.IntList;
import java.util.BitSet;

public class IdenticalBlockCombiner {
    private final RopMethod ropMethod;
    private final BasicBlockList blocks;
    private final BasicBlockList newBlocks;

    public IdenticalBlockCombiner(RopMethod ropMethod) {
        this.ropMethod = ropMethod;
        this.blocks = this.ropMethod.getBlocks();
        this.newBlocks = this.blocks.getMutableCopy();
    }

    public RopMethod process() {
        int n;
        int n2 = this.blocks.size();
        BitSet bitSet = new BitSet(this.blocks.getMaxLabel());
        for (n = 0; n < n2; ++n) {
            BasicBlock basicBlock = this.blocks.get(n);
            if (bitSet.get(basicBlock.getLabel())) continue;
            IntList intList = this.ropMethod.labelToPredecessors(basicBlock.getLabel());
            int n3 = intList.size();
            for (int i = 0; i < n3; ++i) {
                int n4 = intList.get(i);
                BasicBlock basicBlock2 = this.blocks.labelToBlock(n4);
                if (bitSet.get(n4) || basicBlock2.getSuccessors().size() > 1 || basicBlock2.getFirstInsn().getOpcode().getOpcode() == 55) continue;
                IntList intList2 = new IntList();
                for (int j = i + 1; j < n3; ++j) {
                    int n5 = intList.get(j);
                    BasicBlock basicBlock3 = this.blocks.labelToBlock(n5);
                    if (basicBlock3.getSuccessors().size() != 1 || !IdenticalBlockCombiner.compareInsns(basicBlock2, basicBlock3)) continue;
                    intList2.add(n5);
                    bitSet.set(n5);
                }
                this.combineBlocks(n4, intList2);
            }
        }
        for (n = n2 - 1; n >= 0; --n) {
            if (!bitSet.get(this.newBlocks.get(n).getLabel())) continue;
            this.newBlocks.set(n, null);
        }
        this.newBlocks.shrinkToFit();
        this.newBlocks.setImmutable();
        return new RopMethod(this.newBlocks, this.ropMethod.getFirstLabel());
    }

    private static boolean compareInsns(BasicBlock basicBlock, BasicBlock basicBlock2) {
        return basicBlock.getInsns().contentEquals(basicBlock2.getInsns());
    }

    private void combineBlocks(int n, IntList intList) {
        int n2 = intList.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = intList.get(i);
            BasicBlock basicBlock = this.blocks.labelToBlock(n3);
            IntList intList2 = this.ropMethod.labelToPredecessors(basicBlock.getLabel());
            int n4 = intList2.size();
            for (int j = 0; j < n4; ++j) {
                BasicBlock basicBlock2 = this.newBlocks.labelToBlock(intList2.get(j));
                this.replaceSucc(basicBlock2, n3, n);
            }
        }
    }

    private void replaceSucc(BasicBlock basicBlock, int n, int n2) {
        IntList intList = basicBlock.getSuccessors().mutableCopy();
        intList.set(intList.indexOf(n), n2);
        int n3 = basicBlock.getPrimarySuccessor();
        if (n3 == n) {
            n3 = n2;
        }
        intList.setImmutable();
        BasicBlock basicBlock2 = new BasicBlock(basicBlock.getLabel(), basicBlock.getInsns(), intList, n3);
        this.newBlocks.set(this.newBlocks.indexOfLabel(basicBlock.getLabel()), basicBlock2);
    }
}

