/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.Hex;
import java.util.ArrayList;
import java.util.List;

public final class PhiInsn
extends SsaInsn {
    private final int ropResultReg;
    private final ArrayList<Operand> operands = new ArrayList();
    private RegisterSpecList sources;

    public PhiInsn(RegisterSpec registerSpec, SsaBasicBlock ssaBasicBlock) {
        super(registerSpec, ssaBasicBlock);
        this.ropResultReg = registerSpec.getReg();
    }

    public PhiInsn(int n, SsaBasicBlock ssaBasicBlock) {
        super(RegisterSpec.make(n, Type.VOID), ssaBasicBlock);
        this.ropResultReg = n;
    }

    @Override
    public PhiInsn clone() {
        throw new UnsupportedOperationException("can't clone phi");
    }

    public void updateSourcesToDefinitions(SsaMethod ssaMethod) {
        for (Operand operand : this.operands) {
            RegisterSpec registerSpec = ssaMethod.getDefinitionForRegister(operand.regSpec.getReg()).getResult();
            operand.regSpec = operand.regSpec.withType(registerSpec.getType());
        }
        this.sources = null;
    }

    public void changeResultType(TypeBearer typeBearer, LocalItem localItem) {
        this.setResult(RegisterSpec.makeLocalOptional(this.getResult().getReg(), typeBearer, localItem));
    }

    public int getRopResultReg() {
        return this.ropResultReg;
    }

    public void addPhiOperand(RegisterSpec registerSpec, SsaBasicBlock ssaBasicBlock) {
        this.operands.add(new Operand(registerSpec, ssaBasicBlock.getIndex(), ssaBasicBlock.getRopLabel()));
        this.sources = null;
    }

    public void removePhiRegister(RegisterSpec registerSpec) {
        ArrayList<Operand> arrayList = new ArrayList<Operand>();
        for (Operand operand : this.operands) {
            if (operand.regSpec.getReg() != registerSpec.getReg()) continue;
            arrayList.add(operand);
        }
        this.operands.removeAll(arrayList);
        this.sources = null;
    }

    public int predBlockIndexForSourcesIndex(int n) {
        return this.operands.get((int)n).blockIndex;
    }

    @Override
    public Rop getOpcode() {
        return null;
    }

    @Override
    public Insn getOriginalRopInsn() {
        return null;
    }

    @Override
    public boolean canThrow() {
        return false;
    }

    @Override
    public RegisterSpecList getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        if (this.operands.size() == 0) {
            return RegisterSpecList.EMPTY;
        }
        int n = this.operands.size();
        this.sources = new RegisterSpecList(n);
        for (int i = 0; i < n; ++i) {
            Operand operand = this.operands.get(i);
            this.sources.set(i, operand.regSpec);
        }
        this.sources.setImmutable();
        return this.sources;
    }

    @Override
    public boolean isRegASource(int n) {
        for (Operand operand : this.operands) {
            if (operand.regSpec.getReg() != n) continue;
            return true;
        }
        return false;
    }

    public boolean areAllOperandsEqual() {
        if (this.operands.size() == 0) {
            return true;
        }
        int n = this.operands.get((int)0).regSpec.getReg();
        for (Operand operand : this.operands) {
            if (n == operand.regSpec.getReg()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void mapSourceRegisters(RegisterMapper registerMapper) {
        for (Operand operand : this.operands) {
            RegisterSpec registerSpec = operand.regSpec;
            operand.regSpec = registerMapper.map(registerSpec);
            if (registerSpec == operand.regSpec) continue;
            this.getBlock().getParent().onSourceChanged(this, registerSpec, operand.regSpec);
        }
        this.sources = null;
    }

    @Override
    public Insn toRopInsn() {
        throw new IllegalArgumentException("Cannot convert phi insns to rop form");
    }

    public List<SsaBasicBlock> predBlocksForReg(int n, SsaMethod ssaMethod) {
        ArrayList<SsaBasicBlock> arrayList = new ArrayList<SsaBasicBlock>();
        for (Operand operand : this.operands) {
            if (operand.regSpec.getReg() != n) continue;
            arrayList.add(ssaMethod.getBlocks().get(operand.blockIndex));
        }
        return arrayList;
    }

    @Override
    public boolean isPhiOrMove() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        return Optimizer.getPreserveLocals() && this.getLocalAssignment() != null;
    }

    @Override
    public void accept(SsaInsn.Visitor visitor) {
        visitor.visitPhiInsn(this);
    }

    @Override
    public String toHuman() {
        return this.toHumanWithInline(null);
    }

    protected final String toHumanWithInline(String string) {
        RegisterSpec registerSpec;
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(SourcePosition.NO_INFO);
        stringBuffer.append(": phi");
        if (string != null) {
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        if ((registerSpec = this.getResult()) == null) {
            stringBuffer.append(" .");
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(registerSpec.toHuman());
        }
        stringBuffer.append(" <-");
        int n = this.getSources().size();
        if (n == 0) {
            stringBuffer.append(" .");
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(this.sources.get(i).toHuman() + "[b=" + Hex.u2(this.operands.get((int)i).ropLabel) + "]");
            }
        }
        return stringBuffer.toString();
    }

    public static interface Visitor {
        public void visitPhiInsn(PhiInsn var1);
    }

    private static class Operand {
        public RegisterSpec regSpec;
        public final int blockIndex;
        public final int ropLabel;

        public Operand(RegisterSpec registerSpec, int n, int n2) {
            this.regSpec = registerSpec;
            this.blockIndex = n;
            this.ropLabel = n2;
        }
    }
}

