/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.MutabilityControl;
import java.util.ArrayList;
import java.util.HashMap;

public class LocalVariableInfo
extends MutabilityControl {
    private final int regCount;
    private final RegisterSpecSet emptySet;
    private final RegisterSpecSet[] blockStarts;
    private final HashMap<SsaInsn, RegisterSpec> insnAssignments;

    public LocalVariableInfo(SsaMethod ssaMethod) {
        if (ssaMethod == null) {
            throw new NullPointerException("method == null");
        }
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        this.regCount = ssaMethod.getRegCount();
        this.emptySet = new RegisterSpecSet(this.regCount);
        this.blockStarts = new RegisterSpecSet[arrayList.size()];
        this.insnAssignments = new HashMap();
        this.emptySet.setImmutable();
    }

    public void setStarts(int n, RegisterSpecSet registerSpecSet) {
        this.throwIfImmutable();
        if (registerSpecSet == null) {
            throw new NullPointerException("specs == null");
        }
        try {
            this.blockStarts[n] = registerSpecSet;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bogus index");
        }
    }

    public boolean mergeStarts(int n, RegisterSpecSet registerSpecSet) {
        RegisterSpecSet registerSpecSet2 = this.getStarts0(n);
        boolean bl = false;
        if (registerSpecSet2 == null) {
            this.setStarts(n, registerSpecSet);
            return true;
        }
        RegisterSpecSet registerSpecSet3 = registerSpecSet2.mutableCopy();
        registerSpecSet3.intersect(registerSpecSet, true);
        if (registerSpecSet2.equals(registerSpecSet3)) {
            return false;
        }
        registerSpecSet3.setImmutable();
        this.setStarts(n, registerSpecSet3);
        return true;
    }

    public RegisterSpecSet getStarts(int n) {
        RegisterSpecSet registerSpecSet = this.getStarts0(n);
        return registerSpecSet != null ? registerSpecSet : this.emptySet;
    }

    public RegisterSpecSet getStarts(SsaBasicBlock ssaBasicBlock) {
        return this.getStarts(ssaBasicBlock.getIndex());
    }

    public RegisterSpecSet mutableCopyOfStarts(int n) {
        RegisterSpecSet registerSpecSet = this.getStarts0(n);
        return registerSpecSet != null ? registerSpecSet.mutableCopy() : new RegisterSpecSet(this.regCount);
    }

    public void addAssignment(SsaInsn ssaInsn, RegisterSpec registerSpec) {
        this.throwIfImmutable();
        if (ssaInsn == null) {
            throw new NullPointerException("insn == null");
        }
        if (registerSpec == null) {
            throw new NullPointerException("spec == null");
        }
        this.insnAssignments.put(ssaInsn, registerSpec);
    }

    public RegisterSpec getAssignment(SsaInsn ssaInsn) {
        return this.insnAssignments.get(ssaInsn);
    }

    public int getAssignmentCount() {
        return this.insnAssignments.size();
    }

    public void debugDump() {
        for (int i = 0; i < this.blockStarts.length; ++i) {
            if (this.blockStarts[i] == null) continue;
            if (this.blockStarts[i] == this.emptySet) {
                System.out.printf("%04x: empty set\n", i);
                continue;
            }
            System.out.printf("%04x: %s\n", i, this.blockStarts[i]);
        }
    }

    private RegisterSpecSet getStarts0(int n) {
        try {
            return this.blockStarts[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bogus index");
        }
    }
}

