/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.util.IntList;

public class BasicRegisterMapper
extends RegisterMapper {
    private IntList oldToNew;
    private int runningCountNewRegisters;

    public BasicRegisterMapper(int n) {
        this.oldToNew = new IntList(n);
    }

    @Override
    public int getNewRegisterCount() {
        return this.runningCountNewRegisters;
    }

    @Override
    public RegisterSpec map(RegisterSpec registerSpec) {
        int n;
        if (registerSpec == null) {
            return null;
        }
        try {
            n = this.oldToNew.get(registerSpec.getReg());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = -1;
        }
        if (n < 0) {
            throw new RuntimeException("no mapping specified for register");
        }
        return registerSpec.withReg(n);
    }

    public int oldToNew(int n) {
        if (n >= this.oldToNew.size()) {
            return -1;
        }
        return this.oldToNew.get(n);
    }

    public String toHuman() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Old\tNew\n");
        int n = this.oldToNew.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(i);
            stringBuilder.append('\t');
            stringBuilder.append(this.oldToNew.get(i));
            stringBuilder.append('\n');
        }
        stringBuilder.append("new reg count:");
        stringBuilder.append(this.runningCountNewRegisters);
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public void addMapping(int n, int n2, int n3) {
        if (n >= this.oldToNew.size()) {
            for (int i = n - this.oldToNew.size(); i >= 0; --i) {
                this.oldToNew.add(-1);
            }
        }
        this.oldToNew.set(n, n2);
        if (this.runningCountNewRegisters < n2 + n3) {
            this.runningCountNewRegisters = n2 + n3;
        }
    }
}

