/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.type;

import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.FixedSizeList;

public final class StdTypeList
extends FixedSizeList
implements TypeList {
    public static final StdTypeList EMPTY = new StdTypeList(0);
    public static final StdTypeList INT = StdTypeList.make(Type.INT);
    public static final StdTypeList LONG = StdTypeList.make(Type.LONG);
    public static final StdTypeList FLOAT = StdTypeList.make(Type.FLOAT);
    public static final StdTypeList DOUBLE = StdTypeList.make(Type.DOUBLE);
    public static final StdTypeList OBJECT = StdTypeList.make(Type.OBJECT);
    public static final StdTypeList RETURN_ADDRESS = StdTypeList.make(Type.RETURN_ADDRESS);
    public static final StdTypeList THROWABLE = StdTypeList.make(Type.THROWABLE);
    public static final StdTypeList INT_INT = StdTypeList.make(Type.INT, Type.INT);
    public static final StdTypeList LONG_LONG = StdTypeList.make(Type.LONG, Type.LONG);
    public static final StdTypeList FLOAT_FLOAT = StdTypeList.make(Type.FLOAT, Type.FLOAT);
    public static final StdTypeList DOUBLE_DOUBLE = StdTypeList.make(Type.DOUBLE, Type.DOUBLE);
    public static final StdTypeList OBJECT_OBJECT = StdTypeList.make(Type.OBJECT, Type.OBJECT);
    public static final StdTypeList INT_OBJECT = StdTypeList.make(Type.INT, Type.OBJECT);
    public static final StdTypeList LONG_OBJECT = StdTypeList.make(Type.LONG, Type.OBJECT);
    public static final StdTypeList FLOAT_OBJECT = StdTypeList.make(Type.FLOAT, Type.OBJECT);
    public static final StdTypeList DOUBLE_OBJECT = StdTypeList.make(Type.DOUBLE, Type.OBJECT);
    public static final StdTypeList LONG_INT = StdTypeList.make(Type.LONG, Type.INT);
    public static final StdTypeList INTARR_INT = StdTypeList.make(Type.INT_ARRAY, Type.INT);
    public static final StdTypeList LONGARR_INT = StdTypeList.make(Type.LONG_ARRAY, Type.INT);
    public static final StdTypeList FLOATARR_INT = StdTypeList.make(Type.FLOAT_ARRAY, Type.INT);
    public static final StdTypeList DOUBLEARR_INT = StdTypeList.make(Type.DOUBLE_ARRAY, Type.INT);
    public static final StdTypeList OBJECTARR_INT = StdTypeList.make(Type.OBJECT_ARRAY, Type.INT);
    public static final StdTypeList BOOLEANARR_INT = StdTypeList.make(Type.BOOLEAN_ARRAY, Type.INT);
    public static final StdTypeList BYTEARR_INT = StdTypeList.make(Type.BYTE_ARRAY, Type.INT);
    public static final StdTypeList CHARARR_INT = StdTypeList.make(Type.CHAR_ARRAY, Type.INT);
    public static final StdTypeList SHORTARR_INT = StdTypeList.make(Type.SHORT_ARRAY, Type.INT);
    public static final StdTypeList INT_INTARR_INT = StdTypeList.make(Type.INT, Type.INT_ARRAY, Type.INT);
    public static final StdTypeList LONG_LONGARR_INT = StdTypeList.make(Type.LONG, Type.LONG_ARRAY, Type.INT);
    public static final StdTypeList FLOAT_FLOATARR_INT = StdTypeList.make(Type.FLOAT, Type.FLOAT_ARRAY, Type.INT);
    public static final StdTypeList DOUBLE_DOUBLEARR_INT = StdTypeList.make(Type.DOUBLE, Type.DOUBLE_ARRAY, Type.INT);
    public static final StdTypeList OBJECT_OBJECTARR_INT = StdTypeList.make(Type.OBJECT, Type.OBJECT_ARRAY, Type.INT);
    public static final StdTypeList INT_BOOLEANARR_INT = StdTypeList.make(Type.INT, Type.BOOLEAN_ARRAY, Type.INT);
    public static final StdTypeList INT_BYTEARR_INT = StdTypeList.make(Type.INT, Type.BYTE_ARRAY, Type.INT);
    public static final StdTypeList INT_CHARARR_INT = StdTypeList.make(Type.INT, Type.CHAR_ARRAY, Type.INT);
    public static final StdTypeList INT_SHORTARR_INT = StdTypeList.make(Type.INT, Type.SHORT_ARRAY, Type.INT);

    public static StdTypeList make(Type type) {
        StdTypeList stdTypeList = new StdTypeList(1);
        stdTypeList.set(0, type);
        return stdTypeList;
    }

    public static StdTypeList make(Type type, Type type2) {
        StdTypeList stdTypeList = new StdTypeList(2);
        stdTypeList.set(0, type);
        stdTypeList.set(1, type2);
        return stdTypeList;
    }

    public static StdTypeList make(Type type, Type type2, Type type3) {
        StdTypeList stdTypeList = new StdTypeList(3);
        stdTypeList.set(0, type);
        stdTypeList.set(1, type2);
        stdTypeList.set(2, type3);
        return stdTypeList;
    }

    public static StdTypeList make(Type type, Type type2, Type type3, Type type4) {
        StdTypeList stdTypeList = new StdTypeList(4);
        stdTypeList.set(0, type);
        stdTypeList.set(1, type2);
        stdTypeList.set(2, type3);
        stdTypeList.set(3, type4);
        return stdTypeList;
    }

    public static String toHuman(TypeList typeList) {
        int n = typeList.size();
        if (n == 0) {
            return "<empty>";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(typeList.getType(i).toHuman());
        }
        return stringBuffer.toString();
    }

    public static int hashContents(TypeList typeList) {
        int n = typeList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + typeList.getType(i).hashCode();
        }
        return n2;
    }

    public static boolean equalContents(TypeList typeList, TypeList typeList2) {
        int n = typeList.size();
        if (typeList2.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (typeList.getType(i).equals(typeList2.getType(i))) continue;
            return false;
        }
        return true;
    }

    public static int compareContents(TypeList typeList, TypeList typeList2) {
        int n = typeList.size();
        int n2 = typeList2.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4 = typeList.getType(i).compareTo(typeList2.getType(i));
            if (n4 == 0) continue;
            return n4;
        }
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    public StdTypeList(int n) {
        super(n);
    }

    @Override
    public Type getType(int n) {
        return this.get(n);
    }

    @Override
    public int getWordCount() {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.get(i).getCategory();
        }
        return n2;
    }

    @Override
    public TypeList withAddedType(Type type) {
        int n = this.size();
        StdTypeList stdTypeList = new StdTypeList(n + 1);
        for (int i = 0; i < n; ++i) {
            stdTypeList.set0(i, this.get0(i));
        }
        stdTypeList.set(n, type);
        stdTypeList.setImmutable();
        return stdTypeList;
    }

    public Type get(int n) {
        return (Type)this.get0(n);
    }

    public void set(int n, Type type) {
        this.set0(n, type);
    }

    public StdTypeList withFirst(Type type) {
        int n = this.size();
        StdTypeList stdTypeList = new StdTypeList(n + 1);
        stdTypeList.set0(0, type);
        for (int i = 0; i < n; ++i) {
            stdTypeList.set0(i + 1, this.getOrNull0(i));
        }
        return stdTypeList;
    }
}

