/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Type;

public final class CstNat
extends Constant {
    public static final CstNat PRIMITIVE_TYPE_NAT = new CstNat(new CstString("TYPE"), new CstString("Ljava/lang/Class;"));
    private final CstString name;
    private final CstString descriptor;

    public CstNat(CstString cstString, CstString cstString2) {
        if (cstString == null) {
            throw new NullPointerException("name == null");
        }
        if (cstString2 == null) {
            throw new NullPointerException("descriptor == null");
        }
        this.name = cstString;
        this.descriptor = cstString2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CstNat)) {
            return false;
        }
        CstNat cstNat = (CstNat)object;
        return this.name.equals(cstNat.name) && this.descriptor.equals(cstNat.descriptor);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 ^ this.descriptor.hashCode();
    }

    @Override
    protected int compareTo0(Constant constant) {
        CstNat cstNat = (CstNat)constant;
        int n = this.name.compareTo(cstNat.name);
        if (n != 0) {
            return n;
        }
        return this.descriptor.compareTo(cstNat.descriptor);
    }

    public String toString() {
        return "nat{" + this.toHuman() + '}';
    }

    @Override
    public String typeName() {
        return "nat";
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    public CstString getName() {
        return this.name;
    }

    public CstString getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String toHuman() {
        return this.name.toHuman() + ':' + this.descriptor.toHuman();
    }

    public Type getFieldType() {
        return Type.intern(this.descriptor.getString());
    }

    public final boolean isInstanceInit() {
        return this.name.getString().equals("<init>");
    }

    public final boolean isClassInit() {
        return this.name.getString().equals("<clinit>");
    }
}

