/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.util.MutabilityControl;
import java.util.HashMap;

public final class LocalVariableInfo
extends MutabilityControl {
    private final int regCount;
    private final RegisterSpecSet emptySet;
    private final RegisterSpecSet[] blockStarts;
    private final HashMap<Insn, RegisterSpec> insnAssignments;

    public LocalVariableInfo(RopMethod ropMethod) {
        if (ropMethod == null) {
            throw new NullPointerException("method == null");
        }
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n = basicBlockList.getMaxLabel();
        this.regCount = basicBlockList.getRegCount();
        this.emptySet = new RegisterSpecSet(this.regCount);
        this.blockStarts = new RegisterSpecSet[n];
        this.insnAssignments = new HashMap(basicBlockList.getInstructionCount());
        this.emptySet.setImmutable();
    }

    public void setStarts(int n, RegisterSpecSet registerSpecSet) {
        this.throwIfImmutable();
        if (registerSpecSet == null) {
            throw new NullPointerException("specs == null");
        }
        try {
            this.blockStarts[n] = registerSpecSet;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bogus label");
        }
    }

    public boolean mergeStarts(int n, RegisterSpecSet registerSpecSet) {
        RegisterSpecSet registerSpecSet2 = this.getStarts0(n);
        boolean bl = false;
        if (registerSpecSet2 == null) {
            this.setStarts(n, registerSpecSet);
            return true;
        }
        RegisterSpecSet registerSpecSet3 = registerSpecSet2.mutableCopy();
        if (registerSpecSet2.size() != 0) {
            registerSpecSet3.intersect(registerSpecSet, true);
        } else {
            registerSpecSet3 = registerSpecSet.mutableCopy();
        }
        if (registerSpecSet2.equals(registerSpecSet3)) {
            return false;
        }
        registerSpecSet3.setImmutable();
        this.setStarts(n, registerSpecSet3);
        return true;
    }

    public RegisterSpecSet getStarts(int n) {
        RegisterSpecSet registerSpecSet = this.getStarts0(n);
        return registerSpecSet != null ? registerSpecSet : this.emptySet;
    }

    public RegisterSpecSet getStarts(BasicBlock basicBlock) {
        return this.getStarts(basicBlock.getLabel());
    }

    public RegisterSpecSet mutableCopyOfStarts(int n) {
        RegisterSpecSet registerSpecSet = this.getStarts0(n);
        return registerSpecSet != null ? registerSpecSet.mutableCopy() : new RegisterSpecSet(this.regCount);
    }

    public void addAssignment(Insn insn, RegisterSpec registerSpec) {
        this.throwIfImmutable();
        if (insn == null) {
            throw new NullPointerException("insn == null");
        }
        if (registerSpec == null) {
            throw new NullPointerException("spec == null");
        }
        this.insnAssignments.put(insn, registerSpec);
    }

    public RegisterSpec getAssignment(Insn insn) {
        return this.insnAssignments.get(insn);
    }

    public int getAssignmentCount() {
        return this.insnAssignments.size();
    }

    public void debugDump() {
        for (int i = 0; i < this.blockStarts.length; ++i) {
            if (this.blockStarts[i] == null) continue;
            if (this.blockStarts[i] == this.emptySet) {
                System.out.printf("%04x: empty set\n", i);
                continue;
            }
            System.out.printf("%04x: %s\n", i, this.blockStarts[i]);
        }
    }

    private RegisterSpecSet getStarts0(int n) {
        try {
            return this.blockStarts[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("bogus label");
        }
    }
}

