/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.annotation;

import com.android.dx.rop.annotation.AnnotationVisibility;
import com.android.dx.rop.annotation.NameValuePair;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.util.MutabilityControl;
import com.android.dx.util.ToHuman;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;

public final class Annotation
extends MutabilityControl
implements Comparable<Annotation>,
ToHuman {
    private final CstType type;
    private final AnnotationVisibility visibility;
    private final TreeMap<CstString, NameValuePair> elements;

    public Annotation(CstType cstType, AnnotationVisibility annotationVisibility) {
        if (cstType == null) {
            throw new NullPointerException("type == null");
        }
        if (annotationVisibility == null) {
            throw new NullPointerException("visibility == null");
        }
        this.type = cstType;
        this.visibility = annotationVisibility;
        this.elements = new TreeMap();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Annotation)) {
            return false;
        }
        Annotation annotation = (Annotation)object;
        if (!this.type.equals(annotation.type) || this.visibility != annotation.visibility) {
            return false;
        }
        return this.elements.equals(annotation.elements);
    }

    public int hashCode() {
        int n = this.type.hashCode();
        n = n * 31 + this.elements.hashCode();
        n = n * 31 + this.visibility.hashCode();
        return n;
    }

    @Override
    public int compareTo(Annotation annotation) {
        int n = this.type.compareTo(annotation.type);
        if (n != 0) {
            return n;
        }
        n = this.visibility.compareTo(annotation.visibility);
        if (n != 0) {
            return n;
        }
        Iterator<NameValuePair> iterator = this.elements.values().iterator();
        Iterator<NameValuePair> iterator2 = annotation.elements.values().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            NameValuePair nameValuePair;
            NameValuePair nameValuePair2 = iterator.next();
            n = nameValuePair2.compareTo(nameValuePair = iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.toHuman();
    }

    @Override
    public String toHuman() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.visibility.toHuman());
        stringBuilder.append("-annotation ");
        stringBuilder.append(this.type.toHuman());
        stringBuilder.append(" {");
        boolean bl = true;
        for (NameValuePair nameValuePair : this.elements.values()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nameValuePair.getName().toHuman());
            stringBuilder.append(": ");
            stringBuilder.append(nameValuePair.getValue().toHuman());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public CstType getType() {
        return this.type;
    }

    public AnnotationVisibility getVisibility() {
        return this.visibility;
    }

    public void put(NameValuePair nameValuePair) {
        this.throwIfImmutable();
        if (nameValuePair == null) {
            throw new NullPointerException("pair == null");
        }
        this.elements.put(nameValuePair.getName(), nameValuePair);
    }

    public void add(NameValuePair nameValuePair) {
        this.throwIfImmutable();
        if (nameValuePair == null) {
            throw new NullPointerException("pair == null");
        }
        CstString cstString = nameValuePair.getName();
        if (this.elements.get(cstString) != null) {
            throw new IllegalArgumentException("name already added: " + cstString);
        }
        this.elements.put(cstString, nameValuePair);
    }

    public Collection<NameValuePair> getNameValuePairs() {
        return Collections.unmodifiableCollection(this.elements.values());
    }
}

