/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io.instructions;

import com.android.dx.io.instructions.BaseCodeCursor;
import com.android.dx.io.instructions.CodeOutput;

public final class ShortArrayCodeOutput
extends BaseCodeCursor
implements CodeOutput {
    private final short[] array;

    public ShortArrayCodeOutput(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxSize < 0");
        }
        this.array = new short[n];
    }

    public short[] getArray() {
        int n = this.cursor();
        if (n == this.array.length) {
            return this.array;
        }
        short[] sArray = new short[n];
        System.arraycopy(this.array, 0, sArray, 0, n);
        return sArray;
    }

    @Override
    public void write(short s) {
        this.array[this.cursor()] = s;
        this.advance(1);
    }

    @Override
    public void write(short s, short s2) {
        this.write(s);
        this.write(s2);
    }

    @Override
    public void write(short s, short s2, short s3) {
        this.write(s);
        this.write(s2);
        this.write(s3);
    }

    @Override
    public void write(short s, short s2, short s3, short s4) {
        this.write(s);
        this.write(s2);
        this.write(s3);
        this.write(s4);
    }

    @Override
    public void write(short s, short s2, short s3, short s4, short s5) {
        this.write(s);
        this.write(s2);
        this.write(s3);
        this.write(s4);
        this.write(s5);
    }

    @Override
    public void writeInt(int n) {
        this.write((short)n);
        this.write((short)(n >> 16));
    }

    @Override
    public void writeLong(long l) {
        this.write((short)l);
        this.write((short)(l >> 16));
        this.write((short)(l >> 32));
        this.write((short)(l >> 48));
    }

    @Override
    public void write(byte[] byArray) {
        int n = 0;
        boolean bl = true;
        for (byte by : byArray) {
            if (bl) {
                n = by & 0xFF;
                bl = false;
                continue;
            }
            this.write((short)(n |= by << 8));
            bl = true;
        }
        if (!bl) {
            this.write((short)n);
        }
    }

    @Override
    public void write(short[] sArray) {
        for (short s : sArray) {
            this.write(s);
        }
    }

    @Override
    public void write(int[] nArray) {
        for (int n : nArray) {
            this.writeInt(n);
        }
    }

    @Override
    public void write(long[] lArray) {
        for (long l : lArray) {
            this.writeLong(l);
        }
    }
}

