/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.util.AnnotatedOutput;
import java.util.Collection;

public abstract class Section {
    private final String name;
    private final DexFile file;
    private final int alignment;
    private int fileOffset;
    private boolean prepared;

    public static void validateAlignment(int n) {
        if (n <= 0 || (n & n - 1) != 0) {
            throw new IllegalArgumentException("invalid alignment");
        }
    }

    public Section(String string, DexFile dexFile, int n) {
        if (dexFile == null) {
            throw new NullPointerException("file == null");
        }
        Section.validateAlignment(n);
        this.name = string;
        this.file = dexFile;
        this.alignment = n;
        this.fileOffset = -1;
        this.prepared = false;
    }

    public final DexFile getFile() {
        return this.file;
    }

    public final int getAlignment() {
        return this.alignment;
    }

    public final int getFileOffset() {
        if (this.fileOffset < 0) {
            throw new RuntimeException("fileOffset not set");
        }
        return this.fileOffset;
    }

    public final int setFileOffset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("fileOffset < 0");
        }
        if (this.fileOffset >= 0) {
            throw new RuntimeException("fileOffset already set");
        }
        int n2 = this.alignment - 1;
        this.fileOffset = n = n + n2 & ~n2;
        return n;
    }

    public final void writeTo(AnnotatedOutput annotatedOutput) {
        this.throwIfNotPrepared();
        this.align(annotatedOutput);
        int n = annotatedOutput.getCursor();
        if (this.fileOffset < 0) {
            this.fileOffset = n;
        } else if (this.fileOffset != n) {
            throw new RuntimeException("alignment mismatch: for " + this + ", at " + n + ", but expected " + this.fileOffset);
        }
        if (annotatedOutput.annotates()) {
            if (this.name != null) {
                annotatedOutput.annotate(0, "\n" + this.name + ":");
            } else if (n != 0) {
                annotatedOutput.annotate(0, "\n");
            }
        }
        this.writeTo0(annotatedOutput);
    }

    public final int getAbsoluteOffset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("relative < 0");
        }
        if (this.fileOffset < 0) {
            throw new RuntimeException("fileOffset not yet set");
        }
        return this.fileOffset + n;
    }

    public abstract int getAbsoluteItemOffset(Item var1);

    public final void prepare() {
        this.throwIfPrepared();
        this.prepare0();
        this.prepared = true;
    }

    public abstract Collection<? extends Item> items();

    protected abstract void prepare0();

    public abstract int writeSize();

    protected final void throwIfNotPrepared() {
        if (!this.prepared) {
            throw new RuntimeException("not prepared");
        }
    }

    protected final void throwIfPrepared() {
        if (this.prepared) {
            throw new RuntimeException("already prepared");
        }
    }

    protected final void align(AnnotatedOutput annotatedOutput) {
        annotatedOutput.alignTo(this.alignment);
    }

    protected abstract void writeTo0(AnnotatedOutput var1);

    protected final String getName() {
        return this.name;
    }
}

