/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.Leb128;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.file.CodeItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMember;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.io.PrintWriter;

public final class EncodedMethod
extends EncodedMember
implements Comparable<EncodedMethod> {
    private final CstMethodRef method;
    private final CodeItem code;

    public EncodedMethod(CstMethodRef cstMethodRef, int n, DalvCode dalvCode, TypeList typeList) {
        super(n);
        if (cstMethodRef == null) {
            throw new NullPointerException("method == null");
        }
        this.method = cstMethodRef;
        if (dalvCode == null) {
            this.code = null;
        } else {
            boolean bl = (n & 8) != 0;
            this.code = new CodeItem(cstMethodRef, dalvCode, bl, typeList);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof EncodedMethod)) {
            return false;
        }
        return this.compareTo((EncodedMethod)object) == 0;
    }

    @Override
    public int compareTo(EncodedMethod encodedMethod) {
        return this.method.compareTo(encodedMethod.method);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('{');
        stringBuffer.append(Hex.u2(this.getAccessFlags()));
        stringBuffer.append(' ');
        stringBuffer.append(this.method);
        if (this.code != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.code);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void addContents(DexFile dexFile) {
        MethodIdsSection methodIdsSection = dexFile.getMethodIds();
        MixedItemSection mixedItemSection = dexFile.getWordData();
        methodIdsSection.intern(this.method);
        if (this.code != null) {
            mixedItemSection.add(this.code);
        }
    }

    @Override
    public final String toHuman() {
        return this.method.toHuman();
    }

    @Override
    public final CstString getName() {
        return this.method.getNat().getName();
    }

    @Override
    public void debugPrint(PrintWriter printWriter, boolean bl) {
        if (this.code == null) {
            printWriter.println(this.getRef().toHuman() + ": abstract or native");
        } else {
            this.code.debugPrint(printWriter, "  ", bl);
        }
    }

    public final CstMethodRef getRef() {
        return this.method;
    }

    @Override
    public int encode(DexFile dexFile, AnnotatedOutput annotatedOutput, int n, int n2) {
        boolean bl;
        int n3 = dexFile.getMethodIds().indexOf(this.method);
        int n4 = n3 - n;
        int n5 = this.getAccessFlags();
        int n6 = OffsettedItem.getAbsoluteOffsetOr0(this.code);
        boolean bl2 = n6 != 0;
        boolean bl3 = bl = (n5 & 0x500) == 0;
        if (bl2 != bl) {
            throw new UnsupportedOperationException("code vs. access_flags mismatch");
        }
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, String.format("  [%x] %s", n2, this.method.toHuman()));
            annotatedOutput.annotate(Leb128.unsignedLeb128Size(n4), "    method_idx:   " + Hex.u4(n3));
            annotatedOutput.annotate(Leb128.unsignedLeb128Size(n5), "    access_flags: " + AccessFlags.methodString(n5));
            annotatedOutput.annotate(Leb128.unsignedLeb128Size(n6), "    code_off:     " + Hex.u4(n6));
        }
        annotatedOutput.writeUleb128(n4);
        annotatedOutput.writeUleb128(n5);
        annotatedOutput.writeUleb128(n6);
        return n3;
    }
}

