/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.dex.file.ValueEncoder;
import com.android.dx.rop.cst.CstArray;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArrayAnnotatedOutput;

public final class EncodedArrayItem
extends OffsettedItem {
    private static final int ALIGNMENT = 1;
    private final CstArray array;
    private byte[] encodedForm;

    public EncodedArrayItem(CstArray cstArray) {
        super(1, -1);
        if (cstArray == null) {
            throw new NullPointerException("array == null");
        }
        this.array = cstArray;
        this.encodedForm = null;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_ENCODED_ARRAY_ITEM;
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    @Override
    protected int compareTo0(OffsettedItem offsettedItem) {
        EncodedArrayItem encodedArrayItem = (EncodedArrayItem)offsettedItem;
        return this.array.compareTo(encodedArrayItem.array);
    }

    @Override
    public String toHuman() {
        return this.array.toHuman();
    }

    @Override
    public void addContents(DexFile dexFile) {
        ValueEncoder.addContents(dexFile, this.array);
    }

    @Override
    protected void place0(Section section, int n) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput();
        ValueEncoder valueEncoder = new ValueEncoder(section.getFile(), byteArrayAnnotatedOutput);
        valueEncoder.writeArray(this.array, false);
        this.encodedForm = byteArrayAnnotatedOutput.toByteArray();
        this.setWriteSize(this.encodedForm.length);
    }

    @Override
    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        if (bl) {
            annotatedOutput.annotate(0, this.offsetString() + " encoded array");
            ValueEncoder valueEncoder = new ValueEncoder(dexFile, annotatedOutput);
            valueEncoder.writeArray(this.array, true);
        } else {
            annotatedOutput.write(this.encodedForm);
        }
    }
}

