/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CatchHandlerList;
import com.android.dx.util.FixedSizeList;

public final class CatchTable
extends FixedSizeList
implements Comparable<CatchTable> {
    public static final CatchTable EMPTY = new CatchTable(0);

    public CatchTable(int n) {
        super(n);
    }

    public Entry get(int n) {
        return (Entry)this.get0(n);
    }

    public void set(int n, Entry entry) {
        this.set0(n, entry);
    }

    @Override
    public int compareTo(CatchTable catchTable) {
        if (this == catchTable) {
            return 0;
        }
        int n = this.size();
        int n2 = catchTable.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Entry entry;
            Entry entry2 = this.get(i);
            int n4 = entry2.compareTo(entry = catchTable.get(i));
            if (n4 == 0) continue;
            return n4;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static class Entry
    implements Comparable<Entry> {
        private final int start;
        private final int end;
        private final CatchHandlerList handlers;

        public Entry(int n, int n2, CatchHandlerList catchHandlerList) {
            if (n < 0) {
                throw new IllegalArgumentException("start < 0");
            }
            if (n2 <= n) {
                throw new IllegalArgumentException("end <= start");
            }
            if (catchHandlerList.isMutable()) {
                throw new IllegalArgumentException("handlers.isMutable()");
            }
            this.start = n;
            this.end = n2;
            this.handlers = catchHandlerList;
        }

        public int hashCode() {
            int n = this.start * 31 + this.end;
            n = n * 31 + this.handlers.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.compareTo((Entry)object) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(Entry entry) {
            if (this.start < entry.start) {
                return -1;
            }
            if (this.start > entry.start) {
                return 1;
            }
            if (this.end < entry.end) {
                return -1;
            }
            if (this.end > entry.end) {
                return 1;
            }
            return this.handlers.compareTo(entry.handlers);
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public CatchHandlerList getHandlers() {
            return this.handlers;
        }
    }
}

