/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.rop.cst.CstType;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.Hex;

public final class CatchHandlerList
extends FixedSizeList
implements Comparable<CatchHandlerList> {
    public static final CatchHandlerList EMPTY = new CatchHandlerList(0);

    public CatchHandlerList(int n) {
        super(n);
    }

    public Entry get(int n) {
        return (Entry)this.get0(n);
    }

    @Override
    public String toHuman() {
        return this.toHuman("", "");
    }

    public String toHuman(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = this.size();
        stringBuilder.append(string);
        stringBuilder.append(string2);
        stringBuilder.append("catch ");
        for (int i = 0; i < n; ++i) {
            Entry entry = this.get(i);
            if (i != 0) {
                stringBuilder.append(",\n");
                stringBuilder.append(string);
                stringBuilder.append("  ");
            }
            if (i == n - 1 && this.catchesAll()) {
                stringBuilder.append("<any>");
            } else {
                stringBuilder.append(entry.getExceptionType().toHuman());
            }
            stringBuilder.append(" -> ");
            stringBuilder.append(Hex.u2or4(entry.getHandler()));
        }
        return stringBuilder.toString();
    }

    public boolean catchesAll() {
        int n = this.size();
        if (n == 0) {
            return false;
        }
        Entry entry = this.get(n - 1);
        return entry.getExceptionType().equals(CstType.OBJECT);
    }

    public void set(int n, CstType cstType, int n2) {
        this.set0(n, new Entry(cstType, n2));
    }

    public void set(int n, Entry entry) {
        this.set0(n, entry);
    }

    @Override
    public int compareTo(CatchHandlerList catchHandlerList) {
        if (this == catchHandlerList) {
            return 0;
        }
        int n = this.size();
        int n2 = catchHandlerList.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Entry entry;
            Entry entry2 = this.get(i);
            int n4 = entry2.compareTo(entry = catchHandlerList.get(i));
            if (n4 == 0) continue;
            return n4;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static class Entry
    implements Comparable<Entry> {
        private final CstType exceptionType;
        private final int handler;

        public Entry(CstType cstType, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("handler < 0");
            }
            if (cstType == null) {
                throw new NullPointerException("exceptionType == null");
            }
            this.handler = n;
            this.exceptionType = cstType;
        }

        public int hashCode() {
            return this.handler * 31 + this.exceptionType.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.compareTo((Entry)object) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(Entry entry) {
            if (this.handler < entry.handler) {
                return -1;
            }
            if (this.handler > entry.handler) {
                return 1;
            }
            return this.exceptionType.compareTo(entry.exceptionType);
        }

        public CstType getExceptionType() {
            return this.exceptionType;
        }

        public int getHandler() {
            return this.handler;
        }
    }
}

