/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.VariableSizeInsn;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstLiteral32;
import com.android.dx.rop.cst.CstLiteral64;
import com.android.dx.rop.cst.CstType;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public final class ArrayData
extends VariableSizeInsn {
    private final CodeAddress user;
    private final ArrayList<Constant> values;
    private final Constant arrayType;
    private final int elemWidth;
    private final int initLength;

    public ArrayData(SourcePosition sourcePosition, CodeAddress codeAddress, ArrayList<Constant> arrayList, Constant constant) {
        super(sourcePosition, RegisterSpecList.EMPTY);
        if (codeAddress == null) {
            throw new NullPointerException("user == null");
        }
        if (arrayList == null) {
            throw new NullPointerException("values == null");
        }
        int n = arrayList.size();
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal number of init values");
        }
        this.arrayType = constant;
        if (constant == CstType.BYTE_ARRAY || constant == CstType.BOOLEAN_ARRAY) {
            this.elemWidth = 1;
        } else if (constant == CstType.SHORT_ARRAY || constant == CstType.CHAR_ARRAY) {
            this.elemWidth = 2;
        } else if (constant == CstType.INT_ARRAY || constant == CstType.FLOAT_ARRAY) {
            this.elemWidth = 4;
        } else if (constant == CstType.LONG_ARRAY || constant == CstType.DOUBLE_ARRAY) {
            this.elemWidth = 8;
        } else {
            throw new IllegalArgumentException("Unexpected constant type");
        }
        this.user = codeAddress;
        this.values = arrayList;
        this.initLength = arrayList.size();
    }

    @Override
    public int codeSize() {
        int n = this.initLength;
        return 4 + (n * this.elemWidth + 1) / 2;
    }

    @Override
    public void writeTo(AnnotatedOutput annotatedOutput) {
        int n = this.values.size();
        annotatedOutput.writeShort(768);
        annotatedOutput.writeShort(this.elemWidth);
        annotatedOutput.writeInt(this.initLength);
        switch (this.elemWidth) {
            case 1: {
                for (int i = 0; i < n; ++i) {
                    Constant constant = this.values.get(i);
                    annotatedOutput.writeByte((byte)((CstLiteral32)constant).getIntBits());
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    Constant constant = this.values.get(i);
                    annotatedOutput.writeShort((short)((CstLiteral32)constant).getIntBits());
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n; ++i) {
                    Constant constant = this.values.get(i);
                    annotatedOutput.writeInt(((CstLiteral32)constant).getIntBits());
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n; ++i) {
                    Constant constant = this.values.get(i);
                    annotatedOutput.writeLong(((CstLiteral64)constant).getLongBits());
                }
                break;
            }
        }
        if (this.elemWidth == 1 && n % 2 != 0) {
            annotatedOutput.writeByte(0);
        }
    }

    @Override
    public DalvInsn withRegisters(RegisterSpecList registerSpecList) {
        return new ArrayData(this.getPosition(), this.user, this.values, this.arrayType);
    }

    @Override
    protected String argString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n    ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(this.values.get(i).toHuman());
        }
        return stringBuffer.toString();
    }

    @Override
    protected String listingString0(boolean bl) {
        int n = this.user.getAddress();
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = this.values.size();
        stringBuffer.append("fill-array-data-payload // for fill-array-data @ ");
        stringBuffer.append(Hex.u2(n));
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("\n  ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(this.values.get(i).toHuman());
        }
        return stringBuffer.toString();
    }
}

