/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.util.FixedSizeList;

public final class LineNumberList
extends FixedSizeList {
    public static final LineNumberList EMPTY = new LineNumberList(0);

    public static LineNumberList concat(LineNumberList lineNumberList, LineNumberList lineNumberList2) {
        int n;
        if (lineNumberList == EMPTY) {
            return lineNumberList2;
        }
        int n2 = lineNumberList.size();
        int n3 = lineNumberList2.size();
        LineNumberList lineNumberList3 = new LineNumberList(n2 + n3);
        for (n = 0; n < n2; ++n) {
            lineNumberList3.set(n, lineNumberList.get(n));
        }
        for (n = 0; n < n3; ++n) {
            lineNumberList3.set(n2 + n, lineNumberList2.get(n));
        }
        return lineNumberList3;
    }

    public LineNumberList(int n) {
        super(n);
    }

    public Item get(int n) {
        return (Item)this.get0(n);
    }

    public void set(int n, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n, item);
    }

    public void set(int n, int n2, int n3) {
        this.set0(n, new Item(n2, n3));
    }

    public int pcToLine(int n) {
        int n2 = this.size();
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            Item item = this.get(i);
            int n5 = item.getStartPc();
            if (n5 > n || n5 <= n3) continue;
            n3 = n5;
            n4 = item.getLineNumber();
            if (n3 == n) break;
        }
        return n4;
    }

    public static class Item {
        private final int startPc;
        private final int lineNumber;

        public Item(int n, int n2) {
            if (n < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("lineNumber < 0");
            }
            this.startPc = n;
            this.lineNumber = n2;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

