/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.ByteBlock;
import com.android.dx.cf.code.ByteBlockList;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.code.SwitchList;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Bits;
import com.android.dx.util.IntList;
import java.util.ArrayList;

public final class BasicBlocker
implements BytecodeArray.Visitor {
    private final ConcreteMethod method;
    private final int[] workSet;
    private final int[] liveSet;
    private final int[] blockSet;
    private final IntList[] targetLists;
    private final ByteCatchList[] catchLists;
    private int previousOffset;

    public static ByteBlockList identifyBlocks(ConcreteMethod concreteMethod) {
        BasicBlocker basicBlocker = new BasicBlocker(concreteMethod);
        basicBlocker.doit();
        return basicBlocker.getBlockList();
    }

    private BasicBlocker(ConcreteMethod concreteMethod) {
        if (concreteMethod == null) {
            throw new NullPointerException("method == null");
        }
        this.method = concreteMethod;
        int n = concreteMethod.getCode().size() + 1;
        this.workSet = Bits.makeBitSet(n);
        this.liveSet = Bits.makeBitSet(n);
        this.blockSet = Bits.makeBitSet(n);
        this.targetLists = new IntList[n];
        this.catchLists = new ByteCatchList[n];
        this.previousOffset = -1;
    }

    @Override
    public void visitInvalid(int n, int n2, int n3) {
        this.visitCommon(n2, n3, true);
    }

    @Override
    public void visitNoArgs(int n, int n2, int n3, Type type) {
        switch (n) {
            case 172: 
            case 177: {
                this.visitCommon(n2, n3, false);
                this.targetLists[n2] = IntList.EMPTY;
                break;
            }
            case 191: {
                this.visitCommon(n2, n3, false);
                this.visitThrowing(n2, n3, false);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 190: 
            case 194: 
            case 195: {
                this.visitCommon(n2, n3, true);
                this.visitThrowing(n2, n3, true);
                break;
            }
            case 108: 
            case 112: {
                this.visitCommon(n2, n3, true);
                if (type != Type.INT && type != Type.LONG) break;
                this.visitThrowing(n2, n3, true);
                break;
            }
            default: {
                this.visitCommon(n2, n3, true);
            }
        }
    }

    @Override
    public void visitLocal(int n, int n2, int n3, int n4, Type type, int n5) {
        if (n == 169) {
            this.visitCommon(n2, n3, false);
            this.targetLists[n2] = IntList.EMPTY;
        } else {
            this.visitCommon(n2, n3, true);
        }
    }

    @Override
    public void visitConstant(int n, int n2, int n3, Constant constant, int n4) {
        this.visitCommon(n2, n3, true);
        if (constant instanceof CstMemberRef || constant instanceof CstType || constant instanceof CstString) {
            this.visitThrowing(n2, n3, true);
        }
    }

    @Override
    public void visitBranch(int n, int n2, int n3, int n4) {
        switch (n) {
            case 167: {
                this.visitCommon(n2, n3, false);
                this.targetLists[n2] = IntList.makeImmutable(n4);
                break;
            }
            case 168: {
                this.addWorkIfNecessary(n2, true);
            }
            default: {
                int n5 = n2 + n3;
                this.visitCommon(n2, n3, true);
                this.addWorkIfNecessary(n5, true);
                this.targetLists[n2] = IntList.makeImmutable(n5, n4);
                break;
            }
        }
        this.addWorkIfNecessary(n4, true);
    }

    @Override
    public void visitSwitch(int n, int n2, int n3, SwitchList switchList, int n4) {
        this.visitCommon(n2, n3, false);
        this.addWorkIfNecessary(switchList.getDefaultTarget(), true);
        int n5 = switchList.size();
        for (int i = 0; i < n5; ++i) {
            this.addWorkIfNecessary(switchList.getTarget(i), true);
        }
        this.targetLists[n2] = switchList.getTargets();
    }

    @Override
    public void visitNewarray(int n, int n2, CstType cstType, ArrayList<Constant> arrayList) {
        this.visitCommon(n, n2, true);
        this.visitThrowing(n, n2, true);
    }

    private ByteBlockList getBlockList() {
        int n;
        BytecodeArray bytecodeArray = this.method.getCode();
        ByteBlock[] byteBlockArray = new ByteBlock[bytecodeArray.size()];
        int n2 = 0;
        int n3 = 0;
        while ((n = Bits.findFirst(this.blockSet, n3 + 1)) >= 0) {
            if (Bits.get(this.liveSet, n3)) {
                ByteCatchList byteCatchList;
                IntList intList = null;
                int n4 = -1;
                for (int i = n - 1; i >= n3; --i) {
                    intList = this.targetLists[i];
                    if (intList == null) continue;
                    n4 = i;
                    break;
                }
                if (intList == null) {
                    intList = IntList.makeImmutable(n);
                    byteCatchList = ByteCatchList.EMPTY;
                } else {
                    byteCatchList = this.catchLists[n4];
                    if (byteCatchList == null) {
                        byteCatchList = ByteCatchList.EMPTY;
                    }
                }
                byteBlockArray[n2] = new ByteBlock(n3, n3, n, intList, byteCatchList);
                ++n2;
            }
            n3 = n;
        }
        ByteBlockList byteBlockList = new ByteBlockList(n2);
        for (n = 0; n < n2; ++n) {
            byteBlockList.set(n, byteBlockArray[n]);
        }
        return byteBlockList;
    }

    private void doit() {
        BytecodeArray bytecodeArray = this.method.getCode();
        ByteCatchList byteCatchList = this.method.getCatches();
        int n = byteCatchList.size();
        Bits.set(this.workSet, 0);
        Bits.set(this.blockSet, 0);
        while (!Bits.isEmpty(this.workSet)) {
            try {
                bytecodeArray.processWorkSet(this.workSet, this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SimException("flow of control falls off end of method", illegalArgumentException);
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                ByteCatchList.Item item = byteCatchList.get(i);
                int n3 = item.getStartPc();
                if (!Bits.anyInRange(this.liveSet, n3, n2 = item.getEndPc())) continue;
                Bits.set(this.blockSet, n3);
                Bits.set(this.blockSet, n2);
                this.addWorkIfNecessary(item.getHandlerPc(), true);
            }
        }
    }

    private void addWorkIfNecessary(int n, boolean bl) {
        if (!Bits.get(this.liveSet, n)) {
            Bits.set(this.workSet, n);
        }
        if (bl) {
            Bits.set(this.blockSet, n);
        }
    }

    private void visitCommon(int n, int n2, boolean bl) {
        Bits.set(this.liveSet, n);
        if (bl) {
            this.addWorkIfNecessary(n + n2, false);
        } else {
            Bits.set(this.blockSet, n + n2);
        }
    }

    private void visitThrowing(int n, int n2, boolean bl) {
        ByteCatchList byteCatchList;
        int n3 = n + n2;
        if (bl) {
            this.addWorkIfNecessary(n3, true);
        }
        this.catchLists[n] = byteCatchList = this.method.getCatches().listFor(n);
        this.targetLists[n] = byteCatchList.toTargetList(bl ? n3 : -1);
    }

    @Override
    public void setPreviousOffset(int n) {
        this.previousOffset = n;
    }

    @Override
    public int getPreviousOffset() {
        return this.previousOffset;
    }
}

