"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteAliasRecord = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
class WebsiteAliasRecord extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { domainName, recordNames, target, privateZone, vpcId } = props;
        const zone = aws_route53_1.HostedZone.fromLookup(this, 'Zone', {
            domainName,
            privateZone,
            vpcId,
        });
        recordNames.forEach((recordName) => {
            const hash = crypto.createHash('md5').update(recordName).digest('hex').substr(0, 6);
            new aws_route53_1.ARecord(this, `WebsiteAliasRecord${hash}`, {
                zone,
                recordName: `${recordName}.`,
                target: aws_route53_1.RecordTarget.fromAlias(target),
            });
            if (!props.disableIPv6) {
                new aws_route53_1.AaaaRecord(this, `WebsiteIPv6AliasRecord${hash}`, {
                    zone,
                    recordName: `${recordName}.`,
                    target: aws_route53_1.RecordTarget.fromAlias(target),
                });
            }
        });
    }
}
exports.WebsiteAliasRecord = WebsiteAliasRecord;
_a = JSII_RTTI_SYMBOL_1;
WebsiteAliasRecord[_a] = { fqn: "@cloudcomponents/cdk-static-website.WebsiteAliasRecord", version: "1.48.0" };
//# sourceMappingURL=data:application/json;base64,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