#! /usr/bin/env python3
# -*- coding: utf-8 -*-
# @Time    : 2021-10-18 17:25
# @Site    :
# @File    : DBHelper.py
# @Software: PyCharm
from XZGUtil import logger
import ast
from operator import itemgetter

def create_in_sql(table_name: str, data: dict, conversion=False, update=False):
    """
    传入字典和表名，返回组装好的sql
    sql中的插入字段为传入字典的key
    conversion:是否全部转换成字符串类型
    update:是否启动更新语句
    data = {'w':'d1','ew':'d2','wr':'d3','wa':'d4'}
    """
    sql = 'insert into ' + table_name + ' ('
    data_keys = [key for key in data.keys()]
    for key in data_keys:
        sql += key
        if data_keys.index(key) != len(data_keys) - 1:
            sql += ','
        else:
            sql += ')  values ('
            for key in data_keys:
                value = data.get(key)
                if isinstance(value, str) or conversion:
                    sql += f'"{value}",'
                elif value == None:
                    sql += f'null,'
                else:
                    sql += f'{value},'
            sql = sql.rstrip(',')
    if update:
        sql += ")  ON DUPLICATE KEY UPDATE "
        for key in data_keys:
            sql += key + '=' + f'values({key}),'
        sql = sql.rstrip(',')
        sql += ";"
    else:
        sql += ");"
    return sql

def create_many_sql(table_name: str, data_list: list, conversion=False, update=False):
    """
    传入字典和表名，返回组装好的sql
    sql中的插入字段为传入字典的key
    conversion:是否全部转换成字符串类型
    update:是否启动更新语句
    data = [{'w':'d1','ew':'d2','wr':'d3','wa':'d4'},{'w':'d1','ew':'d2','wr':'d3','wa':'d4'},{'w':'d1','ew':'d2','wr':'d3','wa':'d4'}]
    """

    rel_data = []
    data = data_list[0]
    sql = 'insert into ' + table_name + ' ('
    data_keys = [key for key in data.keys()]
    for key in data_keys:
        item_list = []
        sql += key
        if data_keys.index(key) != len(data_keys) - 1:
            sql += ','
        else:
            sql += ')  values ('
            for key in data_keys:
                value = data.get(key)
                # if isinstance(value, str) or conversion:
                #     sql += f'"%s",'
                if value == None:
                    sql += '%s,'
                else:
                    sql += '%s,'
            sql = sql.rstrip(',')
    if update:
        sql += ")  ON DUPLICATE KEY UPDATE "
        for key in data_keys:
            sql += key + '=' + f'values({key}),'
        sql = sql.rstrip(',')
        sql += ";"
    else:
        sql += ");"
    for item in data_list:
        rel_data.append(tuple(item.values()))
    return sql, rel_data




def __paths(data, path='source_root', k=''):
    '''
    用于遍历json树
    :param data: 原始数据，或者key对应的value值
    :param path: key值字符串，默认值为''
    :return:
    '''
    if isinstance(data, dict):
        for k, v in data.items():
            tmp = path + ".get('%s')" % k
            if not isinstance(v, dict):
                yield (f"'{upper_lower(k)}':"+tmp, v, k)
            yield from __paths(v, tmp, k)
    if isinstance(data, list):
        for k, v in enumerate(data):
            if isinstance(k, int) and isinstance(v, str):
                pass
            else:
                tmp = path + '[%d]' % k
                if not isinstance(k, int):
                    yield (f"'{upper_lower(k)}':"+tmp, v, k)
                yield from __paths(v, tmp, k)

def find_key_path(key,data):
    '''
    查找key路径
    :param key: 需要查找路径的key值
    :return: 包含key值路径的list
    '''

    if isinstance(key, list):
        rel = []
        for ks in key:
            rel += find_key_path(ks, data)
        return rel
    result = []
    for path, value in __paths(data):
        if path.endswith("['%s']" % key):
            result.append(path)
    with open('path.txt', 'w+', encoding='utf-8') as f:
        list(map(lambda line: f.write(line + '\r'), result))
    return result

def find_value_path(key,data):
    '''
    查找某个值的路径
    :param key: 需要查找的值，限制为字符串，数字，浮点数，布尔值
    :return:
    '''
    result = []
    for path, value in __paths(data):
        if isinstance(value, (str, int, bool, float)):
            if value == key:
                result.append(path)
    with open('path.txt', 'w+', encoding='utf-8') as f:
        list(map(lambda line: f.write(line + '\r'), result))
    return result


def upper_lower(word: str):
    """单词大写字母换成下划线加小写"""
    new_str = ''
    for sr in word:
        if word.index(sr) == 0:
            new_str += sr.lower()
        else:
            if sr.islower():
                new_str += sr.lower()
            else:
                new_str += f"_{sr.lower()}"
    return new_str


def parse_json(data: dict, key_list: list = None):
    """
    第一步
    :param data: 传入想要解析的json
    :param key_list: 想要的key列表，不传递则返回所有的字段，传递则返回列表中的key  ex:['lastIndex']
    :return:
    """
    rel = []
    filter_list = []
    for i in __paths(data):
        key = upper_lower(i[2])
        print(i)
        if key not in filter_list:
            if key_list:
                rel.append({'key': key, "value": i[1], "path": i[0]} if i[2] in key_list else None)
            else:
                rel.append({'key': key, "value": i[1], "path": i[0]})
            filter_list.append(key)
    print(list(filter(None, rel)))


def create_msql_table(table_name, field: list):
    """
    第二步,创建建变sql
    :param table_name: 表名
    :param field: 此字段为第一步输出的列表 [{'key': 'lastIndex', 'value': None, 'path': "source_root.get('lastIndex')",'comment':'交易额'}, {'key': 'lastIndex', 'value': '15', 'path': "source_root.get('result').get('page').get('lastIndex')",'comment':'姓名'}]
    key：将作为字段名
    value：将判断类型，拼接成响应类型
    comment：注释
    :return:
    """
    field = sorted(field, key=itemgetter('key'))
    head = f"""CREATE TABLE `{table_name}` (\n`id` int(6) NOT NULL AUTO_INCREMENT COMMENT '',\n`create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"""
    end = """PRIMARY KEY (`id`)\n ) ENGINE=InnoDB AUTO_INCREMENT=35765 DEFAULT CHARSET=utf8; """
    for item in field:
        key = item.get('key')
        value = item.get('value')
        comment = item.get('comment')
        if isinstance(value, float):
            field = f"`{key}` float DEFAULT NULL COMMENT '{comment}',\n" if comment else ''
        elif isinstance(value, int):
            if len(str(value)) <= 10:
                field = f"`{key}` int(11) DEFAULT NULL COMMENT  '{comment}',\n" if comment else ''
            else:
                field = f"`{key}` bigint(128) DEFAULT NULL COMMENT  '{comment}',\n" if comment else ''
        else:
            if len(f"{value}") >= 50:
                field = f"`{key}` longtext DEFAULT NULL COMMENT  '{comment}',\n" if comment else ''
            else:
                field = f"`{key}` varchar(128) DEFAULT NULL COMMENT  '{comment}',\n" if comment else ''
        head += field
    print(head+end)


def select_public(db, sql):
    """
    公共查询方法
    :return:
    """
    try:
        db.ping()
    except:
        db.connect()
    cursor = db.cursor()
    cursor.execute(sql)
    db.commit()
    result = cursor.fetchall()
    # logger.info(result)
    db.close()
    return result


def insert_many(db, sql, data: list = None):
    """
   公共插入方法
   :return:
   """
    try:
        db.ping()
    except:
        db.connect()
    cursor = db.cursor()
    if data:
        cursor.executemany(sql, data)
    else:
        cursor.execute(sql)
    db.commit()
    cursor.close()
    db.close()

if __name__ == '__main__':
    null = None
    true = True
    false = False
    data = {"data":{"result":[{"validDate":"2023-04-30","baseCrowdExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512 WHERE (new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512.behavior IN ('pv', 'fav', 'cart'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"蔓迪品牌实时行为人群","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":22119028,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"蔓迪","tagId":157512,"price":null,"values":"3883772","tagName":"品牌实时行为人群_S3","adapterType":null,"optionGroupId":37660,"key":"157512_37660"},{"optionType":null,"names":"曝光,收藏,加购","tagId":157512,"price":null,"values":"pv,fav,cart","tagName":"品牌实时行为人群_S3","adapterType":null,"optionGroupId":38354,"key":"157512_38354"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-05-11","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"157512_37660\",\"names\":\"蔓迪\",\"optionGroupId\":37660,\"tagId\":157512,\"tagName\":\"品牌实时行为人群_S3\",\"values\":\"3883772\"},{\"key\":\"157512_38354\",\"names\":\"曝光,收藏,加购\",\"optionGroupId\":38354,\"tagId\":157512,\"tagName\":\"品牌实时行为人群_S3\",\"values\":\"pv,fav,cart\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512 WHERE (new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_dmp_tag_realtime_brand_157512.behavior IN ('pv', 'fav', 'cart'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":18176426,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableEdit":"false","isEnableDuplicate":"false","isEnableDelete":"false","crowd_iter_ai":"2","lbsStorageData":"{}","relateRecommendIds":"","isClickOptimization":"1655442361789"},"custId":null,"apps":[],"coverage":55753,"createtime":"2022-05-11","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null},{"validDate":"2023-04-30","baseCrowdExpression":"SELECT DISTINCT m_2.__aid AS __aid FROM  ( SELECT SUM(new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.trd_cnt) AS sum1, new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid AS __aid FROM new_dmp.taobao_dmp_dp_view_rpt_brand_behavior WHERE (new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.bc_type IN ('-9999') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.ds >= '20210511' AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cate2_id IN ('122290002') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.trd_cnt > 0) GROUP BY new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid )  AS m_2 WHERE (m_2.sum1 >= 1 AND m_2.sum1 <= 999)","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"蔓迪品牌_近1年购买","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":22119018,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"蔓迪","tagId":160784,"price":null,"values":"3883772","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40010,"key":"160784_40010"},{"optionType":null,"names":"OTC药品/国际医药>OTC药品>白发脱发","tagId":160784,"price":null,"values":"122290002","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40025,"key":"160784_40025"},{"optionType":null,"names":"全部","tagId":160784,"price":null,"values":"-9999","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40012,"key":"160784_40012"},{"optionType":null,"names":"购买","tagId":160784,"price":null,"values":"4","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40014,"key":"160784_40014"},{"optionType":null,"names":"购买次数","tagId":160784,"price":null,"values":"1","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40018,"key":"160784_40018"},{"optionType":null,"names":"1~999","tagId":160784,"price":null,"values":"1~999","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40019,"key":"160784_40019"},{"optionType":null,"names":"最近N天","tagId":160784,"price":null,"values":"1","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40022,"key":"160784_40022"},{"optionType":null,"names":"365","tagId":160784,"price":null,"values":"365","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40023,"key":"160784_40023"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-05-11","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"160784_40010\",\"names\":\"蔓迪\",\"optionGroupId\":40010,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"3883772\"},{\"key\":\"160784_40025\",\"names\":\"OTC药品/国际医药>OTC药品>白发脱发\",\"optionGroupId\":40025,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"122290002\"},{\"key\":\"160784_40012\",\"names\":\"全部\",\"optionGroupId\":40012,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"-9999\"},{\"key\":\"160784_40014\",\"names\":\"购买\",\"optionGroupId\":40014,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"4\"},{\"key\":\"160784_40018\",\"names\":\"购买次数\",\"optionGroupId\":40018,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1\"},{\"key\":\"160784_40019\",\"names\":\"1~999\",\"optionGroupId\":40019,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1~999\"},{\"key\":\"160784_40022\",\"names\":\"最近N天\",\"optionGroupId\":40022,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1\"},{\"key\":\"160784_40023\",\"names\":\"365\",\"optionGroupId\":40023,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"365\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT m_2.__aid AS __aid FROM  ( SELECT SUM(new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.trd_cnt) AS sum1, new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid AS __aid FROM new_dmp.taobao_dmp_dp_view_rpt_brand_behavior WHERE (new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.bc_type IN ('-9999') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.ds >= '20210511' AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cate2_id IN ('122290002') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.trd_cnt > 0) GROUP BY new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid )  AS m_2 WHERE (m_2.sum1 >= 1 AND m_2.sum1 <= 999)","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":18176414,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableEdit":"false","isEnableDuplicate":"false","isEnableDelete":"false","CROWD_FACTORY_MARK_KEY":"1","crowd_iter_ai":"2","lbsStorageData":"{}","relateRecommendIds":"","isClickOptimization":"1655443492289"},"custId":null,"apps":[],"coverage":1556053,"createtime":"2022-05-11","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":47,"updatetime":null},{"validDate":"2023-04-30","baseCrowdExpression":"SELECT DISTINCT m_1.__aid AS __aid FROM  ( SELECT DISTINCT m_2.__aid AS __aid FROM  ( SELECT SUM(new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cart_cnt) AS sum1, new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid AS __aid FROM new_dmp.taobao_dmp_dp_view_rpt_brand_behavior WHERE (new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.bc_type IN ('-9999') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.ds >= '20211112' AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cate2_id IN ('122290002') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cart_cnt > 0) GROUP BY new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid )  AS m_2 WHERE (m_2.sum1 >= 1 AND m_2.sum1 <= 999) MINUS SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2', '3') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('15')) )  AS m_1","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"蔓迪品牌_180天加购15天未购","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":22118993,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"蔓迪","tagId":160784,"price":null,"values":"3883772","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40010,"key":"160784_40010"},{"optionType":null,"names":"OTC药品/国际医药>OTC药品>白发脱发","tagId":160784,"price":null,"values":"122290002","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40025,"key":"160784_40025"},{"optionType":null,"names":"全部","tagId":160784,"price":null,"values":"-9999","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40012,"key":"160784_40012"},{"optionType":null,"names":"加购","tagId":160784,"price":null,"values":"5","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40014,"key":"160784_40014"},{"optionType":null,"names":"1~999","tagId":160784,"price":null,"values":"1~999","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40021,"key":"160784_40021"},{"optionType":null,"names":"最近N天","tagId":160784,"price":null,"values":"1","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40022,"key":"160784_40022"},{"optionType":null,"names":"180","tagId":160784,"price":null,"values":"180","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40023,"key":"160784_40023"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"蔓迪","tagId":150556,"price":null,"values":"3883772","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32933,"key":"150556_32933"},{"optionType":null,"names":"购买","tagId":150556,"price":null,"values":"4","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32934,"key":"150556_32934"},{"optionType":null,"names":"高,中,低","tagId":150556,"price":null,"values":"1,2,3","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32935,"key":"150556_32935"},{"optionType":null,"names":"最近15天","tagId":150556,"price":null,"values":"15","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32936,"key":"150556_32936"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-05-11","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"160784_40010\",\"names\":\"蔓迪\",\"optionGroupId\":40010,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"3883772\"},{\"key\":\"160784_40025\",\"names\":\"OTC药品/国际医药>OTC药品>白发脱发\",\"optionGroupId\":40025,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"122290002\"},{\"key\":\"160784_40012\",\"names\":\"全部\",\"optionGroupId\":40012,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"-9999\"},{\"key\":\"160784_40014\",\"names\":\"加购\",\"optionGroupId\":40014,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"5\"},{\"key\":\"160784_40021\",\"names\":\"1~999\",\"optionGroupId\":40021,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1~999\"},{\"key\":\"160784_40022\",\"names\":\"最近N天\",\"optionGroupId\":40022,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1\"},{\"key\":\"160784_40023\",\"names\":\"180\",\"optionGroupId\":40023,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"180\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":false,\"operator\":2,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150556_32933\",\"names\":\"蔓迪\",\"optionGroupId\":32933,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"3883772\"},{\"key\":\"150556_32934\",\"names\":\"购买\",\"optionGroupId\":32934,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"4\"},{\"key\":\"150556_32935\",\"names\":\"高,中,低\",\"optionGroupId\":32935,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"1,2,3\"},{\"key\":\"150556_32936\",\"names\":\"最近15天\",\"optionGroupId\":32936,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"15\"}]}],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT m_1.__aid AS __aid FROM  ( SELECT DISTINCT m_2.__aid AS __aid FROM  ( SELECT SUM(new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cart_cnt) AS sum1, new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid AS __aid FROM new_dmp.taobao_dmp_dp_view_rpt_brand_behavior WHERE (new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.bc_type IN ('-9999') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.ds >= '20211112' AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cate2_id IN ('122290002') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cart_cnt > 0) GROUP BY new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid )  AS m_2 WHERE (m_2.sum1 >= 1 AND m_2.sum1 <= 999) MINUS SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2', '3') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('15')) )  AS m_1","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":18176400,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableEdit":"false","isEnableDuplicate":"false","isEnableDelete":"false","CROWD_FACTORY_MARK_KEY":"1","crowd_iter_ai":"2","lbsStorageData":"{}","relateRecommendIds":""},"custId":null,"apps":[],"coverage":1471081,"createtime":"2022-05-11","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":47,"updatetime":null},{"validDate":"2023-04-30","baseCrowdExpression":"SELECT DISTINCT m_1.__aid AS __aid FROM  ( SELECT DISTINCT m_2.__aid AS __aid FROM  ( SELECT SUM(new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.clt_cnt) AS sum1, new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid AS __aid FROM new_dmp.taobao_dmp_dp_view_rpt_brand_behavior WHERE (new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.bc_type IN ('-9999') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.ds >= '20211112' AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cate2_id IN ('122290002') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.clt_cnt > 0) GROUP BY new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid )  AS m_2 WHERE (m_2.sum1 >= 1 AND m_2.sum1 <= 999) MINUS SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2', '3') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('15')) )  AS m_1","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"蔓迪品牌_180天收藏15天未购","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":22118980,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"蔓迪","tagId":160784,"price":null,"values":"3883772","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40010,"key":"160784_40010"},{"optionType":null,"names":"OTC药品/国际医药>OTC药品>白发脱发","tagId":160784,"price":null,"values":"122290002","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40025,"key":"160784_40025"},{"optionType":null,"names":"全部","tagId":160784,"price":null,"values":"-9999","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40012,"key":"160784_40012"},{"optionType":null,"names":"收藏","tagId":160784,"price":null,"values":"2","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40014,"key":"160784_40014"},{"optionType":null,"names":"1~999","tagId":160784,"price":null,"values":"1~999","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40016,"key":"160784_40016"},{"optionType":null,"names":"最近N天","tagId":160784,"price":null,"values":"1","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40022,"key":"160784_40022"},{"optionType":null,"names":"180","tagId":160784,"price":null,"values":"180","tagName":"品牌行为人群_S5","adapterType":null,"optionGroupId":40023,"key":"160784_40023"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"蔓迪","tagId":150556,"price":null,"values":"3883772","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32933,"key":"150556_32933"},{"optionType":null,"names":"购买","tagId":150556,"price":null,"values":"4","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32934,"key":"150556_32934"},{"optionType":null,"names":"高,中,低","tagId":150556,"price":null,"values":"1,2,3","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32935,"key":"150556_32935"},{"optionType":null,"names":"最近15天","tagId":150556,"price":null,"values":"15","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32936,"key":"150556_32936"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-05-11","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"160784_40010\",\"names\":\"蔓迪\",\"optionGroupId\":40010,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"3883772\"},{\"key\":\"160784_40025\",\"names\":\"OTC药品/国际医药>OTC药品>白发脱发\",\"optionGroupId\":40025,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"122290002\"},{\"key\":\"160784_40012\",\"names\":\"全部\",\"optionGroupId\":40012,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"-9999\"},{\"key\":\"160784_40014\",\"names\":\"收藏\",\"optionGroupId\":40014,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"2\"},{\"key\":\"160784_40016\",\"names\":\"1~999\",\"optionGroupId\":40016,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1~999\"},{\"key\":\"160784_40022\",\"names\":\"最近N天\",\"optionGroupId\":40022,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"1\"},{\"key\":\"160784_40023\",\"names\":\"180\",\"optionGroupId\":40023,\"tagId\":160784,\"tagName\":\"品牌行为人群_S5\",\"values\":\"180\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":false,\"operator\":2,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150556_32933\",\"names\":\"蔓迪\",\"optionGroupId\":32933,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"3883772\"},{\"key\":\"150556_32934\",\"names\":\"购买\",\"optionGroupId\":32934,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"4\"},{\"key\":\"150556_32935\",\"names\":\"高,中,低\",\"optionGroupId\":32935,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"1,2,3\"},{\"key\":\"150556_32936\",\"names\":\"最近15天\",\"optionGroupId\":32936,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"15\"}]}],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT m_1.__aid AS __aid FROM  ( SELECT DISTINCT m_2.__aid AS __aid FROM  ( SELECT SUM(new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.clt_cnt) AS sum1, new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid AS __aid FROM new_dmp.taobao_dmp_dp_view_rpt_brand_behavior WHERE (new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.bc_type IN ('-9999') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.ds >= '20211112' AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.cate2_id IN ('122290002') AND new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.clt_cnt > 0) GROUP BY new_dmp.taobao_dmp_dp_view_rpt_brand_behavior.__aid )  AS m_2 WHERE (m_2.sum1 >= 1 AND m_2.sum1 <= 999) MINUS SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('3883772') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2', '3') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('15')) )  AS m_1","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":18176387,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableEdit":"false","isEnableDuplicate":"false","isEnableDelete":"false","CROWD_FACTORY_MARK_KEY":"1","crowd_iter_ai":"2","lbsStorageData":"{}","relateRecommendIds":""},"custId":null,"apps":[],"coverage":627962,"createtime":"2022-05-11","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":47,"updatetime":null},{"validDate":"2023-03-31","baseCrowdExpression":"SELECT DISTINCT new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final.__aid AS __aid FROM new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final INNER JOIN new_dmp.alimama_ods_dmp_kw_aid2kw_output ON new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final.__aid = new_dmp.alimama_ods_dmp_kw_aid2kw_output.__aid WHERE (new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final.interest_group IN ('7', '39') AND new_dmp.alimama_ods_dmp_kw_aid2kw_output.period <= '30' AND new_dmp.alimama_ods_dmp_kw_aid2kw_output.kw_ids IN ('16419937', '16227888', '16200408', '15937692', '15577787', '15937686', '16117460', '15937697', '16200420', '18220189', '14848103', 's_15626596'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"水飞蓟_养生专家_酒品人生","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"万相台侧重人群专用_引力魔方","appId":83,"enableTime":"2022-05-09","id":21993261,"status":2},{"iconMark":"&#xe685;","appName":"万相台侧重人群专用_直通车","appId":81,"enableTime":"2022-07-13","id":21993259,"status":2},{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-05-09","id":21992901,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"最近30天","tagId":162845,"price":null,"values":"30","tagName":"关键词圈人高阶版","adapterType":null,"optionGroupId":40991,"key":"162845_40991"},{"optionType":null,"names":"水飞蓟,水飞蓟胶囊,护肝水飞蓟,护肝水飞蓟胶囊,奶蓟草水飞蓟,护肝,护肝片,护肝胶囊,护肝片男士,护肝片正品,保肝,保肝护肝","tagId":162845,"price":null,"values":"16419937,16227888,16200408,15937692,15577787,15937686,16117460,15937697,16200420,18220189,14848103,s_15626596","tagName":"关键词圈人高阶版","adapterType":null,"optionGroupId":40992,"key":"162845_40992"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"养生专家,酒品人生","tagId":125020,"price":null,"values":"7,39","tagName":"特征兴趣","adapterType":null,"optionGroupId":13539,"key":"125020_13539"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-04-29","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"162845_40991\",\"names\":\"最近30天\",\"optionGroupId\":40991,\"tagId\":162845,\"tagName\":\"关键词圈人高阶版\",\"values\":\"30\"},{\"key\":\"162845_40992\",\"names\":\"水飞蓟,水飞蓟胶囊,护肝水飞蓟,护肝水飞蓟胶囊,奶蓟草水飞蓟,护肝,护肝片,护肝胶囊,护肝片男士,护肝片正品,保肝,保肝护肝\",\"optionGroupId\":40992,\"tagId\":162845,\"tagName\":\"关键词圈人高阶版\",\"values\":\"16419937,16227888,16200408,15937692,15577787,15937686,16117460,15937697,16200420,18220189,14848103,s_15626596\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"125020_13539\",\"names\":\"养生专家,酒品人生\",\"optionGroupId\":13539,\"tagId\":125020,\"tagName\":\"特征兴趣\",\"values\":\"7,39\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final.__aid AS __aid FROM new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final INNER JOIN new_dmp.alimama_ods_dmp_kw_aid2kw_output ON new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final.__aid = new_dmp.alimama_ods_dmp_kw_aid2kw_output.__aid WHERE (new_dmp.dmj_ex_1_gprofile_tag_base_part_fourth_final.interest_group IN ('7', '39') AND new_dmp.alimama_ods_dmp_kw_aid2kw_output.period <= '30' AND new_dmp.alimama_ods_dmp_kw_aid2kw_output.kw_ids IN ('16419937', '16227888', '16200408', '15937692', '15577787', '15937686', '16117460', '15937697', '16200420', '18220189', '14848103', 's_15626596'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":18029335,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableDelete":"false","crowd_iter_ai":"2","isEnableEdit":"false","lbsStorageData":"{}","relateRecommendIds":"","isEnableDuplicate":"false"},"custId":null,"apps":[],"coverage":1267820,"createtime":"2022-04-29","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null},{"validDate":"2023-03-31","baseCrowdExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('3230013') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('2', '3', '4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('30'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"品牌_江中近30天收藏加购购买","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"万相台侧重人群专用_引力魔方","appId":83,"enableTime":"2022-08-01","id":21837252,"status":2},{"iconMark":"&#xe685;","appName":"万相台侧重人群专用_直通车","appId":81,"enableTime":"2022-08-01","id":21837251,"status":2},{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-08-01","id":21837245,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"江中","tagId":150556,"price":null,"values":"3230013","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32933,"key":"150556_32933"},{"optionType":null,"names":"收藏,加购,购买","tagId":150556,"price":null,"values":"2,3,4","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32934,"key":"150556_32934"},{"optionType":null,"names":"高,中","tagId":150556,"price":null,"values":"1,2","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32935,"key":"150556_32935"},{"optionType":null,"names":"最近30天","tagId":150556,"price":null,"values":"30","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32936,"key":"150556_32936"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-04-18","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150556_32933\",\"names\":\"江中\",\"optionGroupId\":32933,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"3230013\"},{\"key\":\"150556_32934\",\"names\":\"收藏,加购,购买\",\"optionGroupId\":32934,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"2,3,4\"},{\"key\":\"150556_32935\",\"names\":\"高,中\",\"optionGroupId\":32935,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"1,2\"},{\"key\":\"150556_32936\",\"names\":\"最近30天\",\"optionGroupId\":32936,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"30\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('3230013') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('2', '3', '4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('30'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":17870158,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","canOptimization":"1","isEnableEdit":"false","isEnableDuplicate":"false","isEnableDelete":"false","crowd_iter_ai":"2","lbsStorageData":"{}","relateRecommendIds":""},"custId":null,"apps":[],"coverage":415232,"createtime":"2022-04-18","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null},{"validDate":"2023-02-28","baseCrowdExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('1878075452') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('1', '2', '3', '4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2', '3') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('90'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"赛洛兰_近90天行为人群","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-29","id":21661320,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"赛洛兰","tagId":150556,"price":null,"values":"1878075452","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32933,"key":"150556_32933"},{"optionType":null,"names":"浏览,收藏,加购,购买","tagId":150556,"price":null,"values":"1,2,3,4","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32934,"key":"150556_32934"},{"optionType":null,"names":"高,中,低","tagId":150556,"price":null,"values":"1,2,3","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32935,"key":"150556_32935"},{"optionType":null,"names":"最近90天","tagId":150556,"price":null,"values":"90","tagName":"店铺品牌行为人群","adapterType":null,"optionGroupId":32936,"key":"150556_32936"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-03-31","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150556_32933\",\"names\":\"赛洛兰\",\"optionGroupId\":32933,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"1878075452\"},{\"key\":\"150556_32934\",\"names\":\"浏览,收藏,加购,购买\",\"optionGroupId\":32934,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"1,2,3,4\"},{\"key\":\"150556_32935\",\"names\":\"高,中,低\",\"optionGroupId\":32935,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"1,2,3\"},{\"key\":\"150556_32936\",\"names\":\"最近90天\",\"optionGroupId\":32936,\"tagId\":150556,\"tagName\":\"店铺品牌行为人群\",\"values\":\"90\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.brand_id IN ('1878075452') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.type IN ('1', '2', '3', '4') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.level IN ('1', '2', '3') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_brand_behavior_normal.period IN ('90'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":17721236,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableDelete":"false","crowd_iter_ai":"2","isEnableEdit":"false","lbsStorageData":"{}","relateRecommendIds":"","isEnableDuplicate":"false"},"custId":null,"apps":[],"coverage":31191,"createtime":"2022-03-31","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null},{"validDate":"2023-02-28","baseCrowdExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425 ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.__aid WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.gender IN ('0') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.member_level IN ('1', '10') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.alipay_amt_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.alipay_freq_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.dim IN ('4'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"白芸豆_乡村金凤凰","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":21647798,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"乡村金凤凰","tagId":152127,"price":null,"values":"4","tagName":"下沉市场特征用户","adapterType":null,"optionGroupId":34225,"key":"152127_34225"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"女性用户","tagId":114554,"price":null,"values":"0","tagName":"用户性别","adapterType":null,"optionGroupId":12685,"key":"114554_12685"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"20次以上","tagId":150375,"price":null,"values":"5","tagName":"月均消费频次","adapterType":null,"optionGroupId":32710,"key":"150375_32710"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"极度活跃,超级会员","tagId":150373,"price":null,"values":"1,10","tagName":"淘气值活跃度","adapterType":null,"optionGroupId":32708,"key":"150373_32708"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"消费6000元以上","tagId":150374,"price":null,"values":"5","tagName":"月均消费金额","adapterType":null,"optionGroupId":32709,"key":"150374_32709"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-03-30","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"152127_34225\",\"names\":\"乡村金凤凰\",\"optionGroupId\":34225,\"tagId\":152127,\"tagName\":\"下沉市场特征用户\",\"values\":\"4\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"114554_12685\",\"names\":\"女性用户\",\"optionGroupId\":12685,\"tagId\":114554,\"tagName\":\"用户性别\",\"values\":\"0\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150375_32710\",\"names\":\"20次以上\",\"optionGroupId\":32710,\"tagId\":150375,\"tagName\":\"月均消费频次\",\"values\":\"5\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150373_32708\",\"names\":\"极度活跃,超级会员\",\"optionGroupId\":32708,\"tagId\":150373,\"tagName\":\"淘气值活跃度\",\"values\":\"1,10\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150374_32709\",\"names\":\"消费6000元以上\",\"optionGroupId\":32709,\"tagId\":150374,\"tagName\":\"月均消费金额\",\"values\":\"5\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425 ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.__aid WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.gender IN ('0') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.member_level IN ('1', '10') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.alipay_amt_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.alipay_freq_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.dim IN ('4'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":17708298,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableDelete":"false","crowd_iter_ai":"2","isEnableEdit":"false","lbsStorageData":"{}","relateRecommendIds":"","isEnableDuplicate":"false"},"custId":null,"apps":[],"coverage":640955,"createtime":"2022-03-30","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null},{"validDate":"2023-02-28","baseCrowdExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425 ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.__aid WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.member_level IN ('1', '10') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.alipay_amt_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.alipay_freq_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.dim IN ('1'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"白芸豆_小镇高活女性","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":21647757,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"小镇高活女性","tagId":152127,"price":null,"values":"1","tagName":"下沉市场特征用户","adapterType":null,"optionGroupId":34225,"key":"152127_34225"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"20次以上","tagId":150375,"price":null,"values":"5","tagName":"月均消费频次","adapterType":null,"optionGroupId":32710,"key":"150375_32710"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"极度活跃,超级会员","tagId":150373,"price":null,"values":"1,10","tagName":"淘气值活跃度","adapterType":null,"optionGroupId":32708,"key":"150373_32708"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"消费6000元以上","tagId":150374,"price":null,"values":"5","tagName":"月均消费金额","adapterType":null,"optionGroupId":32709,"key":"150374_32709"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-03-30","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"152127_34225\",\"names\":\"小镇高活女性\",\"optionGroupId\":34225,\"tagId\":152127,\"tagName\":\"下沉市场特征用户\",\"values\":\"1\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150375_32710\",\"names\":\"20次以上\",\"optionGroupId\":32710,\"tagId\":150375,\"tagName\":\"月均消费频次\",\"values\":\"5\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150373_32708\",\"names\":\"极度活跃,超级会员\",\"optionGroupId\":32708,\"tagId\":150373,\"tagName\":\"淘气值活跃度\",\"values\":\"1,10\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150374_32709\",\"names\":\"消费6000元以上\",\"optionGroupId\":32709,\"tagId\":150374,\"tagName\":\"月均消费金额\",\"values\":\"5\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425 ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.__aid WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.member_level IN ('1', '10') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.alipay_amt_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.alipay_freq_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_11425.dim IN ('1'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":17708247,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableDelete":"false","crowd_iter_ai":"2","isEnableEdit":"false","lbsStorageData":"{}","relateRecommendIds":"","isEnableDuplicate":"false"},"custId":null,"apps":[],"coverage":839570,"createtime":"2022-03-30","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null},{"validDate":"2023-02-28","baseCrowdExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_age ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_age.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.__aid WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.gender IN ('0') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_age.age IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.member_level IN ('1', '10') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.alipay_amt_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.alipay_freq_level IN ('5'))","groupId":0,"buildExpression":null,"businessId":null,"tableName":null,"subMemberId":null,"unionBPCrowd":false,"appId":0,"appKey":null,"crowdName":"白芸豆_女_35_39","memberId":1566800061,"xapps":[{"iconMark":"&#xe70b;","appName":"引力魔方","appId":74,"enableTime":"2022-06-30","id":21647706,"status":2}],"idType":1,"productId":null,"trackId":null,"selectTagOptionSetDTO":{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[],"selectTagOptionSetDTO":[{"selects":[{"optionType":null,"names":"女性用户","tagId":114554,"price":null,"values":"0","tagName":"用户性别","adapterType":null,"optionGroupId":12685,"key":"114554_12685"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"35-39岁","tagId":114555,"price":null,"values":"5","tagName":"用户年龄","adapterType":null,"optionGroupId":12686,"key":"114555_12686"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"20次以上","tagId":150375,"price":null,"values":"5","tagName":"月均消费频次","adapterType":null,"optionGroupId":32710,"key":"150375_32710"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"极度活跃,超级会员","tagId":150373,"price":null,"values":"1,10","tagName":"淘气值活跃度","adapterType":null,"optionGroupId":32708,"key":"150373_32708"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1},{"selects":[{"optionType":null,"names":"消费6000元以上","tagId":150374,"price":null,"values":"5","tagName":"月均消费金额","adapterType":null,"optionGroupId":32709,"key":"150374_32709"}],"selectTagOptionSetDTO":[],"leaf":true,"operator":1}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":1},{"selects":[],"selectTagOptionSetDTO":[],"leaf":true,"operator":2}],"leaf":false,"operator":4},"enableTime":"2022-03-30","lookalikeTargetCoverage":null,"skipLtpRebuild":false,"iterTarget":null,"sellerMemberId":null,"lookalikeAlgoType":0,"userExpression":"{\"leaf\":false,\"operator\":4,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":false,\"operator\":1,\"selectTagOptionSetDTO\":[{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"114554_12685\",\"names\":\"女性用户\",\"optionGroupId\":12685,\"tagId\":114554,\"tagName\":\"用户性别\",\"values\":\"0\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"114555_12686\",\"names\":\"35-39岁\",\"optionGroupId\":12686,\"tagId\":114555,\"tagName\":\"用户年龄\",\"values\":\"5\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150375_32710\",\"names\":\"20次以上\",\"optionGroupId\":32710,\"tagId\":150375,\"tagName\":\"月均消费频次\",\"values\":\"5\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150373_32708\",\"names\":\"极度活跃,超级会员\",\"optionGroupId\":32708,\"tagId\":150373,\"tagName\":\"淘气值活跃度\",\"values\":\"1,10\"}]},{\"leaf\":true,\"operator\":1,\"selectTagOptionSetDTO\":[],\"selects\":[{\"key\":\"150374_32709\",\"names\":\"消费6000元以上\",\"optionGroupId\":32709,\"tagId\":150374,\"tagName\":\"月均消费金额\",\"values\":\"5\"}]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]},{\"leaf\":true,\"operator\":2,\"selectTagOptionSetDTO\":[],\"selects\":[]}],\"selects\":[]}","deliverAppIdLst":null,"fullStatus":12,"status":1,"garudaExpression":"SELECT DISTINCT new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid AS __aid FROM new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_age ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_age.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.__aid INNER JOIN new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level ON new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.__aid = new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.__aid WHERE (new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_gender.gender IN ('0') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_gprofile_age.age IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_member_level.member_level IN ('1', '10') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_amt_level.alipay_amt_level IN ('5') AND new_dmp.taobao_dmp_dp_dmp_tagfactory_detail_alipay_freq_level.alipay_freq_level IN ('5'))","lookalikeMultiple":null,"gids":null,"newGids":null,"isIter":0,"materialized":true,"odpsExpression":null,"crowdId":17708187,"extra":{"DMP_PLUS":"1","APPLICATION_SCENE":"0","combineRecommendIds":"","_dmpBaseCrowdSourceName":"达摩盘","isEnableCombine":"true","isEnableDelete":"false","crowd_iter_ai":"2","isEnableEdit":"false","lbsStorageData":"{}","relateRecommendIds":"","isEnableDuplicate":"false"},"custId":null,"apps":[],"coverage":745095,"createtime":"2022-03-30","charge":null,"deliverAppId":null,"tbUserId":null,"crowdNew":1,"modelParam":null,"sceneCrowd":null,"storageType":1,"applyDeliverAfterCreate":true,"businessType":1,"updatetime":null}],"pager":{"currentPage":1,"total":59,"pageSize":10}},"info":{"ok":true,"message":null}}
    need_field = ['validDate', 'groupId', 'appId', 'crowdName', 'memberId',
                  'status', 'idType', 'optionType', 'names', 'tagId', 'price', 'values', 'tagName', 'adapterType',
                  'optionGroupId', 'key', 'skipLtpRebuild', 'lookalikeAlgoType', 'userExpression',
                  'fullStatus', 'isI', 'materialized', 'crowdId', 'extra', 'coverage', 'createtime',
                  'crowdNew', 'tbUserId', 'deliverAppId', 'storageType', 'applyDeliverAfterCreate',
                  'businessType', 'DMP_PLUS', 'APPLICATION_SCENE', 'combineRecommendIds', '_dmpBaseCrowdSourceName',
                  'isEnableCombine', 'isEnableEdit', 'isEnableDuplicate', 'isEnableDelete', 'crowd_iter_ai',
                  'lbsStorageData', 'relateRecommendIds', 'isClickOptimization']
    parse_json(data, need_field)
    q = [{'key': 'presales_amount', 'value': '', 'comment': '预售成交金额'}, {'key': 'campaign_type', 'value': '', 'comment': '推广类型'}, {'key': 'direct_payment_number', 'value': '', 'comment': '直接成交笔数'}, {'key': 'pull_new_cost', 'value': '', 'comment': '获客成本(元)'}, {'key': 'subject_type', 'value': '', 'comment': '主体类型'}, {'key': 'total_payment_number', 'value': '', 'comment': '总成交笔数'}, {'key': 'cpti', 'value': '', 'comment': '千次展现成本'}, {'key': 'plan_id', 'value': '', 'comment': '计划id'}, {'key': 'campaign_title', 'value': '', 'comment': '计划名称'}, {'key': 'presales_number', 'value': '', 'comment': '预售成交笔数'}, {'key': 'payment_amount', 'value': '', 'comment': '总成交金额'}, {'key': 'indirect_payment_amount', 'value': '', 'comment': '间接成交金额'}, {'key': 'package_amount', 'value': '', 'comment': '套餐金额'}, {'key': 'brand_name', 'value': '', 'comment': '店铺名称'}, {'key': 'click_cost', 'value': '', 'comment': '点击成本'}, {'key': 'direct_add_car_num', 'value': '', 'comment': '直接加购数'}, {'key': 'ncmd', 'value': '', 'comment': '社群营销成交笔数'}, {'key': 'direct_add_car_count', 'value': '', 'comment': '直接加购量'}, {'key': 'test_goods_potential_index', 'value': '', 'comment': '测款宝贝潜力指数'}, {'key': 'plan_id', 'value': '', 'comment': '计划Id'}, {'key': 'collection', 'value': '', 'comment': '收藏量'}, {'key': 'click_rate_comparison_category_mean', 'value': '', 'comment': '点击率较同类目均值'}, {'key': 'py_money', 'value': '', 'comment': '派样金额'}, {'key': 'community_marketing_money', 'value': '', 'comment': '社群营销成交金额'}, {'key': 'indirect_add_car_count', 'value': '', 'comment': '间接加购量'}, {'key': 'store_subscriptions', 'value': '', 'comment': '店铺订阅量'}, {'key': 'consume', 'value': '', 'comment': '消耗'}, {'key': 'effect_model', 'value': '', 'comment': '效果模型'}, {'key': 'total_add_car', 'value': '', 'comment': '总加购量'}, {'key': 'indirect_add_car_num', 'value': '', 'comment': '间接加购数'}, {'key': 'lzl', 'value': '', 'comment': '留资量'}, {'key': 'pyl', 'value': '', 'comment': '派样量'}, {'key': 'ctr', 'value': '', 'comment': '点击率'}, {'key': 'pnctc', 'value': '', 'comment': '新客成交金额贡献占比'}, {'key': 'car', 'value': '', 'comment': '回吐后消耗'}, {'key': 'conversion_cycle', 'value': '', 'comment': '转化周期'}, {'key': 'exposure', 'value': '', 'comment': '曝光量'}, {'key': 'torcc', 'value': '', 'comment': '留资客户成交量'}, {'key': 'tcr', 'value': '', 'comment': '成交转化率'}, {'key': 'transaction_amount', 'value': '', 'comment': '(试听课/试用品)成交金额'}, {'key': 'ww_consulting_volume', 'value': '', 'comment': '旺旺咨询量'}, {'key': 'shop_url', 'value': '', 'comment': '店铺Url'}, {'key': 'tarcc', 'value': '', 'comment': '留资客户成交金额'}, {'key': 'create_id', 'value': '', 'comment': '创意Id'}, {'key': 'indirect_payment_number', 'value': '', 'comment': '间接成交笔数'}, {'key': 'apoc', 'value': '', 'comment': '加购收藏量'}, {'key': 'store_subscription_cost', 'value': '', 'comment': '店铺订阅成本'}, {'key': 'goods_name', 'value': '', 'comment': '宝贝名称'}, {'key': 'number_viewers', 'value': '', 'comment': '观看量'}, {'key': 'plan_status', 'value': '', 'comment': '计划状态'}, {'key': 'add_collection_cost', 'value': '', 'comment': '加购收藏成本'}, {'key': 'put_cycle', 'value': '', 'comment': '投放周期'}, {'key': 'goods_id', 'value': '', 'comment': '商品Id'}, {'key': 'member_transaction_amount', 'value': '', 'comment': '会员成交金额'}, {'key': 'number_of_transactions', 'value': '', 'comment': '(试听课/试用品)成交笔数'}, {'key': 'statistical_caliber', 'value': '', 'comment': '统计口径'}, {'key': 'launch_scenario', 'value': '', 'comment': '投放场景'}, {'key': 'plan_name', 'value': '', 'comment': '计划名字'}, {'key': 'goods_id', 'value': '', 'comment': '宝贝Id'}, {'key': 'short_video_interaction', 'value': '', 'comment': '短视频互动量'}, {'key': 'click', 'value': '', 'comment': '点击量'}, {'key': 'roi', 'value': '', 'comment': 'ROI'}, {'key': 'direct_payment_amount', 'value': '', 'comment': '直接成交金额'}, {'key': 'subject_name', 'value': '', 'comment': '主体名字'}, {'key': 'sub_scene_type', 'value': '', 'comment': '子场景类型'}, {'key': 'subject_id', 'value': '', 'comment': '主体Id'}, {'key': 'membership_num', 'value': '', 'comment': '入会量'}, {'key': 'cgra', 'value': '', 'comment': '成本保障回吐金额'}, {'key': 'optimization_objective', 'value': '', 'comment': '优化目标'}, {'key': 'date', 'value': '', 'comment': '日期'}, {'key': 'new_customers_roi', 'value': '', 'comment': '新客ROI'}]
    create_msql_table("55", q)
