"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecs = require("aws-cdk-lib/aws-ecs");
// import { PostgresEngineVersion } from 'aws-cdk-lib/aws-rds';
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
//import * as kong_core from 'kong-core';
// import { RdsDatabaseProps } from './kong-eks';
const index_1 = require("./resources/ecs/index");
class KongEcs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        //Create the Kong CP ECS Cluster
        const cluster = new ecs.Cluster(this, 'KongCPCluster', props.clusterProps);
        this.controlPlane = cluster;
        //Create the RDS Instance for KongCP
        const rds = new kong_core.RdsStack(this, 'KongCPRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        //Create the NLB for KongCP Admin
        const nlbAdmin = new kong_core.NlbStack(this, 'KongCPAlb', {
            vpc: this.controlPlane.vpc,
            name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_ADMIN_LB_SUFFIX,
            internetFacing: props.internetFacing ?? false,
        });
        //Create the NLB for KongCP Manager
        let nlbManager;
        if (props.kongFeaturesProps.kongManagerProps.enabled) {
            nlbManager = new kong_core.NlbStack(this, 'KongCPManagerAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_MANAGER_LB_SUFFIX,
                internetFacing: props.internetFacing ?? false,
            });
        }
        //Create the NLB for KongCP DevPortal
        let nlbDevPortal;
        if (props.kongFeaturesProps.devPortalProps.enabled) {
            nlbDevPortal = new kong_core.NlbStack(this, 'KongCPDevPortalAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_DEVPORTAL_LB_SUFFIX,
                internetFacing: props.internetFacing ?? false,
            });
        }
        const tld = props.hostedZoneName;
        this.clusterDns = 'cluster.' + tld + ':' + (props.kongFeaturesProps.clusterProps.port ?? 8005);
        this.telemetryDns = 'telemetry.' + tld + ':' + (props.kongFeaturesProps.clusterTelemetryProps.port ?? 8006);
        const private_ca = new kong_core.AcmPca(this, 'KongPCA', {
            vpc: cluster.vpc,
            hostedZoneName: tld,
            dnsNames: [
                tld,
                'admin.' + tld,
                'cluster.' + tld,
                'telemetry.' + tld,
                'manager.' + tld,
            ],
        });
        this.privateCaArn = private_ca.privateCaArn;
        const kongCPCertificates = new kong_core.Certificates(this, 'KongCPCertificate', {
            topLevelDomain: tld,
            privateCaArn: private_ca.privateCaArn,
            dnsNames: [
                tld,
                'admin.' + tld,
                'cluster.' + tld,
                'telemetry.' + tld,
                'manager.' + tld,
            ],
        });
        kongCPCertificates.node.addDependency(private_ca);
        // const hosted_zone = aws_route53.HostedZone.fromLookup(this, 'HZ', {
        //   domainName: props.hostedZoneName,
        // });
        new index_1.KongControlPlaneECS(this, 'KongCP', {
            cluster: cluster,
            rds: rds.kongPostgresSql,
            adminNlb: nlbAdmin.kongNlb,
            managerNlb: nlbManager ? nlbManager.kongNlb : undefined,
            devPortalNlb: nlbDevPortal ? nlbDevPortal.kongNlb : undefined,
            image: props.image ?? 'docker.io/kong/kong-gateway:2.8.1.0-alpine',
            licenseSecret: props.licenseSecret ?? undefined,
            kongFeaturesProps: {
                adminProps: {
                    httpPort: props.kongFeaturesProps.adminProps.httpPort ?? 8001,
                    httpsPort: props.kongFeaturesProps.adminProps.httpsPort ?? 8444,
                    enableHttp: props.kongFeaturesProps.adminProps.enableHttp ?? true,
                },
                kongManagerProps: {
                    enabled: props.kongFeaturesProps.kongManagerProps.enabled ?? true,
                    enableHttp: props.kongFeaturesProps.kongManagerProps.enableHttp ?? true,
                    httpPort: props.kongFeaturesProps.kongManagerProps.httpPort ?? 8002,
                    httpsPort: props.kongFeaturesProps.kongManagerProps.httpsPort ?? 8445,
                },
                devPortalProps: {
                    enabled: props.kongFeaturesProps.devPortalProps.enabled ?? true,
                },
                clusterProps: {
                    enabled: props.kongFeaturesProps.clusterProps.enabled ?? true,
                    port: props.kongFeaturesProps.clusterProps.port ?? 8005,
                },
                clusterTelemetryProps: {
                    enabled: props.kongFeaturesProps.clusterTelemetryProps.enabled ?? true,
                    port: props.kongFeaturesProps.clusterTelemetryProps.port ?? 8006,
                },
                kongBootstrapMigration: props.kongFeaturesProps.kongBootstrapMigration ?? true,
            },
            kongTaskProps: props.kongTaskProps,
            certificates: kongCPCertificates,
            hostedZoneName: props.hostedZoneName,
            desiredCount: props.desiredCount,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'KongAdminLBDNSName', {
            value: nlbAdmin.kongNlb.loadBalancerDnsName,
            exportName: 'KongAdminLBDNSName',
        });
        if (nlbManager) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongManagerLBBDNSName', {
                value: nlbManager.kongNlb.loadBalancerDnsName,
                exportName: 'KongManagerLBBDNSName',
            });
        }
        if (nlbDevPortal) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongDevPortalLBBDNSName', {
                value: nlbDevPortal.kongNlb.loadBalancerDnsName,
                exportName: 'KongDevPortalLBBDNSName',
            });
        }
    }
}
exports.KongEcs = KongEcs;
_a = JSII_RTTI_SYMBOL_1;
KongEcs[_a] = { fqn: "kong-control-plane.KongEcs", version: "3.0.0-dev.19" };
//# sourceMappingURL=data:application/json;base64,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