# Umsizi wezincwadi

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 Izilimi ezitholakalayo

Izinguqulo zePyhelper zinikeza ukuhumusha okwakhelwe ngaphakathi kokufika kwezilimi ** 131 ** kufaka phakathi:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md)1108_ [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md)1106_ [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) π_997_ [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md)9_93_ [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md)93_ [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) π  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md)69_  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md)61_ [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md)59_ [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md)  
Π_57_ [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md)53 [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) π_40450_48_ π_447_  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


# # 🚀 ukufakwa

Faka kusuka ku-PYPI:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 Ukubuka konke

** Pyhelper ** iyithuluzi eliguquguqukayo  
Ihlanganisa ngaphandle komthungo ku-Acounce, ucwaningo, kanye namaphrojekthi ochwepheshe, okuvumela ukuthi ugxile ekubukeni kunokuba ikhodi ye-boilerplate.

Izinzuzo ezibalulekile:
- Izibalo ezakhelwe ngaphakathi ** kanye nezinsizakalo zezibalo ** 
- 📊 Ukusetshenziswa okulula okusebenzisekayo **
- I-Handy ** Ukuphatha Ifayela nokusesha ** 
- 🔍 ** Syntax Revation ** kwamafayela we-Python40
- 🌍 ** Ukuxhaswa kwezilimi eziningi ** nokuhumusha okulungele ukusetshenziswa
- 🚀 Kwenzelwe i-Prestotyping ** kanye neMfundo ** 

---

## ✨ Izici Key

### 📊 ukubukwa kwedatha
- Amashadi we-Bar: avundlile & vertical (`hbar`, `vbar`)  
- Ukusabalalisa Iziza: Ama-histograms (`histo`), ama-box plots (`boxplot`), kde plots (`kdeplot`)  
- Iziza zokuqhathanisa: i-violin, i-gearm, iziza zomucu  
- Ukuhlaziywa kokuhlangana: Ama-HeatMaps (`heatmap`), akepp akisa ama-(`scatter`)  
- Ukubonwa okuthuthukile: Hlanganisa iziza, iziza ezihlanganayo, iziza zokuphindaphinda  
- Amathebula wedatha: Ithebula elifomethiwe libonisa (`table`)  

### 📈 Ukuhlaziywa Kwezibalo
- ** Ithayinti eliphakeme ** : Kusho (`get_media`), Median (`get_median`), Imodi π_  
- ** Ukuhlakazeka ** : Uhla lwe-[![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md), umehluko (`get_var`), ukuphambuka okujwayelekile (`get_desv`)  
- ** Ukuhlaziywa ** : Imibiko yokuhlakazeka [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md), izibalo ze-IQR, ukuguqulwa okujwayelekile, ukuguqula okunemibandela  
- ** I-Outlier Detection ** : Izindlela ze-IQR ne-Z-SCORE  

### 🗂️ ukuphathwa kwefayela
- Ukutholwa kwe-Smart nge-`call()` (auto-detect CSV, JSON, XML, etc.)  
- Ukuxhaswa kwamafomethi amaningi (CSV, JSON, XML, PDF, spatial data)  
- Ukuphathwa kweDatabase ye-SQL nge-`DataBase` Class  
- Izinsiza Zokuguqula ```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```  

### 🛠️ Amathuluzi wonjiniyela
- Shintsha uhlelo (`Switch`, `AsyncSwitch`)  
- Ukuhlola i-Syntax [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md)  
- Iphutha elicebile elibika [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md)  
- Uhlelo Oludidiyelwe Usizo ```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```  

### 🌍
- 100+ Ukuhumusha okwakhelwe ngaphakathi  
- Ukuhunyushwa ngokwezifiso okulula  
- Ulimi LOKUGCINA LOKUGCINA LOKUFUNDA (`set_language()114_13_


### izibalo eziyisisekelo
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### I-Visuanization
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

# # 1 Ukuphathwa Kwefayela
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### Ukuhumusha Kwakho Kwamanje
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### syntax ukuqinisekiswa
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 isakhiwo sephrojekthi

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## π License

Le phrojekthi inamalayisense ngaphansi kwe- ** MIT π_4 _ ** .  
Bona ifayela le-[LICENSE](LICENSE) ngemininingwane.

---

## 🔮 Roadmap

- Izinhlobo ezengeziwe zokubuka

- I-database ye-database enwetshiwe (NoSQL, graph databases)

- Ukuhlanganiswa komshini wokuhlanganisa

- Isikhombimsebenzisi esisekelwe kuwebhu

- Uhlelo lwe-plugin

---

⚡ Ukulungele ukwehlisa ukuqhekeka kwakho kwe-Python yakho nge - ** pyhelper ** ? Qala ukuhlola namuhla!