# Ярдәмче китапханәсе

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 Мөмкин

Фихехер ** 131 телгә кадәр булган тәрҗемәләрне тәкъдим итә ** 131 телдән **, шул исәптән:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) π_10101_  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![qu](https://img.shields.io/badge/lang-qu-red.svg)](readme/README.qu.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![so](https://img.shields.io/badge/lang-so-orange.svg)](readme/README.so.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![tt](https://img.shields.io/badge/lang-tt-orange.svg)](readme/README.tt.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 урнаштыруны

Пипидан урнаштырыгыз:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 артык күзәтү

** Фихерпер ** Бик күп санлы.  
Бу академик, тикшеренүләр, профессиональ проектларга бертуктаусыз интеграцияләнә, боланерплат коды түгел, ә төнләргә игътибар итергә мөмкинлек бирә.

Төп өстенлекләр:
- 🧮 төзелгән ** статистика һәм математика гаиләсе ** 
- 📊 җиңел - куллану ** Мәгълүмат визуализациясе трафиклары ** 
- 🗂 куллы ** файл эшкәртү һәм эзләү ** 
- 🔍* синтаксикс тикшерү ** Python файллар өчен
- 🌍 ** Күп телле ярдәм ** Әзер тәрҗемә итү белән
- ** Тиз прототибинг ** һәм ** Мәгариф ** өчен оптимальләштерелгән **

---

## ✨ Төп үзенчәлекләр

### 📊 мәгълүмат визуализациясе
- Бар схемалары: горизонталь һәм вертикаль (`hbar`, `vbar`)  
- Бүләк киймәләре: гистограммалар (`histo`), Кэро бүлмәләре (`boxplot`), Кид участоклары (`kdeplot`)  
- Чагыштырма участоклар: Скрипка, сузык, полосалар  
- Корреляция анализы: (`heatmap`), таратучы ташлар (`scatter`)  
- Алга киткән визуализацияләр: пар кичектерү, уртак участоклар, регрессия участоклары  
- Мәгълүмат өстәлләре: Форматланган таблица (`table`)  

### 📈 статистик анализ
- ** Centralзәк тенденция ** : уртача (`get_media`), Медиан (`get_median`), режим (`get_moda`)  
- ** дисперсия ** : (`get_rank`), вариант (`get_var`), стандарт тайпрация (`get_desv`)  
- ** Анализ ** : дисперсия отчетлар (`disp`), IQR исәпләүләр, нормальләштерү, шартлы трансформацияләр  
- ** Officлем ачыклау ** : IQR һәм З-Сигез балл ысуллары  

### 🗂️ файл белән идарә итү
- `call()` (auto-detect CSV, JSON, XML, etc.) белән акыллы ачыш  
- күп форматлы ярдәм (CSV, JSON, XML, PDF, spatial data)  
- SQL мәгълүмат базасы белән идарә итү `DataBase` класс белән  
- Конверсия коммуналь хезмәтләр (`convert_file`)  

### 🛠️ ясаучы кораллар
- Система системасы (`Switch`, `AsyncSwitch`)  
- Синтаксисны тикшерү (`check_syntax`, `PythonFileChecker`)  
- (multi-language) отчет  
- Интеграль ярдәм системасы (`help`)  

### 🌍 интернационализация
- 100+ төзелгән тәрҗемәләр  
- махсус тәрҗемәләрне йөкләү  
- Эш вакыты (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
``___14_ ``


### төп статистика
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### визуальләштерү
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### файл эшкәртү
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### махсус тәрҗемәләр
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### синтаксикс тикшерүе
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 Проект структурасы

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

Бу проект ** MIT π_4 π_4 _ ** * астында лицензияләнгән.  
Детальләр өчен [LICENSE](LICENSE) файлны карагыз.

---

## 🔮 юл картасы

- Өстәмә визуализация төрләре

- киңәйтелгән мәгълүмат базасы ярдәме (NoSQL, graph databases)

- Машина өйрәнү интеграциясе

- Веб-нигездә интерфейс

- Плагин системасы

---

⚡ your_1_ эш урыннарын ** fyhelper белән кире кайтарырга әзер ** ? Бүген өйрәнә башлагыз!