# Kömekçi kitaphanasy

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 🌍 El elýeterli diller

Piwelper ** 131 dil üçin gurlan translatmalary hödürleýär ** , şol sanda ** 131 dil üçin

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) Π_169_ Π_16_ Π_16_ Π_16_ Π_16_ Π_116_ π11161  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) Π_159_ π1158_ Π_153_ π1153_ [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) Π_149_ Π_148_ Π_144_ Π_144_ π1144_ π1141_ π1141_  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) Π Π1139_ π1138_ Π_138_ Π_133_ Π_133_ π1133_ Python  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) Π1129_ Π_128_ π1128_ ```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
``` π1123_ ```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
``````python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) Π111_ Π_118_ Π_118_ π114_ Π_111_ π111_ π111_ π111_ π111_  
Π1110_ Π_109_ Π_108_ Π_106_ π111_ π111_ Π_103_ Π_1101_  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) Π Π Π Π_98_ Π_98_ [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) π_93 Π__9_ π_91 π_  
π_  
Π_79_ Π_78_ Π_77_ Π_73_ Π_73_ π_71 Π__71 π_  
Π_68_ Π_67_ Π_66_ [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) Π_61_ π_61 Π_  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) Π_56_ Π_51_ Π_51_ Π_51_ Π__4_ Π__4_ License License [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md)  
Π_46_ Π_45_ Π_44_ Π___ Π__3_

---


## 🚀 gurnama

PIPI-den guruň:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 stere syn

** Paýşer ** ** Maglumat derňewini, wizual amallary, statistik amallary we peýdalylyk üçin niýetlenen vilmiki Π_41_ gurallar toplumy  
Akademik, gözleglere we hünär taslamalaryna sazlanyp, Boşluk koduna däl-de, düşünjelere ünsi jemlemäge mümkinçilik berýär.

Esasy artykmaçlyklar:
- 🧮 gurlan ** ** statistika we matematika utgaşmasy **
- 📊 aňsat-ulanmak ** maglumatlary wizuallaşdyrmak örtükleri ** 
- 🗂 derýa ** faýly işlemek we gözlemek ** 
- 🔍 ** sintaksis tassyklamasy ** π440_ faýllary üçin **
- 🌍 ** enelik köp dil ​​goldawy * Taýýar ulanyş terjimeleri bilen
- 🚀 ** çalt prototip üçin ** we ** bilim ** 

---

## ✨ esasy aýratynlyklary

### 📊 Maglumat wizuallaşdyrmagy
- Barlyk diagrammalary: Gorizontal & Wertikal (`hbar`, `vbar`)  
- Distribany paýlamak: gistogrammalar Π_38_  
- deňeşdirme lots: Skripka, Smarm, zolak ýerleri  
- correasiýa derňewi: Cheprepalaplar Π_35_, Smatter plots (`scatter`)  
- Öň ösen noýektler: Jübüt ýerler, bilelikdäki lotlar, regressiýa plakatlary  
- maglumat tablisalary: formatlanan tablisa görkezilýär (`table`)  

###
- ** merkezi tendensiýa ** : Orta (`get_media`), MEDIT Π_31_  
- ** dargamak ** : Aralyk ** Aralyk Π_29_, Π_28_  
- ** Derňew ** : Dispersiýa hasabat berýär Π_26_, IQR hasaplamalary, kadalaşdyrmak, şertli üýtgetmek  
- ** Daşarky birleşmek ** : IQR we Z-bal usullary  

### 🗂️ faýly dolandyryş
- `call()` π25_ bilen akylly açyş π_24  
- Köp formatiýa goldaw (CSV, JSON, XML, PDF, spatial data)  
- SQL maglumat bazasyny π22_ synpy bilen SQL maglumatlar bazasyny dolandyrmak  
- Öwürmek boýunça kömekler Π_21_  

### 🛠️ repser gurallary
- Ulgam ulgamy Π_20_  
- sintaksis barlagyny barlamak (`check_syntax`, `PythonFileChecker`)  
- baý säwlik habar bermek (multi-language)  
- integrirlenen kömek ulgamy Π_17_  

### wrofor
- 100+ gurlan terjimeler  
- Customörite terjimelerini ýükläň  
- iş wagty dili çalyşmagy (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
`


### esasy statistika
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### wizuallaşdyrma
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### faýly işlemek
Π_10_

### Customalatlar
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### sintaksis tassyklamasy
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 Taslamanyň gurluşy

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 π License

Bu taslama ** MIT π_4 π4 Π_ * ** -de ygtyýarnama berilýär.  
Jikme-jiklikler üçin [LICENSE](LICENSE) faýlyna serediň.

---

## 🔮 ýol kartasy

- Goşmaça wizual görnüş görnüşleri

- TRT-iň giň ýaýran maglumat bazasynyň goldawy (NoSQL, graph databases)

- maşyn okuw integrasiýasy

- Web esasly interfeýs

- plugin ulgamy

---

A ** pyhelper ** pyhelper ** super-laryňyzy superkalynlaşdyrmaga taýyn ** ? Şu gün gözleg başlaň!