# Mubatsiri raibhurari

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

# # 🌍 Mitauro Inowanikwa

Pyhelper anopa zvakavakirwa-mushanduro dzeKutenderera kusvika ** Mitauro 131 ** inosanganisira:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md)  [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md)  [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md)  [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md)  [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md)  [![tr](https://img.shields.io/badge/lang-tr-orange.svg)](readme/README.tr.md)  [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md)  [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md)  [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md)  [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
π - 1  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md)  [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md)  [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md)  [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md)  [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md)  [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md)  [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md)  [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md)  [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md)  [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) `` [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
` π_ π_ `` [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md)  [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md)  [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md)  [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md)  [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md)  [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md)  [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md)  [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md)  [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md)  [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) π_ [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) π_  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md)  [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md)  [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md)  [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md)  [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md)  [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md)  [![kri](https://img.shields.io/badge/lang-kri-orange.svg)](readme/README.kri.md)  [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md)  [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md)  [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) ```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
``` π_ π_ π_ π_ π_ π_ π_ π_ [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) ```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
``````python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
``` π_ π_  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) π_ π_ π_ [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) π_ π_ π_ π_  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) о56_ [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ π_ License π_  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) License

---


# # 🚀 kuisirwa

Isa kubva pypi:

License

---

# # 📖 Overview

.  
Iyo inobatanidza musaridzi mumudzidzi, kutsvagisa, uye hunyanzvi mapurojekiti, uchikubvumira kuti utarise nezvezvinonzwisiswa kwete coilerplate kodhi.

Zvakanakisa Zvakanakira:
- 🧮 Yakavakwa-in ** nhamba uye math zvinoshandiswa ** 
- 📊 Easy-To-Kushandisa ** Data Visualization Crappers ** 
- 【Happy ** faira kubata uye kutsvaga ** 
- 🔍 ** Syntax Indationation ** ye Python mafaera
- 🌍 ** Mult-Mutauro Tsigiro
- 🚀 Optimised for ** nekukurumidza prototyping ** uye ** dzidzo ** 

---

# # ✨ Kiyi yezvinhu

# # 1 # 📊 Kuonekwa kweData
- Bar chati: yakatwasuka & vertical (`hbar`, `vbar`)  
- Kuparadzira Zvirongwa: Histograms (`histo`), bhokisi plots (`boxplot`), kde plots (`kdeplot`)  
- enzanisa zvirongwa: violin, boka, strip plots  
- kuongorora kuongorora: Heatmaps er-(`heatmap`), scatter plots (`scatter`)  
- Yakatangira Visualizations: Pair Plots, Joint Plots, Regression Zvirongwa  
- Matafura yedata: Yakagadzirirwa tafura inoratidza [LICENSE](LICENSE)  

# # 1 #
- ** Central Tyncy  
- ** Kupararira ** : Range (`get_rank`), mutsauko (`get_var`), standard kutsauka (`get_desv`)  
-**  
- ** Outler Kuona ** : IQR uye Z-Score Nzira  

# # 1 # 🗂️ faira maneja
- Smart Discovery ne `call()` (auto-detect CSV, JSON, XML, etc.)  
- Multi-formation rutsigiro [LICENSE](LICENSE)  
- SQL Database Management ine `DataBase` kirasi  
- Kutendeuka UTILICUS (`convert_file`)  

# # 1 # 🛠️ zvishandiso zvekugadzira
- switch system (`Switch`, `AsyncSwitch`)  
- Syntax yekutarisa (`check_syntax`, `PythonFileChecker`)  
- Kukanganisa kupfuma kushuma (multi-language)  
- Yakabatanidzwa rubatsiro system q_17_  

# # 1 # 🌍 International
- 100+ Akavakwa-mushanduro  
- mutoro wetsika shanduro  
- Runtime Mutauro Wachinja (`set_language() _15_15_`` 14_14_13_13_


# # # Basic Basic
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

# # 1 # Kuonekwa
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

# # 1 # faira rinobata
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

# # 1 1 Shanduro dzetsika
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

# # 1
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

# # 📂 Project chimiro

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

# # 📜 📜_6_

Iyi purojekiti ine marezinesi pasi pe ** MIT π_4 _ ** .  
Ona iyo [LICENSE](LICENSE) faira rezvinyorwa.

---

# # 🔮 Roadmap

- Kuwedzera Mhando dzeVaisualization

- Yakawedzerwa Database Tsigiro π_

- Muchina Kudzidza Kubatanidzwa

- webhu-based interface

- plugin system

---

⚡ Wagadzirira Supercharge yako Python Inoshanda Ine ** Pyhelper ** ? Kutanga kuongorora nhasi!