# සහායක පුස්තකාලය

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 භාෂා භාෂා

PyHelper විසින් *** 131 දක්වා ලුණු සහිත පරිවර්තන ලබා දෙයි ** ඇතුළුව:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![es](https://img.shields.io/badge/lang-es-yellow.svg)](readme/README.es.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md) [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![af](https://img.shields.io/badge/lang-af-orange.svg)](readme/README.af.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![hy](https://img.shields.io/badge/lang-hy-red.svg)](readme/README.hy.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![be](https://img.shields.io/badge/lang-be-darkblue.svg)](readme/README.be.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md)119_ [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![la](https://img.shields.io/badge/lang-la-orange.svg)](readme/README.la.md) [![lv](https://img.shields.io/badge/lang-lv-green.svg)](readme/README.lv.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![ml](https://img.shields.io/badge/lang-ml-orange.svg)](readme/README.ml.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![sn](https://img.shields.io/badge/lang-sn-orange.svg)](readme/README.sn.md)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sk](https://img.shields.io/badge/lang-sk-red.svg)](readme/README.sk.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) π_609_ π_609_  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md) [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md) [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md) [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md) [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md) [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md) [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) [![yo](https://img.shields.io/badge/lang-yo-orange.svg)](readme/README.yo.md) [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## ස්ථාපනය

PYPI වෙතින් ස්ථාපනය කරන්න:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 දළ විශ්ලේෂණය

** Pyhelper ** දත්ත විශ්ලේෂණය, දෘශ්යකරණය, සංඛ්යාන මෙහෙයුම් සහ උපයෝගීතා වැඩ ප්රවාහය සරල කිරීම සඳහා නිර්මාණය කර ඇති බහුතරයක් **_41_ මෙවලම් කට්ටලය වේ.  
එය බාධාවකින් තොරව ශාස්ත්රීය, පර්යේෂණ හා වෘත්තීය ව්යාපෘති සඳහා ඒකාබද්ධ වන අතර බොයිලේරු තහඩුවට වඩා තීක්ෂ්ණ බුද්ධිය කෙරෙහි අවධානය යොමු කිරීමට ඔබට ඉඩ සලසයි.

ප්රධාන වාසි:
- 🧮 බිල්ට් - සංඛ්යාලේඛන හා ගණිත උපයෝගීතා **
- a භාවිතා කිරීම පහසු ** දත්ත දෘශ්යකරණ වෝපර් ** 
- harywy ** ගොනු හැසිරවීම සහ සෙවීම ** 
- 🔍 * ** syntax වලංගුභාවය ** Python ගොනු සඳහා
- 🌍 ** බහු භාෂා සහාය ** භාවිතා කිරීමට සූදානම් පරිවර්තන සමඟ
- the වේගවත් මූලාකෘති ** සහ අධ්යාපනය සඳහා ප්රශස්ත කර ඇත ** 

---

## ✨ යතුරු ලක්ෂණ

### 📊 දත්ත දෘශ්යකරණය
- බාර් ප්රස්ථාර: තිරස් සහ සිරස් (`hbar`, `vbar`)  
- බෙදා හැරීමේ බිම් කොටස්: හිස්ටෝග්රෑම් (`histo`), කොටු බිම් (`boxplot`), kde plots (`kdeplot`)  
- සංසන්දනාත්මක බිම් කොටස්: වයලීනය, රංචු, තීරු බිම්  
- සහසම්බන්ධකරණ විශ්ලේෂණය: තාපය (`heatmap`), ස්කාටර් ප්ලොට්ස් (`scatter`)  
- උසස් දෘශ්යකරණයන්: යුගල බිම් කොටස්, ඒකාබද්ධ බිම් කොටස්, ප්රතිගාමී බිම් කොටස්  
- දත්ත වගු: ආකෘතිගත කරන ලද වගුව පෙන්වයි (`table`)  

### 📈 සංඛ්යාන විශ්ලේෂණය
- ** කේන්ද්රීය ප්රෝන තාක්ෂණය ** : මධ්යන්ය (`get_media`), Median (`get_median`), මාදිලිය (`get_moda`)  
- ** විසුරුවා හැරීම ** : පරාසය (`get_rank`), විචලනය (`get_var`), සම්මත අපගමනය (`get_desv`)  
- ** විශ්ලේෂණය ** : විසර්ජන වාර්තා (`disp`), iqr ගණනය කිරීම්, සාමාන්යකරණය, කොන්දේසි සහිත පරිවර්තනය  
- ** අභිබවා යාම - IQR සහ ඉසෙඩ් ලකුණු ක්රම  

### 🗂️ ගොනු කළමනාකරණය
- `call()` (auto-detect CSV, JSON, XML, etc.) සමඟ ස්මාර්ට් ඩිස්කවරි  
- බහු-ආකෘති සහාය (CSV, JSON, XML, PDF, spatial data)  
- `DataBase` පන්තිය සමඟ SQL දත්ත සමුදාය කළමනාකරණය  
- පරිවර්තන උපයෝගිතා (`convert_file`)  

### 🛠️ සංවර්ධක මෙවලම්
- පද්ධතිය මාරු කරන්න (`Switch`, `AsyncSwitch`)  
- සින්ටැක්ස් පරීක්ෂා කිරීම (`check_syntax`, `PythonFileChecker`)  
- පොහොසත් දෝෂ වාර්තා කිරීම (multi-language)  
- ඒකාබද්ධ උපකාරක පද්ධතිය (`help`)  

### 🌍 ජාත්යන්තරකරණය
- 100+ LOD-ENT සංවේදනය  
- අභිරුචි පරිවර්තන පූරණය කරන්න  
- ධාවන කාලය භාෂා මාරුව (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```_14_ ``


### මූලික සංඛ්යාලේඛන
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### දෘශ්යකරණය
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ගොනු හැසිරවීම
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### අභිරුචි පරිවර්තන
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### සින්ටාක්ස් වලංගු කිරීම
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 ව්යාපෘති ව්යුහය

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 📜_6_

මෙම ව්යාපෘතිය ** MIT π_4 _ _ _ ** යටතේ බලපත්ර ලබා ඇත.  
විස්තර සඳහා [LICENSE](LICENSE) ගොනුව බලන්න.

---

## 🔮 මාර්ග සිතියම

- අතිරේක දෘශ්යකරණ වර්ග

- දීර් extended දත්ත සමුදා සහාය (NoSQL, graph databases)

- යන්ත්ර ඉගෙනුම් ඒකාබද්ධ කිරීම

- වෙබ් පාදක අතුරුමුහුණත

- ප්ලගිනය පද්ධතිය

---

Your ඔබේ Python කාර්ය ප්රවාහය ** Pyhelper සමඟ සුපිරි චේන්ජ් ** ? අද ගවේෂණය කරන්න!