# ହେଲପର ଲାଇବ୍ରେରୀ |

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE) [![PyPI](https://img.shields.io/pypi/v/pyhelper-tools-jbhm?style=for-the-badge&label=PyPI&color=blue)](https://pypi.org/project/pyhelper-tools-jbhm/)

## 🌍 ଉପଲବ୍ଧ ଭାଷାଗୁଡିକ |

** 131 ଭାଷା ପାଇଁ ପିଲେଲପର୍ ଅବତାଜ-ଇନ୍ ଅନୁବାଦଗୁଡିକ ** ଅନ୍ତର୍ଭୁକ୍ତ:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) [![fr](https://img.shields.io/badge/lang-fr-blue.svg)](readme/README.fr.md) [![de](https://img.shields.io/badge/lang-de-green.svg)](readme/README.de.md) [![ru](https://img.shields.io/badge/lang-ru-purple.svg)](readme/README.ru.md) [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![it](https://img.shields.io/badge/lang-it-lightgrey.svg)](readme/README.it.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md) [![sv](https://img.shields.io/badge/lang-sv-blue.svg)](readme/README.sv.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) [![ar](https://img.shields.io/badge/lang-ar-brown.svg)](readme/README.ar.md) [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![as](https://img.shields.io/badge/lang-as-purple.svg)](readme/README.as.md) [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md) [![bn](https://img.shields.io/badge/lang-bn-teal.svg)](readme/README.bn.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bs](https://img.shields.io/badge/lang-bs-purple.svg)](readme/README.bm.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) [![ca](https://img.shields.io/badge/lang-ca-yellow.svg)](readme/README.ca.md) `python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
` [![ny](https://img.shields.io/badge/lang-ny-red.svg)](readme/README.ny.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md) [![co](https://img.shields.io/badge/lang-co-green.svg)](readme/README.co.md)  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![da](https://img.shields.io/badge/lang-da-purple.svg)](readme/README.da.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![doi](https://img.shields.io/badge/lang-doi-brown.svg)](readme/README.doi.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![eo](https://img.shields.io/badge/lang-eo-green.svg)](readme/README.eo.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md) [![ee](https://img.shields.io/badge/lang-ee-red.svg)](readme/README.ee.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md) [![tl](https://img.shields.io/badge/lang-tl-purple.svg)](readme/README.tl.md)  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![ka](https://img.shields.io/badge/lang-ka-red.svg)](readme/README.ka.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![gn](https://img.shields.io/badge/lang-gn-purple.svg)](readme/README.gn.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![ha](https://img.shields.io/badge/lang-ha-blue.svg)](readme/README.ha.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![ilo](https://img.shields.io/badge/lang-ilo-orange.svg)](readme/README.ilo.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md) [![jw](https://img.shields.io/badge/lang-jw-red.svg)](readme/README.jw.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![kk](https://img.shields.io/badge/lang-kk-orange.svg)](readme/README.kk.md) [![rw](https://img.shields.io/badge/lang-rw-blue.svg)](readme/README.rw.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md) [![ky](https://img.shields.io/badge/lang-ky-red.svg)](readme/README.ky.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) [![mk](https://img.shields.io/badge/lang-mk-green.svg)](readme/README.mk.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mai](https://img.shields.io/badge/lang-mai-blue.svg)](readme/README.mai.md) [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mt](https://img.shields.io/badge/lang-mt-green.svg)](readme/README.mt.md) [![mi](https://img.shields.io/badge/lang-mi-blue.svg)](readme/README.mi.md) [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![mn](https://img.shields.io/badge/lang-mn-orange.svg)](readme/README.mn.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![ne](https://img.shields.io/badge/lang-ne-blue.svg)](readme/README.ne.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md) [![or](https://img.shields.io/badge/lang-or-purple.svg)](readme/README.or.md)  
```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
``` [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) [![fa](https://img.shields.io/badge/lang-fa-blue.svg)](readme/README.fa.md) [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md) [![sm](https://img.shields.io/badge/lang-sm-orange.svg)](readme/README.sm.md) [![sa](https://img.shields.io/badge/lang-sa-green.svg)](readme/README.sa.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![nso](https://img.shields.io/badge/lang-nso-red.svg)](readme/README.nso.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md) π_70lo)  
[![sd](https://img.shields.io/badge/lang-sd-green.svg)](readme/README.sd.md) [![si](https://img.shields.io/badge/lang-si-blue.svg)](readme/README.si.md) [![sl](https://img.shields.io/badge/lang-sl-purple.svg)](readme/README.sl.md) License [![su](https://img.shields.io/badge/lang-su-green.svg)](readme/README.su.md) [![sw](https://img.shields.io/badge/lang-sw-blue.svg)](readme/README.sw.md) [![tg](https://img.shields.io/badge/lang-tg-red.svg)](readme/README.tg.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md) [![te](https://img.shields.io/badge/lang-te-green.svg)](readme/README.te.md)  
[![th](https://img.shields.io/badge/lang-th-blue.svg)](readme/README.th.md)  [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md)  [![ts](https://img.shields.io/badge/lang-ts-purple.svg)](readme/README.ts.md)  [![tk](https://img.shields.io/badge/lang-tk-orange.svg)](readme/README.tk.md)  [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md)  [![uk](https://img.shields.io/badge/lang-uk-blue.svg)](readme/README.uk.md)  [![ur](https://img.shields.io/badge/lang-ur-red.svg)](readme/README.ur.md)  [![ug](https://img.shields.io/badge/lang-ug-purple.svg)](readme/README.ug.md)  [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md)  [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md)  [![cy](https://img.shields.io/badge/lang-cy-blue.svg)](readme/README.cy.md)  
[![xh](https://img.shields.io/badge/lang-xh-red.svg)](readme/README.xh.md) [![yi](https://img.shields.io/badge/lang-yi-purple.svg)](readme/README.yi.md) License [![zu](https://img.shields.io/badge/lang-zu-green.svg)](readme/README.zu.md)

---


## 🚀 ସ୍ଥାପନ

PYPI ରୁ ସଂସ୍ଥାପନ:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 ସମୀକ୍ଷା

** ପାଇଲକର୍ ** ଏକ ବହୁମୁଖୀ Python ସରଳ, ଦର୍ଶନ, ଦୃଶ୍ୟମାନ ଅପରେସନ୍, ଏବଂ ୟୁଟିଲିଟି ୱାର୍କ୍ ଫ୍ଲାଉଟ୍ ** ଏକ ବହୁମୁଖୀ Python ଟୁଲ୍କିଟ୍ | ** ।  
ଏହା ଏକାଡେମିକ୍, ଅନୁସନ୍ଧାନ, ଏବଂ ବୃତ୍ତିଗତ ପ୍ରୋଜେକ୍ଟରେ ଏକାଡେମିକ୍, ଅନୁସନ୍ଧାନ, ଏବଂ ବୃକ୍ଷରୋପଲେଟ୍ କୋଡ୍ ପରିବର୍ତ୍ତେ ଅନ୍ତର୍ନିହିତ ଉପରେ ଧ୍ୟାନ ଦେବାକୁ ଅନୁମତି ଦିଏ |

ମୁଖ୍ୟ ସୁବିଧା:
- 🧮 ବିଲ୍ଟ-ଇନ୍ ** ପରିସଂଖ୍ୟାନ ଏବଂ ଗଣିତ ଉପଯୋଗୀତା ** 
- 📊 ସହଜ--ବ୍ୟବହାର ** ଡାଟା ଭିଜୁଆଲାଇଜେସନ୍ ରାପର୍ସ ** 
- 🗂 ହ୍ୟାଣ୍ଡି ** ଫାଇଲ୍ ନିୟନ୍ତ୍ରଣ ଏବଂ ସନ୍ଧାନ ** 
- 🔍 ** ସିଣ୍ଟାକ୍ସ ବ valid ଧତା ** * Python ଫାଇଲଗୁଡ଼ିକ ପାଇଁ |
- 🌍 ** MALDI- ଭାଷା ସମର୍ଥନ ** 
- ** ଫାଷ୍ଟ ପ୍ରୋଟୋପିଙ୍ଗ୍ ** ଏବଂ ** ଶିକ୍ଷା * ପାଇଁ ଅପ୍ଟିମାଇଜ୍ |

---

## ✨ କି ବ Features ଶିଷ୍ଟ୍ୟଗୁଡିକ |

### 📊 ଡାଟା ଭିଜୁଆଲାଇଜେସନ୍ |
- ବାର୍ ଚାର୍ଟ: ଭୂସମାନ୍ତର ଏବଂ ଭୂଲମ୍ବ (`hbar`, `vbar`)  
- ବଣ୍ଟନ ପ୍ଲଟ୍: Historgrams (`histo`), ବାକ୍ସ ପ୍ଲଟ୍ (`boxplot`), kde plots (`kdeplot`)  
- ତୁଳନାତ୍ମକ ପ୍ଲଟ୍: ବାଦ୍ୟଯନ୍ତ୍ର, SWARM, ଷ୍ଟ୍ରିପ୍ ପ୍ଲଟ୍ |  
- ସମ୍ପର୍କ ବିଶ୍ଳେଷଣ: ସର୍ଟମାପ୍ସ (`heatmap`),, ଛିନ୍ନ ଭିନ୍ନ PLOTS (`scatter`) ବିଛାଇବା |  
- ଉନ୍ନତ ଭିଜୁଆଲାଇଜେସନ୍: ଯୋଡା ପ୍ଲଟ୍, ମିଳିତ ପ୍ଲଟଗୁଡିକ, ରେଗ୍ରେସନ୍ ପ୍ଲଟ୍ |  
- ଡାଟା ସାରଣୀ: ଫର୍ମାଟ୍ ହୋଇଥିବା ଟେବୁଲ୍ (`table`) ପ୍ରଦର୍ଶନ କରେ |  

### 📈 ପରିସଂଖ୍ୟାନ ବିଶ୍ଳେଷଣ |
- ** କେନ୍ଦ୍ରୀୟ ପ୍ରବୃତ୍ତି ** : ଅର୍ଥ (`get_media`), ମଧ୍ୟମ (`get_median`), ମୋଡ୍ (`get_moda`)  
- ** ବିଚ୍ଛେଦ ** : ପରିସର (`get_rank`), ଭିନ୍ନତା (`get_var`), ମାନକ ବିଘ୍ନ (`get_desv`)  
- ** ବିଶ୍ଳେଷଣ ** : ବିଚ୍ଛେଦ ରିପୋର୍ଟ (`disp`), iQr ଗଣନା, ସାଧାରଣ ରୂପାନ୍ତର, ସର୍ତ୍ତମୂଳକ ରୂପାନ୍ତରିତ |  
- ** ବାହାଘର ଚିହ୍ନଟ ** : iqr ଏବଂ z- ସ୍କୋର ପଦ୍ଧତି |  

### 🗂️ ଫାଇଲ୍ ପରିଚାଳନା
- `call()` (auto-detect CSV, JSON, XML, etc.) ସହିତ ସ୍ମାର୍ଟ ଆବିଷ୍କାର |  
- ମଲ୍ଟି ଫର୍ମାଟ୍ ସପୋର୍ଟ (CSV, JSON, XML, PDF, spatial data) |  
- `DataBase` ଶ୍ରେଣୀ ସହିତ SQL ଡାଟାବେସ୍ ପରିଚାଳନା |  
- ରୂପାନ୍ତର ଉପଯୋଗିତା (`convert_file`) |  

### 🛠️ ଡେଭଲପର୍ ଉପକରଣଗୁଡ଼ିକ |
- ସିଷ୍ଟମ୍ (`Switch`, `AsyncSwitch`) ସୁଇଚ୍ ସିଷ୍ଟମ୍ |  
- ବାକ୍ୟବିନ୍ୟାସ ଯାଞ୍ଚ (`check_syntax`, `PythonFileChecker`)  
- ସମୃଦ୍ଧ ତ୍ରୁଟି ରିପୋର୍ଟ କରିବା (multi-language)  
- ଇଣ୍ଟିଗ୍ରେଟେଡ୍ ହେଲପ୍ ସିଷ୍ଟମ (`help`)  

### 🌍 ଆନ୍ତର୍ଜାତୀୟକରଣ |
- 100+ ବିଲ-ଇନ୍ ଅନୁବାଦଗୁଡିକ |  
- କଷ୍ଟମ୍ ଅନୁବାଦଗୁଡିକ ଲୋଡ୍ କରନ୍ତୁ |  
- ଚାଲିବା ସମୟ ଭାଷା ସୁଇଚ୍ (`set_language() `)  
- Automatic English fallback  

---

## Dependencies (handled automatically):

- pandas, numpy (data manipulation)

- matplotlib, seaborn (visualization)

- scikit-learn (statistics)

- sqlalchemy (database)

- geopandas (spatial data)

---

## 🔧 Usage Examples

### Set language 

**support for up to 131 languages** 
```python
from helper import set_language

set_language("en")  # English
set_language("es")  # Spanish
set_language("fr")  # French
set_language("de")  # German
set_language("ru")  # Russian
set_language("tr")  # Turkish
set_language("zh")  # Chinese
set_language("it")  # Italian
set_language("pt")  # Portuguese
set_language("sv")  # Swedish
set_language("ja")  # Japanese
set_language("ar")  # Arabic
...
```


### ମ basic ଳିକ ପରିସଂଖ୍ୟାନ |
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### ଭିଜୁଆଲାଇଜେସନ୍ |
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### ଫାଇଲ୍ ହ୍ୟାଣ୍ଡଲିଂ |
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### କଷ୍ଟମ୍ ଅନୁବାଦ |
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### ବାକ୍ୟବିନ୍ୟାସ ବ valid ଧତା |
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 ପ୍ରୋଜେକ୍ଟ ଗଠନ |

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 License

** MIT π_4 _ ** ତଳେ ଏହି ପ୍ରକଳ୍ପ ଲାଇସେନ୍ସପ୍ରାପ୍ତ |  
ବିବରଣୀ ପାଇଁ [LICENSE](LICENSE) ଫାଇଲ ଦେଖନ୍ତୁ |

---

## 🔮 ରୋଡମ୍ୟାପ୍ |

- ଅତିରିକ୍ତ ଭିଜୁଆଲାଇଜେସନ୍ ପ୍ରକାରଗୁଡିକ |

- ବିସ୍ତାରିତ ଡାଟାବେସ୍ ସମର୍ଥନ (NoSQL, graph databases)

- ମେସିନ୍ ଶିଖିବା ଏକୀକରଣ |

- ୱେବ୍ ଆଧାରିତ ଇଣ୍ଟରଫେସ୍ |

- ପ୍ଲଗଇନ୍ ସିଷ୍ଟମ୍ |

---

Theyphery ** Pyleler ** ସହିତ ଆପଣଙ୍କର Python ୱାର୍କଫ୍ଲୋ ସୁପରଚାର୍ଜ ପାଇଁ ପ୍ରସ୍ତୁତ | ଆଜି ଅନୁସନ୍ଧାନ କରିବା ଆରମ୍ଭ କରନ୍ତୁ!