# सहयोगी पुस्तकालय

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)__171_

## 🌍 उपलब्ध भाषाहरू

Pyheler प्रस्तावहरू प्रदान गर्दछ ** 1 131 भाषाहरू ** 1 131 भाषाहरू ** समावेश गर्दछ:

[![en](https://img.shields.io/badge/lang-en-red.svg)](readme/README.md) π_169968_ π_16767_ π_16666_ [![zh](https://img.shields.io/badge/lang-zh-black.svg)](readme/README.zh.md) π_1632_ [![pt](https://img.shields.io/badge/lang-pt-brightgreen.svg)](readme/README.pt.md)  
[![ja](https://img.shields.io/badge/lang-ja-red.svg)](readme/README.ja.md) π_15998_ [![sq](https://img.shields.io/badge/lang-sq-blue.svg)](readme/README.sq.md) [![am](https://img.shields.io/badge/lang-am-green.svg)](readme/README.am.md) π_155 = [![ay](https://img.shields.io/badge/lang-ay-brown.svg)](readme/README.ay.md) [![az](https://img.shields.io/badge/lang-az-lightblue.svg)](readme/README.az.md) [![bm](https://img.shields.io/badge/lang-bm-darkgreen.svg)](readme/README.bm.md)  
[![eu](https://img.shields.io/badge/lang-eu-pink.svg)](readme/README.eu.md)9 π_1498_ [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bho](https://img.shields.io/badge/lang-bho-orange.svg)](readme/README.bho.md) [![bg](https://img.shields.io/badge/lang-bg-green.svg)](readme/README.bg.md) [![ceb](https://img.shields.io/badge/lang-ceb-blue.svg)](readme/README.ceb.md)__1_  
[![hr](https://img.shields.io/badge/lang-hr-blue.svg)](readme/README.hr.md) [![cs](https://img.shields.io/badge/lang-cs-red.svg)](readme/README.cs.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![dv](https://img.shields.io/badge/lang-dv-orange.svg)](readme/README.dv.md) [![nl](https://img.shields.io/badge/lang-nl-orange.svg)](readme/README.nl.md) [![et](https://img.shields.io/badge/lang-et-blue.svg)](readme/README.et.md)_  
[![fi](https://img.shields.io/badge/lang-fi-blue.svg)](readme/README.fi.md) [![fy](https://img.shields.io/badge/lang-fy-orange.svg)](readme/README.fy.md) [![gl](https://img.shields.io/badge/lang-gl-green.svg)](readme/README.gl.md) [![el](https://img.shields.io/badge/lang-el-blue.svg)](readme/README.el.md) [![gu](https://img.shields.io/badge/lang-gu-orange.svg)](readme/README.gu.md) [![ht](https://img.shields.io/badge/lang-ht-green.svg)](readme/README.ht.md) [![haw](https://img.shields.io/badge/lang-haw-red.svg)](readme/README.haw.md)  
[![iw](https://img.shields.io/badge/lang-iw-purple.svg)](readme/README.iw.md) [![hi](https://img.shields.io/badge/lang-hi-orange.svg)](readme/README.hi.md) [![hmn](https://img.shields.io/badge/lang-hmn-green.svg)](readme/README.hmn.md) [![hu](https://img.shields.io/badge/lang-hu-blue.svg)](readme/README.hu.md) [![is](https://img.shields.io/badge/lang-is-red.svg)](readme/README.is.md) [![ig](https://img.shields.io/badge/lang-ig-purple.svg)](readme/README.ig.md) [![id](https://img.shields.io/badge/lang-id-green.svg)](readme/README.id.md) [![ga](https://img.shields.io/badge/lang-ga-blue.svg)](readme/README.ga.md)  
[![kn](https://img.shields.io/badge/lang-kn-purple.svg)](readme/README.kn.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![km](https://img.shields.io/badge/lang-km-green.svg)](readme/README.km.md) [![gom](https://img.shields.io/badge/lang-gom-red.svg)](readme/README.gom.md) [![ko](https://img.shields.io/badge/lang-ko-purple.svg)](readme/README.ko.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ku](https://img.shields.io/badge/lang-ku-green.svg)](readme/README.ku.md) [![ckb](https://img.shields.io/badge/lang-ckb-blue.svg)](readme/README.ckb.md)  
[![lo](https://img.shields.io/badge/lang-lo-purple.svg)](readme/README.lo.md) π_9998_ [![ln](https://img.shields.io/badge/lang-ln-blue.svg)](readme/README.ln.md) [![lt](https://img.shields.io/badge/lang-lt-red.svg)](readme/README.lt.md) [![lg](https://img.shields.io/badge/lang-lg-purple.svg)](readme/README.lg.md) π_9 π__ [![mg](https://img.shields.io/badge/lang-mg-red.svg)](readme/README.mg.md)  
[![ms](https://img.shields.io/badge/lang-ms-purple.svg)](readme/README.ms.md) π_898_ π_878_ [![mr](https://img.shields.io/badge/lang-mr-red.svg)](readme/README.mr.md) [![lus](https://img.shields.io/badge/lang-lus-purple.svg)](readme/README.lus.md) [![my](https://img.shields.io/badge/lang-my-green.svg)](readme/README.my.md) [![no](https://img.shields.io/badge/lang-no-red.svg)](readme/README.no.md)  
[![om](https://img.shields.io/badge/lang-om-orange.svg)](readme/README.om.md) [![ps](https://img.shields.io/badge/lang-ps-green.svg)](readme/README.ps.md) π_776_ [![ro](https://img.shields.io/badge/lang-ro-purple.svg)](readme/README.ro.md)_ [![gd](https://img.shields.io/badge/lang-gd-blue.svg)](readme/README.gd.md) [![st](https://img.shields.io/badge/lang-st-purple.svg)](readme/README.st.md)_  
π_6868_ π_6766666665__ [![ta](https://img.shields.io/badge/lang-ta-purple.svg)](readme/README.ta.md)__  
π_377_ [![ti](https://img.shields.io/badge/lang-ti-red.svg)](readme/README.ti.md) π_555_ [![ak](https://img.shields.io/badge/lang-ak-green.svg)](readme/README.ak.md) (`get_media`) [![uz](https://img.shields.io/badge/lang-uz-orange.svg)](readme/README.uz.md) [![vi](https://img.shields.io/badge/lang-vi-green.svg)](readme/README.vi.md)  
π_466_ π_4545_ π_4444_4333__

---


## 🚀 स्थापना

PYPI बाट स्थापना गर्नुहोस्:

```bash
pip install pyhelper-tools-jbhm
```

---

## 📖 सिंहावलोकन

** pyler ** एक बहुमुखी ** सरलीकृत π_411_ टूलिट हो ** डाटा विश्लेषण, तथ्या .्गिकरण, सांख्यिकीय अपरेशहरू **।  
यसले सिद्दहीन शैक्षिक, अनुसन्धान, र व्यावसायिक परियोजनाहरूमा समाहित गर्दछ, तपाईंलाई आन्दोलप्लेट कोड भन्दा अन्तर्दृष्टिमा ध्यान केन्द्रित गर्न अनुमति दिन्छ।

मुख्य सुविधाहरू:
- 🧮 निर्मित ** तथ्या .्क र गणित उपयोगिताहरू ** 
- 📊 सजिलो-देखि-प्रयोग ** डाटा दृश्य र्यापरहरू ** 
- 🗂 ह्यान्डर ** फाईल ह्यान्डलिंग र खोजी गर्नुहोस् ** 
- 🔍 ** सिन्ट्याक्स मान्यता ** Python फाईलहरू
- 🌍 ** बहु-भाषा समर्थन ** तयार-देखि-प्रयोग अनुवादको साथ
- 🚀 ** फास्ट प्रोटोटाइपिंग ** र ** शिक्षा ** 

---

## ✨ कुञ्जी सुविधाहरू

### 📊 डाटा दृश्य
- बार चार्ट: क्षैतिज र ठाडो π_3999999  
- वितरण प्लट्स: हिस्टोग्राम (`histo`), बक्स प्लट (`boxplot`), केडीई प्लट्स π_3666  
- तुलनात्मक प्लट्स: Violin, swarm, स्ट्रिप प्लट  
- सहकार्य विश्लेषण: π__35_, Scerter प्लट्स π_3434_  
- उन्नत दृश्यहरू: जोडी प्लट, संयुक्त प्लट्स, प्रतिगमन प्लट्स  
- डाटा तालिकाहरू: ढाँचा तालिकाले π_3333_ प्रदर्शन गर्दछ  

### 📈 सांख्यिकीय विश्लेषण
- ** केन्द्रीय प्रवृत्ति ** यसको मतलब (`get_media`), औसत (`get_median`), मोड π_3030_  
- ** परिष्कृत ** : दायरा (`get_rank`), भिन्नता (`get_var`), मानक विचलन (`get_desv`)  
- ** विश्लेषण ** : विघटन रिपोर्टहरू (`disp`), IQR गणना, सामान्यकरण, सशर्त रूपान्तरणहरू  
- ** आउट्रॉर्डर पत्ता लगाउनुहोस् ** * iqr र z-स्कोर विधिहरू  

### 🗂️ फाइल व्यवस्थापन
- स्मार्ट डिस्कवरी π_225_ (auto-detect CSV, JSON, XML, etc.) को साथ  
- बहु-ढाँचा समर्थन (CSV, JSON, XML, PDF, spatial data)  
- SQL डाटाबेस व्यवस्थापन π_2222 वर्गको साथ  
- रूपान्तरण उपयोगिताहरू (`convert_file`)  

### 🛠️ विकासकर्ता उपकरणहरू
- स्विच प्रणाली π_220_  
- सिन्ट्याक्स चेक (`check_syntax`, `PythonFileChecker`)  
- रिच त्रुटि (multi-language) रिपोर्ट गर्दै  
- एकीकृत सहयोग प्रणाली (`help`)  

### 🌍 अन्तर्राष्ट्रियकरण
- 100+ निर्मित अनुवाद  
- अनुकूलन अनुकूलन अनुवाद  
- रनटाइम भाषा स्विच (`set_language()15___14_13_13_____


### आधारभूत तथ्या .्क
```python
import helper as hp

data = [1, 2, 2, 3, 4, 5]

print(hp.get_media(data))   # Mean
print(hp.get_median(data))  # Median
print(hp.get_moda(data))    # Mode
```

### दृश्य
```python
import helper as hp

df = hp.pd.DataFrame({"values": [5, 3, 7, 2, 9]})
hp.histo(df, "values", bins=5, title="Sample Histogram")
```

### फाईल ह्यान्डलिंग
```python
from helper import call

data = call(name="my_data", type="csv")  # Finds and loads a CSV file automatically
```

### अनुकूलन अनुवाद
```python
from helper import load_user_translations

# Load custom translations from lang.json
load_user_translations("custom/lang.json")
```

### syntax प्रमाणीकरण
```python
from helper import run

run("./path/to/my_script.py")
#Show gui pop up with results
```

---

## 📂 परियोजना संरचना

```
helper/
├── core.py
├── __init__.py
├── lang/
│   ├── en.json
│   ├── es.json
│   └── ... (100+ files)
└── submodules/
    ├── graph.py
    ├── statics.py
    ├── utils.py
    ├── caller.py
    ├── checker.py
    ├── manager.py
    ├── pyswitch.py
    ├── shared.py
    └── DBManager.py
```

---

## 📜 📜_6_6__

यो परियोजना ** __5_ _ _ _ _ ** अन्तरिक्ति प्रदान गरिएको छ।  
विवरणका लागि π__3_ फाईल हेर्नुहोस्।

---

## 🔮 रोडम्याप

- अतिरिक्त दृश्य प्रकारहरू

- विस्तारित डाटाबेस समर्थन (NoSQL, graph databases)

- मेसिन सिक्ने एकीकरण

- वेब-आधारित ईन्टरफेस

- प्लगइन प्रणाली

---

⚡ तपाईंको ⚡_1_ कार्यप्रसारहरू सुपरचार्ज गर्न तयार छ ** pyler ** आज अन्वेषण सुरु गर्नुहोस्!